#!/usr/bin/perl

BEGIN {    push        (@INC, "./shared/perl/");   }
    
    

# CGI for editing features
# 
# Takes a entry id, loads entry from the middleware, loads template, puts them together...
# 


use strict;
use CGI;
use IMC::SiteInfo;
use IMC::Features;
use IMC::ViewFeatures;
use IMC::EditFeature;
use IMC::EditFeaturesMenu;
use IMC::Preferences;
use IMC::Authentication;
use IMC::Database;
use IMC::Error;
use Data::Dumper;
use Template;

use vars qw( $VERSION $first_dir $second_dir );

$VERSION    = sprintf("%d.%02d", q$Revision: 1.7 $ =~ /(\d+)\.(\d+)/);
$first_dir  = '/www/';
$second_dir = '/local/';

my $self = &init( @_ );

print $self->{'query'}->header();

&main( $self );

sub init
{
	my ($type) = @_;
	my  $self  = {};

	$self->{'query'}         = new CGI;
	$self->{'dbh'}		   = IMC::Database::connect(); 
	$self->{'site_obj'}      = new IMC::SiteInfo( 'query'      => $self->{'query'},
						      'dbh'        => $self->{'dbh'},
						      'ENV'        => \%ENV,
						      'first_dir'  => $first_dir,
						      'second_dir' => $second_dir);
	$self->{'site_name'}     = $self->{'site_obj'}->{'NAME'};
        $self->{'templates_dir'} = $first_dir . $self->{'site_name'} . $second_dir . 'templates';
        $self->{'template_obj'}  = &load_template_obj( $self );
        $self->{'authentication_obj'} = new IMC::Authentication('query'    => $self->{'query'}, 
								'ENV'      => \%ENV,
								'site_obj' => $self->{'site_obj'},
                                                                'first_dir'  => $first_dir,
                                                                'second_dir' => $second_dir);
	
	return bless $self;
}

sub main
{
	my $self = shift;

	if (    $self->{'query'}->param( 'screen' ) eq 'menu' ) { &show_menu( $self ); }
	elsif ( $self->{'query'}->param( 'screen' ) eq 'edit' ) { &edit_feature( $self ); }
	elsif ( $self->{'query'}->param( 'screen' ) eq 'view' ) { &view( $self ); }
        elsif ( $self->{'query'}->param( 'screen' ) eq 'update_files' ) { &update_files( $self ); }
        elsif ( $self->{'query'}->param( 'screen' ) eq 'preferences' )  { &preferences( $self ); }
        else	{ 	&show_menu( $self );	}

	
	#not the best or most optimized solution
        #&write_out_features_to_disk( $self );
}

sub show_menu
{
	my $self = shift;

	my $features_menu_obj = new IMC::EditFeaturesMenu( 'SITE_ID' => $self->{'site_obj'}->{'ID'},
							   'NUMBER_TO_LIST' 	  => 50,
		  			  		   'ORDER_BY' => ' TIMESTAMP DESC',
                                                           'dbh' => $self->{'dbh'} );
		
	&process_template( $self, $features_menu_obj );
}


sub update_files
{
        my $self = shift;
        
	my $update_message = "Files on the disk have been update";
	
        my $features_menu_obj = new IMC::EditFeaturesMenu( 'SITE_ID' => $self->{'site_obj'}->{'ID'},
							   'MESSAGE' => $update_message,
                                                           'dbh' => $self->{'dbh'} );

        &process_template( $self, $features_menu_obj );
	&write_out_features_to_disk( $self );        
}




sub edit_files
{
	my $self = shift;

	my $features_menu_obj = new IMC::EditFiles( 
			        'site_obj' => $self->{'site_obj'}, 
			        'dbh' => $self->{'dbh'},
			        'authentication_obj' => $self->{'authentication_obj'} );
	
	&process_template( $self, $features_menu_obj );
}




sub view
{
	my $self = shift;
	my $vals;
	   $vals->{'ID'}      = $self->{'query'}->param( 'ID' ) if ( $self->{'query'}->param( 'ID'  ) );
	   $vals->{'dbh'}     = $self->{'dbh'};
	   $vals->{'SITE_ID'} = $self->{'site_obj'}->{'ID'} if ( $self->{'site_obj'}->{'ID'} );
	   $vals->{'OFFSET'}      = $self->{'query'}->param( 'OFFSET' ) if ( $self->{'query'}->param( 'OFFSET'  ) );
	   $vals->{'NUMBER_TO_LIST'} 	  = $self->{'site_obj'}->{'NUMBER_TO_LIST'};
	   $vals->{'NUMBER_TO_LIST'}      = $self->{'query'}->param( 'NUMBER_TO_LIST' ) if ( $self->{'query'}->param( 'NUMBER_TO_LIST'  ) );
	   
	my $view_features_obj = new IMC::ViewFeatures( $vals );
			
	&process_template( $self, $view_features_obj );
}


sub preferences
{
    my $self = shift;

    warn $self->{'site_obj'};
    my $preferences_obj = new IMC::Preferences( 'site_obj' => $self->{'site_obj'},
						'dbh'      => $self->{'dbh'},
					        'authentication_obj' => $self->{'authentication_obj'} );
    
    if ( $self->{'query'}->param( 'submit' ) eq 'Submit' )
    {
       	$preferences_obj->update( $self->{'query'} );
    }
    
    &process_template( $self, $preferences_obj );
}



sub edit_feature
{
	my $self = shift;

	my $editfeature_values;
	   $editfeature_values->{'ID'}      = $self->{'query'}->param( 'ID' ) if ( $self->{'query'}->param( 'ID'  ) );
	   $editfeature_values->{'SITE_ID'} = $self->{'site_obj'}->{'ID'} if ( $self->{'site_obj'}->{'ID'} );
	   $editfeature_values->{'AUTHENTICATED'} = $self->{'authentication_obj'}->VALID();
	   $editfeature_values->{'query'}   = $self->{'query'};
           $editfeature_values->{'dbh'}     = $self->{'dbh'};
	   $editfeature_values->{'authentication_obj'} = $self->{'authentication_obj'};	

	my $edit_feature_obj = new IMC::EditFeature( $editfeature_values );
		
	#we're updating a template....
	#I don't know it this is the right way to do it....
	if ( $self->{'query'}->param( 'submit' ) =~ /Submit/i )
	{
		#warn 'in submit';
		$edit_feature_obj->update( $self->{'query'} );
	}
	elsif ( $self->{'query'}->param( 'submit' ) eq 'Delete' )
	{
		#warn 'in delete';
		$edit_feature_obj->delete_feature( $self->{'query'} );
	}
	
	&process_template( $self, $edit_feature_obj );
	&write_out_features_to_disk( $self );
}

sub write_out_features_to_disk
{
	my $self    = shift;
	my $numb    = 1;	
	my $offset  = 0;
	my $counter = 0;

	while ( $numb ) {
		$numb = _do_write_out_features_to_disk( $self, $offset, $counter );
		$offset = $offset + $numb;
		$counter++;
	}
	
}

sub _do_write_out_features_to_disk
{
	my ($self, $offset, $counter) = @_;
	#write out features to disk
	my $feature_obj = new IMC::ViewFeatures( 'site_obj' => $self->{'site_obj'},
						 'NUMBER_TO_LIST'      => $self->{'site_obj'}->{'NUMBER_TO_LIST'},
                                                 'dbh' => $self->{'dbh'},
						'OFFSET' => $offset, 
                                                 'output_to_file' => 1 );
	my $file_name = '';
	if ( $counter == 0 ) {
		$file_name =  $self->{'site_obj'}->{'INCLUDES_DIR'} . $self->{'site_obj'}->{'FEATURES_FILE'};
	}
	else {
		$self->{'site_obj'}->{'FEATURES_FILE'} =~ /^([^\.]*)(\.[^\.]*)$/;
	    $file_name =  $self->{'site_obj'}->{'INCLUDES_DIR'} . $1 . $counter . $2;
	}

	&process_template( $self, $feature_obj, $file_name );
	
	#getting the number retrieved... 
	return( scalar( @{ $feature_obj->{'features'} } ) );
}

sub error_page
{
	my $error_msg = shift;
	my $error_obj = new IMC::Error;
	$error_obj->log_error( $error_msg ); warn "error page";
	&process_template( $error_obj, $self->{'template_obj'} );
}

sub process_template
{
	my ($self, $data_obj, $output) = @_;
	
	my  $template_name = $data_obj->template_name || &default_template( $self, $data_obj );
	
	#this processes the template and prints it to STDOUT
	$self->{'template_obj'}->process( $template_name, $data_obj->vars, $output) || die $self->{'template_obj'}->error(), "\n";
    
#	warn $self->{'query'}->dump . "<P><pre>" . Data::Dumper->Dump( [$data_obj->vars()] );
}


# in case the entry_object doesn't have a template name
# then we need to pick one... this is a place for more code to be written...
sub default_template
{
	my $entry_obj	=	shift;
	
	#i could do lots of interesting checks on entry_obj
	#here to see what kind of template I want, but
	#i'm just going to return a very simple default at this point.
	return ( 'default_library_entry.template' );
}

sub load_template_obj
{
	my $self = shift;
	my $env_hash;

	%$env_hash = ( %ENV );
		
	$ENV{ REQUEST_URI } =~ m/^([^\?]*)/;
	$env_hash->{'SHORT_URI'} = $1;
	
	return Template->new({
			INCLUDE_PATH => $self->{'templates_dir'},
			INTERPOLATE  => 1,
            VARIABLES => {
                version => $VERSION,
                ENV => $env_hash,
            },
		}) || die "$Template::ERROR\n";
}


sub determine_site_name
{
	my $self = shift;
	$ENV{ 'SCRIPT_FILENAME' } =~ m!/([^/]*)/[^/]*$!;
	my $site_name = $1;
	$site_name =~ s/\.indymedia\.org//;
	if ($site_name == "www") {
	$site_name = "mayday";
	}
	return $site_name;
}

