<? 
# $Id: edit_webcast.php3,v 1.24 2001/04/17 07:41:37 andy Exp $

include("../local/webcast/webcast-setup.php3");
include("../local/webcast/webcast.inc");
include("../shared/db_class.php3");


#create a new db object
$db_obj = new DBClass();

if (file_exists("debug")) {
  $tb_name="webcastdebug";
  $seq_name="webcastdebugid";
}
else {
  $tb_name="webcast";
  $seq_name="webcastid";
}

#find the publishtype..
if (strlen(chop($publishtype))==0) { 
     $publishtype = "webcast";
}
    
if (strlen(chop($rating)) != 0) {
#doing a rating..
  echo top("rating an article","nocache"); 

  $rated_today = false;
    
  if ($ratings_system["user_rate_daily_only"] == "yes") {
    
    #only allow once per IP, per day. may break with PROXYs
    $publish_buffer_data = array ("remote_ip" => $REMOTE_ADDR,
				  "publish_time" => "now",
				  "action" => "rate",
				  "user_id" => $userid,
				  "external_id" => $art_id,
				  "table_name" => "publishbuffer",
				  "seq_name" => "publishbufferid",
				  "article_seq_name" => $seq_name,
				  "article_table_name" => $tb_name,
                                  #the fields below are used to compare with previously rated
                                  #stories (if the same IP has rated today)
				  "heading" => $heading,
				  "summary" => $summary
				  ); 
    
    list ($result, $rows) = $db_obj->execute('publish_buffer','select',$publish_buffer_data);
    
    if ($rows > 0) {
      #assume more than one rating done a day!
      echo  "<p> I have detected that you have <i>rated this story today already</i>.";
      echo  "<br> Please come back tommorrow, as <b>I have not rated this article </b>";
      echo "<p> There has been $rows rating(s) on this article today from your IP $REMOTE_ADDR.";
      $rated_today = true;
    }
  }
  
  $rate_data = array (
		      "table_name" => "article_classification",
		      "seq_name" => "article_classificationid",
		      "article_id" => $art_id,
                      #these are un-used as yet (user/classification ids)
		      "user_id" => $userid,
		      "categorisation_id" => "0",
                      #value of rating
		      "rating" => $rating_select
		      );
  
  if (! $rated_today) {
   #make sure we dont let people rate twice+ per day per article 
   #(unless that is switched off in webcast-setup.php3)

    list ($result, $reason) = $db_obj->execute('rating','irrelevant',$rate_data);
    
    if ($result) {

      echo "<p><b>$heading</b> has been rated.<p> Thanks for contributing!";
      
      #The rating action needs to be inserted into the publishbuffer
      $publish_buffer_data = array ("remote_ip" => $REMOTE_ADDR,
				    "publish_time" => "now",
				    "action" => "rate",
				    "user_id" => $userid,
 				    #this is a reference to the article 
				 #(this field is equiv. to the unique key in webcast)
				    "external_id" => $art_id,
				    "table_name" => "publishbuffer",
				    "seq_name" => "publishbufferid",
				    "article_seq_name" => $seq_name,
				    "article_table_name" => $tb_name
				    ); 
      
      $result = $db_obj->execute('publish_buffer','insert',$publish_buffer_data);
      
      $group=$publishtype;
      #$parent_id and $id are sent along. If rating a "top-level" article, 
      #parent_id and id are the same. So we just use parent_id, 
      #which takes care of both cases ie top-level articles and comments
      $article_id = $parent_id;
      #this refresh will update the article on disk, as well as the summary pages
      $server_base_url = "http://".getenv("HTTP_HOST").dirname(getenv("SCRIPT_NAME"))."/display.php3?refresh=y&article_id=".$article_id."&group=".$group;
      readfile($server_base_url);
      
    } else {
      echo "<p>Sorry, I can't rate <b>$heading</b> in the database\n<p>";
      
      if (strlen(chop($reason)) != 0) 
	{
	  echo "A possible reason is:<p>\n";
	  echo "$reason<p>\n";
	  echo "which may or may not make sense to you or the collective.\n";
	}
      echo "Annoying, isn't it? Sorry about that. Please try again later.\n";
    }
  }
  
} else {

#updating the article entry.
#Need a PASSWORD to edit an article

  echo top("editing an article","nocache"); 
  
  $password = chop($password);
  if ($password != $manage_password) {
    echo "<blockquote><blockquote>\n";
    echo "Sorry I think you got here without using a password.\n"
      . "Either you are being sneaky or I made a mistake.\n"
      . "Please return to the <a href=\"display.php3?led=y\">edit</a> page\n"
      . "and try again.\n";
    echo "</blockquote></blockquote>\n";
    echo " password u sent was: " . $password . "!";
    $output = bottom();
    echo $output;
    exit;
  }
  
  $data_array = array ( "heading" => $heading,"author" => $author,"article" => $article,"contact" => $contact,"link" => $link,"address" => $address,"phone" => $phone, "mime_type" => $mime_type,"summary" => $summary,"display" => $display,"art_id" => $art_id,"linked_file" => $linked_file,"table_name" => $tb_name,"seq_name" => $seq_name, "is_html" => chop($text_format), "group_status"=> chop($group_status), "language"=>chop($language), "encoding" => chop($encoding) );

  #re-save an updated 'long' story.
  if (strlen(chop($article)) > 4000) {
        # force the article file to be text type
  	$upload_ext = ".txt";

        #story has become to long, after re-edits, need to save it somewhere
        # generate unique file name
	$clean_basename = strtolower(ereg_replace("[^a-zA-Z0-9\._-]", "_", 
	                  substr(   stripslashes($heading), 0, 10)));
	
	$upload_target = $upload_folder . $clean_basename . $upload_ext;
	
        # need to check if we are about to wipe another file!
	while (file_exists($upload_target)) {
	  $tmpname = strtolower(tempnam($upload_folder, $clean_basename));
	  $upload_target = $tmpname . $upload_ext;
	}
	$textfp = fopen($upload_target, "w");

	#strip slashes from the article text.
	fwrite($textfp, stripslashes($article));
	fclose($textfp);
	
        #zero the article , since it was written to disk, so that pg wont choke.
	$data_array["article"] = "";
        #write the name of the linked file into the table record.
	$data_array["html_file"] = $upload_target;
  }
  
  list ($result, $reason) = $db_obj->execute('updating', 'irrelevant', $data_array);
  
  $heading = htmlspecialchars(stripslashes($heading));
    
  if ($result) 
    {
      echo "<p><b>$heading</b> has been updated in the database.\n";
      echo "Thanks for administrating!\n<p>";
      
      echo "<a href=\"front.php3?group=$publishtype&page=0\">go back to main display </a><br>";
      echo "(you may need to press <b>reload</b> when you get there to see your ";
      echo "changes)\n";
      echo "<p><a href=\"display.php3?led=y&group=$publishtype\">go back to administration </a>";
      
      $group=$publishtype;
      if ($parent_id != 0) {
	#refresh the parent article if edited a comment.
	$article_id = $parent_id;
      } else {
      	$article_id = $art_id;
      }
      #this refresh will update the article on disk, as well as the summary pages
      $server_base_url = "http://".getenv("HTTP_HOST").dirname(getenv("SCRIPT_NAME"))."/display.php3?refresh=y&article_id=".$article_id."&group=".$group;
      readfile($server_base_url);
      
    } else {
      echo "<p>Sorry, I can't update <b>$heading</b> in the database\n<p>";

      if (strlen(chop($reason)) != 0) 
	{
	  echo "A possible reason is:<p>\n";
	  echo "$reason<p>\n";
	  echo "which may or may not make sense to you or the collective.\n";
	}
      echo "Annoying, isn't it? Sorry about that. Please try again later.\n";
    }
  
}
$db_obj->try_close();
print bottom();

?>



