<?
# $Header: /usr/local/cvsroot/active/webcast/display.php3,v 1.77 2001/04/05 11:37:02 andy Exp $
# $Id: display.php3,v 1.77 2001/04/05 11:37:02 andy Exp $

#changed paths from relative to abs 11/23 jacobi
#changed it back to relative - mafew 11/24
include("webcast-setup-default.php3");
include("../local/webcast/webcast-setup.php3");
include("../local/webcast/webcast.inc");

include("cast_class.inc");
include("summary_list.inc");
include("group_class.inc");

#include the functions necessary in making the article admin mode.
include("article_admin.inc");

#include the functions necessary in making the summary/article pages.
include("article_display.inc");

#include the new_data-process functions - used by the mirror_system to create thumbnails
include("new_data-process.inc");

if (! $db_class_php3) {
  include("../shared/db_class.php3");
}

#process the user input parameters - recieve one hash, containing all important
#variables.
# $data["article_id"] - the id of the article wanted (if in article mode)
# $data["display_mode"] - whether in group admin/article admin/refresh/browser display mode
# $data["page"] - what page of summaries we are on (if in summary mode)
# $data["mode"] - article or summary mode.

$control_data = process_input_parameters();

#make the database object here.
$db_obj = new DBClass();
#make the groupItem object for the CastItem objects.
$grp_object = new GroupItem($control_data["publishtype"],$db_obj);

$control_data["group_object"] = $grp_object;

switch($control_data["display_mode"]) {
case 'group_admin':

 # the groups administration mode.
 echo top("groups administration", "nocache", $control_data["menu"],
          $control_data["extra_menu"], "", $control_data["extra_args"]);

 #this form of the constructor (with no groupname) tells the object not to load
 #from the db.
 $group_object = new GroupItem("",$db_obj);
 #this function echos data directly - ie sends it straight to browser.
 $group_object->make_group_admin_form();
 
 echo bottom();
 break;	

case 'led':
 #the article administration display mode.

 echo top($control_data["publishtype_heading"]. "article administration",
          "nocache",$control_data["menu"], $control_data["extra_menu"], "",
          $control_data["extra_args"]);
  
 $nav_data = form_editing_nav_bar($control_data);

 list ($result,$total) = $db_obj->execute('led', $control_data["mode"], $control_data);

 #call the function to output the admin table and form
 make_admin_form_and_table($result,$total,$control_data,$nav_data,$db_obj);

 $output = bottom();
 echo $output;
 break;
  
case 'refresh':
 #generate the static files. either just the summary pages, or one article and 
 #the summary pages.

 #calculate how long it takes.. used in do_static_file_writing()
 $start_time = time();

 #do the database call
 list ($result_index, $rows, $page_gen_start, $page_gen_max, $refresh_output)
       = do_db_call($db_obj,$control_data);

 #call the main page loop, giving the starting page, and the ending (max) page
 $refresh_output_2 = do_main_page_loop($result_index, $rows, $page_gen_start,
                                       $page_gen_max, $db_obj, $control_data);
 
 if ($control_data["mode"] =='article') {
   #was asked to refresh an article, refresh the summary static pages also.
   #this is implemented so that the usual call to refresh, in new_data-process.php3
   #can happen once. Ie ask to refresh an article (a new article or a comment),
   #and the summaries get refreshed also.
   $control_data["mode"] = 'summaries';

   #calculate how long it takes.. used in do_static_file_writing()
   $start_time = time();
    
   #do the database call
   list ($result_index, $rows, $page_gen_start, $page_gen_max, $refresh_output_3)
         = do_db_call($db_obj, $control_data);
    
   #call the main page loop, giving the starting page, and the ending (max) page
   $refresh_output_4 = do_main_page_loop($result_index, $rows, $page_gen_start,
                                         $page_gen_max, $db_obj, $control_data);
   }

 #write the refreshing messages to disk, so that it can be included by the 
 #refresh.php3 script.
 #this is so that we can can include display.php3?refresh=y&page=XX inside 
 #front.php3, then include the newly generated summary page, without getting 
 #the refreshing messages at the top of the page. 

 $fffp = fopen("../local/webcast/cache/refresh_results.html", "w");
 $r_output = $refresh_output . $refresh_output_2 . $refresh_output_3 . $refresh_output_4;
 fwrite($fffp, $r_output, strlen($r_output));
 fclose($fffp);

break;

case 'browse':
 #the dynamic case

 #do the database call
 list ($result_index, $rows, $page_gen_start, $page_gen_max)
       = do_db_call($db_obj, $control_data);

 #call the main page loop, giving the starting page, and the ending (max) page
 do_main_page_loop($result_index, $rows, $page_gen_start,$page_gen_max, $db_obj,
                   $control_data);

break;

case 'all_article_refresh':
#refresh ALL articles onto disk.

  #calculate how long it takes.. used in do_static_file_writing()
  $start_time = time();

  $control_data["mode"] = "summaries";

  #this call to the db , in summary mode, is to retrieve data useful in making
  #inter-article navigation links - eg next/prev article links.

  list ($rez,$all_articles,$p,$m,$refresh_output)
       = do_db_call($db_obj,$control_data );
 
  #the mode should be article, for db calls now.
  $control_data["mode"] = "article";

  for ($i=0;$i < $all_articles; $i++) {
    #grab all the result objects from the database..
    $a_obj[$i] = pg_fetch_object($rez,$i);
    }

  #now do the loop - formatting the articles and writing the them out..
  for ($i=0; $i < $all_articles; $i++) {
    #set the article id from the db..
    $control_data["article_id"] = $a_obj[$i]->id;
    #this variable is used for writing the static output..
    $article_id = $a_obj[$i]->id;
    
    #set up the variables necessary for "previous"|"next" article links.
    if ($i > 0) {
     $control_data["previous_article_id"]=$a_obj[$i-1]->id;
     $control_data["previous_article_heading"]=$a_obj[$i-1]->heading;
    } else {
     $control_data["previous_article_id"]=0;
    }
    if ($i != ($all_articles-1)) {
     $control_data["next_article_id"]=$a_obj[$i+1]->id;
     $control_data["next_article_heading"]=$a_obj[$i+1]->heading;
    } else {
     $control_data["next_article_id"]=0;
    } 

    $refresh_output_2 .= "refreshing article <b>". $a_obj[$i]->heading."</b>";

   #do the database call
   list ($result_index, $rows, $page_gen_start, $page_gen_max, $refresh_output_3)
         = do_db_call($db_obj, $control_data);

   #call the main page loop, giving the starting page, and the ending (max) page
   $refresh_output_4 = do_main_page_loop($result_index, $rows, $page_gen_start,
                                         $page_gen_max, $db_obj, $control_data);
 
   $refresh_output_2 .= $refresh_output_3 . $refresh_output_4;
   }
   
 #write the refreshing messages to disk, so that it can be included by the 
 #refresh.php3 script.
 #this is so that we can can include display.php3?refresh=y&page=XX inside 
 #front.php3, then
 #include the newly generated summary page, without getting the refreshing 
 #messages at the top of the page.

 $fffp = fopen("../local/webcast/cache/refresh_results.html", "w");
 $r_output = $refresh_output . $refresh_output_2;
 fwrite($fffp, $r_output, strlen($r_output));
 fclose($fffp);
 
break;

# index case yet to come
# merge search-process.php3 script functionality into here, taking adv. of
#CastItem/GroupItem.

case 'mirror_system':
  echo top("file mirroring system check",
          "nocache",$control_data["menu"], $control_data["extra_menu"], "",
          $control_data["extra_args"]);

  #fetch list of all linked files in the group.
  $control_data["mode"] = 'linked_files';
  list ($result,$total) = $db_obj->execute('selecting', $control_data["mode"], $control_data);

  echo "<p> There are $total uploaded multimedia files for this database.";
  
  if ($control_data["mirror_system_options"] == "errors_only") {
    echo "<br><a href=\"display.php3?mirror_system=y\">Show verbose results</a>";
    $errors_only = true;
  } else {
    $errors_only = false;
    echo "<br><a href=\"display.php3?mirror_system=errors_only\">Show only errors</a>";
  }

  clearstatcache();
  #loop through all attached multimedia files!

  $errored_files = 0;

  for($i=0;$i<$total;$i++) {
    #grab the row from the db as an associative array
    $linked_file_object = pg_fetch_array($result,$i);
    
    $linked_file_object["linked_file"] = chop($linked_file_object["linked_file"]);

    $lnk = "<a href=\"front.php3?article_id=".chop($linked_file_object["id"])."\">".chop($linked_file_object["heading"])."</a>";
    $output = "<p>Determining status of file <b>".  $linked_file_object["linked_file"] ."</b> - attached to ".$lnk;
    $output .= "<br> Mime type is <i>" .$linked_file_object["mime_type"]."</i>";

    $error_found = false;

    #find if local file exists.
    $output .=  "<br>Checking file exists locally...";
    $local_size = filesize($linked_file_object["linked_file"]);
    if ($local_size > 0)  {
      $local_file_exists = true;
      $output .= "OK. File size is $local_size bytes.";
    } else {
      $local_file_exists = false;
      $error_found = true;
      $output .= "<b>missing!</b>";
    }
    
    #find thumb filename form - only for image mimes.
    #determine if thumb exists locally - only for image mimes
    #(if not existing locally, try to make it locally - using ./make_thumb script)
    if ((strpos(chop($linked_file_object["mime_type"]),"image")) !== false) {
      $output .= "<br>Checking thumbail exists locally..";
      eregi("([a-zA-Z0-9/\._-]+)\.([a-zA-Z0-9]+)$",$linked_file_object["linked_file"],$regs);
      $filename_thumb = $regs[1] . "-thumb." . $regs[2];

      $local_thumb_size = filesize($filename_thumb);
      if ($local_thumb_size > 0 ) {
	$local_thumb_exists = false;
	$output .= "OK. File size is $local_thumb_size bytes.";
      } else {
	$local_thumb_exists = true;
	$output .= "<b>missing!</b>";
	$error_found = true;
	
        #try to re-create thumb locally if local file wasn't missing too.
	if ($local_file_exists) {
           $thumb_result = generate_thumbnail($linked_file_object["linked_file"],$regs[2]);
           if ($thumb_result) {
             $output .= " Thumbnail was made sucessfully. ";
           } else {
             $output .= "<b> Thumbail could not be made! </b> ";
           }
           
	}
      } 
      #graphic file - we need a thumb.
      $local_thumb_not_needed = false;
      
    } else {
      #is some other sort of mimetype - thumb not needed.
      $local_thumb_not_needed = true;
    }


    #perform the checks on the mirrored files!
    #Check using FTP!
    
    $mirror_server = "ftp.loudeye.com";
    $ftp_user_name = "imc";
    $ftp_user_pass = "m3dia!";

    # set up basic connection
    $conn_id = ftp_connect("$mirror_server"); 

    # login with username and password
    $login_result = ftp_login($conn_id, "$ftp_user_name", "$ftp_user_pass"); 
    
    # check connection
    if ((!$conn_id) || (!$login_result)) { 
      $output .= "<br>Ftp connection has failed!";
      $output .= "<br>Attempted to connect to $mirror_server for user $ftp_user_name";
      $output .= "<br><b>Cannot check mirrored file status!</b>";
      #$error_found = true;
      
    } else {
      #echo "Connected to $mirror_server, for user $user";
      
      
      #find mirror filename form of linked file. determine if exists
      #get filesize, check if same as local version!
      $mirror_size = ftp_size($conn_id,$mirror_file);  
        
      #if file exists remotely but not locally - WARNING condition.
        
      #find mirror thumbnail filename form of linked file. determine if exists -
      #get filesize, check if same as local version!
      #if file exists remotely but not locally - WARNING condition. 
        
      ftp_quit($conn_id);
    }
    
    
     #update multimedia_file table - insert or update with metadata - sizes, pixel sizes etc

    $output .= "<hr>";
    

    if ( (! $errors_only) 
	 || ($errors_only && $error_found)) {
      #display if verbose, or if error condition, if we are only showing errors
      echo $output;
    }
    
    if ($error_found) {
      $errored_files ++;
    }
  
  }
  #end of for loop.

  echo "<br> Checked all multimedia files.";
  echo "<br> <b> $errored_files files in error.</b>";

  $output = bottom();
  echo $output;
  break;
  
}

$db_obj->try_close();

# 
# end main script.
#

#
#Function for processing user input parameters
#
# Parameters from summary mode, admin mode.
#
function process_input_parameters() {
global $article_id, $led, $gadmin, $page, $refresh, $index, $group, $sort, $rate, $filter, $edit_comments,$default_edit_comments_led,$first,$mirror_system;

#setup the parameters to the database.
if (file_exists("debug")) {
  $data_hash = array (
		 "table_name" => "webcastdebug",
		 "seq_name" => "webcastdebugid"
		 );
} else {
  $data_hash = array (
		 "table_name" => "webcast",
		 "seq_name" => "webcastid"
	       );
}

# database query mode - could be 'summaries' or 'article'
$data_hash["mode"] = "summaries";        

# what does the user want to do? could be 'refresh' or 'browse' or 'led' or 
# 'group_admin' ( led -- linking, editing or deleting of articles)
$data_hash["display_mode"] = "browse";       

# do we want a specific article?
if (strlen(chop($article_id)) != 0) {
    $data_hash["mode"] = "article";
    $data_hash["article_id"]=chop($article_id);
} else {
    $data_hash["article_id"]=0;
}

if (strlen(chop($led)) != 0) {
    $data_hash["display_mode"] = "led";
}

if (strlen(chop($gadmin)) != 0) {
    $data_hash["display_mode"] = "group_admin";
}

if (strlen(chop($mirror_system)) != 0) {
    $data_hash["display_mode"] = "mirror_system";
    $data_hash["mirror_system_options"] = chop($mirror_system);
}

if (strlen(chop($page)) != 0) {
    $data_hash["page"] = chop($page);
} else {
    $data_hash["page"] = 0;
}

if (strlen(chop($refresh)) != 0) {
    $data_hash["display_mode"] = "refresh";
    if ($control_data["mode"] == 'article') {
        $data_hash["page"] = 0;
    }
    if ((chop($refresh))=="all") {
        $data_hash["display_mode"] = "all_article_refresh";
        #make sure the page var is zero.
        $data_hash["page"] = 0;
    }
}

if (strlen(chop($index)) != 0) {
  # not yet implemented - link in the search-process.php3 stuff here.
  $data_hash["display_mode"] = "index";
}

#the group (publishtype) parameter determines what "area" of the db to select.
#if no group parameter is sent , assume the main "area" of webcast
if (strlen(chop($group)) == 0) {
  $data_hash["publishtype"]="webcast";
  $data_hash["publishtype_heading"] = " webcast ";
  $data_hash["extra_args"]="group=webcast";
  $data_hash["extra_menu"]="";
  #set to nomenu to not show the quick link bar (produced in webcast.inc)
  $data_hash["menu"] = "menu";
}
else {
  $data_hash["publishtype"]=chop($group);
  $data_hash["publishtype_heading"]=" " . chop($group) ." ";
  $data_hash["extra_args"]="group=". chop($group);
  $data_hash["extra_menu"]="";
  $data_hash["menu"] = "menu";
}

#used to sort article summaries based on created/modified timestamps.
if (strlen(chop($sort)) != 0) {
	$data_hash["sort_filter"] = chop($sort);
} else {
	$data_hash["sort_filter"] = "date_desc";
}

#used to indicate a sorting (in summaries/admin display) based on (average) ratings.
if (strlen(chop($rate)) != 0) {
	$data_hash["rate"] = chop($rate);
}  else {
	$data_hash["rate"] = "none";
}

#process some article admin parameters.

#used to indicate a sorting (in summaries/admin display) based on mime types.
if (strlen(chop($filter)) != 0) {
	$data_hash["filter"] = chop($filter);
}  else {
	$data_hash["filter"] = "none";
}

if (strlen(chop($edit_comments)) != 0) {       
   $data_hash["edit_comments"] = $edit_comments;
} else {
   $data_hash["edit_comments"] = $default_edit_comments_led;
}

#pass the offset wanted to the database code..
if (strlen(chop($first)) != 0) {
	$data_hash["first_story"] = chop($first);
} else {
	$data_hash["first_story"] = 0;
}

return $data_hash;

}


?>

