<? 
# $Id: cast_class.inc,v 1.95 2001/06/30 09:21:57 andy Exp $

# how to display web pages for webcasts

# generates the front page from existing stuff in the database
# also has edit functions



if (! $cast_class_inc) {
  $cast_class_inc = true;

  class CastItem {

  #the GroupItem object - API on how to display articles.
  var $group_object;
  var $groupname;
  var $id;
  var $db_obj;

  function CastItem($id, $group_object_constructed, $db_obj_constructed) {
  # constructor - need the id in database, and two objects, GroupItem, DBClass

  #this article_id is the "anchor" id for these sets of articles being displayed.
  #that is, it is the article id of the "parent" article (think comments)..
  #although if an article has parent id of zero, then it is LINKED.
	$this->id = $id;

 	$this->group_object = $group_object_constructed;
        #access the groups db row.
        $groupdata = $this->group_object->form_data();
        $this->groupname=chop($groupdata["group_id"]);
        
        $this->db_obj = $db_obj_constructed;
  }

  function make_clickable($item) {
	$pattern = '#(http://|ftp://|mailto:|news:)([^\s<>()\]\[]+)([\s\n<>()\[\]]*)#';
	$ret = preg_replace($pattern,"<a href=\"\\1\\2\"><u>\\1\\2</u></a>\\3",$item);
   	return($ret);
  }

  #main entry point into CastItem class, designed to display the article in certain
  #modes. 
  function display($data_object, $mode, $rating_avg="not rated") {

    $str = "";

    $this->$mode=$mode;	
	
    $str .= "<!-- top language:" . $data_object->language . " -->";
	

    if ($data_object->parent_id ==0 && $this->$mode == "article") {
    	#only if not displaying a comment.
  	$str .= $this->utils($data_object);
    }
    $str .= $this->head_auth_date($data_object);
    $str .= $this->details($data_object, $rating_avg);
   

    if ($this->$mode == "article") {
      # display the full article (whatever it is)
      $str.= $this->display_article($data_object);
   
      #display the summaries too - only if this is not a comment
      # This is used to get the list of LINKED articles (ie other
      # main articles , not comments, that have been linked )
      if ($data_object->parent_id == 0) {

         #tell the display summary not to print the summary of ourselves
         #since the  display_article already has.
         $linked_summary = $this->display_summary($data_object,"no");

         if ($linked_summary != "") {
            $str .= "<font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\"><b>Linked articles:</b>" . $linked_summary;
         }
      }
          
   } else {
     # just show the summarised version
     $str .= $this->display_summary($data_object,"yes");
   }

   return $str;
  }

  function utils ($data_object) {
   global $appear;
   #add links to email article, print article (if not printable), pdf this article.
    
    $str = "<a href=\"email_display.php3?article_id=".$data_object->id."\">email this story</a> | \n";
    $str .= "<a href=\"pdf.php3?article_id=".$data_object->id."\">download as PDF</a> | \n";
    if (! ($appear["printable"] == "yes") || $appear["printable"] == "") {
	#added by manse for white bg
	$str .= "<a href=\"print.php3?article_id=". $data_object->id;
	$str .= "\">print article</a>\n";
    }
    $str .= "<p>";
    return $str;
  }


  # Function head_auth_date and details
  # At the moment designed to be called straight after one another (hmm)

  # head_auth_date:
  # returns a string contained a table tag (UNCLOSED!) , with information
  # inserted regarding db item fields 'heading', 'author', 'date'.
  # uses the 'heading_bgcolor' variable for tr bgcolor tag.
  
  function head_auth_date($data_object) {
  # Heading,Author,Date table 
    global $appear;
    
    # break down the pgsql timestamp into year, month, etc.
    ereg("([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})", 
      $data_object->created, $r);
   
    # break down the pgsql timestamp into year, month, etc.
    ereg("([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})", 
      $data_object->modified, $mod); 

    $timestamp = mktime($r[4], $r[5], $r[6], $r[2], $r[3], $r[1]);
    $timestamp += 60*60*$appear["time_difference"];
  
    $m_timestamp = mktime($mod[4], $mod[5], $mod[6], $mod[2], $mod[3], $mod[1]);
    $m_timestamp += 60*60*$appear["time_difference"];

    $nice_date = date("h:ia D M j 'y", $timestamp);
    
    if (substr($nice_date, 0, 1) == "0") {
      # strip leading 0
      $nice_date = substr($nice_date, 1);
    }
    
    $m_nice_date = date("h:ia D M j 'y", $m_timestamp);
    
    if (substr($m_nice_date, 0, 1) == "0") {
      # strip leading 0
      $m_nice_date = substr($m_nice_date, 1);
    }

    $str .= "<table width=\"100%\" border=0 hspace=0 vspace=0 cellspacing=0>";
    $str .= "<tr bgcolor=\"".$appear["heading_bgcolor"]."\"><td>\n";
    $str .= "<font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\"><b>\n";
    $str .= htmlentities($data_object->heading)."\n";
    $str .= "</b><br>\n";
    $str .= "<font size=-1>by ".htmlentities($data_object->author)."\n";
    $str .= "<i>".$nice_date."</i>";
    if ($timestamp != $m_timestamp) {
	$str .= " (Modified on $m_nice_date)";
    }
    $str .= "</font></font>\n";
    $str .= "</td></tr>\n";

    return $str;
  }

  # details:
  # returns a string closing the above unclosed table tag. , with information
  # inserted regarding db item fields 'address', 'phone', 'contact' (email).
  # uses the 'subheading_bgcolor' variable for tr bgcolor tag.
  #RATINGS: Also prints out information on the ratings!

  function details($data_object, $rating_avg) {
    global $appear, $ratings_system;

  # Contact,Link table
    $str .= "<tr bgcolor=\"". $appear["subheading_bgcolor"] ."\" valign=top>\n";

    $str .= "<td width=\"100%\"><font size=-1 face=\"Helvetica, Arial\" color=\"". $appear["fgcolor"] ."\">\n";
    if (strlen(chop($data_object->address)) != 0) 
    {
	    $str .= " address: ".$data_object->address;
    }

    if (strlen(chop($data_object->phone)) != 0) 
    {
	    $str .= " phone: ".$data_object->phone;
    }
    if (strlen(chop($data_object->contact)) != 0) 
    {
      $str .= " <a href=\"mailto:".$data_object->contact."\">"
      	.$data_object->contact."</a> ";
    }
    $str .= "</font></td></tr>";

    #Ratings: display the average.
    if ($ratings_system["display_avg_rating"] == "yes") {
	$rating_str .= "<tr bgcolor=\"". $appear["subheading_bgcolor"] ."\" valign=top>";
	$rating_str .= "<td width=\"100%\"><font size=-1 face=\"Helvetica, Arial\">\n";

	#convert the ratings display number into the group's rating description.
	$description = $this->group_object->rating_description($rating_avg);
	$rating_str .= "Average rating of <b>" . $description . "</b>" ;

	$rating_str .= "</font>\n";
	$rating_str .= "</td></tr>";

        if ($description != "not rated") {
           #only add the rating description html if actually rated.
           $str .= $rating_str;
        }
    }

    $str .= "</table>\n";
    return $str;
  }


  #Function to display multimedia article summary.

  #The argument 'display_self', can control whether to print out
  #the summary of an article, in the case of only having a
  #main article and NO other linked articles. This is used in the article view
  #(see above)
  
  function display_summary($data_object, $display_self="yes") {
    global $upload_folder, $relative_upload_folder, $upload_url,  
      $thumb_maxx, $thumb_maxy, $mirror_url, $appear,
      $mirror_delay, $multiple_thumbs, $number_of_thumbs, $mime_url, $use_mime_urls;

      if ($display_self == "yes") {

        #Get the summary out there nice and quick.
        $summary_ = $this->make_clickable(nl2br(htmlentities($data_object->summary)));
        $str .= "<table width=\"100%\" border=0 hspace=0 vspace=0>";
        $str .= "<tr><td><font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\">\n";
        $str .= "$summary_\n"; 
        $str .= "</font>\n";
        $str .= "</td></tr></table>\n";

      }

      $thumb = "";
      
      if (file_exists("debug")) {
        $data_link = array (
          "article_id" => $data_object->id,
          "table_name" => "webcastdebug",
          "linktable_name" => "weblinkdebug",
          "seq_name" => "webcastdebugid"
          );
        } else {
          $data_link = array (
            "article_id" => $data_object->id,
            "table_name" => "webcast",
            "linktable_name" => "weblink",
            "seq_name" => "webcastid"
            );
          }

    # Select from the database information about all the other
    # multimedia articles linked to this one.

    # It returns the db item itself as one row.
    list ($result_index, $rows) 
      = $this->db_obj->execute('selecting', 'getlinked', $data_link);

    $strlink = ""; $mime_icons_url = "";

    # loop around however many linked items we have
    # This loop generates the HTML tags necessary for producing
    # a summary of the multimedia article. 

    if ($display_self == "no") {
      $start_loop = 1;
    }
    else if ($display_self = "yes") {
      $start_loop = 0;
    }

    for ($item=$start_loop;$item<$rows;$item++) {
      #do the db call.
      $link_object = pg_fetch_object($result_index, $item);
      #figure out the mimetype of the linked item
      $mime_type = chop($link_object->mime_type);
      #get the filename of any associated media.
      $filename = chop($link_object->linked_file);
      $filenamebase = basename($filename);
      #figure out an an URL to the associated media.
      $file_url = $upload_url . $filenamebase;
     
      #a URL to linked 
      $full_url[$item] = "front.php3?article_id=" . $link_object->id . "&group=" .$this->groupname;
      $headings[$item] = chop(htmlentities($link_object->heading));
      eregi("([a-zA-Z0-9/\._-]+)\.([a-zA-Z0-9]+)$",$filename,$regs);

      if ($link_object->numcomment == 1)
      {
	$comments = " and one comment";
	$separate_comments = "<br><a href=\"$full_url[$item]\">read one comment</a>\n";
      }
      else if ($link_object->numcomment > 1)
      {
	$comments = " and ".$link_object->numcomment." comments";
	$separate_comments = "<br><a href=\"$full_url[$item]\">read " . $link_object->numcomment
	  . " comments</a>\n";
      } else {
	$comments = "";
	$separate_comments = "<br><a href=\"$full_url[$item]\">write a comment or give a rating</a>\n";
      }
      $filename_thumb = $regs[1] . "-thumb." . $regs[2];

      #determine if we have a story on our hands...
      $story[$item] = ( (strlen(chop($link_object->article)) > 0) or 
			#article in database.. or
      			(file_exists(chop($link_object->html_file))) );
			# long article entered, stored on disk, filename == field 'html_file'

      if (strlen(chop($link_object->link)) > 0) {
        $extlink = chop($link_object->link);

	# check the URL starts with http:// or ftp://
	if (!(ereg("^http://",$extlink,$reg) 
	  or ereg("^ftp://",$extlink,$reg))) { 
	  $extlink = "http://" . $extlink;
	}
	
	# for displayed URL strip start and crop if it's too long
        $cropextlink = eregi_replace("http://", "", $extlink);
        if (strlen($cropextlink) > $appear["url_crop"]) {
          $cropextlink = substr($cropextlink, 0, $appear["url_crop"]) . "...";
        }
	
        $external_link[$item] = "<a href=\"$extlink\">$cropextlink</a>";
      }


      #figure out a mimetype icon string (img src tags)
      if ($use_mime_urls) {
        $mime_icons_url[$item] .= $mime_url[$mime_type];
      }
      
      # do some mime specific processing of link text and number of
      # comments.
      
      switch($mime_type) {
        case "text/html":
          if ($story[$item]
            || (strlen(chop($link_object->linked_file)) > 0)) {
            $link_message[$item] = "(full story$comments)";
          }
          break;

        case "text/plain":
          if ($story[$item]
            || (strlen(chop($link_object->linked_file)) > 0)) {
            $link_message[$item] = "(full story$comments)";
          }
          break;
        case "text/x-url":
          $link_message[$item] = $link_object->heading;
          $full_url[$item] = $link_object->link;
	  $separate_comments_link[$item] = $separate_comments;
          break;      
        case "image/gif":
        case "image/jpeg":
	case "image/png":
          if ($story[$item]) {
            if ($use_mime_urls) {
              #add on to the mime_icons_url string since this has a story also
              $mime_icons_url[$item] .= $mime_url["text/plain"];
            }
          
            $link_message[$item] = "(picture and story$comments)";

	  } else {
            $link_message[$item] = "(picture$comments)";
	  }

      	  $thumb[$item] = " ";
	  $sizes="";
	  #find some to way to sensibly find the sizes of the images.
	   $thumb[$item] = "<img src=\"";
	   $thumb[$item] .= $this->make_largefile_url($filename_thumb,$link_object->mime_type, $link_object->mirrored);
	   $thumb[$item] .= "\" ". $sizes[3];
	   $thumb[$item] .= "border=0><br>";

          break;
        case "audio/mpeg":
          $size = filesize($filename);
          $size = $size / 1000000;
          $size = sprintf("%.1f", $size);
          $link_message[$item] = "(sound: mp3 @ $size megs)";
          if ($story[$item]) {
	    $story_link[$item] = "or <a href=\"$full_url[$item]\">(full ";
	    $story_link[$item] .= "story)</a>\n";
	  }

      	  $full_url[$item] = $this->make_largefile_url($filename,
	    $link_object->mime_type, $link_object->mirrored);

	  $separate_comments_link[$item] = $separate_comments;
          break;

        case "audio/x-pn-realaudio":
          $link_message[$item] = "(sound: realaudio)";
          if ($story[$item]) {
	          $story_link[$item] = "or <a href=\"$full_url[$item]\">(full ";
	          $story_link[$item] .= "story)</a>\n";
      	  } 

          $full_url[$item] = $this->make_realmedia_url($filenamebase, 
	    $link_object->mime_type, $link_object->mirrored);
	  if ($full_url[$item] == "notmirrored") {
	    $link_message[$item] = "(sound: realaudio - ready in
	    $mirror_delay minutes)";
	  }
	  $separate_comments_link[$item] = $separate_comments;

          break;

        case "video/x-pn-realvideo":
          $link_message[$item] = "(video: realvideo)";
          if ($story[$item]) {
	          $story_link[$item] = "or <a href=\"$full_url[$item]\">(full ";
	          $story_link[$item] .= "story)</a>\n";
      	  }

          $full_url[$item] = $this->make_realmedia_url($filenamebase, 
	    $link_object->mime_type, $link_object->mirrored);
	  if ($full_url[$item] == "notmirrored") {
	    $link_message[$item] = "(video: realvideo - ready in
	    $mirror_delay minutes)";
	  }
	  $separate_comments_link[$item] = $separate_comments;

          break;

	default:
	  $link_message[$item] = "(full story$comments)";
      }

      # debug: $media_type = $link_object->mime_type;

    } #end linked items loop

    #
    # cycle through again to actually generate HTML
    # 

    for ($item=$start_loop;$item<$rows;$item++) {
      $str .= "<font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\">\n";

      #$full url is only set to notmirrored if realmedia files havent been 
      #mirrored yet, and the global readmedia_url is also set to none. 
      #see make_realmedia_url function.
      
      #full_url is a href tag comprosed of db item field 'id' - that is
      #a link to front.php3 using the article_id=<id value> call.
      if ($full_url[$item] != "notmirrored") {
	$str .= "<center><a href=\"". $full_url[$item] . "\"><b>";
      }
      #
      # multiple_thumbs is set in webcast-setup.php3
      #
      if ($multiple_thumbs == "no") {
         #do old method. just show one thumb nail
         if ($item = 0) {
           $str .= $thumb[$item];
         }
      }
      elseif($multiple_thumbs = "yes") {
        if ($item < $number_of_thumbs || $number_of_thumbs == 0) {
          #the thumb array is setup containing an img src tag if the
          #db item has 'mimetype' field set to image/gif image/jpg

          $str .= $thumb[$item];
        }
      } 

      # Add a mime type icon .. and
      # the heading array is db item field 'heading'
      $str .= $mime_icons_url[$item] . $headings[$item] . " ";

      #the link_message is db item field 'numcomment' tacked on the end
      # of a 'mimetype' specific string eg (full story...), (picture..)
      # Exceptions: text/url , audio/mpeg , audio/x-pn-realaudio , audio/x-pn-realvideo.
      $str .= $link_message[$item];
      $str .= "</b></a></center>";
      #story link is a link back to the db item - via field 'id' using
      # "front.php3?article_id=<id value>"  . Only used for exceptions
      # to mimetype dependency above.

      $str .= $story_link[$item];
      
      #external_link array is a kludged version of the db item field 'link'
      
      $str .= "<center>". $external_link[$item]. "</center><br>\n";
      
      #separate_comments_link is db item field 'numcomment'-dependent link to
      # read the (variable number of) comments. 
      # It is used by the exceptions to link_message mimetype dependency, above.  
      $str .= $separate_comments_link[$item];
      $str .= "</font>\n";
    }

    return $str;
  }


  ###Function to display multimedia article.

  function display_article($data_object) {
    global $upload_folder, $upload_url, $mirror_url, $appear, $mirror_delay, $quick_comment, $ratings_system;

        $str .= "<table width=\"100%\" border=0 hspace=0 vspace=0>";
    $str .= "<tr><td><font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\">\n";
    $summary_ = $this->make_clickable(nl2br(htmlentities($data_object->summary)));
    $str .= "<p><blockquote><blockquote>\n";
    $str .= "$summary_\n</blockquote></blockquote>";

    $mime_type = chop($data_object->mime_type);
    $linked_file = chop($data_object->linked_file);
    $html_file = chop($data_object->html_file);	

    $filedirname = dirname( $linked_file );
    $filenamebase = basename( $linked_file );
    # unless we're using ramgen, change .rm to .ram 
    if ($ramgen != "yes") {
      $ramfilebase = eregi_replace(".r[avm]$", ".ram", $filenamebase);
    } else {
      $ramfilebase = $filenamebase;
    }
    $file_url = $upload_url . $filenamebase;
    $filename = $filedirname . "/" . $filenamebase;
	
    if (strlen(chop($data_object->link)) > 0) {
      $extlink = chop($data_object->link);

      # check the URL starts with http:// or ftp://
      if (!(ereg("^http://",$extlink,$reg) 
	or ereg("^ftp://",$extlink,$reg))) { 
	$extlink = "http://" . $extlink;
      }

      # for displayed URL strip start and crop if it's too long
      $cropextlink = eregi_replace("http://", "", $extlink);
      if (strlen($cropextlink) > $appear["url_crop"]) {
        $cropextlink = substr($cropextlink, 0, $appear["url_crop"]) . "...";
      }

      $external_link = "<p><a href=\"$extlink\">$cropextlink</a>";
    }

    #
    #process the ATTACHED (uploaded) multimedia file in some way.. 
    # 
    #(notice: if nothing got attached.. mime_type is still set at text/plain.)
    # is it a text file of some sort?
    if ( $mime_type == "text/html" || $mime_type == "text/plain") 
    {
 	if (file_exists($linked_file)) {
		$fd = fopen($linked_file, "r");
		$file_contents = fread($fd, filesize($linked_file));
		fclose($fd);
      	}
	$str .= "<p>\n";			

	if (chop($data_object->mime_type) == "text/html") {
	      $str .= (chop($file_contents));
      	} else {
	      $str .= $this->make_clickable(nl2br(htmlentities(chop($file_contents))));
      	}

      

    } elseif ($mime_type == "image/gif" || $mime_type == "image/jpeg" 
	      || $mime_type == "image/png") {
      if (file_exists($filename)) {
        $sizes = GetImageSize($filename);
      } else {
	$sizes = "";
      }
      	$str .= "<img src=\"" . $this->make_largefile_url($filename, 
	    $data_object->mime_type, $data_object->mirrored) . "\" ";
      	$str .= $sizes[3] . "><p>";

   } elseif ($mime_type == "audio/mpeg") {

          $size = filesize($filename);
          $size = $size / 1000000;
          $size = sprintf("%.1f", $size);
          $link_message = "listen to the report 
            (sound: mp3 @ $size megs)";

      	  $full_url = $this->make_largefile_url($filename,
	    $data_object->mime_type, $data_object->mirrored);
          $str .= "<a href=\"" . $full_url . "\">$link_message</a>";

    } elseif ($mime_type == "audio/x-pn-realaudio") {
      $full_url = $this->make_realmedia_url($filenamebase,
      	$data_object->mime_type, $data_object->mirrored);

      if ($full_url == "notmirrored") {
	$str .= "(sound: realaudio - ready in $mirror_delay minutes)";
      } else {
	$str .= "<a href=\"" . $full_url . "\">";
	$str .= "listen (realaudio)</a>";
      }

    } elseif ($mime_type == "video/x-pn-realvideo") {
      $full_url = $this->make_realmedia_url($filenamebase,
      	$data_object->mime_type, $data_object->mirrored);
      if ($full_url == "notmirrored") {
	$str .= "(video: realvideo - ready in $mirror_delay minutes)";
      } else {
	$str .= "<a href=\"" . $full_url . "\">";
	$str .= "watch this video (realvideo)</a>";
      }

    } else {
      #unknown mimetype.. display a link for downloading..
        $str .= "<br>Download attached file: ";
        $download_url = $this->make_largefile_url($filename,$data_object->mime_type, $data_object->mirrored);
        $str .= "<a href=\"".$download_url."\"> $filenamebase (mimetype: " . $data_object->mime_type . ")</a>";
	if ( $mime_type == "application/msword" ) {
	$str .= "<br> or view as PDF document: ";
	$str .= "<a href=http://" . getenv("HTTP_HOST") . "/convert.php3?target=pdf&article_id=" . $data_object->id . "> ($filenamebase as PDF)</a>";
	$str .= " or as a ";
	$str .= "<a href=http://" . getenv("HTTP_HOST") . "/convert.php3?target=html&article_id=" . $data_object->id . ">web page: </a><p>";
	}
    }    

    # here is where we extract article text from the db column 'article'
    if (strlen(chop($data_object->article)) > 0) {
      $str .= "<p>\n";

      #note : new use of "is_html" field to switch whether article is plain or html
      if (chop($data_object->is_html) == "t") {
	      $str .= chop($data_object->article);
      } else {
	      $str .= $this->make_clickable(nl2br(htmlentities(chop($data_object->article))));
      }

    } else {
      #perhaps the article was too long , so open the file in $html_file 
      # and display as raw html (if html was included)
      $long_story = chop($data_object->html_file);
      if (file_exists($long_story)) {
	$fd = fopen($long_story, "r");
	$long_story_file_contents = fread($fd, filesize($long_story));
	fclose($fd);

        if (chop($data_object->is_html) == "t") {
          $str .= stripslashes(chop($long_story_file_contents));
        } else {
          $str .= $this->make_clickable(nl2br(htmlentities(stripslashes(chop($long_story_file_contents)))));
        }
      }
    }
 
    #display a external web link
    $str .= $external_link;
    
    #"acknowledge" end of original article and start of discussions - 
    #if statement below executes once from point of view of loop calling 
    #it, all other $article_id's are comments on the original article..
    if ($data_object->id == $this->id) {



      # this case for original article
      #
      #quick comment code.
      #
       if ($quick_comment == "yes") {

	$str .= $this->make_comment_system($data_object->id);        

       } else {
	   $str .= "<p><a href=\"comment.php3?publishtype=$this->groupname&top_id=".$data_object->id."\">add your own comments</a>\n";
       }

       #if allowing user ratings, display a form to allow a rate.
       if ($ratings_system["user_rate"] == "yes") {
	   
	  $str .= $this->make_rating_system($data_object->heading,$data_object->id,$this->id);
       }

    } 
    # else - the just-printed article in the loop actually was a comment.
    else {
	#this case for comments

	#need to display comments on comments.	
	#$str .= "<p><a href=\"comment.php3?publishtype=$this->groupname&top_id=".$data_object->id."\">comment on this comment</a>\n";

	#add a form, on rating the comments.
	if ($ratings_system["user_rate"] == "yes") {
	   
	  $str .= $this->make_rating_system($data_object->heading,$data_object->id,$this->id);
       }
    }

    $str .= "</font>\n";
    $str .= "</td></tr></table>\n";

    return $str;
  }

  function make_comment_system($id) {
   global $appear;
   	$filecomment = "comment-quick-entryform.inc";
   	$fd=fopen($filecomment, "r");
   	$sz = filesize($filecomment);
   	$qc = fread($fd, $sz);
   	fclose($fd);
  
   	$str .= "<table border=0 cellspacing=0 width=\"100%\" bgcolor=\"".$appear["background_grey"]."\">";
   	$str .= "<tr><td>";
   	$str .= "<font face=\"Helvetica, Arial\"><b> Make a quick comment on this article.</b></td></tr>";
   	$str .= $qc;
   	$str .= "<tr><td><input type=\"hidden\" name=\"top_id\" value=\"$id\">";
   	$str .= "<input type=\"hidden\" name=\"publishtype\" value=\"$this->groupname\">";
	 
   	$str .= "<font face=\"Helvetica, Arial\">add your own <a href=\"comment.php3?publishtype=$this->groupname&top_id=".$id."\">longer comments</a> (including web links and multimedia uploads)</td>";
   	$str .= "</form></font></table>";
   	return $str;
  }


  function make_rating_system($heading,$id,$parent_id) {
    global $appear;

        $str .= "<table border=0 cellspacing=0 width=\"100%\" bgcolor=\"".$appear["background_grey"]."\">";

	if ($id != $parent_id) {
		$rating_heading = "Make a rating on this comment.";
	} else { 
		$rating_heading = "Make a rating on this article.";
	}

	$str .= "<tr><td> <font face=\"Helvetica, Arial\"><b>$rating_heading</b></td></tr>";

	#setup the form to assign new ratings.
	$str .= "<tr><td>";
	$str .= "<form method=\"post\" action=\"edit_webcast.php3\">
                 <input type=\"hidden\" name=\"rating\" value=\"yes\">
                 <input type=\"hidden\" name=\"heading\" value=\"".chop($heading)."\">
		 <input type=\"hidden\" name=\"parent_id\" value=\"".$parent_id."\">
                 <input type=\"hidden\" name=\"userid\" value=\"1\">
 		 <input type=\"hidden\" name=\"publishtype\" value=\"$this->groupname\">
                 <input type=\"hidden\" name=\"art_id\" value=\"".$id."\" >";
	#use the group object to print the rating system select widget.
	$str .= $this->group_object->make_rating_system_select();

	$str .= "<font face=\"Helvetica, Arial\"><input type=\"submit\" value=\"Add rating\">";
	$str .= "</tr></td></form></table>";
	$str .= "</font>";
	return $str;
  }


  function make_largefile_url($filename, $mime_type, $mirrored) {
    global $upload_url, $mirror_url, $mirror_mime_types;
  
    	if ($mirrored == "t" && eregi(chop($mime_type), $mirror_mime_types, $regs)) {
        	$filenamebase = basename( $filename );
		$ret = $mirror_url[chop($mime_type)] . $filenamebase;
    	} else {
        	$ret = $filename;
    	}
    	return $ret;
  }

  function make_realmedia_url($filenamebase, $mime_type, $mirrored) {
    global $ramgen, $realmedia_url, $mirror_url, $mirror_mime_types;
  
    # unless we're using ramgen, change .rm to .ram 
    if ($ramgen != "yes") {
      $ramfilebase = eregi_replace(".r[avm]$", ".ram", $filenamebase);
    } else {
      $ramfilebase = $filenamebase;
    }
    
    if ($mirrored == "t" 
      && eregi(chop($mime_type), $mirror_mime_types, $regs)) {
      	$ret = $mirror_url[chop($mime_type)] . $ramfilebase;
    } else {
      	if ($realmedia_url == "none") {
	  $ret = "notmirrored";
	} else {
      	  $ret = $realmedia_url . $ramfilebase;
	}
    }
    return $ret;
  }

  #end of class definition
  }
} # end if (! $cast_class_inc)

?>





