<?php
#
# Functions below implement the functionality needed to slurp the articles from the
#  database, format them into a variety of html depending whether summaries or a 
#  specific article is wanted,
#  and either display them or cache them on disk.


#
# Function do_db_call calls the database, via the DBClass object, asking for
# a 'selecting' type query, using the desired mode of the user.
# That is, a mode of 'summaries' or 'article' at the moment.
# It is assumed the data hash has been setup with all appriopriate key/value pairs.

function do_db_call($db_obj, $db_data) {
#kludge a few vars in from the main namespace
global $page_length, $summary_pages_to_refresh_auto;

#Here is where the db call is made, selecting either a specific article or
#all summaries.
# When selecting the summaries, all the 'top-level' articles
#(ie articles not comments to articles) are returned.
#When the rows are feed to the castclass object for display, in summary
#mode, the castclass object makes a further call for all linked articles
#to display in the summary view.
# When selecting the article , the article and the associated comments,
#are returned. These are feed to the castclass object for displaying in
#article mode.

$db_obj->write_to_log("article_display.inc:do_db_call()\n");
list ($result_index, $rows) = $db_obj->execute('selecting', $db_data["mode"], $db_data);

#calculate how many pages this many articles will need to be displayed.  
$page_total = ceil( (float) $rows/ (float) $page_length);

# loop through only one (html) page if we are in browse (dynamic) display mode
# whether or not we are in summaries or article mode..
if ($db_data["display_mode"] == 'browse') {
  $page_gen_max = $page_wanted + 1;
  $page_gen_start = $page_wanted;
  
}
if ( $db_data["display_mode"] =='refresh'
     || $db_data["display_mode"] =='all_article_refresh' ) {
# In refresh or all_article_refresh display mode:
# In article mode, we only want to output one long html page.
# In refresh display mode, summary mode, we want to output many pages.
  
#start refreshing the pages from the one specified.
#If a page wasnt specified, it defaults to zero.
  $page_gen_start = $db_data["page"]; 

  if ($db_data["mode"] == 'article') {
    $page_gen_max = 1;
  } else {
    #hard limit the number of pages to refresh in summary mode..
    if ($summary_pages_to_refresh_auto <= 0) {
	$summary_pages_to_refresh_auto = 2;
    }

    $page_gen_max = $page_gen_start + $summary_pages_to_refresh_auto;
    if ($page_gen_max > $page_total) {
	$page_gen_max = $page_total;
    }
  }

  if ($page_total == 0) {
#if there arent any stories available, we need to at least go through
#the loop below once to detect that, and put a string out saying "no story to tell yet.."
    $page_gen_max = 1;
  }
  
# close table tag just in case for sidebar table style
# so netscape users can see stuff without waiting
# for whole page after refresh is done
  echo "</td></tr></table>\n";

  if ($mode == 'summaries' && $display_mode == "refresh") {
    $refresh_output = "<p>refreshing ".($page_gen_max-$page_gen_start)." summary pages. Starting on page $page, ending on page ".($page_gen_max-1)."<p>\n";
  } else if ($mode == 'article' && $display_mode == "refresh") {
    $refresh_output = "<p>refreshing article id $article_id.<p>\n";
  } else if ($mode == 'summaries' && $display_mode == "all_article_refresh") {
    $refresh_output = "<p> refreshing all $rows articles.<p>\n";
  }

 #flush();

} 
#end refresh/all_article_refresh display mode

# if in summary mode, update the mirror flags first
if ($db_data["mode"] != "article") {
  list ($result,$reason) = $db_obj->execute('mirror_flag_update', 'ignoreme', $db_data);
  if ( (! $result) && strlen(chop($reason)) != 0) {
     $refresh_output .= $reason;
  }
}

#return the db result

return array ($result_index, $rows, $page_gen_start,$page_gen_max, $refresh_output);
}
#end function do_db_call


#
#Function which does the looping through the pages
# calls - do_inner_page_loop, do_page_nav_aids, do_static_file_writing
#

function do_main_page_loop($result_index, $rows, $page_gen_start,$page_gen_max,
                           $db_obj, $article_data) {
#kludge a few vars in from the main namespace
global $page_length;

#echo "dmpl: $rows, $page_gen_start,$page_gen_max<br>";

#recalculate how many pages this will need.
$page_total = ceil( (float) $rows/ (float) $page_length);

#loop: generate the summaries or article from the request start page to the end page.
  for ($page_gen = $page_gen_start; $page_gen < $page_gen_max;  $page_gen++) {
    
    #calculate the first and last article
    $first = $page_gen * $page_length;
    $last = $first + $page_length - 1;
    
    #if we are generating summaries, and the number of rows returned is greater than
    #than the desired articles for the page, the limit is the page length,
    #else we dont have enough to fit the page, so just use what we have..
    if ($article_data["mode"] == "summaries" && $rows > $last+1) {
      $limit = $page_length;
    } else {
      $limit = $rows - $first;
    }
    #echo "first is $first , last is $last , limit is $limit <p>";

    #through db class, write to log file.
    $db_obj->write_to_log("article_display.inc:do_main_page_loop() display mode " . $article_data["display_mode"] . "; mode " . $article_data["mode"] . "; page $page_gen\n");

    #call function to generate each page. It will output $limit number of articles
    # (formatted through CastItem object) each HTML page.
    $output = do_inner_article_display_loop($result_index, $first, $limit, $page_gen,
                                            $rows, $db_obj, $article_data);
    
    #call helper function to make page navigation html
    if ($article_data["mode"] == "summaries") {
       $output .= do_page_nav_aids($page_gen,$rows,$last,$page_total,$article_data);
    }

    if ($article_data["display_mode"] == 'browse') {
      #dynamic display  - output the html to the browser.
      $output .= bottom();
      echo $output;
    } else { 
      #else must be display_mode = refresh or all_article_refresh
      #call the helper function to write the static output.

      #Here, we dont need to worry about bottom() , as top() and bottom()
      # are appended dynamically at request time via front.php3 (which indexes
      # into the static file system)
     
      $refresh_output .= do_static_file_writing($output,$page_gen,$article_data);
    }

  } 
# end $page_gen for loop

 #return the refresh/static files messages
 return $refresh_output; 
}
#end function do_main_loop


#
# Function for do inner article display loop
#
# This is called *once* per html _page_ . It loops around for a limited number of
# articles per page, & for each article it uses a CastItem object to display it.

function do_inner_article_display_loop($result_index, $first, $limit,$page_gen, $rows, $db_obj, $article_data) {
global $page_length;

    #recalculate how many total pages this request will need.
    $page_total = ceil( (float) $rows/ (float) $page_length);

    $article_table_start = "<table width=\"100%\" border=0 hspace=0 vspace=0>\n";
    
    #
    # Main Loop: loop through $limit number of articles for this HTML page.
    # 
    #  
    for ($cell_counter=0; $cell_counter<$limit; $cell_counter++) {
      #fetch the object from the database , indexed by cell_counter and first. 
      $data_object = pg_fetch_object($result_index, $cell_counter + $first);

      #echo "debug: " . $data_object->id. ":" . $data_object->heading . "<br>";
  	
      $article_table .= display_article_filtered($db_obj,$data_object,$article_data);
    }
 
    if ($limit == 0 || strlen($article_table) == 0) {
      $article_table .= "\n<td><b>no story to tell yet</b></td>\n";
    }


    # if we are viewing an summary, say which page we are on
    if ($article_data["mode"] != "article") {
      $which_page = "(page " . ($page_gen+1) . " of " . $page_total . ")";

    } else {
      #set up prev/next article links in article mode

      $page_nav_prev = "<a href=\"front.php3?article_id=".$article_data["previous_article_id"]."&group=".$article_data["publishtype"]."\"> next article - <b>".$article_data["previous_article_heading"]."</b></a> ";
      $page_nav_next = "<a href=\"front.php3?article_id=".$article_data["next_article_id"]."&group=".$article_data["publishtype"]."\"> previous article - <b>".$article_data["next_article_heading"]."</b></a>";
      if ($article_data["previous_article_id"] != 0) {
	$page_nav = $page_nav_prev;
      }
      if ($article_data["previous_article_id"] !=0 && $article_data["next_article_id"] !=0) {
	$page_nav .= " | ";
      }
      if ($article_data["next_article_id"] != 0) {
        $page_nav .= $page_nav_next;
      } 
      $page_nav .= "<br>";
    }

    #set type of cache to issue, via top(), depending upon what display mode.
    #if its dynamic output (browse) we can cache for longer.
    if ($article_data["display_mode"] == 'browse') {
	$cache = "cache";
    } else {
	$cache = "shortcache";
    }
    
    #
    # Do "top" ie front header, sidebar etc.. ie begin actual web page.. 
    #	<<HTML here>> ie header -> articles --> footer .
    # 
    $top = top($article_data["publishtype_heading"]. "news " . $which_page, "cache",
               $article_data["menu"], $article_data["extra_menu"] , $page_nav,
               $article_data["extra_args"]);

    # i'm commenting this navigation bar out
    # according to the principle of least surprise
    # it's cool but people upgrading their code should not have this appear
    # by default because it substantially interferes with the layout
    # rather they should be able to turn it on with a config preference
    # which needs to be created - maffew april 2001

    #if ($article_data["mode"] != "article") {
        #Place html nav links allowing , sorting of articles
        #by ctime/mtime/ratings etc within the current group.
    	#$nav = form_article_nav_bar($article_data); 
    #} else {
    #	$nav = "";
    #}

    $nav = "";

    $output = $top . $nav . $article_table_start. $article_table;
    $output .= "\n</table><p>\n";
 
return $output;
}
#end function do_inner_page_loop


#
# function which displays the article, according to a ratings filter.
#

function display_article_filtered($db_obj,$data_object,$article_data) {
global $ratings_system;

      #if the article row passed is crap, ie no id, just return.
      if ($data_object->id == "") return;

      #RATINGS: filter stories using the ratings_system global variable
      $rate_data = array (
			  "table_name" => "article_classification",
			  "article_id" => $data_object->id
			  );
      list ($ratings_result, $rate_rows) = $db_obj->execute('selecting','ratings_avg'
                                                            ,$rate_data);
      if ($ratings_result) {
        #everything ok - just returns one row with average.
	$rate_obj = pg_fetch_object($ratings_result, 0);
	$rating_avg = $rate_obj->avg;
	if ($rating_avg == "") $rating_avg=0;
      } else {
        #no ratings yet.
	$rating_avg = 0;
      }

      #echo "<p>using " .$ratings_system["default_threshold"]." as a threshold.";
      
      #filter out article if not higher than a threshold.
      if ($rating_avg >= $ratings_system["default_threshold"]) {

        #make the CastItem object here.	- give the id, the GroupItem object, and
        #the DBClass object.
	$news_item = new CastItem($article_data["article_id"],$article_data["group_object"],$db_obj);
	
	$output = "\n<tr valign=\"top\"><td>\n";

        #make the CastItem object display the article.
	$output .= $news_item->display($data_object, $article_data["mode"], $rating_avg);
	#$output .= "\n<br>&nbsp;</td></tr>\n";
	$output .= "\n</td></tr>\n";

      } else {
        #dont display. The article's rating is below the default threshold! write into a different version of the front cache perhaps?!
        $output = "";
      }
return $output;
}
#end function display_article_filtered.

#
# Function for making the page navigation aids
# 

function do_page_nav_aids($page_gen, $rows, $last,$page_total,$article_data) {

#echo "do_page_nav_aids $page_gen, $rows, $last,$page_total";

 #data["extra_args"] is the group parameters
 $args_to_use = $article_data["extra_args"]; 
 
 #need to add 'sort' and 'rate' parameters , so that page nav links
 #go to the consistent static files.
 $args_to_use .= "&sort=".$article_data["sort_filter"]."&rate=".$article_data["rate"];
    
  if ($page_gen > 0) {
    if ($article_data["display_mode"] == 'browse') {
      $pagelink = "<td align=left>"
	. "<a href=\"display.php3?" . $args_to_use
	. "&page=" . ($page_gen-1)
	. "\">&lt;&lt;newer stories</a></td>\n";
    } else {
      $pagelink = "<td align=left>"
	. "<a href=\"front.php3?" . $args_to_use
	. "&page=" . ($page_gen-1)
	. "\">&lt;&lt;newer stories</a></td>\n";
    }
  }
  
#if the number of rows retrieved from the datbase, is greater than the number
#of article on this page.
  if ($rows > $last + 1) {
    if ($article_data["display_mode"] == 'browse') {
      if ($mode != "article") {
	$pagelink .= "<td align=right>"
	  . "<a href=\"display.php3?" . $args_to_use
	  . "&page=" . ($page_gen+1)
	  . "\">more stories&gt;&gt;</a></td>\n";
      }
    } else {
      $pagelink .= "<td align=right>"
	. "<a href=\"front.php3?" . $args_to_use
	. "&page=" . ($page_gen+1)
	. "\">more stories&gt;&gt;</a></td>\n";
    }
  }
  
#do page navigation links. Start with a hardcoded link to first page.
  $page_nav = "<a href=\"front.php3?" . $args_to_use ."&page=0\">first page</a> | page ";
    
#warning magic number below. controls how many page links are shown
  $start = $page_gen - 10;

#start on second page.. page 0 - first page page 1 - second page
  if ($start < 1) {
    $start = 1;
  }

#warning: magic number below. controls how many page links are shown
  $end = $page_gen + 11;

#end on second last page
  if ($end > $page_total - 1) {
    $end = $page_total - 1;
  }

#the case for only two pages.. ie start==end
  if ($start == $end) {
    $end = 2;
  }

  for ($page_num=$start; $page_num < $end; $page_num++) {
    if ($page_gen != $page_num) {
      $page_nav .= "<a href=\"front.php3?" . $args_to_use
	. "&page=" . ($page_num)
	. "\"> " . ( $page_num + 1) . "</a> | ";
    }
    else {
#we are "on" this page so dont make it hyperlinked.
      $page_nav .= " <b>" . ($page_num + 1) . "</b> | ";
    }
  }

#end with hardcoded link to last page
$page_nav .= " <a href=\"front.php3?" . $args_to_use . "&page=" . ($page_total - 1). "\"> last page (".($page_total).") </a>";

#compose all the helpful navigation links at the bottom of the summary view
if (strlen($pagelink) != 0) {
  $output .= "<table border=0 width=100%><tr>\n";
  $output .= $pagelink;
  $output .= "</tr><tr align=center>" . $page_nav ;
  $output .= "</tr></table>\n";
}

return $output;
}
#end function do_page_nav_aids()

#
#Function for making the navigation bar on the article page
#

function form_article_nav_bar($article_data) {

/* Not currently implemented for article display yet.
#start the filters here - ie show hidden only, show "showing" only, show different mime types only

if (strlen(chop($filter)) == 0) {
	$filter_string = "<i> Filtering articles is not on. </i><br>";
        $filters_flag="&filter=none";
} else {
	if (chop($filter)=='none') { $filter_string = " not on. ";}
			      else { $filter_string = "<b>" . $filter." items only. </b>";}
 	$filter_string = "<i> Filtering articles by " . $filter. " </i><br>";
        $filters_flag="&filter=".chop($filter);
}
*/

if ($article_data["rate"] == 'none') {
	$rate_string = "<i> Grouping articles by rating is not on.</i><br>";
	$rating_flag="&rate=none";
} else {
	$rate_string = "<b>" .$article_data["rate"] . " first. </b>";
	$rate_string = "<i> Grouping articles by rating is ".$rate_string."</i><br>";
	$rating_flag="&rate=".$article_data["rate"];
}


$sort_flag = "&sort=".$article_data["sort_filter"];


#formulate the base URL for the filter options including the comments flag..
$filters_toggle_base="<a href=\"front.php3?". $article_data["extra_args"] . $sort_flag . $rating_flag;

#formulate the base URL for the sorting options 
$base_sort_url = "<a href=\"front.php3?" . $article_data["extra_args"] . $rating_flag ;

#formulate the base URL for the grop by ratings options
$base_rating_url = "<a href=\"front.php3?" . $article_data["extra_args"] . $sort_flag ;

#mime type selector - not used yet for articles..
#$navigate .= $filter_string . "Filter story by: " . make_mime_type_selector($filters_toggle_base);

#created/modified time order selector
list ($selector, $sort_desc)  = make_created_mod_order_selector($base_sort_url,
                                                                $article_data["sort_filter"]);
#display the status of the filtering/sorting/grouping by rating system
$sort_string = "<i> Sorting articles by <b> " .$sort_desc. "</b></i>.<br>";

#ratings selector
$navigate .= $rate_string ."Group articles by ratings: " . make_rating_order_selector($base_rating_url);

$navigate .= $sort_string . "Sort story by: " . $selector; 

return $navigate;
}


#
# Function implementing the static file caching system.
#

function do_static_file_writing($output,$page_gen,$article_data) {
global $front_file, $front_page_news_file, $summary_file, $summary_length, $start_time, $article_file_prefix;

if ($article_data["mode"] == 'summaries') {
  $exploded_output = explode("<!--endmenu-->", $output);
  $output = $exploded_output[1];
  
  $this_front_file = $front_file . $page_gen . "-". $article_data["publishtype"]. "-" . $article_data["sort_filter"] . "-" . $article_data["rate"] . ".html";
  $fffp = fopen($this_front_file, "w");
  fwrite($fffp, $output, strlen($output));
  fclose($fffp);
  
  # for the front page, write out a copy with a special name
  # and munge it up a bit so it works in that context
  if ($page_gen == 0) {
    # munge the relative URLs to point within newsfolder
    $output = eregi_replace("display.php3", "news/display.php3", $output);
    $output = eregi_replace("front.php3", "news/front.php3", $output);
    $output = eregi_replace("\.\.\/", "./", $output);
    $fffp = fopen($front_page_news_file, "w");
    fwrite($fffp, $output, strlen($output));
    fclose($fffp);
    
    # one liners style for front page
    #TODO : SUMMARY LIST function: the markup (eg html) can be created from the above routines
    #no need for a new db connection & query inside this function.      
    $output = summary_list($summary_length);
    $fffp = fopen($summary_file, "w");
    fwrite($fffp, $output, strlen($output));
    fclose($fffp);

    # newswire xml rss
    if (!$newswire_rss_file) { $newswire_rss_file = './newswire.rss'; }
    $output_rss = summary_list_xml($summary_length);
    $fffp = fopen('./newswire.rss' , "w");
    fwrite($fffp, $output_rss, strlen($output_rss));
    fclose($fffp);
				
  }      	
  
  # apparently flush only works with print and not echo?
  $elapsed = time() - $start_time;
  $refresh_output = "<br>page $page_gen refreshed - $elapsed seconds so far<br>\n";

} else {
  #must be $mode = 'article' - writing the article to a file
  $exploded_output = explode("<!--endmenu-->", $output);
  $output = $exploded_output[1];
  if (strlen(chop($article_file_prefix))==0) {
      $article_file_prefix = "./local/webcast/cache/article";
  }
  $this_article_file = $article_file_prefix . $article_data["article_id"] . "-" . $article_data["publishtype"]. ".html";
  $fffp = fopen($this_article_file, "w");
  fwrite($fffp, $output, strlen($output));
  fclose($fffp);

  $elapsed = time() - $start_time; 
  $refresh_output = "(article id ".$article_data["article_id"]." refreshed - $elapsed seconds so far)<br>\n"; 

  #touch the timestamp file HERE. Ie only update the timestamp for refreshing 
  #summary pages ie when a new article/comment is published/editied.
  touch ("./local/webcast/cache/timestamp");
}

return $refresh_output;
}
#end function do_static_file_writing()

?>
