<?php

#
# [[[ Functions below are used for the administration page(s) display ]]] 
#

#
#Function for making the navigation bar on the article admin page
#

function form_editing_nav_bar($admin_data) {
#kludge some vars out of the main namespace
global $edit_page_length;

#start the filters here - ie show hidden only, show "showing" only, show different mime types only
if ($admin_data["filter"] == 'none') {
	$filter_string = "<i> Filtering articles is not on. </i><br>";
        $filters_flag="&filter=none";
} else {
        $filter_string = "<b>" . $admin_data["filter"]." items only. </b>";
 	$filter_string = "<i> Filtering articles by " . $filter_string. " </i><br>";
        $filters_flag="&filter=".$admin_data["filter"];
}

if ($admin_data["rate"] == 'none') {
	$rate_string = "<i> Grouping articles by rating is not on.</i><br>";
	$rating_flag="&rate=none";
} else {
	$rate_string = "<b>" .$admin_data["rate"] . " first. </b>";
	$rate_string = "<i> Grouping articles by rating is ".$rate_string."</i><br>";
	$rating_flag="&rate=".chop($admin_data["rate"]);
}


if ($admin_data["sort"] == 'none') {
	$sort_flag = "&sort=date_desc";
} else {
	$sort_flag = "&sort=".$admin_data["sort"];
}

if (substr($admin_data["edit_comments"], 0, 1) == "y") {
  $comments_flag = "&edit_comments=y";
  $comments_toggle_append = "&edit_comments=n\">hide comments</a>\n";
} else {
  $comments_flag = "";
  $comments_toggle_append = "&edit_comments=y\">show comments</a>\n";
}
	
#offset into the db.
$first_story_flag = "&first=".$admin_data["first_story"];

  #make a common "state of admining" flag..
  #add the led=y to the view filters ..ie send the fact that we are in article
  #admin to the top function, so that the href's get the cgi params correct.
  $common_flag = "&led=y";
  
$comments_toggle = "<a href=\"display.php3?". $admin_data["extra_args"] . $common_flag .$sort_flag . $rating_flag . $filters_flag . $first_story_flag. $comments_toggle_append ;

#formulate the base URL for the filter options including the comments flag..
$filters_toggle_base="<a href=\"display.php3?". $admin_data["extra_args"] . $common_flag . $sort_flag . $rating_flag . $comments_flag;

#save the admin link setup & filter flags for later.
$nav_bar["adminlink"] = $filters_toggle_base;
$nav_bar["filterflag"] = $filters_flag;

#formulate the base URL for the sorting options 
$base_sort_url = "<a href=\"display.php3?" . $admin_data["extra_args"] . $common_flag . $rating_flag . $filters_flag . $first_story_flag . $comments_flag;

#formulate the base URL for the grop by ratings options
$base_rating_url = "<a href=\"display.php3?" . $admin_data["extra_args"] . $common_flag . $sort_flag . $filters_flag . $first_story_flag . $comments_flag;

#start compiling the output HTML. start with the comments toggle.
$nav_bar["navigate"] .= $comments_toggle . "<p>\n";

#mime type selector
$nav_bar["navigate"] .= $filter_string . "Filter story by: " . make_mime_type_selector($filters_toggle_base);

#created/modified time order selector
list ($selector, $sort_desc)  = make_created_mod_order_selector($base_sort_url,$admin_data["sort_filter"]);
#display the status of the filtering/sorting/grouping by rating system
$sort_string = "<i> Sorting articles by <b> " .$sort_desc. "</b></i>.<br>";

#ratings selector
$nav_bar["navigate"] .= $rate_string ."Group articles by ratings: " . make_rating_order_selector($base_rating_url);


$nav_bar["navigate"] .= $sort_string . "Sort story by: " . $selector; 

return $nav_bar;
}


#makes the userspace (eg html) navigation bar for selecting filters on stories (for
# current group)

function make_mime_type_selector($base_url) {

#hidden/display should be across mimes..


	$filters_toggle_hide = $base_url . "&filter=hidden\">hidden stories only</a> | \n";
	$filters_toggle_show = $base_url . "&filter=visible\">displaying stories only </a> | \n";
	$filters_toggle_media_text= $base_url. "&filter=text\">text stories only</a> | \n"; 
	$filters_toggle_media_images= $base_url . "&filter=images\">images only</a> | \n"; 
	$filters_toggle_media_video= $base_url . "&filter=video\">video uploads only</a> | \n"; 
	$filters_toggle_media_audio= $base_url . "&filter=audio\">audio uploads only</a> | \n";
	$filters_toggle_everything = $base_url . "&filter=none\">everything</a>\n";

	$order_selector = $filters_toggle_hide. $filters_toggle_show. $filters_toggle_media_text. $filters_toggle_media_images . $filters_toggle_media_video . $filters_toggle_media_audio . $filters_toggle_everything."<p>";

	return $order_selector;
}

#makes the user-space navigation bar for sort articles based upon
#creation / modification time.

function make_created_mod_order_selector($base_url,$sort) {

	$sort_menu = $base_url."&sort=date_desc\">latest news</a> | \n";
	$sort_menu .= $base_url."&sort=date_asc\">oldest news</a> | \n";

	$sort_menu .= $base_url."&sort=mod_desc\">recently modified (latest first) </a> | \n";
	$sort_menu .= $base_url."&sort=mod_asc\">recently modified (oldest first)</a>\n";


switch ($sort) {
   case 'date_desc':
 	$sort_desc = "latest news first";
	break;
   case 'date_asc':
	$sort_desc = "oldest news first";
   	break;
   case 'mod_desc':
	$sort_desc = "recently modified (lastest first)";
	break;
   case 'mod_asc':
	$sort_desc = "recently modified (oldest first)";
	break;
   default:
	$sort_desc = "latest news first";
	break;
}
	return array($sort_menu . "<p>", $sort_desc);
}

#makes the user-space navigation bar for selecting if sorting articles by rating.
function make_rating_order_selector($base_url) {

	$rate_menu = $base_url . "&rate=none\">none (show articles unrated)</a> | \n";
	$rate_menu .= $base_url . "&rate=highest\">highest rating first</a> | \n";
	$rate_menu .= $base_url . "&rate=lowest\">lowest rating first</a>\n";

	return $rate_menu . "<p>";
}


#
# Functon to make form and table of article administration page.
# 

function make_admin_form_and_table($table,$total,$data,$nav_bar,$db_obj) {
  global $appear;
  global $ratings_system;
  global $use_mime_urls, $mime_url;
  global $edit_comments, $edit_page_length;

#show how many stories (& possibly comments) returned for this admin session 
$items = pg_NumRows($table);

#get the maximum and minimum ids of articles displayed.
#find them by looping thru articles - thus set them here so that real id's will
#change them to real max/min.
$max_id = 0;
$min_id = 1000000;

# [[[Start form allowing editing of articles
#
$admin_form_string = "";

$admin_form_string .= "<form method=\"post\" action=\"led-process.php3\">";
$admin_form_string .= "<input type=\"hidden\" name=\"edit_comments\" value=\"$edit_comments\">";
$admin_form_string .= "<input type=\"hidden\" name=\"publishtype\" value=\"".$data["publishtype"]."\">";

# End form setup]]]

# grouping, ie linking, stuff
#This button allows grouping (linking) of stories together.
$link_string .= "<input type=\"submit\" name=\"action\" value=\"Group selected stories\">";
$link_string .= "Use this button to group similar stories together (say a text piece and a picture). They will be presented as one article on the front page.";
$link_string .= "<br><br>Administration password:  ";
$link_string .= "<input type=\"password\" name=\"password\" size=\"20\"><br><br>\n";

#display some statistics
$stats .= "There are ".$total["articles"]." articles, and ".$total["comments"]." comments, in the database for group <b> " . $data["publishtype"]."</b>\n";


#calculate total items under management at the moment (ie in the database)
if (substr($edit_comments, 0, 1) == "y") {
 	$comment_string =  " (including comments).\n " ;
	
	#calculate total items. Since comments included, then add both totals
	$total_items = $total["articles"] + $total["comments"];
} else {
        $comment_string = " (skipping comments).\n ";

	#calculate total items. Only articles.
	$total_items = $total["articles"];
}

#calculate which of the "view newer" | "view older"  items links are necessary

$move_base = $nav_bar["adminlink"];
if ($data["first_story"] == 0 && $items >= $edit_page_length) {
	$prev_bar = $move_base . $nav_bar["filterflag"] . "&first=$edit_page_length\">view older items &gt;&gt;</a> | ";
	$next_bar = ""; 
			
} else if ($data["first_story"] > 0) {
	#sanity check. but really should round to nearest multiple of $edit_page_length
	if ($data["first_story"] > 0 && $data["first_story"] < $edit_page_length) {
		$data["first_story"] = $edit_page_length;
 }

	#move one edit_page_length offset back..
	$next_offset = $data["first_story"] - $edit_page_length;
	$next_bar = $move_base . $nav_bar["filterflag"] . "&first=$next_offset\">&lt;&lt; view newer items</a> | ";
	#maybe even older items to visit...
	$prev_offset = $data["first_story"] + $edit_page_length;

	if ($prev_offset < $total_items) {
		#there is more items to visit, since offset is still smaller
		#than total items..
		$prev_bar = $move_base . $nav_bar["filterflag"] . "&first=$prev_offset\">view older items &gt;&gt;</a> | ";
	} else {
		$prev_bar = " ";
	}
}

#navigate through the articles links.
$article_nav = "<p> Navigate through the articles: \n". $next_bar . $prev_bar ;

#display the "hide" or "show" comments.
$admin_form_string .= $article_nav;

#display the filters nav bar - made by function call, make_admin_nav_bar()
$admin_form_string .= $nav_bar["navigate"];

#display the grouping stuff
$admin_form_string .= $link_string;


$font = "<font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\">";

# [[[ Start article table headings.
$admin_form_table_string .= "<table border=1 cellspacing=0>\n";
$admin_form_table_string .= "<tr>\n";
$admin_form_table_string .= "<td align=center>$font<b>story ID</b></font></td>\n";
$admin_form_table_string .= "<td align=center>$font<b>Is story displayed?</b></font></td>\n";
if (substr($edit_comments, 0, 1) == "y") { 
	$admin_form_table_string .= "<td align=center>$font<b>Is this a article?</b></font></td>\n"; 
} 
$admin_form_table_string .= "<td align=center>$font<b>heading</b></font></td>\n"; 
$admin_form_table_string .= "<td align=center>$font<b>author</b></font></td>\n"; 
$admin_form_table_string .= "<td align=center>$font<b>Ratings info</b></font></td>\n"; 
$admin_form_table_string .= "<td align=center>$font<b>Edit Content and Ratings</b></font></td>\n"; 
$admin_form_table_string .= "<td align=center>$font<b>MIME type</b></font></td>\n"; 
$admin_form_table_string .= "<td align=center>$font<b>created</b></font></td>\n"; 
$admin_form_table_string .= "<td align=center>$font<b>Group info (id's of other stories linked to)</b></font></td>\n"; 
# End article table headings. ]]]  

#counter for actual rows returned with id field set. 
# (SQL used in db_class for two table select, used for gathering 
# average ratings on each article,
# returns 1 row with nothing set in fields, if nothing is returned.)

$actual_items=0;

for ($i=0; $i<$items; $i++) { 
	$admin_form_table_string .= "<tr><td>$font\n"; 

	$row_obj = pg_fetch_object($table, $i); 
	# pick out the id 
	$id = chop($row_obj->id);
	if (strlen($id) == 0) {
		continue;
	}

        #find max/min id - used in led-process, to check the names of form elements.
        if ($id > $max_id) { $max_id = $id; }
        if ($id < $min_id) { $min_id = $id; }

	$actual_items++; 

	#The first column..  the select box for operations on multiple selections..  
	$select_auto = "select" .  $id; 
	$admin_form_table_string .= "<input type=\"checkbox\" name=\"$select_auto\" value=\"$id\">\n"; 
	$admin_form_table_string .= "$id\n"; 
	#The second column..  
	if ($row_obj->display == "t") { 
		$value = "showing"; 
		$button = "Hide story"; 
	} else { 
		$value = "hidden"; 
		$button = "Show story"; 
	} 
	$admin_form_table_string .= "</font></td><td>$font$value\n"; 
	#place a button to toggle show/hide status..  
	$admin_form_table_string .= "<input type=\"submit\" name=\"action_$id\" value=\"$button\">"; 
	#The (optional) third column...  
	if (substr($edit_comments, 0, 1) == "y") { 
		if (chop($row_obj->parent_id) != 0) { 
			$value = "No. Parent ID is " . $row_obj->parent_id; 
		} else { 
			$value = "Yes."; 
		} 
		$admin_form_table_string .= "</font></td><td>$font$value\n"; 
	} 
	#Subsequent columns are displaying data from the db entry 
	#heading 
	$value = htmlspecialchars(chop($row_obj->heading)); 
	if (! $value) { $value = ".  "; } 
	#use the new static article system for the clickable link 
	if (chop($row_obj->parent_id) != 0 ) { 
		#comment, use the parent id as a id into the clickable link.  
		$id_to_use = chop($row_obj->parent_id); 
	} else { $id_to_use = $id; } 

	$admin_form_table_string .= "</font></td><td>$font<a href=\"front.php3?article_id=$id_to_use&group=".$data["publishtype"]."\">$value</a>\n"; 
	#author 
	$value = htmlspecialchars(chop($row_obj->author)); 
	if (!  $value) { $value = ".  "; } 
	$admin_form_table_string .= "</font></td><td>$font$value\n"; 

	#Display the ratings info...  

	# TO-DO:encapsulate ratings/linking sql, processing into html in 
	# common article object.. CastItem ? GroupItem?

	$data_rate["table_name"] = "article_classification"; 
	$data_rate["seq_name"] = "article_classificationid"; 
	$data_rate["article_id"] = $row_obj->id; 
	$admin_form_table_string .= "</font></td><td>$font"; 
	list ($result_ratings,$rows_ratings) = $db_obj->execute('selecting','ratings',$data_rate); 
	if($rows_ratings == 0 ) { $admin_form_table_string .= "Not rated."; } 
	else { 
		$admin_form_table_string .= "$rows_ratings submitted rating"; 
		if ($rows_ratings > 1) $admin_form_table_string .= "s"; 
		list ($result_ratings,$rows_ratings) = $db_obj->execute('selecting','ratings_avg',$data_rate); 
		$rate_obj = pg_fetch_object($result_ratings,0); 
		$admin_form_table_string .= " equalling an average rating of <b>" .  $ratings_system[$rate_obj->avg] .  "</b> (".$rate_obj->avg.")"; 
	} 
	#The column for the editing button 
	$admin_form_table_string .= "</font></td><td>$font"; 
	#Edit this story button 
	$admin_form_table_string .= "<input type=\"submit\" name=\"action_$id\" value=\"Edit story\">"; 
	#MIME type
        if (chop($row_obj->linked_file) != "") {
            $value = htmlspecialchars(chop($row_obj->mime_type));
            if ($use_mime_urls) { $article_mime_icon = $mime_url[chop($row_obj->mime_type)]; } 
        } else {
            $value = "No uploaded file.";
            $article_mime_icon = "";
        }
	if (!  $value) { $value = ".  "; } 
	$admin_form_table_string .= "</font></td><td>$font$value\n" . $article_mime_icon;; 

	#Date published
	$value = htmlspecialchars(chop($row_obj->created)); 
	if (!  $value) { $value = ".  "; } 
	$admin_form_table_string .= "</font></td><td>$font$value\n"; 

	#Display the linking info.. 
	#this is used to display the linking info.
  	if (file_exists("debug")) {
           $tb_link_name="weblinkdebug";
           $seq_link_name="weblinkdebugid";
  	} else {
           $tb_link_name="weblink";
           $seq_link_name="weblinkid";
        }
 
	$data_link["table_name"] = $tb_link_name; 
	$data_link["seq_name"] = $seq_link_name; 
	$data_link["order_field"]="created"; 
	$data_link["article_id"]=$row_obj->id; 
	$admin_form_table_string .= "</font></td><td>$font"; 
	list ($result_index, $rows_link) = $db_obj->execute('selecting','linking',$data_link); 
	if ($rows_link == 0) { $admin_form_table_string .= ".  "; } 
	for($j=0;$j<$rows_link;$j++) { 
		$data_obj = pg_fetch_object($result_index, $j); 
		if ($data_obj->fromlink != $row_obj->id) { 
			$admin_form_table_string .= $data_obj->fromlink .","; 
		} else {  
			$admin_form_table_string .= $data_obj->tolink .  ","; 
		}
	} 
} #end loop through all articles.  

$admin_form_string .= "<input type=\"hidden\" name=\"min_id\" value=\"$min_id\">";
$admin_form_string .= "<input type=\"hidden\" name=\"max_id\" value=\"$max_id\">";
$stats .= "<br>Showing <b>$actual_items</b> items between ID's $max_id and $min_id.";

$admin_form_table_string .= "</font></td></tr></table></form><p>\n"; 


#add the stats, indicate whether we or viewing comments or not, 
#then the table to the main admin form string
$admin_form_string .= $stats. $comment_string . $admin_form_table_string;

$admin_form_string .= $article_nav;

$admin_form_string .= $nav_bar["navigate"];


#output the html to the browser
echo $admin_form_string;
}

?>
