<?php

// $Id: RSS.php,v 1.2 2001/06/21 07:00:34 andy Exp $
// RSS parser class. Copyright 2000 Hroi Sigurdsson
// Requires expat XML.
// Should be able to parse both 0.9 and 0.91 versions of RSS.
class RSS {

	// Public properties

	// Holds channel metadata.
	var $Channel = array();
	// Holds all <item> elements and data.
	var $Items = array();
	// Holds one <item> element, copied from Items by next_item()
	// @see RSS.next->item()
	// @see RSS.$Items
	var $Item = array();
	// Holds data from the optional <image> element and subelements
	var $Image = false;
	// Holds data from the optional <textinput> element and subelements
	var $TextInput = array();
	// Holds data from the optional <skipDays> element and subelements
	var $SkipDays = array();
	// Holds data from the optional <skipHours> element and subelements
	var $SkipHours = array();
	// Contain an error message, if any errors occur.
	var $Error;

	// Private properties
	var $xml_parser;
	var $_rssfile;
	var $current_element;
	var $parent_element;
	var $item_position = 0;


	function startElement($parser, $name, $attrs = array()){
		$this->parent_element = $this->current_element;
		$this->current_element = $name;
	}
	
	function characterData($parser, $data){
		switch($this->parent_element){
			case "CHANNEL":
				switch($this->current_element) {
					case "TITLE":
					case "LINK":
					case "DESCRIPTION":
					case "LANGUAGE":
					case "RATING":
						$this->Channel[strtolower($this->current_element)] .= trim($data);
				}
				break;
			case "IMAGE":
				switch($this->current_element) {
					case "TITLE":
					case "URL":
					case "LINK":
					case "WIDTH":
					case "HEIGHT":
					case "DESCRIPTION":
					$this->Image[strtolower($this->current_element)] .= trim($data);
				}
				break;
			case "ITEM":
				switch($this->current_element) {
					case "TITLE":
					case "LINK":
					case "DESCRIPTION":
						$this->Items[$this->item_position][strtolower($this->current_element)] .= trim($data);
				}
				break;
			case "TEXTINPUT":
				switch($this->current_element) {
					case "TITLE":
					case "DESCRIPTION":
					case "NAME":
					case "LINK":
						$this->TextInput[strtolower($this->current_element)] .= trim($data);
				}
				break;
			case "SKIPHOURS":
				switch($this->current_element) {
					case "HOUR":
						$this->SkipHours[] = $data;
				}
			break;
			case "SKIPDAYS":
				switch($this->current_element) {
					case "DAY":
						$this->SkipDays[] = $data;
				}

		}
	}
	
	function endElement($parser, $name) {
		$this->current_element = $this->parent_element;
		if($name == "ITEM") {
			$this->item_position++;
		}
	}

	// Constructor. Pass it a filename.	
	function RSS($filename) {
		if($this->_rss_file = @file($filename, 1)){
			$this->xml_parser = xml_parser_create();
			xml_set_object($this->xml_parser, &$this);
			xml_set_element_handler($this->xml_parser, "startElement", "endElement");
			xml_set_character_data_handler($this->xml_parser, "characterData");
			return $this->parse();
		} else {
			$this->Error = 'Could not fetch file';
			return false;
		}
	}

	function parse() {
		if(!count($this->_rss_file)){
			$this->Error = "Empty or missing data.";
			return false;
		} else {
			while(list(, $line) = each($this->_rss_file)) {
				if(!xml_parse($this->xml_parser, $line)) {
					$this->Error = xml_error_string(xml_get_error_code($this->xml_parser));
					return false;
				}
			}
			xml_parser_free($this->xml_parser);
			unset($this->_rss_file);
		}
		$this->item_position = 0;
		return true;
	}

	// Steps through the Items array and sets the Item array. Returns false when no items are left.
	function next_item() {
		if(count($this->Items) <= $this->item_position) {
			return false;
		} else {
			$this->Item = &$this->Items[$this->item_position];
			$this->item_position++;
			return true;
		}
	}

	function error() {
		return $this->Error;
	}

	function item($key) {
		return $this->Item[$key];
	}

	function channel($key) {
		return $this->Channel[$key];
	}

	function image($key) {
		return $this->Image[$key];
	}

}

?>

