CREATE TABLE webcast_groups (id int4 NOT NULL UNIQUE, group_id char(20) NOT NULL UNIQUE, group_description char(90), icon_url char(90), allow_open_publishing bool, allow_rating bool, quick_comment bool, email_contact_tech char(90), email_contact_editorial char(90), email_contact_auto_news char(90), auto_news_header char(300), auto_news_footer char(300), robot_email char(90), displaying bool, password char(20), parent_group int4); 
CREATE SEQUENCE webcast_groupsid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;

INSERT INTO webcast_groups VALUES (nextval('webcast_groupsid'), 'webcast', 'main publishing area for template indymedia', 'http://images.indymedia.org/imc/webcast.jpg', 'true','true','true', 'webcoders@cat.org.au', 'imc-template@cat.org.au','imc-template-news@cat.org.au','','+++ to see this new story, visit http://www.template.indymedia.org +++','imc-template-bot@cat.org.au','true', 'changeme', 0);

CREATE TABLE webcast_groups_appear (id int4 NOT NULL UNIQUE, webcast_groups_id int4 NOT NULL UNIQUE, bgcolor char(10), fgcolor char(10), linkcolor char(10), vlinkcolor char(10), alinkcolor char(10), heading_bgcolor char(10), subheading_bgcolor char(10), background_grey char(10), printable bool, url_crop_length int4, display_avg_rating bool, threshold_rating int4, entryform_filename char(80)); 
CREATE SEQUENCE webcast_groups_appearid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;

INSERT INTO webcast_groups_appear VALUES (nextval('webcast_groups_appearid'), '1', '#ffffff', '#000000','#cc6600','#660000','#ffff00','#ffffff','#66ccff','#cccccc','true','40','true','1', 'entryform.inc');

CREATE TABLE ratings_system (id int4 NOT NULL UNIQUE, rating_description char(30), group_id int4 NOT NULL); 
CREATE SEQUENCE ratings_systemid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;

INSERT INTO ratings_system VALUES (nextval('ratings_systemid'),'Average','1');
INSERT INTO ratings_system VALUES (nextval('ratings_systemid'),'OK','1');
INSERT INTO ratings_system VALUES (nextval('ratings_systemid'),'Good stuff','1');
INSERT INTO ratings_system VALUES (nextval('ratings_systemid'),'Recommended','1');
INSERT INTO ratings_system VALUES (nextval('ratings_systemid'),'Excellent','1');

CREATE TABLE usertable (id int4 NOT NULL UNIQUE, name char(90), email char(90), address char(120), phone char(20), article_password char(20) );
 
CREATE SEQUENCE usertableid start 2 increment 1 maxvalue 2147483647 minvalue 2 cache 1;

grant ALL on webcast_groups to php;
grant ALL on webcast_groupsid to php;
grant ALL on webcast_groups_appear to php;
grant ALL on webcast_groups_appearid to php;
grant ALL on ratings_system to php;
grant ALL on ratings_systemid to php;
grant ALL on usertable to php;
grant ALL on usertableid to php;

update webcast set html_file = linked_file,linked_file='' where linked_file!='' and mime_type='text/html' and html_file ='';
update webcast set html_file = linked_file,linked_file='' where linked_file!='' and mime_type='text/plain' and html_file =''; 
