#============================================================= -*-perl-*-
#
# IMC::WriteOutFeatures
#
# DESCRIPTION
#   Module implementing the writing out of features to disk.
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  Intellecutal Property Is Theft.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license.
#
#========================================================================
 
package IMC::WriteOutFeatures;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::ViewFeatures;
use IMC::CategoriesMenu;
use IMC::EditLanguagesMenu;


sub _init {
    my ($self, $config) = @_;

    $self->{'template_name'} = 'view_feature.template';
    $self->{'NUMBER_TO_LIST'} = 5;
    $self->{'screen'} = 'view';

    foreach my $config_key( keys %$config )	{
	$self->{ $config_key } = $config->{ $config_key };
    }

 		
    return $self;
}


sub write_out_features_to_disk
{
    my $self    = shift;
    
    warn "in write_out_features_to_disk";
    # Main combined output
    #     For this one we can just give blank where sql and
    #     code, that way it'll include all the features....
    _itterate_through_a_section( $self, '', '' );
    
    # Language Specific Output
    #     For each language we need to write out a seperate
    #     set of features files....
    my $languages_obj = new IMC::EditLanguagesMenu('site_obj' => $self->{'site_obj'},
			   	                   'dbh'      => $self->{'dbh'});
    
    foreach my $language ( @{ $languages_obj->{'languages'} } )
    {
	_itterate_through_a_section( $self, 
				     " LANGUAGE_ID = $language->{'ID'}",
				     $language->{'CODE'} );
    }
	  
    
    # Category Specific Output
    #     For each category of feature we need to write out 
    #     a specific set of features files for people to see
    my $categories_obj = new IMC::CategoriesMenu('site_obj' => $self->{'site_obj'},
			   	                 'dbh'      => $self->{'dbh'});
    
    foreach my $category ( @{ $categories_obj->{'categories'} } )
    {
	_itterate_through_a_section( $self, 
				     " CATEGORY_ID = $category->{'ID'}",
				     $category->{'CODE'} );
    }
    
    # Combined Language/Category Output
    #     I hadn't thought of this one until now... oops!
    
    
}

sub _itterate_through_a_section
{
    my ($self, $where_sql, $code)    = @_;
    my  $numb    = 1;	
    my  $offset  = 0;
    my  $counter = 0;
    
    warn "Where_sql:$where_sql code:$code";
    
    while ( $numb ) {
	$numb = _do_write_out_features_to_disk( $self, $offset, $counter, $where_sql, $code );
	$offset = $offset + $numb;
	$counter++;
    }
}

sub _do_write_out_features_to_disk
{
    my ($self, $offset, $counter, $where_sql, $code) = @_;

    #write out features to disk
    my $feature_obj = new IMC::Features( 'site_obj'        => $self->{'site_obj'},
					 'NUMBER_TO_LIST'  => $self->{'site_obj'}->{'NUMBER_TO_LIST'},
					 'OFFSET'          => $offset, 
					 'WHERE_SQL'       => $where_sql,
					 'output_to_file'  => 1,
					 'template_name'   => 'view_feature.template');
   
    $feature_obj->retrieve_entries();

    my $file_name = &_determine_file_name( $self, $counter, $code);

    &process_template( $self, $feature_obj, $file_name );
    warn "\n(" . exists( $feature_obj->{'features'}  ) . ')';
    
    my $to_return = scalar( @{ $feature_obj->{'features'} } ) if exists( $feature_obj->{'features'}  );
    
    #getting the number retrieved...
    return( $to_return );
}


sub process_template
{
    my ($self, $data_obj, $output) = @_;
    
    my  $template_name = $data_obj->template_name || &default_template( $self, $data_obj );
    warn "template_name:$template_name dataobj:$data_obj->vars OUTPUT:$output";
    #this processes the template and prints it to STDOUT
    $self->{'template_obj'}->process( $template_name, $data_obj->vars, $output) || warn $self->{'template_obj'}->error(), "\n";
    warn "AFter output";
#    warn Data::Dumper->Dump( [ $data_obj->vars() ] );
}



sub _determine_file_name 
{
    my ($self, $counter, $code) = @_;
    
    my  $file_name = '';
    $code = '_' . $code if $code;
    
    if ( $counter == 0 ) {
	$self->{'site_obj'}->{'FEATURES_FILE'} =~ /^([^\.]*)(\.[^\.]*)$/;
	$file_name =  $self->{'site_obj'}->{'INCLUDES_DIR'} . $1 . $code . $2;
    }
    else {
	$self->{'site_obj'}->{'FEATURES_FILE'} =~ /^([^\.]*)(\.[^\.]*)$/;
	$file_name =  $self->{'site_obj'}->{'INCLUDES_DIR'} . $1 . $code . $counter . $2;
    }
     warn "file_name:$file_name";
    return $file_name;
}

1;
