#============================================================= -*-perl-*-
#
# IMC::ViewFeatures
#
# DESCRIPTION
#   Module implementing a 'feature' viewing object.
#   for editing and updating features in the system....
#   
# AUTHOR 
#   Evan Henshaw-Plath <evan@protest.net> 
#    
# COPYLEFT  
#   Copyleft (C) 2000 Evan Henshaw-Plath.                      
#    
#   This module is free software; you can redistribute it and/or 
#   modify it under the GPL license.
#
#========================================================================
 
package IMC::ViewFeatures;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Features;
use IMC::Featured;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;

	$self->{'template_name'} = 'view_feature.template';
	$self->{'NUMBER_TO_LIST'} = 5;
	$self->{'OFFSET'} = 0;
	$self->{'screen'} = 'view';

	
	%$self = ( %$self, %$config );

	&retrieve_entry( $self );
		
    return $self;
}



# This should be what goes and calls and gets and entry populated....
sub retrieve_entry
{
    my $self = shift;
		
    #get all the features for this site_id, 
    if ( $self->{ 'ID' } ) 
    { 
	$self->{'feature_obj'} = new IMC::Featured( 'ID' => $self->{'ID'} );
	
	$self->{'feature'} = $self->{'feature_obj'}->vars();
    }
    elsif( $self->{ 'site_obj' } || $self->{'SITE_ID'} )
    {
	$self->{'features_obj'} = new IMC::Features( 
			              'SITE_ID'   => $self->{'SITE_ID'},
				      'site_obj'  => $self->{'site_obj'},
				      'WHERE_SQL' => $self->{'WHERE_SQL'},
				      'ORDER_BY'  => 'TIMESTAMP DESC',
				      'LIMIT'     => "$self->{'OFFSET'}, $self->{'NUMBER_TO_LIST'}");
	
	$self->{'features_obj'}->retrieve_entries;
	$self->{'features'} = \@{ $self->{'features_obj'}->entries() };
    }
}



sub vars
{
    my $self = shift;
    my $hash;
    
    foreach my $self_key( keys %$self )	{
	$hash->{ $self_key } = $self->{ $self_key };
    }
    return ($hash);
}



1;

