#============================================================= -*-perl-*-
#
# IMC::SiteName
#
# DESCRIPTION
#   Module determining the site name and adding it to the database.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#========================================================================
 
package IMC::SiteName;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;



sub _init {
    my ($self, $config) = @_;
	
	%$self = ( %$self, %$config );
	
	#make sure we've got a database handle
	$self->{'dbh'} = IMC::Database::connect() unless $self->{'dbh'};
	
	#&determine_domain_name( $self );
	&retrieve_site_id( $self );

    return $self;
}


sub retrieve_site_id {
	my ($self, $recurse_check) = @_;
	
	my $domain_name = $self->{'dbh'}->quote( &determine_domain_name( $self ) );
	
		

	my $select_sql =  "select ID from DOMAIN_NAME_TO_SITE_ID 
			   WHERE DOMAIN_NAME = $domain_name";

	my $sth =  $self->{'dbh'}->prepare( $select_sql );
   	$sth->execute() 
		or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
				
	my $site_info =	$sth->fetchrow_hashref();
	unless ( $site_info )
	{ 
		my $unqoted_site_name = &determine_domain_name( $self );
		   $self->{'NAME'}    = $unqoted_site_name;
		&determine_site_name( $self, $unquoted_site_name );
		&update_entry_in_db( $self );
		&retrieve_site_info( $self, 1 ) unless $recurse_check;
		warn "failed to select site_info $select_sql sitename $site_name has been added.";
	}

	%$self = ( %$self, %$site_info );
	warn ( %$self );
	&set_secondary_site_info( $self );
	$sth->finish();
}



sub update_entry_in_db
{
	my ($self) = @_;
	
	if ($self->{'SITE_ID'} && $self->{'DOMAIN_NAME'}) {
		_add_new_entry( $self );
	}
	
}

#don't use this one.... 
sub _update_existing_entry
{
	my $self	= shift;
	my $set_sql     = join( ' ', 
				' NAME = ', 
				$self->{'dbh'}->quote( $self->{'NAME'} ),);

	my $update_sql =  "UPDATE DOMAIN_NAME_TO_SITE_ID SET $set_sql
			   WHERE ID = $self->{'ID'}";
	
	#warn "update_sql:$update_sql";
	
	my $sth =  $self->{'dbh'}->prepare( $update_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $update_sql");
				
	$sth->finish();
}	


sub _add_new_entry
{
	my $self	= shift;
	#warn 'in add_new_entry';

	my $values_sql = join( ', ',  
			       $self->{'dbh'}->quote( $self->{'NAME'} ),
			       $self->{'SITE_ID'} );

	my $insert_sql =  "INSERT INTO DOMAIN_NAME_TO_SITE_ID 
			   (DOMAIN_NAME, SITE_ID) VALUES( $values_sql )";
	
	warn "insert_sql:\n\n$insert_sql\n\n";
	
	my $sth =  $self->{'dbh'}->prepare( $insert_sql );
   	$sth->execute() or 
		warn("DB ERROR ", $sth->errstr, " QUERY $insert_sql");
				
	$sth->finish();
}	
	

sub determine_password
{
	my    ( $self ) = @_;
	my    ( $passwd_file, $manage_password );
	open  ( FILE, "$self->{'first_dir'}$self->{'NAME'}$self->{'second_dir'}" . 'password.php3' ) or warn( "failed to open:$self->{'first_dir'}$self->{'NAME'}$self->{'second_dir'}"."password.php3" );
	while (<FILE>) { $passwd_file = join '', $passwd_file, $_ }
	close   FILE;
	        $passwd_file =~ s/<\?//;
	        $passwd_file =~ s/\?>//;
	eval    $passwd_file;	
	return  $manage_password;
}

sub determine_domain_name
{
	my $self = shift;
	return $self->{'ENV'}->{ 'SERVER_NAME' };
}
        
sub determine_site_name
{
        my ($self, $domain_name) = @_;
	
	my @symlinks = 'ls -l /www/vhosts/';
	#results
	#lrwxrwxrwx 1 root root 12 Mar  3 18:43 belgium.indymedia.org -> /www/belgium
	
	foreach $symlink (@symlinks)
	{
		#find out if this is the one we want
		if ( $symlink =~ m/$domain_name/i)
		{
			#check to see where the symlink goes
			$symlink =~ m!([^/]*)/?$!;

			#we've got our site name!
			return ( $1 );
		}
	}
	#if we get here we've failed...
        return (0);
}
 


sub set
{
	my ($self, $key, $value) = @_;
	
	$self->{ $key } = $value;
}



sub vars
{
	my $self = shift;
	my $hash; 
	
	foreach my $self_key( keys %$self )	{
		$hash->{ $self_key } = $self->{ $self_key };
	}
	return ($hash);
}

1;
