#============================================================= -*-perl-*-
#
# IMC::SiteInfo
#
# DESCRIPTION
#   Module implementing a site_info object.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#========================================================================
 
package IMC::SiteInfo;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;


sub _init {
    my ($self, $config) = @_;
	
	%$self = ( %$self, %$config );
	
	#make sure we've got a database handle
	$self->{'dbh'} = IMC::Database::connect() unless $self->{'dbh'};
	
	&retrieve_site_info( $self );

    return $self;
}


sub retrieve_site_info {
	my ($self, $recurse_check) = @_;
	
	$recurse_check = 0 unless $recurse_check;
	
	my $site_name = $self->{'dbh'}->quote( &determine_site_name( $self ) );
	
	my $select_sql =  "select * from IMC_SITE_INFO WHERE NAME = $site_name";

	my $sth =  $self->{'dbh'}->prepare( $select_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
				
	my $site_info =	$sth->fetchrow_hashref();
	unless ( $site_info )
	{ 
		my $unqoted_site_name = &determine_site_name( $self );
		   $self->{'NAME'}    = $unqoted_site_name;

		&update_entry_in_db( $self );
		&retrieve_site_info( $self, $recurse_check++ ) unless( $recurse_check == 2);
		warn "failed to select site_info $select_sql sitename $site_name has been added.";
	}

	%$self = ( %$self, %$site_info );
	#warn ( %$self );
	&set_secondary_site_info( $self );
	$sth->finish();
}

sub set_secondary_site_info
{
	my $self = shift;
	$self->{'INCLUDES_DIR'}  = $self->{'first_dir'} . $self->{'NAME'} . $self->{'second_dir'} . 'include/';
	$self->{'FEATURES_FILE'} = 'imcfront.inc';
	$self->{'PASSWORD'}    = &determine_password( $self );
}


sub update_entry_in_db
{
	my ($self) = @_;
	
warn 'in update_entry_in_db';

	if ($self->{'ID'}) {
		_update_existing_entry( $self );
	}
	else {
		_add_new_entry( $self );
	}
	
}

sub _update_existing_entry
{
	my $self	= shift;
        
        #hack to make sure there is a number_to_list
        $self->{'NUMBER_TO_LIST'} = 5 unless  $self->{'NUMBER_TO_LIST'};
        
	my $set_sql = join( ' ',
			    ' NAME = ',  $self->{'dbh'}->quote( $self->{'NAME'} ),
			    ', TITLE = ',  $self->{'dbh'}->quote( $self->{'TITLE'} ),
			    ', LANGUAGE = ',  $self->{'dbh'}->quote( $self->{'LANGUAGE'} ),
			    ', DESCRIPTION = ',  $self->{'dbh'}->quote( $self->{'DESCRIPTION'} ),
			    ', COPYRIGHT = ',  $self->{'dbh'}->quote( $self->{'COPYRIGHT'} ),
			    ', EMAIL = ',  $self->{'dbh'}->quote( $self->{'EMAIL'} ),
			    ', NUMBER_TO_LIST = ' , $self->{'NUMBER_TO_LIST'});

	my $update_sql =  "UPDATE IMC_SITE_INFO SET $set_sql WHERE ID = $self->{'ID'}";
	
	warn "update_sql:$update_sql";
	
	my $sth =  $self->{'dbh'}->prepare( $update_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $update_sql");
				
	$sth->finish();
}	


sub _add_new_entry
{
	my $self	= shift;
	#warn 'in add_new_entry';

	my $values_sql = join( ', ',
			      $self->{'dbh'}->quote( $self->{'NAME'} ) );
        
	my $insert_sql =  "INSERT INTO IMC_SITE_INFO  (NAME, NUMBER_TO_LIST) VALUES( $values_sql, 5 )";
	
	warn "insert_sql:\n\n$insert_sql\n\n";
	
	my $sth =  $self->{'dbh'}->prepare( $insert_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $insert_sql");
				
	$sth->finish();
}	
	

sub determine_password
{
	my    ( $self ) = @_;
	my    ( $passwd_file, $manage_password );
	open  ( FILE, "$self->{'first_dir'}$self->{'NAME'}$self->{'second_dir'}" . 'password.php3' ) or warn( "failed to open:$self->{'first_dir'}$self->{'NAME'}$self->{'second_dir'}"."password.php3" );
	while (<FILE>) { $passwd_file = join '', $passwd_file, $_ }
	close   FILE;
	        $passwd_file =~ s/<\?//;
	        $passwd_file =~ s/\?>//;
	eval    $passwd_file;	
	return  $manage_password;
}

sub determine_site_name
{
    my $self = shift;
    
    my $path_to_actual_site = '';
    my $script_filename =   $self->{'ENV'}->{ 'SCRIPT_FILENAME' };
       $script_filename =~  m!^(.*)/[^/]*$!;
    my $script_filename =   $1;
    
    if ( -l $script_filename ) {
	$path_to_actual_site = readlink $script_filename;
    } else { #use the old method
	  $self->{'ENV'}->{ 'SCRIPT_FILENAME' } =~  m!^(.*)/[^/]*$!;
	  $path_to_actual_site = $1;
    }
    
    #ok, so now we've got the path to the actula site either way,
    #lets figure out what the real site name is!

    $path_to_actual_site =~ m!/([^/]*)/?$!;
    my $site_name = $1;
    
    return $site_name;
}


sub set
{
	my ($self, $key, $value) = @_;
	
	$self->{ $key } = $value;
}



sub vars
{
	my $self = shift;
	my $hash; 
	
	foreach my $self_key( keys %$self )	{
		$hash->{ $self_key } = $self->{ $self_key };
	}
	return ($hash);
}

1;
