#============================================================= -*-perl-*-
#
# IMC::Preferences
#
# DESCRIPTION
#   Module implementing a preferences object.
#   Basically it lets you view and set values for SiteInfo, cool eh?
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2001 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license.
#
#========================================================================
 
package IMC::Preferences;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::SiteInfo;

## This is the main version number for the library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;

    warn "IN PREFERNECES";    
    $self->{'template_name'} = 'preferences.template';
    $self->{'screen'}        = 'preferences';

    %$self = ( %$self, %$config );

#    my $params = $self->{'query'}->Vars();
# 
#    foreach my $key( keys %$params ) {
#             $self->{ $key } =  $params->{ $key };
#    }
    warn "I need a site info object" unless $self->{'site_obj'};
    
    if ( $self->{'authentication_obj'}->VALID() ){
	 warn "you are authnic";
	 $self->{'AUTHENTICATED'} = $self->{'authentication_obj'}->VALID();
      	 $self->{'PASSWORD'} = $self->{'authentication_obj'}->{'PASSWORD'};
    }else {warn 'you are innauthentic';}
    
    return $self;
}



# This should be what goes and calls and gets and entry populated....
sub retrieve_entry
{
	my $self = shift;
		
	$self->{'site_obj'} = new IMC::SiteInfo( 'ID' => $self->{'ID'} );
		
	$self->{'feature'} = $self->{'feature_obj'}->vars();
	
       my $params = $self->{'query'}->Vars();
        
       foreach my $key( keys %$params ) {
             $self->{'feature'}->{ $key } =  $params->{ $key };
        }

	warn "AUTHEN: $self->{'AUTHENTICATED'} ";
	if ( $self->{'AUTHENTICATED'} ){
		$self->{'PASSWORD'} = $self->{'authentication_obj'}->{'PASSWORD'};
	}
}


#this is called when a form is submitted
#it takes a cgi query object with the results of the post...
#then it updates a Featured object with the info and 
#has that recommitted to the database
sub update
{
	my ($self, $query) = @_;
	warn "in update";
	if ($self->{'AUTHENTICATED'}) {
		my $params = $query->Vars();
	
		foreach my $key( keys %$params ) { 
			$self->{'site_obj'}->set( $key, $params->{ $key } ); 
		}
		
		my $results = $self->{'site_obj'}->update_entry_in_db();
		
#		if ($self->{'ID'}) {
#			$self->{'message'} = "Preferences: $self->{'ID'} have been updated"; 
#		}
#		else {
#			$self->{'message'} = "Feature ID: $self->{'ID'} has been added"; 
#		}		
		$self->{'sucess'}  = $results;
	
		#now make sure we've got the latest in our own records....
		$self->{'feature'} = $self->{'site_obj'}->vars();
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Authenication Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}

}



sub vars
{
	my $self = shift;
	my $hash;
		
	foreach my $self_key( keys %$self )	{
		$hash->{ $self_key } = $self->{ $self_key };
	}
	return ($hash);
}



1;





