#============================================================= -*-perl-*-
#
# IMC::LanguagesMenu
#
# DESCRIPTION
#   Module implementing a languages menu object.
#   for editing and updating languages in the system....
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license.
#
#========================================================================
 
package IMC::LanguagesMenu;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Language;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;
	
    #set defaults
    $self->{'template_name'} = 'edit_languages_menu.template';
    
    #let them be overriden
    %$self = ( %$self, %$config );
    
    &load_languages( $self );
		
    return $self;
}


# This should be what goes and calls and gets and entry populated....
sub load_languages
{
	my $self = shift;
	
	
	#get all the features for this site_id, 
	if ( $self->{ 'site_obj' } ) 
	{ 
	    $self->{'languages_obj'} = new IMC::Languages( 'site_obj'           => $self->{'site_obj'},
							    'dbh'                => $self->{'dbh'},
						            'authentication_obj' => $self->{'authentication_obj'} );


	    $self->{'languages'} = \@{ $self->{'languagess_obj'}->languages() } if ( $self->{'languages_obj'}->languages() );
	}
}





1;
