#============================================================= -*-perl-*-
#
# IMC::Languages
#
# DESCRIPTION
#   Module implementing a feature language object.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#========================================================================

package IMC::Languages;
use base qw( IMC::DB_Peer_Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG $VARS );
use IMC::Database;

$VARS = { 'TABLE' => 'LANGUAGE' };


sub _init {
    my ($self, $config) = @_; 
    
    foreach my $config_key( keys %$config )	{
	  $self->{ $config_key } = $config->{ $config_key };
    }
    $self->{'entries_array_name'} = 'languages';
    $self->{'VARS'} = $VARS;

    #make sure we've got a database handle
    $self->{'dbh'} = IMC::Database::connect() unless $self->{'dbh'};
	
    #&retrieve_entry( $self, $self->{'ID'} ) if( $self->{ 'ID' } );

    return $self;
}


#sub retrieve_entry {
#    my ($self, $ID, $SITE_ID) = @_;
#	
#    my $site_sql   =  " AND SITE_ID = $SITE_ID " if $SITE_ID;
#    my $select_sql =  "select * from LANGUAGES WHERE ID = $ID $site_sql";
#	
#    my $sth =  $self->{'dbh'}->prepare( $select_sql );
#    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
#				
#    my $entry_hash	=	$sth->fetchrow_hashref();
#	
#    foreach my $entry_key ( keys %$entry_hash )
#    {
#	$self->{ $entry_key } = $entry_hash->{ $entry_key };
#    }
#    $sth->finish();
#}


#sub retrieve_entries {
#    my ($self, $SITE_ID) = @_;
#    warn "retrieving entries";
#    
#    $SITE_ID = $self->{'site_obj'}->{'ID'} unless( $SITE_ID );
#    my ($where_sql, $order_by_sql, $limit_sql);
#    
#    $where_sql    = join( ' ', " SITE_ID = ", $self->{'SITE_ID'} ) if $SITE_ID;
#    $order_by_sql = " ORDER BY " . $self->{'ORDER_BY'}  if $self->{'ORDER_BY'};
#    $limit_sql    = " LIMIT " . $self->{'LIMIT'}   if $self->{'LIMIT'};
#	
#    my $select_sql =  "select * from LANGUAGE WHERE $where_sql $order_by_sql $limit_sql";
#	
#    my $sth =  $self->{'dbh'}->prepare( $select_sql ) or warn "Failed to prepare";
#    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
#				
#    while ( my $language_hash	=	$sth->fetchrow_hashref() )
#    {
#	push @{ $self->{'languages'} }, $language_hash;
#    }
#    $sth->finish();
#}



sub update_entry_in_db
{
    my ($self) = @_;
    
    if ($self->{'ID'}) {
	_update_existing_entry( $self );
    }
    else {
	_add_new_entry( $self );
    }
}

sub _update_existing_entry
{
	my $self	= shift;
	my $set_sql = join( ' ',
                            '  CODE = ', $self->{'dbh'}->quote( $self->{'CODE'} ),
			    ', NAME = ', $self->{'dbh'}->quote( $self->{'NAME'} ),
			    ', SITE_ID  = ', $self->{'SITE_ID'},
			    ', DEFAULT_LANGUAGE = ', $self->{'DEFAULT_LANGUAGE'} ) ;

	my $update_sql =  "UPDATE LANGUAGE SET $set_sql WHERE ID = $self->{'ID'}";
	
	my $sth =  $self->{'dbh'}->prepare( $update_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $update_sql");
	
	$sth->finish();
}	


sub _add_new_entry
{
	my $self	= shift;
	my $values_sql = join( ', ', $self->{'dbh'}->quote( $self->{'CODE'} ),
			             $self->{'dbh'}->quote( $self->{'NAME'} ),
				     $self->{'dbh'}->quote( $self->{'SITE_ID'} ),
				     $self->{'dbh'}->quote( $self->{'DEFAULT_LANGUAGE'} ) );


	my $insert_sql =  "INSERT INTO LANGUAGE (CODE, NAME, SITE_ID, DEFAULT_LANGUAGE) VALUES( $values_sql )";
	
	#warn "insert_sql:\n\n$insert_sql\n\n";
	
	my $sth =  $self->{'dbh'}->prepare( $insert_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $insert_sql");
				
	$sth->finish();
}	
	

sub delete_entry
{
    my $self	= shift;
    
    my $delete_sql =  "DELETE FROM LANGUAGE WHERE ID = $self->{'ID'}";
	
	
    my $sth =  $self->{'dbh'}->prepare( $delete_sql );
    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $delete_sql");
		
    $sth->finish();
}	


sub set
{
    my ($self, $key, $value) = @_;
	
    $self->{ $key } = $value;
}



sub vars
{
    my $self = shift;
    my $hash; 
    
    foreach my $self_key( keys %$self )	{
	$hash->{ $self_key } = $self->{ $self_key };
    }
    return ($hash);
}

1;
