#============================================================= -*-perl-*-
#
# IMC::Features
#
# DESCRIPTION
#   Module implementing a imc features list middlware.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#========================================================================

package IMC::Features;
use base qw( IMC::DB_Peer_Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Featured;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;

#	warn "initing IMC::Features";	

	foreach my $config_key( keys %$config )	{
		$self->{ $config_key } = $config->{ $config_key };
	}

	#make sure we've got a database handle
	$self->{'dbh'} = IMC::Database::connect() unless $self->{'dbh'};

    return $self;
}


# This should be what goes and calls and gets and entry populated....
sub retrieve_entry
{
	my $self = shift;
	
	#figure out if we're looking for an entry or a category (list of entries)
	if ( $self->{ 'ID' } ) #just one entry?
	{ 
		#yes, let's retrieve just one entry
		$self->{ 'ENTRY' } = new IMC::Featured( 'ID' => $self->{'ID'} );
		
	}
	elsif ( $self->{'CATEGORY'} )
	{
		#ok, so we're not getting an entry, but a category of entries...
#		$self->{ 'CATEGORY_OBJ' }  = new EAM::Category( 'CATEGORY' => $self->{ 'CATEGORY' } );
		
		#actually we could either get the entries for that category or the category info
		#for now we'll get both the category info is already in the category_obj
		#so now all we have left is to get the entries in that category
		$self->{ 'CATEGORY_HASH' } = $self->{ 'CATEGORY_OBJ' }->retrieve_entries();
		
	}
}


sub retrieve_entries
{
    my ($self) = @_;
    my ($where_sql, $order_by_sql, $limit_sql);
    warn "retrieve entries";
    $where_sql    = $self->_get_site_select_sql; 
    $where_sql    = join( ' AND ', $where_sql, $self->{'WHERE_SQL'} ) if $self->{'WHERE_SQL'};
    $order_by_sql = " ORDER BY " . $self->{'ORDER_BY'}  if $self->{'ORDER_BY'};
    $limit_sql    = $self->_determine_limit_sql;
    
    my $select_sql =  "select * from FEATURES WHERE $where_sql $order_by_sql $limit_sql";
	
    my $sth =  $self->{'dbh'}->prepare( $select_sql ) or warn "Failed to prepare";
    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
				
    while ( my $entry_hash	=	$sth->fetchrow_hashref() )
    {
	warn "pushing" . $entry_hash->{'ID'};
	$entry_hash->{ 'TIME' } = &timestamp_made_pretty( $entry_hash->{'TIMESTAMP'} );
	push @{ $self->{'features'} }, $entry_hash;
    }
    #warn $self->{'entries'};
    
    $sth->finish();
}


sub _determine_limit_sql
{
    my $self = shift;
    my $limit_sql;
    
    #First we see if have a limit param
    return ( " LIMIT " . $self->{'LIMIT'} )  if $self->{'LIMIT'};
    
    #Op, we don't, let's try other ways to set limit....
    if( $self->{'NUMBER_TO_LIST'} =~ m/\d/  && $self->{'OFFSET'} =~ m/\d/ ) {
	return( " LIMIT  $self->{'OFFSET'}, $self->{'NUMBER_TO_LIST'} " );
    }
    
    #we didn't find anything, so we'll return a blank string
    return( '' );
}


#This should be removed, it violates the seperation of content from presentation
sub timestamp_made_pretty
{ 
	my $timestamp = shift;
	
	$timestamp =~ /^(\d{4})(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)$/;
	
	return ( "$4:$5:$6 $3:$2:$1");
}

sub entries
{
	my $self = shift;
	return ( \@{ $self->{'entries'} } );
}


sub vars
{
	my $self = shift;
	my $hash; 
	
	foreach my $self_key( keys %$self )	{
		$hash->{ $self_key } = $self->{ $self_key };
	}
	return ($hash);
}


1;
