#============================================================= -*-perl-*-
#
# IMC::Featured
#
# DESCRIPTION
#   Module implementing a featured article object.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#========================================================================
 
package IMC::Featured;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;

sub _init {
    my ($self, $config) = @_;
	

	foreach my $config_key( keys %$config )	{
		$self->{ $config_key } = $config->{ $config_key };
	}
	
	#make sure we've got a database handle
	$self->{'dbh'} = IMC::Database::connect() unless $self->{'dbh'};
	
	&retrieve_entry( $self, $self->{'ID'} ) if( $self->{ 'ID' } );

    return $self;
}


sub retrieve_entry {
	my ($self, $ID, $SITE_ID) = @_;
	
	my $site_sql   =  " AND SITE_ID = $SITE_ID " if $SITE_ID;
	my $select_sql =  "select * from FEATURES WHERE ID = $ID $site_sql";
	
	my $sth =  $self->{'dbh'}->prepare( $select_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
				
	my $entry_hash	=	$sth->fetchrow_hashref();
	
	foreach my $entry_key ( keys %$entry_hash )
	{
		$self->{ $entry_key } = $entry_hash->{ $entry_key };
	}
	$sth->finish();

}

sub update_entry_in_db
{
	my ($self) = @_;
	
	if ($self->{'ID'}) {
		_update_existing_entry( $self );
	}
	else {
		_add_new_entry( $self );
	}
	
}

sub _update_existing_entry
{
	my $self	= shift;
	my $set_sql = join( ' ',
	       		    '  TITLE = ', $self->{'dbh'}->quote( $self->{'TITLE'} ),
       			    ', SUB_TITLE = ', $self->{'dbh'}->quote( $self->{'SUB_TITLE'} ),
			    ', IMAGE_URL = ', $self->{'dbh'}->quote( $self->{'IMAGE_URL'} ),
			    ', IMAGE_CAPTION = ', $self->{'dbh'}->quote( $self->{'IMAGE_CAPTION'} ),
			    ', LINK_1    = ', $self->{'dbh'}->quote( $self->{'LINK_1'} ),
			    ', LINK_2    = ', $self->{'dbh'}->quote( $self->{'LINK_2'} ),
			    ', LINK_3    = ', $self->{'dbh'}->quote( $self->{'LINK_3'} ),
                            ', LINK_1_TITLE    = ', $self->{'dbh'}->quote( $self->{'LINK_1_TITLE'} ),
                            ', LINK_2_TITLE    = ', $self->{'dbh'}->quote( $self->{'LINK_2_TITLE'} ),
                            ', LINK_3_TITLE    = ', $self->{'dbh'}->quote( $self->{'LINK_3_TITLE'} ),
			    ', BODY = ', $self->{'dbh'}->quote( $self->{'BODY'} ),
			    ', TEMPLATE  = ', $self->{'dbh'}->quote( $self->{'TEMPLATE'} ),
			    ', LANGUAGE_ID = ', $self->{'LANGUAGE_ID'},
			    ', CATEGORY_ID = ', $self->{'CATEGORY_ID'},
			    ', TIMESTAMP = TIMESTAMP');

	my $update_sql =  "UPDATE FEATURES SET $set_sql WHERE ID = $self->{'ID'}";
	
#	warn "update_sql:$update_sql";
	
	my $sth =  $self->{'dbh'}->prepare( $update_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $update_sql");
	
	$sth->finish();
}	


sub _add_new_entry
{
	my $self	= shift;
	my $values_sql = join( ', ', $self->{'dbh'}->quote( $self->{'TITLE'} ),
			             $self->{'dbh'}->quote( $self->{'SUB_TITLE'} ),
				     $self->{'dbh'}->quote( $self->{'IMAGE_URL'} ),
				     $self->{'dbh'}->quote( $self->{'IMAGE_CAPTION'} ),
				     $self->{'dbh'}->quote( $self->{'LINK_1'} ),
				     $self->{'dbh'}->quote( $self->{'LINK_2'} ),
				     $self->{'dbh'}->quote( $self->{'LINK_3'} ),
                                     $self->{'dbh'}->quote( $self->{'LINK_1_TITLE'} ),
                                     $self->{'dbh'}->quote( $self->{'LINK_2_TITLE'} ),
                                     $self->{'dbh'}->quote( $self->{'LINK_3_TITLE'} ),
				     $self->{'dbh'}->quote( $self->{'BODY'} ),
				     $self->{'dbh'}->quote( $self->{'TEMPLATE'} ),
			             $self->{'LANGUAGE_ID'},
			             $self->{'CATEGORY_ID'},
				     $self->{'SITE_ID'} );

	my $insert_sql =  "INSERT INTO FEATURES (TITLE, SUB_TITLE, IMAGE_URL, IMAGE_CAPTION, LINK_1, LINK_2, LINK_3, LINK_1_TITLE, LINK_2_TITLE,
        LINK_3_TITLE, BODY, TEMPLATE, SITE_ID) VALUES( $values_sql )";
	
	#warn "insert_sql:\n\n$insert_sql\n\n";
	
	my $sth =  $self->{'dbh'}->prepare( $insert_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $insert_sql");
				
	$sth->finish();
}	
	

sub delete_entry
{
	my $self	= shift;

	my $delete_sql =  "DELETE FROM FEATURES WHERE ID = $self->{'ID'}";
	
#	warn "update_sql:$update_sql";
	
	my $sth =  $self->{'dbh'}->prepare( $delete_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $delete_sql");
		
	$sth->finish();
}	


sub set
{
	my ($self, $key, $value) = @_;
	
	$self->{ $key } = $value;
}



sub vars
{
	my $self = shift;
	my $hash; 
	
	foreach my $self_key( keys %$self )	{
		$hash->{ $self_key } = $self->{ $self_key };
	}
	return ($hash);
}

1;
