#============================================================= -*-perl-*-
#
# IMC::Error
#
# DESCRIPTION
#   Module for errors list middlware.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#========================================================================
 
package IMC::Error;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;

sub _init {
    my ($self, $config) = @_;
	
	#set defaults..
	$self->{'template_name'} = 'default_error.template';
	%$self = ( %$self, %$config );

    return $self;
}


sub vars
{
	my $self = shift;
	my $hash;
	
	foreach my $self_key( keys %$self )	{
		$hash->{ $self_key } = $self->{ $self_key };
	}

	return ($hash);
}


sub log_error
{
 	my ( $self, $error_message ) = @_;

	push @{ $self->{'errors'} }, $error_message;
	
	warn $error_message;
}

1;