
#============================================================= -*-perl-*-
#
# IMC::EditLanguage
#
# DESCRIPTION
#   Module implementing a edit language object.
#   for editing and updating languages in the features system....
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms of the GPL license.
#
#========================================================================
 
package IMC::EditLanguage;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Languages;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION       = '0.01-rc0';
$ERROR         = '';
$DEBUG         = 0;

sub _init {
    my ($self, $config) = @_;

    $self->{'template_name'} = 'edit_language.template';
    $self->{'screen'} = 'edit_language';
	
    %$self = ( %$self, %$config );

    $self->{'SITE_ID'} = $self->{'site_obj'}->{'ID'};
    $self->{'AUTHENTICATED'} = $self->{'authentication_obj'}->VALID();
    
    
    my $params = $self->{'query'}->Vars();
    
    foreach my $key( keys %$params ) {
	$self->{ $key } =  $params->{ $key };
    }
    
    
    &retrieve_entry( $self );
		
    return $self;
}



# This should be what goes and calls and gets and entry populated....
sub retrieve_entry
{
    my $self = shift;

    $self->{'language_obj'}    = new IMC::Languages( 'ID'      => $self->{'ID'},
					             'SITE_ID' => $self->{'SITE_ID'} );
    my $results = $self->{'language_obj'}->retrieve_entry( $self->{'ID'} );
    $self->{'language'}   = $self->{'language_obj'};

    if ( $self->{'AUTHENTICATED'} ){
	$self->{'PASSWORD'} = $self->{'authentication_obj'}->{'PASSWORD'};
    }
}


#this is called when a form is submitted
#it takes a cgi query object with the results of the post...
#then it updates a category object with the info and 
#has that recommitted to the database
sub update
{
	my ($self, $query) = @_;
	
	if ($self->{'AUTHENTICATED'}) {
		my $params = $query->Vars();
	
		foreach my $key( keys %$params ) { 
			$self->{'language_obj'}->set( $key, $params->{ $key } ); 
		}
		
		my $results = $self->{'language_obj'}->update_entry_in_db();
		
		if ($self->{'ID'}) {
			$self->{'message'} = "Language: $self->{'NAME'} has been updated"; 
		}
		else {
			$self->{'message'} = "Language: $self->{'NAME'} has been added"; 
		}		
		$self->{'sucess'}  = $results;
	
		#now make sure we've got the latest in our own records....
		$self->{'language'} = $self->{'language_obj'}->vars();
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Password Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}

}


sub delete
{
	my ($self, $query) = @_;
	
	if ($self->{'AUTHENTICATED'}) {
		my $results = $self->{'language_obj'}->delete_entry();
		
		if ($results) {
			$self->{'message'} = "Language ID: $self->{'ID'} has deleted"; 
		}
		else {
			$self->{'message'} = "Language ID: $self->{'ID'} has NOT been deleted"; 
		}		
		$self->{'sucess'}  = $results;
	
		#now make sure we've got the latest in our own 
                #this is weird, cus we deleted it, shouldnt' this be empty, and shouldn't
                #we send the user to a comfirmation template? Just my thoughts....
		$self->{'language'} = $self->{'language_obj'}->vars();
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Password Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}
}




1;





