#============================================================= -*-perl-*-
#
# IMC::EditFile
#
# DESCRIPTION
#   Module implementing a edit include files.
#   for editing and updating features in the system....
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#========================================================================
 
package IMC::EditFeature;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Featured;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;

	$self->{'template_name'} = 'edit_file.template';
	$self->{'screen'} = 'editfile';
	
	%$self = ( %$self, %$config );
	
	&retrieve_entry( $self );
		
    return $self;
}


sub show_menu 
{
	my ($query, $out)	= @_;

	my @list_of_files = &get_list_of_files();

	foreach my $file ( sort @list_of_files )
	{
		if ( $file =~ /\.inc$/ )
		{
			str $out qq!<br><a href="edit.cgi?screen=edit&file=$file">$file</a>!;
		}
	}
}


sub edit_file
{
	my ($query, $out)	= @_;
	my  $file = $query->param('file');
	my  $file_body = &load_file_body( $file );
	str $out qq!
               <form method="POST">
                File Name: <B>$file</B><p>
                <input type="submit" name="submit" value="Update File">
                <INPUT TYPE="hidden" NAME="screen" VALUE="update">
                <INPUT TYPE="hidden" NAME="file" VALUE="$file">
                 <p>
                <TEXTAREA NAME="file_body" ROWS=20 COLS=80 WRAP=VIRTUAL>$file_body</TEXTAREA>
                </form>!;


}	

sub load_file_body
{
	my $file_name	=	shift;
	my $file_body;
	
	open (FILE_BODY, "$files_dir/$file_name" ) or die( "Oh Shit" );
	while ( my $line = <FILE_BODY> )
	{
		$file_body .= $line ;
	}
	close (FILE_BODY);
	
	return ( $file_body );	
	
	
}


sub get_list_of_files
{

	opendir (FILES, $files_dir) or die( "Oh Shit" );
	my @list_of_files = readdir( FILES );
	closedir (FILES );
	
	return ( @list_of_files );
}


sub update
{
	my ($self, $query) = @_;
	
	if ($self->{'AUTHENTICATED'}) {
		my  $time	=	join '', localtime;
		
		#check file name
		my $file_name = $self->{'query'}->param('file');
		if ( $file_name =~ /\.inc$/ )
		{
			#copy file to make backup....
			my $source_file = "$files_dir/$file_name";
			my $destination_file = "$files_dir/backups/$file_name.$time";
			`cp $source_file $destination_file`;
				
			#write out new file
			open (OUTFILE, ">$source_file") or die $!;
			print OUTFILE $query->param('file_body');
			close OUTFILE;
	
			$self->{'message'} = "File sucessfully updated";
			$self->{'sucess'}  = 0;
		}
		else
		{
			$self->{'message'} = "File failed to update sucessfully";
			$self->{'sucess'}  = 0;
		}
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Password Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}
}




#this is called when a form is submitted
#it takes a cgi query object with the results of the post...
#then it updates a Featured object with the info and 
#has that recommitted to the database
sub update
{
	my ($self, $query) = @_;
	
	if ($self->{'AUTHENTICATED'}) {
		my $params = $query->Vars();
	
		foreach my $key( keys %$params ) { 
			$self->{'feature_obj'}->set( $key, $params->{ $key } ); 
		}
		
		my $results = $self->{'feature_obj'}->update_entry_in_db();
		
		if ($self->{'ID'}) {
			$self->{'message'} = "Feature ID: $self->{'ID'} has been updated"; 
		}
		else {
			$self->{'message'} = "Feature ID: $self->{'ID'} has been added"; 
		}		
		$self->{'sucess'}  = $results;
	
		#now make sure we've got the latest in our own records....
		$self->{'feature'} = $self->{'feature_obj'}->vars();
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Password Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}

}






1;
