#============================================================= -*-perl-*-
#
# IMC::EditFeaturesMenu
#
# DESCRIPTION
#   Module implementing a edit features menu object.
#   for editing and updating features in the system....
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license.
#
#========================================================================
 
package IMC::EditFeaturesMenu;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Features;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;
	
	#warn "initing editfeaturesmenu";
	
	#set defaults
	$self->{'NUMBER_TO_LIST'} = 10;
	$self->{'template_name'} = 'edit_features_menu.template';
	
	#let them be overriden
	%$self = ( %$self, %$config );

	&retrieve_entry( $self );
		
    return $self;
}


# This should be what goes and calls and gets and entry populated....
sub retrieve_entry
{
	my $self = shift;
	
	
	#get all the features for this site_id, 
	if ( $self->{ 'SITE_ID' } ) 
	{ 
		$self->{'features_obj'} = new IMC::Features( 
							'SITE_ID' => $self->{'SITE_ID'}, 
							'ORDER_BY' => 'TIMESTAMP',
							'LIMIT' => $self->{'NUMBER_TO_LIST'} );

		$self->{'features_obj'}->retrieve_entries;
		$self->{'features'} = \@{ $self->{'features_obj'}->entries() };
	}
}





1;
