#============================================================= -*-perl-*-
#
# IMC::EditFeature
#
# DESCRIPTION
#   Module implementing a edit features menu object.
#   for editing and updating features in the system....
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#========================================================================
 
package IMC::EditFeature;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Featured;
use IMC::Categories;
use IMC::Languages;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;

	$self->{'template_name'} = 'edit_feature.template';
	$self->{'screen'} = 'edit';
	
	%$self = ( %$self, %$config );

       my $params = $self->{'query'}->Vars();
 
       foreach my $key( keys %$params ) {
             $self->{ $key } =  $params->{ $key };
        }

	
	&retrieve_entry( $self );
		
    return $self;
}



# This should be what goes and calls and gets and entry populated....
sub retrieve_entry
{
    my $self = shift;
		
    $self->{'feature_obj'}    = new IMC::Featured( 'ID' => $self->{'ID'} );
    $self->{'feature'}        = $self->{'feature_obj'}->vars();
    
    $self->{'languages_obj'}  = new IMC::Languages( 'site_obj' => $self->{'site_obj'} );
    my $results               = $self->{'languages_obj'}->retrieve_entries();
    #    $self->{'langauges_obj'}->retrieve_entries();
    $self->{'languages'}      = $self->{'languages_obj'}->vars();

    $self->{'categories_obj'} = new IMC::Categories( 'site_obj' => $self->{'site_obj'} );
    $self->{'categories_obj'}->retrieve_entries();
    $self->{'categories'}     = $self->{'categories_obj'}->vars();

    if ( $self->{'AUTHENTICATED'} ){
	$self->{'PASSWORD'} = $self->{'authentication_obj'}->{'PASSWORD'};
    }
}


#this is called when a form is submitted
#it takes a cgi query object with the results of the post...
#then it updates a Featured object with the info and 
#has that recommitted to the database
sub update
{
	my ($self, $query) = @_;
	
	if ($self->{'AUTHENTICATED'}) {
		my $params = $query->Vars();
	
		foreach my $key( keys %$params ) { 
			$self->{'feature_obj'}->set( $key, $params->{ $key } ); 
		}
		
		my $results = $self->{'feature_obj'}->update_entry_in_db();
		
		if ($self->{'ID'}) {
			$self->{'message'} = "Feature ID: $self->{'ID'} has been updated"; 
		}
		else {
			$self->{'message'} = "Feature ID: $self->{'ID'} has been added"; 
		}		
		$self->{'sucess'}  = $results;
	
		#now make sure we've got the latest in our own records....
		$self->{'feature'} = $self->{'feature_obj'}->vars();
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Password Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}

}


sub delete_feature
{
	my ($self, $query) = @_;
	
	if ($self->{'AUTHENTICATED'}) {
		my $results = $self->{'feature_obj'}->delete_entry();
		
		if ($results) {
			$self->{'message'} = "Feature ID: $self->{'ID'} has deleted"; 
		}
		else {
			$self->{'message'} = "Feature ID: $self->{'ID'} has NOT been deleted"; 
		}		
		$self->{'sucess'}  = $results;
	
		#now make sure we've got the latest in our own records....
		$self->{'feature'} = $self->{'feature_obj'}->vars();
	}
	else #we're not authenticated....
	{
		$self->{'message'} = "Password Error: Please check the password and try again";
		$self->{'sucess'}  = 0;
	}
}




1;





