#============================================================= -*-perl-*-
#
# IMC::DB_Peer_Base
#
# DESCRIPTION
#   Base class module implementing common functionality for various other
#   IMC modules which do db peer functions. These include retrieving
#   entries, and setting entries in the database.
#
# AUTHOR
#   Andy Wardley   <abw@kfs.org>
#   Stollen by Evan Henshaw-Plath <evan@protest.net>
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license version 2.
#
#------------------------------------------------------------------------
#
#   $Id: DB_Peer_Base.pm,v 1.1 2001/05/27 01:19:38 rabble Exp $
#
#========================================================================
package IMC::DB_Peer_Base;
use base qw( IMC::Base );
require 5.004;

use strict;
use vars qw( $VERSION $AUTOLOAD $VARS $SITE_ID);

$VERSION = sprintf("%d.%02d", q!Revision: 1.0 $Id: DB_Peer_Base.pm,v 1.1 2001/05/27 01:19:38 rabble Exp $ ! =~ /(\d+)\.(\d+)/);


#------------------------------------------------------------------------
# retrieve_entry(\%self, $ID)
#
# Generic function to retreive a single entry from the database.
# For more extensive functions this should be overridden.
# Requires: 
#          self contains a VARS hash which has the TABLE
#          ID of the entry to retrieve
# Returns: 
#          Nothing if sucessful, or the error string from dbi if it fails
#---------------------------------------------------------------------------

sub retrieve_entry {
    my ($self, $ID) = @_;
    
    my $select_sql =  "select * from  $self->{'VARS'}->{'TABLE'}  WHERE ID = $ID ";
    warn "db_peer_base::retreive_entry select_sql:$select_sql";
    my $sth =  $self->{'dbh'}->prepare( $select_sql );
    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
				
    my $entry_hash	=	$sth->fetchrow_hashref();
	
    foreach my $entry_key ( keys %$entry_hash )
    {
	$self->{ $entry_key } = $entry_hash->{ $entry_key };
    }
    
    my $errstr = $sth->errstr;
    
    $sth->finish();
    
    return $errstr;
}



#------------------------------------------------------------------------
# retrieve_entries(\%self, $SITE_ID)
#
# Generic function to retreive a single entry from the database.
# For more extensive functions this should be overridden.
# Requires: 
#          self contains a VARS hash which has the TABLE
#          SITE_ID or the site_obj as part of the $self hash
# Returns: 
#          Nothing if sucessful, or the error string from dbi if it fails
#
# Results: It creates an entries array
#---------------------------------------------------------------------------


sub retrieve_entries {
    my ($self, $SITE_ID) = @_;
    
    my ($where_sql, $order_by_sql, $limit_sql);
    
    $where_sql    = $self->_get_site_select_sql; 
    $where_sql    = join( ' ', $where_sql, $self->{'WHERE_SQL'} ) if $self->{'WHERE_SQL'};
    $order_by_sql = " ORDER BY " . $self->{'ORDER_BY'}  if $self->{'ORDER_BY'};
    $limit_sql    = " LIMIT " . $self->{'LIMIT'}   if $self->{'LIMIT'};
       
    my $select_sql =  "select * from $self->{'VARS'}->{'TABLE'} WHERE $where_sql $order_by_sql $limit_sql"; 
    #    warn "dbpeer:retrieve_entries:$select_sql";
    my $sth =  $self->{'dbh'}->prepare( $select_sql ) or warn "Failed to prepare";
    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $select_sql");
    
    # This is a bit odd but basically in what should the results
    # be put, we put it in the generic 'entries' array, if we don't
    # have a $self->{'entries_array_name'} set to something
    # more interesting.
    my $entries_array_name = $self->{'entries_array_name'};# || 'entries';
    warn $entries_array_name;
    while ( my $entry_hash	=	$sth->fetchrow_hashref() )
    {
	push @{ $self->{ $entries_array_name } }, $entry_hash;
    }

    my $errstr = $sth->errstr;
    
    $sth->finish();
    
    return $errstr;

}




#--------------------------------------------------------------------------
# delete_entry(\%self)
#
# Generic function to delete a single entry from the database.
# For more extensive functions this should be overridden.
# Requires: 
#          self contains a VARS hash which has the TABLE
#          ID which should be deleted.
# Returns: 
#          Nothing if sucessful, or the error string from dbi if it fails
#---------------------------------------------------------------------------

sub delete_entry
{
    my $self	= shift;

    my $delete_sql =  "DELETE FROM $self->{'VARS'}->{'TABLE'} WHERE ID = $self->{'ID'}";

    my $sth =  $self->{'dbh'}->prepare( $delete_sql );
    $sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $delete_sql");
    
    my $errstr = $sth->errstr if $sth->err;
    
    $sth->finish();
    
    return $errstr;
}



sub _get_site_select_sql
{
    my $my_site_id = _get_site_id( @_ );

    my $site_select_sql = join( ' ', " SITE_ID = ", $my_site_id ) if $my_site_id;

    return $site_select_sql;
}

sub _get_site_id {
    my ($self, $SITE_ID) = @_;
    
    return ($SITE_ID)                    if $SITE_ID                    =~ m/\d+/;
    return ($self->{'site_obj'}->{'ID'}) if $self->{'site_obj'}->{'ID'} =~ m/\d+/;
    return ($self->{'SITE_ID'})          if $self->{'SITE_ID'}          =~ m/\d+/;
    return ($self->{'site'}->{'ID'})     if $self->{'site'}->{'ID'}     =~ m/\d+/;
    
}



sub test_sub
{
    warn "sucess with test_sub";
    
    
    return( " SITE_ID = 8 " );
}






