#============================================================= -*-perl-*-
#
# IMC::CategoriesMenu
#
# DESCRIPTION
#   Module implementing a categories menu object.
#   for editing and updating categories in the system....
#   
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  All Rights Refused.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license.
#
#========================================================================
 
package IMC::CategoriesMenu;
use base qw( IMC::Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG );
use IMC::Database;
use IMC::Features;
use Data::Dumper;

## This is the main version number for the EAM::Library.
## It is extracted by ExtUtils::MakeMaker and inserted in various places.
$VERSION     = '0.01-rc0';
$ERROR       = '';
$DEBUG       = 0;



sub _init {
    my ($self, $config) = @_;
	
    warn "initing categories menu";
    
    #set defaults
    $self->{'template_name'} = 'edit_categories_menu.template';
    
    #let them be overriden
    %$self = ( %$self, %$config );
    
    &load_categories( $self );
    
    return $self;
}


# This should be what goes and calls and gets and entry populated....
sub load_categories
{
    my $self = shift;
	
	
    #get all the features for this site_id, 
    if ( $self->{ 'site_obj' } ) 
    { 
	 $self->{'categories_obj'} = new IMC::Categories( 'site_obj'           => $self->{'site_obj'},
	 						  'dbh'                => $self->{'dbh'},
							  'authentication_obj' => $self->{'authentication_obj'} );
	
	my $results  = $self->{'categories_obj'}->retrieve_entries();

	if ( $self->{'categories_obj'}->categories() )
	{
	     $self->{'categories'} = \@{ $self->{'categories_obj'}->categories() };
	}
    }
}





1;
