#============================================================= -*-perl-*-
#
# IMC::Categories
#
# DESCRIPTION
#   Module implementing a feature category object.
#
# AUTHOR
#   Evan Henshaw-Plath   <evan@protest.net>
#
# COPYLEFT
#   2000 Evan Henshaw-Plath.  Intellectual Property Is Theft!
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#========================================================================
 
package IMC::Categories;
use base qw( IMC::DB_Peer_Base );

require 5.005;

use strict;
use vars qw( $VERSION $AUTOLOAD $ERROR $DEBUG $VARS );
use IMC::Database;

$VARS = { 'TABLE' => 'CATEGORY' };

sub _init {
    my ($self, $config) = @_;
	
    #make sure we've got a database handle
    $self->{'dbh'}  = IMC::Database::connect() unless $self->{'dbh'};
    $self->{'VARS'} = $VARS;
    $self->{'entries_array_name'} = 'categories';
    
#    if( $self->{ 'ID' } ) {
#	warn "before retrieve_entry ($self->{'ID'})";
#	&retrieve_entry( $self, $self->{'ID'} );
#    }
#    elsif( $self->{'site_obj'} ) {
#	warn "before retrieve_entries";
#	&retrieve_entries( $self, $self->{'site_obj'}->{'ID'} );
#	warn "after";
#   }
    return $self;
}





sub update_entry_in_db
{
    my ($self) = @_;

    if ($self->{'ID'}) {
	_update_existing_entry( $self );
    }
    else {
	_add_new_entry( $self );
    }
	
}

sub _update_existing_entry
{
	my $self	= shift;
	my $set_sql = join( ' ',
                            '  CODE = ', $self->{'dbh'}->quote( $self->{'CODE'} ),
			    ', NAME = ', $self->{'dbh'}->quote( $self->{'NAME'} ),
			    ', SITE_ID  = ', $self->{'SITE_ID'},
			    ', DEFAULT_CATEGORY = ', $self->{'DEFAULT_CATEGORY'} ) ;

	my $update_sql =  "UPDATE CATEGORY SET $set_sql WHERE ID = $self->{'ID'}";
	
	my $sth =  $self->{'dbh'}->prepare( $update_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $update_sql");
	
	$sth->finish();
}	


sub _add_new_entry
{
	my $self	= shift;
	my $values_sql = join( ', ', $self->{'dbh'}->quote( $self->{'CODE'} ),
			             $self->{'dbh'}->quote( $self->{'NAME'} ),
			             $self->{'dbh'}->quote( $self->{'SITE_ID'} ),
				     $self->{'dbh'}->quote( $self->{'DEFAULT_CATEGORY'} ) );


	my $insert_sql =  "INSERT INTO CATEGORY (CODE, NAME, SITE_ID, DEFAULT_CATEGORY) VALUES( $values_sql )";
	
	#warn "insert_sql:\n\n$insert_sql\n\n";
	
	my $sth =  $self->{'dbh'}->prepare( $insert_sql );
   	$sth->execute() or warn("DB ERROR ", $sth->errstr, " QUERY $insert_sql");
				
	$sth->finish();
}	
	


1;
