#============================================================= -*-perl-*-
#
# IMC::Base
#
# DESCRIPTION
#   Base class module implementing common functionality for various other
#   IMC modules.
#
# AUTHOR
#   Reworked by Evan Henshaw-Plath <evan@protest.net>
#
# COPYRIGHT
#   Copyright (C) 1996-2001 Evan Henshaw-Plath.  
#   All Intellectual Rights should be considerd properties of the
#   capitalist system.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the terms of the GPL license..
#
#------------------------------------------------------------------------
#
#   $Id: Base.pm,v 1.3 2001/05/26 23:52:17 rabble Exp $
#
#========================================================================
 
package IMC::Base;

require 5.004;

use strict;
use vars qw( $VERSION $AUTOLOAD );

$VERSION = sprintf("%d.%02d", q!Revision: 1.2 $Id: Base.pm,v 1.3 2001/05/26 23:52:17 rabble Exp $ ! =~ /(\d+)\.(\d+)/);


#------------------------------------------------------------------------
# new(\%params)
#
# General purpose constructor method which expects a hash reference of 
# configuration parameters, or a list of name => value pairs which are 
# folded into a hash.  Blesses a hash into an object and calls its 
# _init() method, passing the parameter hash reference.  Returns a new
# object derived from Template::Base, or undef on error.
#------------------------------------------------------------------------

sub new {
    my $class  = shift;
    my $params = (@_ && UNIVERSAL::isa($_[0], 'HASH')) ? shift : { @_ };
    my $self   = bless {  _ERROR => '', }, $class;
       %$self  = ( %$self, %$params );
    return $self->_init($params) ? $self : $class->error($self->error);
}


#------------------------------------------------------------------------
# error()
# error($msg, ...)
# 
# May be called as a class or object method to set or retrieve the 
# package variable $ERROR (class method) or internal member 
# $self->{ _ERROR } (object method).  The presence of parameters indicates
# that the error value should be set.  Undef is then returned.  In the
# abscence of parameters, the current error value is returned.
#------------------------------------------------------------------------

sub error {
    my $self = shift;
    my $errvar;

    { 
		no strict qw( refs );
		$errvar = ref $self ? \$self->{ _ERROR } : \${"$self\::ERROR"};
    }
    if (@_) {
		$$errvar = ref($_[0]) ? shift : join('', @_);
		return undef;
    }
    else {
		return $$errvar;
    }
}


#------------------------------------------------------------------------
# _init()
#
# Initialisation method called by the new() constructor and passing a 
# reference to a hash array containing any configuration items specified
# as constructor arguments.  Should return $self on success or undef on 
# error, via a call to the error() method to set the error message.
#------------------------------------------------------------------------

sub _init {
    my ($self, $config) = @_;

	&combine_hashes( $self, $config );

    return $self;
}



#------------------------------------------------------------------------
# combine_hashes()
#
# Takes two hash references and merges the second in to the first, and returns the first.
# Should return a reference to the combined hash on success or undef on 
# error, via a call to the error() method to set the error message.
#------------------------------------------------------------------------

sub combine_hashes
{
	my ($first_hash, $second_hash) = @_;
	foreach my $second_key ( keys %$second_hash )	{
		$first_hash->{ $second_key } = $second_hash->{ $second_key };
	}
	return $first_hash;
}




#------------------------------------------------------------------------
# AUTOLOAD
#
# Provides pseudo-methods for read-only access to various internal 
# members. 
#------------------------------------------------------------------------

sub AUTOLOAD {
    my $self   = shift;
    my $method = $AUTOLOAD;
	
    $method =~ s/.*:://;
    return if $method eq 'DESTROY';
    warn "Method:$method";
    
    return $self->{ $method } if ( $self->{ $method } );
    
#    my $package = $AUTOLOAD;
#    $package =~ s/::[^\:]+$//;
#    warn "($AUTOLOAD)($method)($package)";
}

#------------------------------------------------------------------------
# DESTORY
#
# Clears up and removes database connections if they haven't been
# cleared up.
#
#------------------------------------------------------------------------

sub DESTROY {
    my $self   = shift;

    $self->{'dbh'}->disconnect() if $self->{'dbh'};
}

#------------------------------------------------------------------------
# set
#
# Set a value on the object.
#
#------------------------------------------------------------------------


sub set
{
    my ($self, $key, $value) = @_;
	
    $self->{ $key } = $value;
}


#------------------------------------------------------------------------
# vars
#
# get the values of the object in an unblessed form.
#
#------------------------------------------------------------------------

sub vars
{
    my $self = shift;
    my $hash; 
    
    foreach my $self_key( keys %$self )	{
	$hash->{ $self_key } = $self->{ $self_key };
    }
    return ($hash);
}




1;

