<? 
# $Id: db_class.php3,v 1.43 2001/04/17 10:03:27 andy Exp $

# we can check this variable later on to see if
# this file has already been included
$db_class_php3 = true;

include("../local/db-setup.php3");
include("../local/webcast/webcast-setup.php3");

class DBClass {
  var $conn;

function DBClass() {
  global $pgsql_so;
 
   if (! $pgsql_so) {
    dl("pgsql.so");
    # make sure we load it just the once
    # you can set this variable to true in webcast-setup.php3 if you want to
    # load pgsql.so in php3.ini instead
    $pgsql_so = true;
  }

  #echo "<b> DBClass constructor!</b>";
  $this->conn = 0;
  
  if ( $this->make_connection() == 0) {
      #echo to browser a semi-legible error messages (users will see this)
      echo "<br><b>Cannot get a connection to postgreSQL database!</b>";
      return 0;
  }

  $this->write_to_log("--- Successfully created DBClass object ----\n");
  return 1;
}

function try_close() {
      $close_result = pg_close($this->conn);
      $this->write_to_log("try_close: attempted close of established connection $this->conn: result $close_result\n");
}

function make_connection() {
 global $db_setup;

  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];

  $db_connect = "user=".$db_user." password=".$db_password." dbname=".$db_current;

  #if asked to connection , and the connection id is not null, try to close
  #already established connection.
  if ($this->conn != 0) {
      $this->try_close();
  }

  $this->conn = pg_connect($db_connect);

  #echo "<p>connection is $this->conn";

  if (! $this->conn ) {

      $this->write_to_log("make_connection:Cannot get a connection to postgreSQL database!");
      return 0;
  }
  
  $this->write_to_log("make_connection: made connection ".$this->conn." to db\n");
  return 1;
}

function execute($function='selecting', $mode='summaries', $data='nuthing') {

  #echo "function $function, mode $mode<p>";

  switch($function) {
    case 'selecting':
      list ($result_index, $rows) = $this->execute_selecting($mode, $data);
      return array($result_index, $rows); 
      break;
    case 'updating':
      list ($result, $reason) = $this->execute_update($data);
      return array ($result, $reason);
      break;
    case 'inserting':
      list ($result, $reason) = $this->execute_insert($data);
      return array ($result, $reason);
      break;
    case 'led':
      #select articles for "live" administration (eg editing) via the web interface.
      list ($result,$total) = $this->execute_select_admin($data);
      return array($result,$total);
      break;
    case 'deleting':
      #delete articles.
      $result = $this->execute_delete($data);
      return $result;
      break;
    case 'linking':
      #linking articles together 
      $result = $this->execute_linking($data);
      return $result;
      break;
    case 'mirror_flag_update':
      $result = $this->execute_mirror_flag_update($data);
      return $result;
      break;
    case 'publish_buffer':
      list ($result, $rows, $dataid) = $this->execute_publish_buffer($mode, $data);
      return array ($result, $rows, $dataid);
      break;
    case 'undeleting':
      $result = $this->execute_undelete($data);
      return $result;
      break;
    case 'rating':
      list ($result, $reason) = $this->execute_rating($data);
      return array ($result, $reason);
      break;
    case 'webcast_groups':
      $result = $this->execute_webcast_groups($mode, $data);
      return $result;
      break;
  }

}

function execute_webcast_groups($mode, $data) {

global $db_setup;
$db_user = $db_setup["user"];
$db_password = $db_setup["password"];
$db_current = $db_setup["database"];

$db_table_name = $data["table_name"];
$db_seq_name = $data["seq_name"];

$db_appear_table_name = $data["appear_table_name"];
$db_appear_seq_name = $data["appear_seq_name"];

$db_rate_table_name = $data["rate_table_name"];
$db_rate_seq_name = $data["rate_seq_name"];


switch ($mode) {
  case 'select':
	if (strlen($data["group_id"]) > 0) {
		$where_claws = " group_id='".$data["group_id"]."'";
	} else {
		$where_claws = " id=".$data["id"];
	} 

	$select_str = "select * from $db_table_name where $where_claws;";
	$result = $this->sql_query_wrapper($select_str);
	return $result;
	break;

  case 'rating_system':
	$select_str = "select * from $db_rate_table_name where group_id='".$data["id"]."';";
	$result = $this->sql_query_wrapper($select_str);
	return $result;
	break;

  case 'groups':
	#just select all group entries from webcast_groups table.
	$select_str = "select * from $db_table_name order by id asc;";
	$result = $this->sql_query_wrapper( $select_str);
	return $result;
	break;

  case 'appearance':	
	#select appearance data from webcast_groups_appear table

	#first find the id of the group , using its URL string 'id' 
        #eg 'webcast' or 'internal'
	$select_id = "select id from $db_table_name where group_id='".$data["group_id"]."';";
	$result = $this->sql_query_wrapper($select_id);
	if (! $result) {
		return 0;
	}
	$id = pg_fetch_object($result,0);

	$select_appearance_str = "select * from $db_appear_table_name where webcast_groups_id=".$id->id.";";	
	$result = $this->sql_query_wrapper($select_appearance_str);
	return $result;
	break;

  case 'update':
	#update the entries in the db.
	$update_str = "update $db_table_name set group_id='".$data["group_id"]."',group_description='".$data["description"]."',icon_url='".$data["icon_url"]."',allow_open_publishing='".$data["publish"]."',allow_rating='".$data["rate"]."',quick_comment='".$data["quick_comment"]."',email_contact_tech='".$data["tech_email"]."',email_contact_editorial='".$data["editorial_email"]."',email_contact_auto_news='".$data["auto_news_email"]."',auto_news_footer='".$data["news_footer"]."',auto_news_header='".$data["news_header"]."',robot_email='".$data["robot_email"]."',displaying='".$data["displaying"]."',password='".$data["password"]."' where id='".$data["id"]."';";

	$result = $this->sql_query_wrapper($update_str);

	$update_str = "update $db_appear_table_name set bgcolor='".$data["bgcolor"]."',fgcolor='".$data["fgcolor"]."',linkcolor='".$data["linkcolor"]."',vlinkcolor='".$data["vlinkcolor"]."',alinkcolor='".$data["alinkcolor"]."',heading_bgcolor='".$data["heading_bgcolor"]."',subheading_bgcolor='".$data["subheading_bgcolor"]."',background_grey='".$data["background_grey"]."',printable='".$data["printable"]."',url_crop_length='".$data["url_crop_length"]."',display_avg_rating='".$data["display_avg_rate"]."',threshold_rating='".$data["threshold_rating"]."' where webcast_groups_id='".$data["id"]."';";

	$result2 = $this->sql_query_wrapper($update_str);

	
	#delete previous rating system .. then add new one.
        #this isnt so cool. think harder about this.
	$delete_str = "delete from $db_rate_table_name where group_id='".$data["id"]."';";
	$result3 = $this->sql_query_wrapper($delete_str);

	for ($i=0;$i<$data["rate_system_size"];$i++){
  		$insert_ratings = "insert into $db_rate_table_name values (nextval('$db_rate_seq_name'),'".$data["rate_description"][$i]."','".$data["id"]."');";
  		$result4 = $this->sql_query_wrapper($insert_ratings);
  	}

	return ($result && $result2 && $result3 && $result4);
  
 	break;	
  case 'delete':
	$delete_str = "update $db_table_name set displaying='false' where id=".$data["id"].";";
	$result = $this->sql_query_wrapper($delete_str);
	return $result;
	break;

  case 'undelete':
	$undelete_str = "update $db_table_name set displaying='true' where id=".$data["id"].";";
	$result = $this->sql_query_wrapper($undelete_str);
	return $result;
	break;

  case 'insert':
       #to truly do this correctly, we should use transactions and locks.
       #why? due to the, seemingly remote, chance of someone inserting another
       #entry into the webcast_groups table in between us inserting and
       #then asking the sequence for the last_value. If this did happen without
       #locks we would get the wrong value.

       $begin_trans = "begin transaction;";
       $result = $this->sql_query_wrapper($begin_trans);
       if (! $result) { return 0; }
       $lock_group = "lock table $db_table_name;";
       $result = $this->sql_query_wrapper($lock_group);
       if (! $result) { return 0; }
       $lock_appearance = "lock table $db_appear_table_name;";
       $result = $this->sql_query_wrapper($lock_appearance);
       if (! $result) { return 0; }
       $lock_ratings_system = "lock table $db_rate_table_name;";
       $result = $this->sql_query_wrapper($lock_ratings_system);
       if (! $result) { return 0; }
       

	#insert new group data into the database..
 	$insertion_str="insert into $db_table_name values (nextval('$db_seq_name'),
  	'".$data["group_id"]."', '".$data["group_description"]."', '".$data["icon_url"]."',
  	'".$data["publish"]."', '".$data["rate"]."', '".$data["quick_comment"]."',
        '".$data["email_contact_tech"]."','".$data["email_contact_editorial"]."',
	'".$data["email_contact_auto_news"]."', '".$data["auto_news_header"]."',
  	'".$data["auto_news_footer"]."', '".$data["robot_email"]."',
	'".$data["displaying"]."','".$data["password"]."','0');";

  	$result = $this->sql_query_wrapper( $insertion_str);
	if (! $result) {
		#something went wrong.. remove the locks
 		$end_trans = "end transaction;";
		$result_trans = $this->sql_query_wrapper($end_trans);
		return 0;
	}

	#select the id of the just-inserted group entry, using the sequence.
	$select_id = "select last_value from $db_seq_name;";
	$result = $this->sql_query_wrapper($select_id);
	if (! $result) {
		return 0;
	}
	$id = pg_fetch_object($result,0);
	
	#insert new appearance data into the database. 
	#(what about linking from already existing appearance data? 
	# - maybe a default can be displayed?)

	$insertion_str="insert into $db_appear_table_name values (nextval('$db_appear_seq_name'),
  	'".$id->last_value."', '".$data["bgcolor"]."', '".$data["fgcolor"]."',
  	'".$data["linkcolor"]."', '".$data["vlinkcolor"]."', '".$data["alinkcolor"]."',
        '".$data["heading_bgcolor"]."','".$data["subheading_bgcolor"]."',
	'".$data["background_grey"]."', '".$data["printable"]."',
  	'".$data["url_crop_length"]."', '".$data["display_avg_rate"]."',
	'".$data["threshold_rating"]."','".$data["entryform_filename"]."');";

  	$result = $this->sql_query_wrapper( $insertion_str);
  	if (! $result) {
  	                #something went wrong.. remove the locks
  	                $end_trans = "end transaction;";
  	                $result_trans = $this->sql_query_wrapper($end_trans);
  	                return 0;
  	}

	for ($i=0;$i<$data["rate_system_size"];$i++){
  		$insert_ratings = "insert into $db_rate_table_name values (nextval('$db_rate_seq_name'),'".$data["rate_description"][$i]."','".$id->last_value."');";
  		$result = $this->sql_query_wrapper($insert_ratings);
  		if (! $result) {
                	        #something went wrong.. remove the locks
                        	$end_trans = "end transaction;";
                        	$result_trans = $this->sql_query_wrapper($end_trans);
				return 0;
		}
	}

        $end_trans = "end transaction;";
	$result_trans = $this->sql_query_wrapper($end_trans);

	return $result_trans;
	break;

}

}



function execute_rating($data) {
global $db_setup;
$db_user = $db_setup["user"];
$db_password = $db_setup["password"];
$db_current = $db_setup["database"];
$db_table_name = $data["table_name"];
$db_seq_name = $data["seq_name"];

  $mod_str = "update webcast set modified='now' where id='".$data["article_id"]."';";
  $result = $this->sql_query_wrapper($mod_str);

  $update_str="INSERT INTO $db_table_name VALUES (nextval('$db_seq_name'),
               '".$data["article_id"]."','".$data["rating"]."','".$data["user_id"]."',
               '".$data["categorisation_id"]."');";

  $result = $this->sql_query_wrapper( $update_str);
  if (! $result) {
	$reason = pg_ErrorMessage($this->conn);
  }

  return array ($result, $reason);

}



function execute_publish_buffer($mode, $data) {
global $db_setup;
$db_table_name=$data["table_name"];
$db_seq_name=$data["seq_name"];  

$db_article_seq_name=$data["article_seq_name"];
$db_article_table_name=$data["article_table_name"];

switch ($mode) {
    case 'insert':
        #When rating,the external_id is set already to the id of article being rated
        #Straight after publishing, in new_data-process.php3, this function is called
        #with external_id = 0

        if ($data["external_id"] == 0) {
          #get the value of the id of the last published article..
	  $select_id_str = "SELECT last_value from $db_article_seq_name;";
          $result = $this->sql_query_wrapper($select_id_str);
    
          $obj = pg_fetch_object($result,0);
          $data["external_id"] = $obj->last_value;
	}
    
	$ins_str = "INSERT into $db_table_name values (nextval('$db_seq_name'),
            '".$data["remote_ip"]."','".$data["publish_time"]."',
            '".$data["action"]."','".$data["user_id"]."','".$data["external_id"]."');";
        $result = $this->sql_query_wrapper($ins_str);


        $end_trans = "end transaction;";
	$result_trans = $this->sql_query_wrapper($end_trans);

        #return the $result index from the db call, the rows, and the
        #id of the last insert article (only valid in 'insert' mode,
        # when doing a new article publish , ie not a new comment )
	return array ($result, $rows, $data["external_id"]);
       
        break;

     case 'select':
       #lookup in publish buffer entries from the same IP, and the date is 
       #published today, and ACTION is (publish|rate|...).

       $begin_trans = "begin transaction;";
       $result = $this->sql_query_wrapper($begin_trans);
       if (! $result) { return array(0,0);} 

       $lock_pubbuf = "lock table $db_table_name;";
       $result = $this->sql_query_wrapper($lock_pubbuf);
       if (! $result) { return array(0,0);} 

       $lock_webcast = "lock table $db_article_table_name;";
       $result = $this->sql_query_wrapper($lock_webcast);
       if (! $result) { return array(0,0);}
       
       if (chop($data["action"]) == "rate") {
		$where_claws = " and externalid=".$data["external_id"];
       }


       $select_str = "SELECT * from $db_table_name where publiship = '" . $data["remote_ip"] . "' and action='".$data["action"]."' and CAST(publishdate AS DATE) = CAST (now() AS DATE) $where_claws;";

       $result = $this->sql_query_wrapper($select_str);
       if (! $result) {
	  $end_trans = "end transaction;";
	  $this->sql_query_wrapper($end_trans);
	  return array (0,0);
       }
       $rows = pg_NumRows($result);

      
       switch ($data["action"]) {
  	case 'publish':
        
	 # further checks necessary against multiple publishing...
	 if ($rows > 0) {
	  for($i=0;$i<$rows;$i++) {
	   
	   $x = pg_fetch_object($result,$i);
	   if ($x->externalid == 0) continue;
	        
	     $article_select_str = "SELECT heading,summary from $db_article_table_name WHERE id='".$x->externalid."';";
	     
	     $x_result = $this->sql_query_wrapper($article_select_str);
	     
	     $rows_external = pg_NumRows($x_result);
	     
	     if ($rows_external > 0) {
	       $y = pg_fetch_object($x_result,0);
	       #echo "<br>Checking against articles published today under the heading <b>".$y->heading ."</b>" ;		    	
	       if (chop($y->heading) == chop($data["heading"]) && chop($y->summary) == chop($data["summary"])) {
                 #double publishing detected!
                 #end the transaction! remove the locks!
		 $end_trans = "end transaction;";
		 $result = $this->sql_query_wrapper($end_trans);
		 return array (0, 0);
	       }
	     }
	     #end if rows from "external" table greater than zero
	   }
           #end for
	 }
	 #end if rows from publishbuffer greater than zero
       }
       #end switch statement


       $end_trans = "end transaction;";
       $result = $this->sql_query_wrapper($end_trans);
       return array ($result, $rows);
       break;
}

}


function execute_linking($data) {
  global $db_setup;
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];
  $display_table_name = $data["non_link_table_name"];

  $link_indices = $data["link_indices"];
  $not_display = $data["not_display"];


  for ($i = 0; $i < sizeof($link_indices); $i++) {
  #update display var in db entry for each record when 'video audio still' 
  #in keywords and the entry is not the oldest 
    if (($not_display[$i])) {
	#update the display bool in their webcast table
        $alter_str = "update $display_table_name set display = 'false' where id=".$link_indices[$i].";";	
	$this->sql_query_wrapper( $alter_str);
    }
    #This will link , given a set {a,b,c,d..} , the following pairs:
    # {a,b} , {a,c}, {a,d} ..
    #Then given that the outermost loop ranges over all the indices,
    # All combinations are generated, eg
    # {a,b}, {a,c}, {a,d} {b,c}, {b,d}, {c,d}
    for ($j = $i+1; $j < sizeof($link_indices); $j++) {
      if ($link_indices[$i] != 0 && $link_indices[$j] != 0) {
#link j and i if not already linked.
	$select_str = "select id,strength from $db_table_name where fromlink=".$link_indices[$i]." and tolink=".$link_indices[$j].";";
	$result = $this->sql_query_wrapper( $select_str);
	$rows = pg_NumRows($result);
	if ($rows > 0) {
	  $id = pg_Result($result,0,0);
	  $strength = pg_Result($result,0,1);
	  $strength += 1;
	  $insert_str = "update $db_table_name set keywords='".$data["keywords"]."', strength='".$strength."' where id=".$id." ;";
	  $result = $this->sql_query_wrapper( $insert_str);


	#Should individual article's mod time so be changed?

	}
	else {
	  $insert_str = "insert into $db_table_name values (nextval('$db_seq_name'), '".$link_indices[$i]."', '".$link_indices[$j]."', '".$data["keywords"]."', '0', 'now','now');";
	  $result = $this->sql_query_wrapper( $insert_str);
	}
      #end if link not zero
      }
    #end of for j
    }
  #end of for i
  }
}
  
function execute_delete($data) {
  global $db_setup;
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];

  $result_prt = $this->sql_query_wrapper( "select parent_id from $db_table_name where id = ".$data["article_id"].";");
  if ($result_prt) {
    $prt_id=pg_result($result_prt,0,0); 
  }
  else {
    echo "<h3> cannot find parent article! </h3>";
    $prt_id = 0;
  }

  #$result = $this->sql_query_wrapper( "delete from $db_table_name where id = ".$data["article_id"].";");

 $result = $this->sql_query_wrapper( "update $db_table_name set display = '0' where id =".$data["article_id"].";");

  if ($result) {
    echo "<h3>article " . $data["article_id"] . " deleted </h3><br>";
  }
  else {
    echo "<h3>article not deleted! </h3>";
    $reason = pg_ErrorMessage($this->conn);
    echo "<p>$reason<p>";
  }
  
  if ($result_prt && $prt_id != 0) {
    #get number of comments from the article this response is commenting on, then subtract one and update
    $query_string="select numcomment from $db_table_name where id=".$prt_id.";";
    $table=$this->sql_query_wrapper( $query_string);
    $nc=pg_result($table,0,0);
    $nc=$nc - 1;
    
    $query_string="update $db_table_name set numcomment=$nc where id=".$prt_id.";";
    $result=$this->sql_query_wrapper( $query_string);
  }

  return 0;
}

function execute_undelete($data) {
  global $db_setup;
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];

  $result_prt = $this->sql_query_wrapper( "select parent_id from $db_table_name where id = ".$data["article_id"].";");
  if ($result_prt) {
    $prt_id=pg_result($result_prt,0,0); 
  }
  else {
    echo "<h3> cannot find parent article! </h3>";
    $prt_id = 0;
  }

 $result = $this->sql_query_wrapper( "update $db_table_name set display = 't' where id =".$data["article_id"].";");

  if ($result) {
    echo "<h3>article " . $data["article_id"] . " un-deleted </h3><br>";
  }
  else {
    echo "<h3>article not un-deleted! </h3>";
    $reason = pg_ErrorMessage($this->conn);
    echo "<p>$reason<p>";
  }
  
  if ($result_prt && $prt_id != 0) {
    #get number of comments from the article this response is commenting on, then add one and update
    $query_string="select numcomment from $db_table_name where id=".$prt_id.";";
    $table=$this->sql_query_wrapper( $query_string);
    $nc=pg_result($table,0,0);
    $nc=$nc + 1;
    
    $query_string="update $db_table_name set numcomment=$nc where id=".$prt_id.";";
    $result=$this->sql_query_wrapper( $query_string);
  }

  return 0;
}

function execute_select_admin($data) {
  global $db_setup,$edit_page_length;

  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];
  
  $edit_comments = $data["edit_comments"];

  #use an offset into the articles to show. Allows limiting pages to a set size.
  $offset = $data["first_story"];

  # backward compatibility kludge - maffew oct00
  if (strlen($data["publishtype"]) == 0) {
    $data["publishtype"] = "webcast";
  }

  #switch to do ordering on the rating selection..
  switch($data["rate"]) {
	case 'none':
		#case where we want to show unrated articles too.
		$original_sql = true;
		$table_modifier = "";
	break;	

	case 'highest':
		$original_sql = false;
		$table_modifier = "t1.";
		$sort_filter_rated = "avg(t0.rating) desc,";
	break;	

	case 'lowest':
		$original_sql = false;
		$table_modifier = "t1.";
		$sort_filter_rated = "avg(t0.rating) asc,";
	break;
	
	default:
		$original_sql = true;
		$table_modifier = "";
		break;
  }

  # unless asked do not show comments for editing
  if (substr($edit_comments, 0, 1) != "y") {
    $comments = " and ".$table_modifier."parent_id = 0 ";
  }

  #do order by switch statement
  #default sort filter for summaries selection.
  $sort_filter = $table_modifier."created desc,".$table_modifier."id desc";

  switch($data["sort_filter"]) {
	case 'date_desc':
		$sort_filter = $table_modifier."created desc,".$table_modifier."id desc";
		break;
	case 'date_asc':
		$sort_filter = $table_modifier."created asc,".$table_modifier."id asc";
		break;
	case 'mod_desc':
		$sort_filter = $table_modifier."modified desc,".$table_modifier."created desc,".$table_modifier."id desc";
		break;
 	case 'mod_asc':
		$sort_filter = $table_modifier."modified asc,".$table_modifier."created asc,".$table_modifier."id asc";
		$break;
	}
 
  #switch on the filter setting ...
  switch ($data["filter"]) {
	case 'none': 
		$filter_sql = "";
		break;
	case 'hidden':
		$filter_sql = " and ".$table_modifier."display = 'f' ";
		break;
	case 'visible':
		$filter_sql = " and ".$table_modifier."display ='t' ";
		break;
	case 'text':
		$filter_sql = " and ".$table_modifier."mime_type like '%text%' ";
		break;
	case 'images':
		$filter_sql = " and ".$table_modifier."mime_type like '%image%' ";
		break;
	case 'video':
		$filter_sql = " and ".$table_modifier."mime_type like '%video%' ";
		break;
	case 'audio':
		$filter_sql = " and ".$table_modifier."mime_type like '%audio%' ";
		break;
	default:
		$filter_sql = "";
		break;
	}
  
  #this SQL statement selects the db items to link,edit,delete with.
  $sql_to_get_items = "select * from $db_table_name where arttype='".$data["publishtype"]."' $comments $filter_sql order by $sort_filter ";

  $sql_rated_fields = "t0.articleid,t1.id,t1.arttype,t1.created,t1.modified,t1.author,t1.heading,t1.mime_type,t1.display";

  #could select back all rated fields, that is not just the average, 
  #for more complex stuff..
  $sql_to_get_rated_items = "select avg(t0.rating),".$sql_rated_fields." from article_classification t0, webcast t1 where t1.arttype = '".$data["publishtype"]."' and t0.articleid = t1.id $comments $filter_sql group by ".$sql_rated_fields." order by $sort_filter_rated $sort_filter ";

  $sql_limit_statement = " limit $edit_page_length offset $offset;";

  #switch on whether or not ratings are being used...  
  if ($original_sql ) { $sql_items = $sql_to_get_items; } 
		 else { $sql_items = $sql_to_get_rated_items; }

  $table = $this->sql_query_wrapper( $sql_items . $sql_limit_statement);
  $rows_showing = pg_NumRows($table);


  #TO-DO: make these return the count of all possible articles/comments
  #       with the *filters* includeded in the SQL.
  $rows_available_sql = "select count(*) from $db_table_name where arttype='".$data["publishtype"]."' and parent_id=0;";
  $table2 = $this->sql_query_wrapper($rows_available_sql);
  $rows_available = pg_fetch_object($table2,0);

  $comments_available_sql = "select count(*) from $db_table_name where arttype='".$data["publishtype"]."' and parent_id != 0;";
  $table2 = $this->sql_query_wrapper($comments_available_sql);
  $comments_available = pg_fetch_object($table2,0);


  $stats["articles"] = $rows_available->count;
  $stats["comments"] = $comments_available->count;
  $stats["rows_showing"] = $rows_showing;
  
  return array ($table,$stats); 
}


function execute_insert($data) {
  global $db_setup;
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];

  if ($data["parent_id"] != "0") {
#get number of comments from the article this response is commenting on, then add one and update
    $query_string="select numcomment from $db_table_name where id=".$data["parent_id"].";";
    $table=$this->sql_query_wrapper( $query_string);

    if (! $table) {
        #something went wrong in SQL getting number of comments.. bail out
        return 0;
    }
    

    $nc=pg_result($table,0,0);
    $nc=$nc + 1;

    #update the "number of comments" field in the parent article, also update
    #the mtime of the article.

    #to-do: what about updating the mtime of the head of a linked article set?

    $query_string="update $db_table_name set numcomment=$nc,modified='now' where id=".$data["parent_id"].";";
    $result=$this->sql_query_wrapper( $query_string);

    if (! $result) {
        #something went wrong setting updated number of comments.. bail out
        return 0;
    }
    
  }

  # backward compatibility kludge - maffew oct00
  # changed from $data["publishtype"] to $data["arttype"] - andy jan01
  if (strlen($data["arttype"]) == 0) {
    $data["arttype"] = "webcast";
  }

  $insertion_str="insert into $db_table_name (id, heading, author, date_entered, article, contact, link, address, phone, parent_id, mime_type, summary, numcomment, arttype, html_file, created, modified, linked_file, mirrored, display, group_status, is_html, language, encoding) values (nextval('$db_seq_name'),
  '".$data["heading"]."', '".$data["author"]."', '".$data["date_entered"]."',
  '".$data["article"]."', '".$data["contact"]."', '".$data["link"]."',
  '".$data["address"]."', '".$data["phone"]."', '".$data["parent_id"]."',
  '".$data["mime_type"]."', '".$data["summary"]."', '".$data["numcomments"]."',
  '".$data["arttype"]."', '".$data["html_file"]."',
  '".$data["created_time"]."', '".$data["modified_time"]."',
  '".$data["linked_file"]."', '0', '1', '".$data["group_status"]."',
  '".$data["is_html"]."','".$data["language"]."','".$data["encoding"]."');";

  $result = $this->sql_query_wrapper( $insertion_str);
  if (! $result) {
	$reason = pg_ErrorMessage($this->conn);
  }

  return array ($result, $reason);
}

function execute_update($data) {
  global $db_setup;
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];

  $update_str="update $db_table_name set heading='"
    .$data["heading"]."',author='".$data["author"]."',article='"
    .$data["article"]."',contact='".$data["contact"]."',link='"
    .$data["link"]."',address='".$data["address"]."',phone='"
    .$data["phone"]."',mime_type='".$data["mime_type"]."',summary='"
    .$data["summary"]."',html_file='".$data["html_file"]."'
    ,modified='now',linked_file='".$data["linked_file"]."',display='"
    .$data["display"]."',is_html='".$data["is_html"]."',language='"
    .$data["language"]."',group_status='".$data["group_status"]."',encoding='"
    .$data["encoding"]."' where id=".$data["art_id"].";";

  $result = $this->sql_query_wrapper( $update_str);
  if (! $result) {
      $reason = pg_ErrorMessage($this->conn);
  } 

  return array ($result, $reason);
}

function execute_selecting($mode, $data) {
  # all the SQL commands for selecting things out of the table
  global $db_setup;
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];
  $db_table_name = $data["table_name"];
  $db_seq_name = $data["seq_name"];
  $db_linktable_name = $data["linktable_name"];

  if (strlen($mode) == 0) {
    $mode = 'summaries';
  }

  # backward compatibility kludge - maffew oct00
  if (strlen($data["publishtype"]) == 0) {
    $data["publishtype"] = "webcast";
  }

  #switch to do ordering on the rating selection..
  switch($data["rate"]) {
	case 'none':
		#case where we want to show unrated articles too.
		$original_sql = true;
		$table_modifier = "";
	break;	

	case 'highest':
		$original_sql = false;
		$table_modifier = "t1.";
		$sort_filter_rated = "avg(t0.rating) desc,";
	break;	

	case 'lowest':
		$original_sql = false;
		$table_modifier = "t1.";
		$sort_filter_rated = "avg(t0.rating) asc,";
	break;
	
	default:
		$original_sql = true;
		$table_modifier = "";
		break;
  }

   #do order by switch statement
  #default sort filter for summaries selection.
  $sort_filter = $table_modifier."created desc,".$table_modifier."id desc";

  switch($data["sort_filter"]) {
	case 'date_desc':
		$sort_filter = $table_modifier."created desc,".$table_modifier."id desc";
		break;
	case 'date_asc':
		$sort_filter = $table_modifier."created asc,".$table_modifier."id asc";
		break;
	case 'mod_desc':
		$sort_filter = $table_modifier."modified desc,".$table_modifier."created desc,".$table_modifier."id desc";
		break;
 	case 'mod_asc':
		$sort_filter = $table_modifier."modified asc,".$table_modifier."created asc,".$table_modifier."id asc";
		$break;
	}
 
  #switch on the filter setting ...
  switch ($data["filter"]) {
	case 'none': 
		$filter_sql = " ";
		break;
	case 'hidden':
		$filter_sql = " and ".$table_modifier."display = 'f' ";
		break;
	case 'visible':
		$filter_sql = " and ".$table_modifier."display ='t' ";
		break;
	case 'text':
		$filter_sql = " and ".$table_modifier."mime_type like '%text%' ";
		break;
	case 'images':
		$filter_sql = " and ".$table_modifier."mime_type like '%image%' ";
		break;
	case 'video':
		$filter_sql = " and ".$table_modifier."mime_type like '%video%' ";
		break;
	case 'audio':
		$filter_sql = " and ".$table_modifier."mime_type like '%audio%' ";
		break;
	default:
		$filter_sql = " and ".$table_modifier."display ='t' ";
		break;
	}

  #used in sql[9] - which is used to select only rated summaries..
  $sql_rated_fields = "t0.articleid,t1.id,t1.arttype,t1.created,t1.modified,t1.author,t1.heading,t1.mime_type,t1.display,t1.summary";


  $sql = array ( 

  #used to select all the summaries, with display = true and in a particular group.
  #The summaries are 'top-level' (parent_id=0), using a user-selected ordering.
  0 => "select * from $db_table_name where parent_id=0  and display = 'true' and arttype='".$data["publishtype"]."' order by $sort_filter;",

  #used to select a set of articles, the 'top-level' article and all comments on that
  #article.
  1 => "select * from $db_table_name where id=".$data["article_id"]." and arttype='".$data["publishtype"]."' union select * from $db_table_name where parent_id=".$data["article_id"]." and display = 'true' order by created ASC, id ASC;",

  #used to select the a particular article.
  2 => "select * from $db_table_name where id=".$data["article_id"].";",

  #used to select a set of 'linked' articles for a particular article, 
  #via pointers in the weblink table.
  3 => "select * from $db_table_name where fromlink=".$data["article_id"]." union select * from $db_table_name where tolink=".$data["article_id"]." order by ".$data["order_field"]." DESC;",

  #selects articles matching a set of keywords.
  4 => "select * from $db_table_name where keywords ~* '".$data["keyword"]."' order by ".$data["order_field"]." DESC;",

  #The sql below fetches the linked together multimedia articles.
  # The sql is a UNION (postgres unions remove duplicates)
  # between a SELECT
  #  from the main article db directly using the article id given.
  #  (Thus, if no linked articles then we get at least the article itself back)
  # and a SELECT
  #  from the main article db of any articles that:
  #   have a 'id' field matching that of a link db record's 'fromlink'
  #   OR 'tolink' field
  #  AND
  #   have a id (in the main article db) equal with the 'tolink' field value.
 

  # From the administration page, the stories selected for linking
  # are processed thusly:
  # Story X, X +a, X+b,..,X+n etc (where X < X+a < X+b< .. < X + n)
  # Form links: X , X+a
  #             X, X+b
  #              ..
  #             X, X+n
  # Hence, at present links are "directionally" the same, since the
  # fromlink is always lower in id than tolink, the first PUBLISHED
  # story is linked "outwards" to older stories.

  #Examples:
  #  link table
  #   fromlink tolink
  #      2       5
  #      3       5
  #      2       6
  #
  #  using the SQL with id = 2 gives articles 2 , 5 and 6.
  #  using the SQL with id = 5 gives article 5.
  #
  #  NOTE: modifying the SQL such that the 'webcast.id = weblink.fromlink'
  #  is called instead of 'webcast.id = webcast.tolink' means:
  #
  #  using the SQL with id = 2 gives article 2.
  #  using the SQL with id = 5 gives articles 2 , 3 and 5.
  #

  
  5 => "select ".$db_table_name.".* from $db_table_name,$db_linktable_name where (".$db_linktable_name.".fromlink = ".$data["article_id"]." or ".$db_linktable_name.".tolink = ".$data["article_id"].") and ".$db_table_name.".id = ".$db_linktable_name.".tolink union select ".$db_table_name.".* from $db_table_name where ".$db_table_name.".id = ".$data["article_id"].";",

  # query 6 for use by summariesSinceDate mode. jrochkind. 3/18/00
  6 => "SELECT * FROM $db_table_name WHERE parent_id = 0 AND created >= '".$data[created_since]."';",

  #query to ask for ratings on an article.						  
  7 => "SELECT * FROM $db_table_name WHERE articleid = ". $data["article_id"] .";",
		 
  #query to ask for average of rating field on article.					  
  8 => "SELECT avg(rating) FROM $db_table_name WHERE articleid = ". $data["article_id"] .";",

  #this query selects the summaries, with an avergage from the article_classification
  # allowing an ordering based upon average ratings.
  9 => "select avg(t0.rating),".$sql_rated_fields." from article_classification t0, webcast t1 where t1.display='true' and t1.arttype = '".$data["publishtype"]."' and t0.articleid = t1.id and t1.parent_id=0 $filter_sql group by ".$sql_rated_fields." order by $sort_filter_rated $sort_filter;",

  10 => "select * from ".$db_table_name." where linked_file != ''; "
     );

   #echo "<br> doing $mode";
   switch ($mode) {
     case 'summaries':
     case 'front_page':
        #switch on whether or not ratings are being used to select summaries.  
  	if ($original_sql ) { $sql_items = $sql[0]; } 
		       else { $sql_items = $sql[9]; }
       $result_index = $this->sql_query_wrapper( $sql_items);
       break;    
     case 'article':
       $result_index = $this->sql_query_wrapper( $sql[1]);
       break;
     case 'editing':
       $result_index = $this->sql_query_wrapper( $sql[2]);
       break;
     case 'linking':
       $result_index = $this->sql_query_wrapper( $sql[3]);
       break;
     case 'keywords':
       $result_index = $this->sql_query_wrapper( $sql[4]);
       break;
     case 'getlinked':
       $result_index = $this->sql_query_wrapper( $sql[5]);
       break;
     case 'summariesSinceDate':
       $result_index = $this->sql_query_wrapper( $sql[6]);
       break;
     case 'ratings':
       $result_index = $this->sql_query_wrapper( $sql[7]);
       break;
     case 'ratings_avg':
       $result_index = $this->sql_query_wrapper( $sql[8]);
       break;
     case 'linked_files':
       $result_index = $this->sql_query_wrapper ( $sql[10]);
       break;
   }

  $rows = pg_NumRows($result_index);

  return array ($result_index, $rows);
}

function execute_mirror_flag_update($data) {
# turns mirrored flag on for files that were created long enough ago
# that they should have been mirrored by now

#IDEA: we could do a http get request for the mirrored form of the file,
# and if it works, only then update the mirrored flag if *actually* mirrored.

  global $db_setup, $mirror_delay;
  
  $now = time();
  $mirrored_time = $now - $mirror_delay*60;
  $sql_mirrored_time = $this->unix_time_to_SQL($mirrored_time);
  
  $db_user = $db_setup["user"];
  $db_password = $db_setup["password"];
  $db_current = $db_setup["database"];

  $db_table_name = $data["table_name"];

  $update = "UPDATE $db_table_name set mirrored='t' WHERE created < " . "'$sql_mirrored_time' AND mirrored='f';";

  $result = $this->sql_query_wrapper( $update);
  if (! $result) {
	$reason = pg_ErrorMessage($this->conn);
  }

  return array ($result, $reason);
}

function sql_query_wrapper($query) {
  # a wrapper for SQL queries so that we can log them.
  # protect against overlong stories - 
  # postgresql chokes on them
  if (strlen($query) > 8100) {
      echo "<b>Too much info:</b> I am afraid somehow I have
      ended up asking the database to swallow too much info.
      This probably means there is a bug in our software
      and also that your story has not been added or updated in the
      database.<p>";

      $this->write_to_log("$query\n IS TO LARGE! Not sending it to BACKEND.\n");
      $query_result = false;

  } else {

    $str_to_write = $query."\n";

    $this->write_to_log($str_to_write);

    #try up to three times to execute query.
    $query_result = $this->try_execute($query,3);
    
    #$query_result = pg_Exec($connection, $query);
    
    if ($query_result == 0) {
      $str_to_write="Last query FAILED on connection::".$this->conn."\n";
      $this->write_to_log($str_to_write);
    }
  }
  
  return $query_result;

}


#
# Function which does actual execute of SQL via pg_exec
#
# $query - SQL query
# $times - how many times to try to execute SQL
function try_execute($query, $times) {
      $attempted = 0;

      while ($attempted < $times) {

        $result = pg_exec($this->conn,$query);
        $attempted++;
        
        if ($result == 0) {
          #try to get error message
          $why = pg_errormessage($this->conn);

          $this->write_to_log("try_execute: $query failed because $why: attempt $attempted\n");
          
          # try again if $attempted < $times.

          #what if connection is invalid - try reconnect?
          if ($this->conn == 0 || (strlen($why) == 0)) { $this->make_connection(); }

        } else {
          #success - just return result index.
          $this->write_to_log("try_execute: success: result index $result\n");
          return $result;
        }

      } #end while.
}


#Function that writes to the designated log file.
#prepends Timestamp to message string.
function write_to_log($string) {
  global $db_setup;
    $fp=fopen($db_setup["sql_log"], "a");
    $string = strftime("%c") . " " . $string;
    fwrite ($fp, $string, strlen($string));
    fclose($fp);   
}

  # functions to convert between Unix time (seconds since 1970 style)
  # and postgresql timestamp data type
  # warning: php seems ignorant of timezones, but postgresql
  # supports them quite well. it's probably a good idea to only 
  # use the functions below when the
  # timezone is fixed to the same one as the server is using

  function SQL_to_unix_time($postgresTimestamp) {
    $year = substr($postgresTimestamp, 0, 4);
    $month = substr($postgresTimestamp, 5, 2);
    $day = substr($postgresTimestamp, 8, 2);
    $hour = substr($postgresTimestamp, 11, 2);
    $minute = substr($postgresTimestamp, 14, 2);
    $second = substr($postgresTimestamp, 17, 2);
    # timezone is ignored for Unix timestamps

    return mktime($hour, $minute, $second, $month, $day, $year);
  }

  function unix_time_to_SQL($timestamp) {
    return date("Y-m-d H:i:s", $timestamp);
  }

} # end class

?>













