#! /usr/bin/perl

#######################################################################
# RCS INFO: $Id: index.cgi,v 1.70 2000/10/27 04:06:45 maffew Exp $
#######################################################################

# Name: Selena Sol's Groupware Calendar
#
# Version: 4.0
#
# Last Modified: 08-14-96
#
# Copyright Info:This application was written by Selena Sol
# (selena@eff.org, http://www.extropia.com) having been inspired by
# countless other Perl authors.  Feel free to copy, cite, reference,
# sample, borrow, resell or plagiarize the contents.  However, if you
# don't mind, please let me know where it goes so that I can at least
# watch and take part in the development of the memes. Information wants
# to be free, support public domain freware.  Donations are appreciated
# and will be spent on further upgrades and other public domain scripts.
#
# Finally, PLEASE SEND WORKING URL's to selena@eff.org.  I maintain a list
# of implementations around the world.
#
#######################################################################
# Cosmetic modifications by Chuck Mayo : Last modified 2/23/97
#
#   We now have other options to control the mods:
#
#      display=list   will output the events list
#      days=n         will show n days in events list
#      display=yag    will output the year-at-a-glance view
#      display=small  will draw the thumbnail calendar
#      incr=on        will add "next" & "prev" buttons to thumbnail calendar
#
#######################################################################
#
# Further modified by Cameron Shorter : camerons@cascade.taz.net.au
# starting October 1998.
# History of modifications stored under CVS.  Contact Cameron for details,
# or see http://www.active.org.au/about/ for our version of the source.
#
#######################################################################

# check for debug mode, it's on if there's a file called "debug" in the
# same folder as we are

$debug = (-e "./debug");

#######################################################################
#                       Require Libraries.                            #
#######################################################################

# Now require the necessary files with the subroutine at the end of this
# script marked by "sub CgiRequire".  We use this subroutine so that if
# there is a problem with the require, we will get a meaningful error
# message. 

# ($lib is the location of the Library directory where these files
# are to be stored.  Set $lib = "." if you do not have a Library
# directory.  This variable must be set in this file AS WELL AS in
# calendar.setup!!!)

  $lib = "./Library";

  &CgiRequire("$lib/cgi-lib.pl", "$lib/cgi-lib.sol",
           "$lib/auth-lib.pl", "$lib/date.pl", "$lib/mail-lib.pl");

  # these are CPAN modules - see http://www.cpan.org
  use Time::DaysInMonth;
  
#######################################################################
#                        Gather Form Data.                            #
#######################################################################

# Now use cgi-lib.pl to parse the incomming form data.  We'll pass
# cgi-lib.pl (*form_data) so that our variable will come out as
# $form_data{'key'} instead of $in{'$key'}.  I like to use form_data
# because it is easier for me to remember what the variable is.
# In the end, we will be able to refernce all of the incoming form data as
# $form_data{'variablename'}
  
  &ReadParse(*form_data);

  # processed_data will have fields filled in for the values that are left
  # blank
  %processed_data = %form_data;


#######################################################################
#                       Print http Header.                            #
#######################################################################

# First tell Perl to bypass the buffer.  Then, print out the HTTP
# header. We'll output this quickly so that we
# will be able to do some of our debugging from the web and so that in
# the case of a bogged down server, we won't get timed-out. 

  $! = 1;
  SWITCH: {
    $_ = $processed_data{'display'};

    # Returns a plain text web page
    /headlines/ && do {
      print "Content-type: text/plain\n\n";
      last SWITCH;
    };

    # This won't be called from the web so won't need a content header
    /mail_text/ && do {
      last SWITCH;
    };

    # The rest of the displays are standard html
    print "Content-type: text/html\n\n";
  }

#######################################################################
#             Determine Which Calendar Database to Use.               #
#######################################################################

# Now we will need to determine which calendar databse to use.  If the
# admin has set up more than one calendar, each calendar database will be
# in a subdirectory.  In order to reference these separate databases, the
# link to this script must have added ?calendar=Somesubdirectory at the end
# of the URL.  If we are asking for the main calendar, this variable will
# not be equal to anything.

  if ($form_data{'calendar'} == "") {
    $processed_data{'calendar'} = "./";
  }

# assume today's day, month, year if not specified

  @today = localtime(time);

  if ($form_data{'day'} == "") {
    $processed_data{'day'} = $today[3];
  }
  if ($form_data{'month'} == "") {
    $processed_data{'month'} = $today[4] + 1;
  }
  if ($form_data{'year'} == "") {
    $processed_data{'year'} = $today[5] + 1900;
  }


#######################################################################
#                            Define Variables                         #
#######################################################################

# Now we will define all of our variables by using the define file that
# you should have customized for your own site.

  &CgiRequire("../local/calendar/calendar.setup");

  @timestrings = %TIME;

# MOD: CM
#
# most of this stuff belongs in sub print_month i reckon 
# need to be alittle careful, 'cos tiny bits of it are used
# elesewhere, e.g. $current_month_name [maffew]
#
# We'll need to know the month and year of the next and previous months
# for our "prev" and "next" buttons, as well as our thumbnail calendars.
# Initialize  the variables we'll use for the 
# prev and next month's year

     $next_months_year = $processed_data{'year'};
     if ($processed_data{'month'} == 12) {
       $next_months_year++;
      }
     $last_months_year = $processed_data{'year'};
     if ($processed_data{'month'} == 1) {
       $last_months_year--;
      }

     @mymonth = &make_month_array(
       &jday(
         $processed_data{'month'},
         $processed_data{'day'},
         $processed_data{'year'}));

     $current_month_name = &monthname($processed_data{'month'});

# set $last_month to the number of the current month - 1 
# set $next_month to the number of the current month + 1

     $last_month = ($processed_data{'month'} - 2) % 12 + 1;
     $next_month = $processed_data{'month'} % 12 + 1;
     $last_month_name = &monthname($last_month);
     $next_month_name = &monthname($next_month);


     # Here's some workarounds to catch cases where the display variable
     # is not set
     
     # variables ending in .x cover cases where an image is used
     # instead of a gray browser button

  if ($processed_data{'display'} eq "")
  {
    if ($form_data{'addevent.x'} ne "") {
      $processed_data{'display'} = "Add Event";
    } elsif ($form_data{'editevent.x'} ne "") {
      $processed_data{'display'} = "Edit Event";
    } elsif ($form_data{'viewmonth.x'} ne "") {
      $processed_data{'display'} = "View Month";
    } elsif ($form_data{'day'} ne "") {
      $processed_data{'display'} = "list";
    } else {
      $processed_data{'display'} = "View Month";
    }
  }
      
  SWITCH: {
    $_ = $processed_data{'display'};

    # The main month view
    (
      /View Month/ ||
      /Return to the Calendar/ ||
      /Change M\/Y/
    ) && do {
      &header ("$current_month_name $processed_data{'year'}");
      &print_a_month;
      &footer;
      last SWITCH;
    };
    # Print a list of 7 days or so
    /list/ && do {
      $short_date = substr($current_month_name, 0, 3) . " ";
      $short_date = $short_date . $processed_data{'day'} . ", ";
      $short_date = $short_date . $processed_data{'year'};
      if ($form_data{'days'} > 1) {
        &header ("Events - beginning $short_date");
      } else {
        &header ("Events - $short_date");
      }
      &events_list($form_data{'days'});
      &footer;
      last SWITCH;
    };
    /headlines/ && do {
      &headlines;
      last SWITCH;
    };
    /mail_text/ && do {
      &mail_text;
      last SWITCH;
    };
    # Print a front page with some events
    /front/ && do {
      &header ("");
      &front_page;
      &footer;
      last SWITCH;
    };
     # Zoom in to show full details on one event
    /zoom/ && do {
      &header ("Full event details");
      $rave_page = &event_zoom($form_data{'event'});
      print qq!
        $rave_page
        <p>
        <CENTER>
        <INPUT TYPE = "hidden" NAME = "day" VALUE = "$processed_data{'day'}">
        <INPUT TYPE = "hidden" NAME = "month" VALUE = "$processed_data{'month'}">
        <INPUT TYPE = "hidden" NAME = "year" VALUE =
	"$processed_data{'year'}">
	!;
      
      if ($button_images eq "yes") {
	print qq!
	<INPUT TYPE = "image" NAME = "addevent" ALT="add event"
	  src="../local/images/add-event.gif" $add_event_size border=0>
	<INPUT TYPE = "image" NAME = "editevent" ALT="edit event"
	  src="../local/images/edit-event.gif" $edit_event_size border=0>
	<INPUT TYPE = "image" NAME = "viewmonth" ALT="view month"
	  src="../local/images/view-month.gif" $view_month_size border=0>
	!;
      } else {
	print qq!
          <INPUT TYPE = "submit" NAME = "display" VALUE = "Add Event">
          <INPUT TYPE = "submit" NAME = "display" VALUE = "Edit Event">
          <INPUT TYPE = "submit" NAME = "display" VALUE = "View Month">
          </CENTER>
	!;
      }
      &footer;
      last SWITCH;
    };
    # Year at a glance
    /yag/ && do {
      &header ("Year at a Glance");
      &yag;
      &footer;
      last SWITCH;
    };
    # Small thumbnail calendar
    /small/ && do {
      &header ("Small");
      &smcal($processed_data{'month'}, $processed_data{'year'});
      &footer;
      last SWITCH;
    };

    #######################################################################
    #                       Basic User Authentication                     #
    #######################################################################
    # Remaining display options require the user to log onto the system and
    # hence have a session id defined.  If the user hasnt logged on then
    # present them with a logon form.

    # Now let's check to see if the client is a user who is authorized to use
    # this script.  We will use the web of routines in the library
    # file session-lib.pl to do the following:
    #
    # 1. Ask the user to submit a userid and password.
    # 2. Check that userid/password pair against the information in
    #    $user_file.
    # 3. If the information is invalid, dissallow enterence and provide a
    #    routine for the user to apply for an account.
    # 4. If the information was valid, send back to this script a "session
    #    file id" corresponding to a session file which will have been created
    #    by session-lib.pl and which will contain the users personal
    #    information.  This script will then pass along the session id as a
    #    hidden variable throughout in order to make sure that the user is
    #    valid.

    # We'll pass the subroutine GetSessionInfo which is contained in
    # auth-lib.pl three parameters, the $session_file value (which will be
    # nothing if one has not been set yet), the name of this script (so it can
    # provide links back) and the associative array of form data we got from
    # cgi-lib.pl.

    ($processed_data{'session_file'}, $session_username, $session_group, 
      $session_first_name, $session_last_name, $session_email) = 
      &GetSessionInfo($processed_data{'session_file'}, $this_script_url, 
      *form_data);

    # Refresh $_ for the remainder of the switch statement.
    $_ = $processed_data{'display'};
    /Add Event/ && do {
      &header ("Add an Event");
      &add_item_form;
      &footer;
      last SWITCH;
    };

    /Add This Event/ && do {
      &add_item;
      last SWITCH;
    };

    /Edit Event/ && do {
      &select_event_form;
      last SWITCH;
    };

    /Modify Selected Event/ && do {
      &modify_event_form;
      last SWITCH;
    };

    /Delete Selected Event/ && do {
      &delete_item;
      last SWITCH;
    };

    /Apply These Changes/ && do {
      &modify_event;
      last SWITCH;
    };

    # If the display wasnt defined above, catch the error here.
    &header("Wooopsy");
    print qq!
    <BLOCKQUOTE>
    Sorry, you are not allowed to type return when
    typing in your subject.  Please hit the back button and try
    again.
    </BLOCKQUOTE>
    <CENTER>
    <INPUT TYPE = "submit" NAME = "display"
           VALUE = "Return to the Calendar">
    </CENTER>!;
    &footer;
    last SWITCH;
  }
  exit;

#######################################################################
#                 End of main program                                 #
#######################################################################


#######################################################################
#                      Create Add Item Form                           #
#######################################################################
sub add_item_form
{

# We'll use the subroutine submission_form at the end of this script to
# generate a form with input fields for every item in the database which
# can be manipulated by the client.

  &submission_form("new");

# Print out a standard footer and quit.

  print qq!
  <CENTER><P>
  <INPUT TYPE = "submit" NAME = "display" VALUE = "Add This Event">
  <INPUT TYPE = "reset" VALUE = "Clear This Form">
  <INPUT TYPE = "submit" NAME = "display" VALUE = "View Month">
  </CENTER>!;
}

#######################################################################
#                 Verify event form                                   #
#######################################################################

# verify all the entered data on a new or edit event form

sub verify_event_form
{

# For every compulsory element in our @form_data array, check to see if the
# associated value in %form_data has content.  

  foreach $variable_name (@form_data)
    {
    if ($form_data{$variable_name} eq "" && $variable_name
      ne "calendar" && (!grep(/^$variable_name$/, @optional_fields)))
      {
        # kludge to workaroung my laziness in changing subject to event_name
        # everywhere else - maffew
        if ($variable_name eq "subject") {
          $variable_name = "event name";
        }
        $whybounce .= qq!<li>I'm afraid you need to enter something in the 
        <B>$variable_name</B> input box.  There's certain info
        an events list can't do without.<p>!;
      }
    }

# check for valid inputs: date and time

  if (($form_data{'hour'} < 1) || ($form_data{'hour'} > 12) 
    || ($form_data{'minute'} < 0) || ($form_data{'minute'} > 59)) {
      $whybounce .= qq!<li>Check the <b>time</b> you wrote. I can't make sense
      of
        it.<p>\n!;
  }

  # days_in will return undef if the month <1 or >12, which will
  # conveniently trigger a bounce on this test - maffew
  
  if (($form_data{'day'} < 1) 
    || ($form_data{'day'} > days_in($form_data{'year'}, $form_data{'month'}))) {
      $whybounce .= "<li>You chose a <b>date</b> that doesn't seem to
      exist.<p>\n";
  } 

  # TBD add a check that the date is in the future - [maffew]

# and no gasbagging

  foreach $variable_name (keys %LENGTH_LIMITS) {
    if (length($form_data{$variable_name}) > $LENGTH_LIMITS{$variable_name}) {
      $lines = int($LENGTH_LIMITS{$variable_name}/60);
      $whybounce .= "<li>We'd like you to be a little more concise in\n";
      $whybounce .= "the <b>$variable_name</b> box - less than $lines lines\n";
      $whybounce .= "please.<p>\n";
    }
  }

# Might also want to check for valid looking email and web addresses

}

#######################################################################
#                 Make new row                                        #
#######################################################################

# Massage newly entered event data so it can go in the database

sub make_new_row
{
# Now let's format the incoming form data so that it will all stay on one
# line.  We'll substitute (=~ s/) all occurances (/g) of newlines (\n) for
# <BR> and all occurances of two hard returns (\r\r) for <P>'s.  

# may want to strip certain potentially dangerous HTML that event adders may try
# <a href> is cool, so is <b> <i> etc, but table commands and other things
# are not so nice [maffew]

    foreach $value (@field_values)
      {
      $form_data{$value} =~ s/&/&amp;/g;
      $form_data{$value} =~ s/</&lt;/g;
      $form_data{$value} =~ s/>/&gt;/g;
      $form_data{$value} =~ s/\r\n/<BR>/g;
      $form_data{$value} =~ s/\n/<BR>/g;
      $form_data{$value} =~ s/\r\r/<P>/g;
      $form_data{$value} =~ s/\|/:/g;
      # why are we morphing hyphens into colons? 
      # is this a relic from type in time fields? [maffew]
      # $form_data{$value} =~ s/\-/:/g;
      }

# Now let's simplify some of the variables and generate the new database
# row. (.= means that you should append the new value to the end of the
# existing value for the variable.)

# this little number copies the variables out of the array into
# stand alone variables with the same names as the array lookup key
# maffew

    foreach $value (keys %form_data) {
      $$value = $form_data{$value};
    }

  if ($session_first_name eq "")
    {
    $session_first_name =  "$form_data{'first_name'}";
    $session_last_name =  "$form_data{'last_name'}";
    $session_email = "$form_data{'email'}";
    }

    # if they didn't type in a web address then wipe it

    if ($web eq "http://") {
      $web = "";    
    }

    # Convert hour / minute / ampm to time
    # we take 12am as midnight
    if ($hour == "12") {
      $hour = 0;
    }
    if ($ampm eq "PM") {
      $hour += 12;
    }
    $event_time = sprintf("%0.2d:%0.2d", $hour, $minute);

    $new_row = "";
    $new_row .= "$day\|$month\|$year\|$session_username\|";
    $new_row .= "$session_first_name\|$session_last_name\|$session_email\|";
    $new_row .= "$subject\|$event_time\|$summary\|$item_number|";
    $new_row .= "$location\|$transport\|$contact\|$contact_email|";
    $new_row .= "$web\|$rave";

}

#######################################################################
#                     Add an Item to the Database                     #
#######################################################################

sub add_item
{

    &header ("Adding an Event...");

# Make sure that the client has filled out all the necessary fields in the
# submission form.  First we'll get a list of the variable names (keys)
# associated with the associative array %form_data given to us by
# cgi-lib.pl.  Thus, we will have a list of every field, empty or not,
# submitted by our form.

    @form_data = keys (%form_data);

  &verify_event_form;

  if ($whybounce) {
    #dumpem
    print qq!
    <BLOCKQUOTE>
    <FONT SIZE = "+1">
    Sorry about this, but there seems to be a problem with your
    contribution:<p>
    <ul>
    $whybounce
    </ul>
    I have not added your new event. Please press the <b>back</b>
    button, fix it up and try again.
    </FONT>
    </BLOCKQUOTE>!;
    &footer;
    exit;
  }

# If they have entered valid data, we can go ahead and
# add their new entry.  

# Now create a lockfile while we edit our database file.  The reason that
# we do this is so that if two people are trying to edit the datafile at
# one time, one person will not destroy the modifications made by the
# other person.  We'll create the lock file using the subroutine
# GetFileLoc in cgi-lib.sol, passing it one parameter, the location of
# the lock file used by this program.  You should definitely not create
# the lock file yourself...

  &GetFileLock ("$lock_file");

# First get a unique number from the counter file by
# using the subroutine counter in cgi-lib.sol.  We'll pass the routine one
# parameter which will be the location of the counter file used by this
# program.  The unique counter number is essential because every row must
# be uniquely identifiable for modificaiton and deletions.  The numbers
# don't need to be in any order, and there can be gaping holes between
# numbers (as when items are deleted) but they must be unique.

    $item_number = &counter($counter_file);

#######################################################################
#                        Make The Addition                            #
#######################################################################

# If we got past the lockfile routine it means that we are now the sole
# owner of the database file and can safely make changes.  So let's write
# the contents of the new entry to the database file (appending (>>) the
# new data to the end of the esiting list of items...

    open (DATABASE, ">>$database_file") || &CgiDie ("I am sorry, but I was
  unable to open the calendar data file in the  Make The Addition
  routine. The value I have is $database_file.  Would you please
  check the path and permissions.");

  &make_new_row;

# Add the new database row to the database file and delete the lock file
# so that someone else may modify the database file.  Don't forget the new
# line at the end of the database row so that the next item entered will
# have its own line.
 
    print DATABASE "$new_row\n";
    close (DATABASE);
    &ReleaseFileLock ("$lock_file");

# Now it is time to sort the entries in the database file so that we can
# make sure that when people choose day views, their entries come out
# ordered by time.  
    &sort_events;

# If they asked for it, email it out aswell
    if ($form_data{'announce'} eq "web_email") {
      &get_selected_event($item_number);
      # so this returned @selected_event already split
      &massage_event($selected_event, "text");

      $event_text = "$subject\n";
      $event_text .= "$fulldate\n\n$summary\n\n";
      $event_text .= "[where] $location\n";

      $event_text .= "[transport] $transport\n" unless ($transport eq "");
      $event_text .= "\n[contact] $contact\n";
      $event_text .= "[email] $contact_email\n" unless ($contact_email eq "");
      $event_text .= "[web address] $web\n" unless ($web eq "");
      $event_text .= "\n----\\\\ [the full rave] //----\n\n$rave\n" 
        unless ($rave eq "");

      # remove any remaining html
      $event_text =~ s/<.*?>//g;
      $event_text =~ s/&amp;/&/g;
      $event_text =~ s/&quot;/"/g;
      $event_text =~ s/&lt;/</g;
      $event_text =~ s/&gt;/>/g;

      # need to clean up $subject seperately 'cos we'll use it
      # as the email message subject line
      $subject =~ s/&amp;/&/g;
      $subject =~ s/&quot;/"/g;
      $subject =~ s/&lt;/</g;
      $subject =~ s/&gt;/>/g;

      if ($debug) {
        $actual_email = $debug_announce_email;
        $subject ="test - $subject";
      } else {
        $actual_email = $announce_email;
      }
   
      if ($robot_email && $actual_email)
      {
        &send_mail($robot_email, $actual_email, $subject, $event_text);
        $where_it_went = "It has also been emailed to $actual_email.<p>";
      }
    }
    
    # Print out the standard page footer.
    print qq*
    <H3><CENTER>Your event has been added to the web site, thanks.</H3>
    $where_it_went
    Thanks for contributing!<p>
    <INPUT TYPE = "hidden" NAME = "day" VALUE = "$form_data{'day'}">
    <INPUT TYPE = "hidden" NAME = "month" VALUE = "$form_data{'month'}">
    <INPUT TYPE = "hidden" NAME = "year" VALUE = "$processed_data{'year'}">
    <INPUT TYPE = "submit" NAME = "display" 
           VALUE = "Return to the Calendar">*;
    &footer;

  }

#######################################################################
#                   Sort the events database                          #
#######################################################################
  sub sort_events
  {
    # Now it is time to sort the entries in the database file so that we can
    # make sure that when people choose lists, their entries come out
    # ordered by time and date.  We'll create the lock file so that no one
    # else can modify the database file while we are modifying it.

    &GetFileLock ("$lock_file");
    open (DATABASE, "$database_file") ||  &CgiDie ("I am sorry, but I was
      unable to open the calendar data file in the  Make The Addition
      routine. The value I have is $database_file.  Would you please
      check the path and permissions.");

    # First, add every row in our database file to an array called
    # @database_fields

    while (<DATABASE>) {
      @database_fields = split (/\|/, $_);

      # Now, create a variable called $comment_row which will be used, for now
      # to hold COMMENT lines in the database file since we don not want them
      # sorted along with the rest of the items.

      # are we ever creating comments? maybe this code can be culled [maffew]

      if ($_ =~ /^COMMENT:/) {
        $comment_row .= $_;
      }

      # If the database row is not a COMMENT row, we are going to find the
      # field which has the time and date of the event and append it to the
      # front of the database row (so it occurs twice...once at the beginning
      # of the line and once in the middle somewhere) and add (push) the
      # whole string ($sortable_row) into a growing array called
      # @database_rows.  We'll explain the reason for this in the next
      # comment paragraph.

      else {
        ($hour,$min) = split(":", $database_fields[$index_of_time]);

        # Create a time-date key for sorting and add to begining of event
        # string
        $sortable_row = sprintf(
          "%0.2d%0.2d%0.2d%0.2d%0.2d",
          $database_fields[$index_of_year],
          $database_fields[$index_of_month],
          $database_fields[$index_of_day],
          $hour,$min);
        $sortable_row .= "~~";
        $sortable_row .= $_;
        push (@database_rows, $sortable_row); 
      }
    }

    # When we have added all of the "modified" rows to the array
    # @database_rows we'll sort that array.  This is why we wanted to append
    # the time to the beginning of each of the rows...the sort routine will
    # now sort all of the database items by event time and date.

    # Adding <=> below means that we are sorting
    # numerically, oldest first.

    @sorted_temp_database = sort {$a <=> $b} @database_rows;

  # debug ... [maffew]
  #open (TEMPFILE, ">./Databases/debug-sort") || &CgiDie ("I am sorry, but I was
  #unable to open the debug file in the Make The Addition
  #routine. The value I have is ./Databases/debug-sort.  Would you please
  #check the path and permissions.");
  
   # foreach $database_row (@sorted_temp_database) {
   #   print TEMPFILE "$database_row\n";
   # }
   # close (TEMPFILE);
  

    # Now go through @sorted_temp_database and take out the extra event_time
    # string at the beginning of each database row.  We do this by splitting
    # the string at - and then "pushing" the part of the string which
    # corresponds to the original database row back into the array
    # @final_sorted_database.

    foreach $database_row (@sorted_temp_database) {
      ($extra_event_time, $true_database_row) = split (/~~/, $database_row);    
      push (@final_sorted_database, $true_database_row);
    }
    close (DATABASE);

    # Now we are going to need to change the original database file so that it
    # represents our sorted order.  To do this, we will first create a
    # temporary file to which we will first reprint all of the comment rows
    # stored in the variable $comment_row.

    open (TEMPFILE, ">$temp_file") || &CgiDie ("I am sorry, but I was
      unable to open the temp file in the Make The Addition
      routine. The value I have is $temp_file.  Would you please
      check the path and permissions.");

    print TEMPFILE "$comment_row";

    # Then for each of the database rows stored in @final_sorted_database,
    # we'll print to the temp file.

    foreach $row (@final_sorted_database) {
      print TEMPFILE "$row";
    }

    close (TEMPFILE);

    # Then we will copy our temp file over the original database file so that
    # the resulting file will represent the sort.  Then of course, delete the
    # lock file so others can manipulate the database.

    rename ($temp_file, $database_file);
    chmod (0777, $database_file);
    &ReleaseFileLock ("$lock_file");
  }

#######################################################################
#                   Print out Edit Event Form.                        #
#######################################################################

sub select_event_form
    {

    &header ("Select an Event to Edit");

# Print out the basic header including the hidden fields which we want
# transferred to the modification routines which must have all the user
# information if they are to redcreate database rows.  Since the
# modification routines are going to compare incoming form data to
# database row information, we will want this information to come in with
# the rest of the form data.

    print qq!
    <INPUT TYPE = "hidden" NAME = "username" VALUE = "$session_username">
    <INPUT TYPE = "hidden" NAME = "first_name" VALUE = "$session_first_name">
    <INPUT TYPE = "hidden" NAME = "last_name" VALUE = "$session_last_name">
    <INPUT TYPE = "hidden" NAME = "email" VALUE = "$session_email">
    <CENTER>
    <H3>Your events during $current_month_name $processed_data{'year'}</H3>
    </CENTER>!;

# Begin a table which we will use to display all of the items posted by
# the client on the day they are interested in.  But, for the time being,
# let's not print out the table, but build it in a variable called $table

    $table .= "<TABLE BORDER = \"1\" CELLSPACING = \"2\" 
      CELLPADDING = \"2\">\n";
    $table .= "<TR>\n";
    $table .= "<TH>Select an event</TH>\n";

# Create the header row

    $table .= "<TH>Title</TH>\n";
    $table .= "<TH>Time</TH>\n";
    $table .= "<TH>Day</TH>\n";
    $table .= "<TH>Month</TH>\n";
    $table .= "<TH>Year</TH>\n";
    $table .= "</TR>\n";

# Now open the database and check for items which correspond to the user
# as well as the day, month and year they have requested to look at or
# modify.

    open (DAYFILE, "$database_file") || &CgiDie ("I am sorry, but I was
        unable to open the calendar data file in the Select an Event to Edit 
        Form routine. The value I have is $database_file.  Would you please
        check the path and permissions.");

    while (<DAYFILE>)
      {
      # Make sure to take out the newline.
      chop $_;

# Split out the database row as usual, but this time also use them to make
# an array called @database_values which we'll use in just a bit.

      ($day, $month, $year, $username, $first_name, $last_name, $email,
           $subject, $time, $body, $database_id_number) = split (/\|/,$_);

# Pay attention only to items specific to user, month and year

      if ($month eq "$form_data{'month'}" && $year eq "$processed_data{'year'}" 
        && $session_username eq "$username")
        {

# Flag the fact that we did indeed find an item

        $item_found = "yes"; 

# Continue adding to out $table variable by adding the table row
# corresponding to the database row which matched.  Also, offer them a
# radio button so that they can select which table row to modify.

        $fullmonthname = substr(&monthname($month),0,3);

        $table .= "<TR>\n";
        $table .= "<TD ALIGN = \"center\">";
        $table .= "<INPUT TYPE = \"radio\" NAME =\"item_to_modify\"";
        $table .= "VALUE=\"$database_id_number\"></TD>\n";

        $table .= "<TD>$subject</TD>\n";
        $table .= "<TD>$time</TD>\n";
        $table .= "<TD>$day</TD>\n";
        $table .= "<TD>$fullmonthname</TD>\n";
        $table .= "<TD>$year</TD>\n";

          $table .= "</TR>\n";
        }
      }

    $table .= "</TR></TABLE><P><CENTER>\n";

# If $item_found is still not equal to yes, it means that we did not match
# any items so we should send the client back a little note.

    if ($item_found ne "yes")
      {
      print qq!
      <BLOCKQUOTE>
      I'm sorry, you have not posted any items for this day, so
      there is nothing for me to modify.
      </BLOCKQUOTE>
      <CENTER>    
      <INPUT TYPE = "submit" NAME = "display"
         VALUE = "View Month">!;
      &footer;
      exit;
      }

# If however, it did equal yes, we can go ahead and print out out table.

    print qq!
    <CENTER>
    <P>
    
    <INPUT TYPE = "submit" NAME = "display" 
     VALUE = "Modify Selected Event">
    <INPUT TYPE = "submit" NAME = "display" 
           VALUE = "Delete Selected Event">
    <INPUT TYPE = "reset" VALUE = "Clear This Form">

    <BLOCKQUOTE>Please select one event below using
    the buttons down the left hand side. The choose whether you want to
    edit or delete that event using the buttons above.</BLOCKQUOTE>
    
    $table

    </CENTER>!;
    &footer;
  }

#######################################################################
#                     Delete an Item.                                 #
#######################################################################

sub delete_item
{

# However, we need to make sure that the client actually chose an item to
# delete with the radio buttons.

    if ($form_data{'item_to_modify'} eq "")
      {
      &header ("Whoopsy");
      print qq!
      <CENTER><H3>There was a problem deleting your event...</H3></CENTER>
      <BLOCKQUOTE>
      I'm sorry, I was not able to modify the database because
      none of the buttons on the table were selected so I was
      not sure which item to delete.  Would you please make sure
      that you select an event.
      Just hit your <b>back</b> button and try again.  Thanks.
      </BLOCKQUOTE>!;
      &footer;
      exit;
      }

# Lock the database file as we did for the add item routines.

    &GetFileLock ("$lock_file");

# Create a temporary file as we did for the add routines.

    open (TEMP, ">$temp_file") || &CgiDie ("I am sorry, but I was unable
  to open the temp file in the Delete an Item routine.  The value I
  have is $temp_file.  Would you check the path and permissions.");

    close (TEMP);

# While there is data in the database file check to see which item matches
# the  deletion

    open (DATA, "$database_file") || &CgiDie ("I am sorry, but I was unable
        to open the data file in the Delete an Item routine.  The value I
        have is $database_file.  Would you check the path and
        permissions.");

    while (<DATA>)
      {
      chop $_;
      @grepfields=split(/\|/,$_);

# Get the unique database id for the database row

      $database_id = $grepfields[$index_of_db_id];

# If the unique database id of the row is not equal to the database id
# number submitted by the client then we do not want to delete it so we'll
# print it to the temp file.

      if ($database_id ne "$form_data{'item_to_modify'}")
        {
        # weird - why open and close the TEMP file for each row? - [maffew]
        open (TEMP, ">>$temp_file") || &CgiDie ("I am sorry, but I was unable
        to open the temp file in the Delete an Item routine.  The value I
        have is $temp_file.  Would you check the path and permissions.");

        print TEMP "$_\n";
        close (TEMP);
        }
      } # End of while (<DATA>)

# Once we have gone through all of the items in the database, we can copy
# the temp file over the database file and the deletion will have been
# made since the row which matched the database id number will not have
# been printed to the temp file.  Close the database file and delete the
# lock file so others can modify the database file.

    close (DATA);
    rename ($temp_file, $database_file);
    &ReleaseFileLock ("$lock_file");
    chmod (0777, $database_file); # MOD: make the file editable from the
                                  # shell - may not be necessary for all
                                  # systems - CM

# Print up a standard footer

    &header ("Deleting an Event...");
    print qq!
    <CENTER>
    <FONT SIZE = "+3">Your item has been deleted
    </FONT>
    <P>
    <INPUT TYPE = "hidden" NAME = "day" VALUE = "$form_data{'day'}">
    <INPUT TYPE = "hidden" NAME = "month" VALUE = "$form_data{'month'}">
    <INPUT TYPE = "hidden" NAME = "year" VALUE = "$processed_data{'year'}">
    <INPUT TYPE = "submit" NAME = "display"
           VALUE = "Return to the Calendar">
    </CENTER>!;
    &footer;
    exit;
    }

#######################################################################
#                             Get Selected Event                      #
#######################################################################

# picks the event with the matching id out of the database
# returns it in @selected_event

sub get_selected_event
{
    local ($id) = @_;

    open (DATA, "$database_file") || &CgiDie ("I am sorry, but I was
    unable to open the data file in the Modify Event routine.  The
    value I have is $database_file.  Would you check the path and
    permissions.");

    undef($selected_event);
    while (($row = <DATA>) && !$selected_event)
    {
      chop $row;
      @grepfields=split(/\|/,$row);

      $database_id = $grepfields[$index_of_db_id];

      if ($database_id eq "$id")
      {
        #we found it
        $selected_event = $row;   
      }
    }
    close(DATA);
}

#######################################################################
#                             Modify Event Form                       #
#######################################################################

# present a form for the user to edit a selected event

sub modify_event_form
{
      &header("edit selected event");
    
# However, we need to make sure that the client actually chose an item to
# modify with the radio buttons.

      if ($form_data{'item_to_modify'} eq "")
      {
        print qq!
        <CENTER><H3>There was a problem finding your event</H3></CENTER>
        <BLOCKQUOTE>
        I'm sorry, I couldn't find an event to edit as
        none of the radio buttons on the table was selected so I was
        not sure which one you want.  Would you please make sure
        that you select an event.
        Just hit your <b>back</b> button.  Thanks.
        </BLOCKQUOTE>!;
        &footer;
        exit;
      }

    &get_selected_event($form_data{'item_to_modify'});

    @event_split=split(/\|/,$selected_event);

    # load up up $form_* variables with stuff to go in the form

    $i = 0;
    foreach $value (@field_values) {
      $form_var = "form_" . $value;
      $$form_var = $event_split[$i];
      $$form_var =~ s/<BR>/\n/g;
      $$form_var =~ s/<P>/\n\n/g;
      $$form_var =~ s/"/&quot;/g;
      $i++
    }

    ($form_hour, $form_minute) = split(/:/, $form_time);
    if ($form_hour < 12) {
      $form_ampm = "AM";
    } else {
      $form_ampm = "PM";
    }
    $form_hour %= 12;
    if ($form_hour == 0) { $form_hour = 12; }

    $form_month = &monthname($form_month);

    &submission_form("modify");

    print qq!
    <CENTER>
    <INPUT TYPE = "hidden" NAME = "item_to_modify" 
      VALUE = "$form_data{'item_to_modify'}">
    <INPUT TYPE = "hidden" NAME = "item_number" 
      VALUE = "$form_data{'item_to_modify'}">
    <INPUT TYPE = "submit" NAME = "display"
           VALUE = "Apply These Changes">
    <INPUT TYPE = "submit" NAME = "display"
           VALUE = "Return to the Calendar">
    </CENTER>!;
    &footer;

}

#######################################################################
#                             Modify Event                            #
#######################################################################

sub modify_event
{
# However, we need to make sure that the client actually chose an item to
# modify with the radio buttons.

    &header("Applying your changes...");

    if ($form_data{'item_to_modify'} eq "")
      {
      print qq!
      <CENTER><H3>There was a problem modifying your 
      event in the database</H3></CENTER>
      <BLOCKQUOTE>
      Somehow I lost track of which event we were editing.
      It's probabaly beyond your control. Maybe come
      back later and try again? Sorry about that.
      </BLOCKQUOTE>!;
      &footer;
      exit;
      }

    @form_data = keys (%form_data);

    &verify_event_form;

    if ($whybounce) {
      #dumpem
      print qq!
      <BLOCKQUOTE>
      <FONT SIZE = "+1">
      Sorry about this, but there seems to be a problem with your
      contribution:<p>
      <ul>
      $whybounce
      </ul>
      I have not modified your event. Please press the <b>back</b>
      button, fix it up and try again.
      </FONT>
      </BLOCKQUOTE>!;
      &footer;
      exit;
    }

# Just as we did above, create the lock file and temp file.

    &GetFileLock ("$lock_file");

    open (TEMPFILE, ">$temp_file") || &CgiDie ("I am sorry, but I was unable
        to open the temp file in the Modify Event routine.  The value I
        have is $temp_file.  Would you check the path and permissions.");

    open (DATABASE, "$database_file") || &CgiDie ("I am sorry, but I was
  unable to open the data file in the Modify Event routine.  The
  value I have is $database_file.  Would you check the path and
  permissions.");

# As we did for deletion, get the unique database id number for each row.

    while (<DATABASE>)
      {
      chop;
      @fields = split (/\|/, $_);
      $item_id = $fields[$index_of_db_id];

# Unless the item id matches the one that the client submited, 
# we'll add the line to our growing list of database rows in $new_data

      if ($item_id ne "$form_data{'item_to_modify'}")
        {
        $new_data .= "$_\n";
        }
      } # End of  while (<DATABASE>)

# Once we get through all the items in the database, we should have found
# one that matched the modify event selected by the user and the rest
# should be stored in $new_data.  So now we'll print the rows in $new_data
# to our temp file.

    print TEMPFILE "$new_data";

    &make_new_row;
    
    print  TEMPFILE "$new_row\n";
    close (TEMPFILE);
    close (DATABASE);
    rename ($temp_file, $database_file);
    chmod (0777, $database_file); # MOD: make the file editable from the
                                  # shell - may not be necessary for all
                                  # systems - CM

    &ReleaseFileLock ("$lock_file");

# Now print up the usual footer with an option to add another item.

    print qq!
    <CENTER>
    <H3>Your event has been modified</H3>
    Thanks for contributing\!<p>
    <INPUT TYPE = "hidden" NAME = "day" VALUE = "$form_data{'day'}">
    <INPUT TYPE = "hidden" NAME = "month" VALUE = "$form_data{'month'}">
    <INPUT TYPE = "hidden" NAME = "year" VALUE = "$processed_data{'year'}">
    <INPUT TYPE = "submit" NAME = "display"
           VALUE = "Return to the Calendar">
    </CENTER>!;
    
    &footer;

# Now it is time to sort the entries in the database file so that we can
# make sure that when people choose day views, their entries come out
# ordered by time.  Once again, we'll create the lock file so that no one
# else can modify the database file while we are modifying it.
    &sort_events;
}

#########################################################################
#                           make_month_array                            #
#########################################################################

sub make_month_array
  {

# Define some variables which will be local to this subroutine

  my($juldate)  = $_[0];
  my($month,$day,$year,$weekday);
  my($tempjdate,$firstweekday,$numdays,$lastweekday);
  my(@myarray);

# The following line gets the date of the passed parameter

  ($month, $day, $year, $weekday) = &jdate($juldate);

# Make a NEW date based on the FIRST of the month instead

  $tempjdate = &jday($month, 1, $year);

# get weekday of 1st of the month

  ($month, $day, $year, $weekday) = &jdate($tempjdate);

  $firstweekday = $weekday;
  $currentyear = "$year";

  $month++;

  if ($month > 12)
    {
    $month = 1;
    $year++;
    }

  $tempjdate = &jday($month,1,$year);
  $tempjdate--;
  ($month, $day, $year, $weekday) = &jdate($tempjdate);
  $numdays = $day;
  $lastweekday = $weekday;

  for ($x = 0;$x < $firstweekday; $x++)
    {
    $myarray[$x] = " ";
    } #End of for

  for ($x = 1; $x <= $numdays; $x++ )
    {
    $myarray[$x + $firstweekday - 1] = $x;
    }

  for ($x = $lastweekday; $x < 6; $x++)
    {
    push(@myarray,"");
    }
  
  return @myarray;
  }

#########################################################################
#                               &CgiRequire                             #
#########################################################################

# This subroutine checks to see whether the file that we are trying to
# require actually exists and is readable by us.  The reason for this
# subroutine is to provide the developer with an informative error message
# when attempting to debug the scripts.

sub CgiRequire
  {

# Define $require_file as a local variable and set it equal to the
# filename we sent when we called this routine.

  local (@require_files) = @_;

# Check to see if the file exists and is readable by us.  If so, go ahead
# and require it.

  foreach $file (@require_files)
    {
    if (-e "$file" && -r "$file")
      {
      require "$file";
      }

# If not, send back an error message that will help us isolate the
# problem with the script.

    else
      {
      print "I'm sorry, I was not able to open $file.  Would you
             please check to make sure that you gave me a valid filename
             and that the permissions on $require_file are set to allow me
             access?";
      exit;
      }
    }
  }

########################################################################
# Construct a list of variables to tack on the end of a URL
########################################################################
  sub variable_list
  {
    my $variable_list;

    $variable_list = "\&day=$day_number";
    if ($processed_data{'month'} != $today[4]+1) {
      $variable_list .= "\&month=$processed_data{'month'}";
    }
    if ($processed_data{'year'} != $today[5]+1900) {
      $variable_list .= "\&year=$processed_data{'year'}";
    }
    if ($processed_data{'session_file'} != "") {
      $variable_list .= "&session_file=$processed_data{'session_file'}";
    }
    if ($processed_data{'calendar'} != "") {
      $variable_list .= "&calendar=$processed_data{'calendar'}";
    }

    # Remove the first "&" in the variable list
    $variable_list =~ s/&//;

    return $variable_list;
  }

########################################################################
#                               &print_a_month                         #
########################################################################

  sub print_a_month
  {
    # Events to be extracted from the database that are relevant for
    # this month
    my (@events);
    my $event_index = 0;

    if ($print_graphics eq "Yes")
    {
      # We're using graphics for month, year, prev & next

      # First, build a series of HTML IMG tags for the
      # digits of the current year.

      # Toss the year into an array
      @yr_digits = split("", $processed_data{'year'});

      # Initialize a variable to hold the IMG tags
      $yr_tags = "";

      # Loop through the array of year digits building the tags
      foreach $digit (@yr_digits) {
        $yr_tags .= "<IMG SRC=\"$art_dir/$digit.$art_file_type\">";
      }

      # Now print the top table row
      print qq!
        <CENTER>
        <TABLE BORDER = "2" CELLPADDING = "4" CELLSPACING = "4"> 
        <TR>
        <TD ALIGN=CENTER VALIGN=CENTER>
        <A HREF="$this_script_url?year=$last_months_year&month=$last_month&session_file=$processed_data{'session_file'}&calendar="><IMG SRC=$prev_art BORDER=0></A>
        </TD>
        <TD ALIGN=CENTER COLSPAN=5><IMG SRC="$art_dir/$current_month_name.$art_file_type"> $yr_tags</TD>
        <TD ALIGN=CENTER VALIGN=CENTER>
        <A HREF="$this_script_url?year=$next_months_year&month=$next_month&session_file=$processed_data{'session_file'}&calendar="><IMG SRC=$next_art BORDER=0></A>
        </TD>
        <TR>
        </CENTER>
        <TR>!;
    }

    else {
      # if we're not using graphics, go ahead and print the top row
      # as text
      print qq!
      <CENTER>
      <TABLE BORDER = "1" CELLPADDING = "4" CELLSPACING = "0">
      <TR>
      <TD ALIGN=CENTER VALIGN=CENTER>
      <A HREF="$this_script_url?year=$last_months_year&month=$last_month&session_file=$processed_data{'session_file'}&calendar=">$last_month_name</A>
      </TD>
      <TD ALIGN=CENTER COLSPAN=5><FONT SIZE=7><I>$current_month_name</I></FONT></TD>
      <TD ALIGN=CENTER VALIGN=CENTER>
      <A HREF="$this_script_url?year=$next_months_year&month=$next_month&session_file=$processed_data{'session_file'}&calendar=">$next_month_name</A>
      </TD>
      <TR>
      </CENTER>
      <TR>!;
    }

    # END MOD

    # Print up the table header (Weekdays).  For every day (foreach $day) in
    # our list of days (@day_names), print out the day as a table header.
    # Then plot in the table row delimiters...

    foreach $day (@day_names)
    {
      print "<TH>$day</TH>\n";
    }
    print "</TR>\n<TR>\n";

    # Create the variable $count_till_last_day which we will use to make sure
    # that we do not add on too many <TR>s.  Also clear out a new variable
    # called $weekday which we will use to keep track of the two dimensional
    # aspect of the calendar...that is, we need to break the calendar rows
    # after every seventh cell representing as week. (We'll talk more about
    # this in just a bit).

    $count_till_last_day = "0";
    $weekday = 0;

    # Extract events from the events database.
    @events = &parse_database(
      &jday($processed_data{'month'},1,$processed_data{'year'}), #first day
      &jday($next_month,1,$next_months_year) - 1                 #last day
    );

    # For every day in the mymonth array we are going to need to create a
    # cell for the calendar.  @mymonth, if you recall, is an array we got from 
    # &make_month_array

    #######################################################################
    #                   Create a Table Cell for Each Day                  #
    #######################################################################
    $event_index = 0;

    # Get next event
    $this_event = $events[$event_index++];
    ($day, $month, $year, $the_rest) = split (/\|/,$this_event);
    @this_event_columns = split (/\|/,$this_event);

    foreach $day_number (@mymonth)
    {
    # Begin incrementing our two counter variables.
    # Make sure that we add a break for every week to make the calendar 2 
    # dimensional.  Thus, when we have gone through sets of seven days in this
    # foreach loop, we will reset $weekday to zero.  Below, we'll use these
    # values to determine where we drop the </TR><TR>, making a new calendar
    # room.  When weekday is greater than 6, we'll know that we need a
    # </TR><TR> so by setting the $weekday flag to zero, we will notify the
    # script just a few lines down from here to insert the row break.

      $weekday = ($weekday + 1) % 7;

      # Print a table cell for each day.  However, since we want to make each
      # of the numbers in each of the cells clickable so that someone can click
      # on the number to see a day view, we are going to need to manmage alot of
      # information here.  Firstly, we will build a variable called
      # $variable_list which will be used to create a long URL appendix which
      # will be used to transfer indformation using URL encoding.  As we will
      # learn more specifically later, the routine which generates the day views
      # needs to have the day, year, and month values if it is to bring up a day
      # view.  It must also have the session_file value (as all the routines in
      # this script must) and the special tag view_day=on.  So we'll gather all
      # of that information and appending it to the $variable_list variable.
      # Notice, the number in each cell is made
      # clickable by using URL encoding to tag the URL with all of the variables
      # we want passed.

      print "<TD VALIGN = \"top\" WIDTH = \"150\"";

      # Highlight the background of the cell for today.
      if (
        ($day_number == $today[3]) &&
	($processed_data{'month'} == $today[4]+1) && 
	($processed_data{'year'} == $today[5]+1900)) 
      {
        print " BGCOLOR = \"$second_color\"";
      }
      print ">\n";
      print (
        "<A HREF = \"$this_script_url?",
        &variable_list,
        "\">$day_number</A>\n");

      # We are going to need to run through all of the database items and look
      # for database rows whose subject belong on the day cell we are building.
      # Thus, for every row, we must determine if the day, month, and year of
      # the item on that row equal the day, month and year of the cell we are
      # buiulding.

      while (
        $day == "$day_number" && $month == "$processed_data{'month'}" && 
        $year == "$currentyear")
      {
        # If we were able to answer true to all of those conditions, then we
        # have found a match and we should print out the subject in that cell.

        $subject = $this_event_columns[$index_of_subject];
        $crop_subject = substr($subject, 0, 20);
        if (length($subject) > 20) { $crop_subject .= "..."; }
        print qq!<BR><FONT SIZE = "1">$crop_subject</FONT>\n!;  

        # Get next event
        $this_event = $events[$event_index++];
        ($day, $month, $year, $the_rest) = split (/\|/,$this_event);
        @this_event_columns = split (/\|/,$this_event);
          
        # why do we do this twice? really stumped on this one
        # $this_event = $events[$event_index++];
        # ($day, $month, $year, $the_rest) = split (/\|/,$this_event);
        # @this_event_columns = split (/\|/,$this_event);

      } # End of if ($day eq "$day_number" && $month eq ...

      # Once we have checked all the way through the database, we should close
      # that cell and move on to the next.
      print "</TD>\n";

      # If, however, we have reached the end of a week row, we are going to need
      # to begin a new table row for the next week.  If $weekday is equal to
      # zero, then we know that it is time.  If not, continue with the row.
      # (BTW, here we use == instead of just = because if we used =, perl would
      # interpret the part inside the if () to be assigning the value of zero to
      # $weekday...which it would do...and evaluate the whole process as true.
      # That of course would undercut the whole point of counting with
      # $weekday.)
      if ($weekday == 0)
        {
        print "</TR>\n";

        # But before we just blindly print up another table row, we better be
        # sure that we haven't actually reached the end of the month...Thus, if
        # $count_till_last_day equals @mymonth we know that there are no more
        # days left and we should not begin a new row.  (Notice that when we
        # refernce @mymonth without quotes we receive the numerical value of
        # the number of # elements in the array).

        unless ($count_till_last_day == @mymonth)
          {
          print "<TR>";
          } # End of unless ($count_till_last_day == @mymonth)

        } # End of if ($weekday == 0)
      } # End of foreach $day_number (@mymonth)

    # Finally, once we are done making all of the cells for the calendar, 
    # print up the HTML footer
    print "<TR>\n";

    # MOD: camerons
    # Include previous and next thumbnail calendars only if fancy is selected
    if ($form_data{'fancy'} ne "")
    {
      # MOD: CM
      #
      # Add another table row containing thumbnails of the previous and next
      # month's calendars, with the action buttons in the center cell. We'll
      # call the &smcal routine which inserts the small calendars into the 
      # first and last table cells.

      # first table row

      print "<TR><TD WIDTH=15% VALIGN=TOP COLSPAN=2>\n";

      # call smcal to print thumbnail calendar in first cell
      # of first row

      &smcal($last_month, $last_months_year);

      print "</TD>\n"
    }

    # print action buttons & banner in center cell

    print qq!
    <TD ALIGN=CENTER VALIGN=TOP COLSPAN=7>
    <CENTER>
    For day-at-a-glance, click any day number.
    <BR>
    Or, see another month:<BR> !;

    # do the buttons & banner...

    &select_a_month;
    &select_a_year;

    print qq!
      <INPUT TYPE = "submit" NAME = "display"
          VALUE = "Change M/Y">
      <INPUT TYPE = "submit" NAME = "display"
           VALUE = "Add Event">
      <INPUT TYPE = "submit" NAME = "display" VALUE = "Edit Event">
    !;
    print "\n";
    print "</CENTER></TD>";

    # MOD: camerons
    if ($form_data{'fancy'} ne "")
    {
      # call smcal again for thumbnail in last cell

      print "<TD WIDTH=15% VALIGN=TOP COLSPAN=2>\n";
      &smcal($next_month, $next_months_year);
      print "</TD>\n";
    }
    print "</TR>\n";
    print "</TABLE>\n";

    #  here's where the HTML is finished for the calendar. 

    print "</CENTER>";

    # END MOD
  }

########################################################################
#             Parse the calendar database                              #
########################################################################

# Parse the calendar database and return a list of entries between the
# start and finish days supplied.
# This procedure assumes the database has been sorted in time order, as
# it exits after it has found the last date.
#
# Usage: parse_database($first_julian_day, $last_julian_day)
#

sub parse_database
{
  my ($first_day) = $_[0];
  my ($last_day)  = $_[1];
  my (@return_list);

  open (DATABASE, "$database_file") || &CgiDie ("I am sorry, but I
    was unable to open the calendar data file in the parse_database
    routine.  The value I have is $database_file.
    Would you please check the path and the permissions.");

  while (<DATABASE>) {
    ($day, $month, $year, $the_rest) = split (/\|/,$_);

    if (&jday($month,$day,$year) > $last_day) {
      last; # we have finished extracting all required records, so exit loop
    }
    if (jday($month,$day,$year) >= $first_day) {
      push(@return_list, ($_));
    }
  }
  close (DATABASE);  
  return @return_list;
}
      

########################################################################
#                               &select_a_month                        #
########################################################################

  sub select_a_month
    {

    print "<SELECT NAME=\"month\">\n";
    foreach $month (@month_names)
      {
      if ($month ne "$form_month")
        {
        print "<OPTION VALUE = \"$MONTH_ARRAY{$month}\">$month\n";
        }
      else
        {
        print "<OPTION SELECTED VALUE = \"$MONTH_ARRAY{$month}\">$month\n";
        }
      }
    print "</SELECT>\n";
    }

######################################################################
#                               &select_a_year                       #
######################################################################

  sub select_a_year
    {
    print "<SELECT NAME = \"year\">\n";

    @today = localtime(time);

    $the_current_year = $today[5] + 1900;
    $greatest_year = $the_current_year + $years_ahead;

    for ($i = $the_current_year; $i <= $greatest_year; $i++)
      {
      if ($i eq "$form_year")
        {
        print "<OPTION SELECTED VALUE = \"$i\">$i\n";
        }
      else
        {
        print "<OPTION VALUE = \"$i\">$i\n";
        }
      }
    print "</SELECT>\n";
    }

######################################################################
#                              &submission_form                      #
######################################################################
 
  sub submission_form
    {
    local ($type_of_form) = @_;

    # since this form might be used for brand new events
    # or modifying old ones, we'll assume we can use the
    # variable names corresponding to the form and database
    # field names, but with "form_" in front; and copy those values into 
    # the form and if we're modifying an existing event then these variables
    # will have useful info; and if we're adding a new form
    # then these variables will be undefined and it doens't
    # matter - maffew

    # the form_* variables will have to have any embedded quotes (")
    # escaped as &quot; - and ampersands as &amp;

    # first fill in defaults if this is a new event
    
    if ($type_of_form eq "new") {
      $form_ampm = "PM";
      $form_month = $current_month_name;
      @today = localtime(time);
      $the_current_year = $today[5] + 1900;
      $form_year = $the_current_year;
      $form_contact = $session_first_name . " " . $session_last_name;
      $form_contact_email = $session_email;
      $form_web = "http://";
    }

    print qq!
    Boxes labelled in <b>bold</b> are essential, the others are optional. Please
    leave the optional ones blank if you're not using them.
    <p>!;
  
    if ($session_first_name ne "")
      {
      print qq!
      <TABLE BORDER = "0" CELLSPACING = "2" CELLPADDING = "2">
      <TR ALIGN = "LEFT">
      <TD><b>Your name</b></TD>
      <TD>$session_first_name $session_last_name</TD>
      <TR ALIGN = "LEFT">
      <TD><b>Your email</b></TD>
      <TD>$session_email</TD>
      </TR>!;
      }
    else
      {
      print qq!
      <TABLE BORDER = "0" CELLSPACING = "2" CELLPADDING = "2">
      <TR ALIGN = "LEFT">
      <TD><B>First Name</B></TD>
      <TD><INPUT TYPE = "text" NAME = "first_name" SIZE = "20"
        MAXLENGTH = "20"></TD>
      </TR>
      <TR ALIGN = "LEFT">
      <TD><B>Last Name</B></TD>
      <TD><INPUT TYPE = "text" NAME = "last_name" SIZE = "20"
        MAXLENGTH = "20"></TD>
      </TR>
      <TR ALIGN = "LEFT">
      <TD><B>Email</B></TD>
      <TD><INPUT TYPE = "text" NAME = "email" SIZE = "20"
        MAXLENGTH = "20"></TD>
      </TR>!;
      }

    print qq!
    <TR ALIGN = "LEFT">
    <TD><B>Event name</B></TD>
    <TD><INPUT TYPE = "text" NAME = "subject" SIZE = "60"
        VALUE="$form_subject" MAXLENGTH = "60"></TD>
    </TR>

    <TR ALIGN = "LEFT">
    <TD><B>Time</B><br>
    (12 pm is midday)
    </TD>
    <TD>
    <INPUT TYPE = "text" NAME = "hour" SIZE = "2"
        MAXLENGTH = "2" VALUE="$form_hour">
        
    <B>:</B>
    
    <INPUT TYPE = "text" NAME = "minute" SIZE = "2"
        MAXLENGTH = "2" VALUE="$form_minute">!;

    # Set up AM/PM options
    print "<SELECT NAME = \"ampm\">";
    if ($form_ampm eq "AM") {
      print "<OPTION SELECTED VALUE = \"AM\">AM\n";
      print "<OPTION VALUE = \"PM\">PM\n";
    } else {
      print "<OPTION VALUE = \"AM\">AM\n";
      print "<OPTION SELECTED VALUE = \"PM\">PM\n";
    }
    print "</SELECT>\n";

    print qq!
    <B>Date</B>    
    <INPUT TYPE = "text" NAME = "day" SIZE = "2"
        MAXLENGTH = "2" VALUE="$form_day">!;

    &select_a_month;

    &select_a_year;

    print qq!
    </TD>
    </TR>

    <TR ALIGN = "LEFT">
    <TD><B>Location</B></TD>
    <TD><INPUT TYPE = "text" NAME = "location" SIZE = "60"
        VALUE="$form_location" MAXLENGTH = "60"></TD>
    </TR>

    <TR ALIGN=LEFT>
    <TD><B>Summary</b> (what is happening and why - in three lines or less)</TD>
    <TD><TEXTAREA WRAP = "virtual" NAME = "summary" ROWS = "3"
         COLS = "60">$form_summary</TEXTAREA></TD>
    </TR>

    <TR ALIGN=LEFT>
    <TD><B>Contact</b> (name, organisation, phone numbers)</TD>
    <TD><TEXTAREA WRAP = "virtual" NAME = "contact" ROWS = "2"
         COLS = "60">$form_contact</TEXTAREA></TD>
    </TR>

    <TR ALIGN = "LEFT">
    <td>Contact email</td>
    <TD><INPUT TYPE = "text" NAME = "contact_email" SIZE = "60"
        VALUE="$form_contact_email" MAXLENGTH = "60"></TD>
    </TR>

    <TR ALIGN = "LEFT">
    <td>Web address for more info</td>
    <TD><INPUT TYPE = "text" NAME = "web" SIZE = "60"
        VALUE="$form_web" MAXLENGTH = "80"></TD>
    </TR>

    <TR ALIGN=LEFT>
    <td>How to get there (e.g. bus, train details)</td>
    <TD><TEXTAREA WRAP = "virtual" NAME = "transport" ROWS = "2"
         COLS = "60">$form_transport</TEXTAREA></TD>
    </TR>

    <TR ALIGN=LEFT>
    <td>The full rave (up to a page of info about the event)</td>
    <TD><TEXTAREA WRAP = "virtual" NAME = "rave" ROWS = "8"
         COLS = "60">$form_rave</TEXTAREA></TD>
    </TR>!;

    if ($type_of_form eq "new") {
      print qq!
      <TR ALIGN=LEFT>
      <td>Where should this event be announced?<br>
      (Posting multiple events? Please post to the website only - so that 
      the email list is not overloaded.)
      </td>
      <TD>
      <select name="announce">
      <option selected value="web_email">Web site and email list
      <option value="web_only">Web site only
      </select>
      </TD>
      </TR>!;
    }

    print "</TABLE>\n";
    }


######################################################################
#                              &smcal                                #
######################################################################

# MOD: CM
#
# This routine outputs the thumbnail calendar. The logic is the same
# as the original "Print Out Calendar" section and, indeed, much of
# that code is duplicated here. Most of what's different is to not
# print the $body or $subject from the calendar.events file, and 
# tighten everything up considerably with smaller type, table cells
# and borders, etc.
#
# Can be called individually with "calendar.cgi?small=on (incr=on)

   sub smcal
   {

     local ($sm_month, $sm_months_year)= @_;
     local ($sm_current_month_name, $sm_current_year);
     $real_month = $processed_data{'month'};
     @smmonth = &make_month_array(&jday($sm_month,1,$sm_months_year));
     $processed_data{'month'} = $real_month;
     $sm_current_month_name = &monthname($sm_month);
     $yr_htm = "'".substr($sm_months_year,2,2);

     if ($form_data{'incr'} ne "" )
       {
       print qq!
       <CENTER>
       <TABLE BORDER = "1" CELLPADDING = "2" CELLSPACING = "2">
       <TR><TH ALIGN=LEFT><A HREF=$this_script_url?month=$last_month&year=$last_mo_year&small=on&incr=on><</A>
       </TH>
       <TH ALIGN=CENTER COLSPAN=5>
       <FONT SIZE=2><A HREF="$this_script_url?year=$sm_months_year&month=$sm_month" target=_top>$sm_current_month_name $yr_htm</A>
       </FONT>
       </TH>
       <TH ALIGN=RIGHT>
       <A HREF=$this_script_url?month=$next_month&year=$next_mo_year&small=on&incr=on>></A>
       </TH>
       </TR>!;
       }
     else
       {
       print qq!
       <CENTER>
       <TABLE BORDER = "1" CELLPADDING = "2" CELLSPACING = "2">
       <TR>
       <TH COLSPAN=7 ALIGN=CENTER><FONT SIZE=2>
       <FONT SIZE=2><A HREF="$this_script_url?year=$sm_months_year&month=$sm_month" target=_top>$sm_current_month_name $yr_htm</A>
       </TR>
       <TR>!;
       }

# Print up the table header (Weekdays).  For every day (foreach $day) in
# our list of days (@day_names), print out the day as a table header.
# Then plop in the table row delimiters...

# MOD - Don't print the whole day name, just the first character - 

     foreach $day (@day_names)
       {
       $day_header = substr($day,0,1);
       print "<TH><FONT SIZE=1>$day_header</FONT></TH>\n";
       }

     print "</TR>\n<TR>\n";

# Create the variable $count_till_last_day which we will use to make sure
# that we do not add on too many <TR>s.  Also clear out a new variable
# called $weekday which we will use to keep track of the two dimensional
# aspect of the calendar...that is, we need to break the calendar rows
# after every seventh cell representing as week. (We'll taslk more about
# this in just a bit).

    $count_till_last_day = "0";
    $weekday = 0;

# For every day in the smmonth array we are going to need to create a
# cell for the calendar.  @mymonth, if you recall, is an array we got from
# &make_month_array

#######################################################################
#                   Create a Table Cell for Each Day                  #
#######################################################################

    foreach $day_number (@smmonth)
      {

# Begin incrementing our two counter variables.

      $count_till_last_day++;
      $weekday++;

# Make sure that we add a break for every week to make the calendar 2
# dimensional.  Thus, when we have gone through sets of seven days in this
# foreach loop, we will reset $weekday to zero.  Below, we'll use these
# values to determine where we drop the </TR><TR>, making a new calendar
# room.  When weekday is greater than 6, we'll know that we need a
# </TR><TR> so by setting the $weekday flag to zero, we will notify the
# script just a few lines down from here to insert the row break.

      $weekday = 0 if ($weekday > 6);

# Print a table cell for each day.  However, since we want to make each
# of the numbers in each of the cells clickable so that someone can click
# on the number to see a day view, we are going to need to manmage alot of
# information here.  Firstly, we will build a variable called
# $variable_list which will be used to create a long URL appendix which
# will be used to transfer indformation using URL encoding.  As we will
# learn more specifically later, the routine which generates the day views
# needs to have the day, year, and month values if it is to bring up a day
# view.  It must also have the session_file value (as all the routines in
# this script must) and the special tag view_day=on.  So we'll gather all
# of that information and appending it to the $variable_list variable.

      $variable_list = "day=$day_number&year=$sm_months_year";
      $variable_list .= "&month=$sm_month";
      $variable_list .= "&session_file=$processed_data{'session_file'}";
      $variable_list .= "&calendar=$form_data{'calendar'}";
      $variable_list .= "&view_day=on";

      # check to see if there's an event for this day

      $event_today = 0;
      open (DATABASE, "$database_file") || &CgiDie ("I am sorry, but I
        was unable to open the calendar data file in the Create a Table
        Cell for Each Day routine.  The value I have is $database_file.
        Would you please check the path ansd the permissions.");

      while (($row = <DATABASE>) && !$event_today)
        {
        ($day, $month, $year, $the_rest) = split (/\|/,$row);

# We are going to need to run through all of the database items and look
# for database rows whose subject belong on the day cell we are building.
# Thus, for every row, we must determine if the day, month, and year of
# the item on that row equal the day, month and year of the cell we are
# building.
        
            $event_today =  ($day eq "$day_number" && $month eq
            "$processed_data{'month'}" && $year eq "$currentyear")

        } # End of while (<DATABASE>)

# Now create the actual cell.  Notice, the number in each cell is made
# clickable by using URL encoding to tag the URl with all of the variables
# we want passed.

# MOD: CM
#
# Here's where we get small. We set cell width to "10", the font size to
# "1", and we e print only the day number.

      if ($event_today) {
        print qq!<TD VALIGN = "top" WIDTH = "10" ALIGN="right" 
          bgcolor="$second_color"><FONT SIZE=1>\n!;
      } else {
        print qq!<TD VALIGN = "top" WIDTH = "10" ALIGN="right" 
         bgcolor="$bgcolor"><FONT SIZE=1>\n!;
      }
      
      print qq!<A HREF = "$this_script_url?$variable_list">$day_number</A>\n!;

      print "</FONT></TD>\n";

# If, however, we have reached the end of a week row, we are going to need
# to begin a new table row for the next week.  If $weekday is equal to
# zero, then we know that it is time.  If not, continue with the row.
# (BTW, here we use == instead of just = because if we used =, perl would
# interpret the part inside the if () to be assigning the value of zero to
# $weekday...which it would do...and evaluate the whole process as true.
# That of course would undercut the whole point of counting with
# $weekday.)
      if ($weekday == 0)
        {
        print "</TR>\n";

# But before we just blindly print up another table row, we better be sure
# that we haven't actually reached the end of the month...Thus, if
# $count_till_last_day equals @smmonth we know that there are no more days
# left and we should not begin a new row.  (Notice that when we refernce
# @smmonth without quotes we receive the numerical value of the number of
# elements in the array).

        unless ($count_till_last_day == @smmonth)
          {
          print "<TR>";
          } # End of unless ($count_till_last_day == @smmonth)

        } # End of if ($weekday == 0)
      } # End of foreach $day_number (@smmonth)

# Finally, once we are done making all of the cells for the calendar,
# print up the HTML footer
    print "</TABLE></FONT>\n";

    } 

#######################################################################
#            &massage_event                                           #
#######################################################################

# get an event ready for display in list format
# e.g. convert time from 24 hour to am/pm format

# inputs: 
# $event - text line containg the database row to massage
# $format - "html" to include HTML formatting tags, "text" for plain text

sub massage_event
{
      local ($event, $format) = @_;
      
      @event_split = split (/\|/,$event);

      # load up up variables with stuff to go on the page

      $i = 0;
      foreach $value (@field_values) {
        $$value = $event_split[$i];
        $i++
      }

      # set variable $prox to the number of days
      # from today the event will occur.
      $prox = &jday($month,$day,$year) - &today;
     
      # today
      if ($prox == 0) {
       $color = $warn_color_1;
      }

      # tomorrow
      elsif ($prox == 1) {
        $color = $warn_color_2;
      }

      # day after tomorrow
      elsif ($prox == 2) {
        $color = $warn_color_3;
      }

      else {
        $color = $normal_color;
      }

      $tempjdate = &jday($month, $day, $year);
      ($a, $b, $c, $weekday) = &jdate($tempjdate);
      $day_of_week = $day_names[$weekday];
      $name_of_month = &monthname($month);
      
      ($hour, $minute) = split(/:/, $time);
      if ($hour < 12) {
        $ampm = "am";
      } else {
        $ampm = "pm";
      }
      $hour %= 12;
      if ($hour == 0) { $hour = 12; }
      $nice_time = "$hour:$minute" . $ampm;
      
      $fulldate = "$nice_time $day_of_week $day $name_of_month";

      if ($format eq "html")
      {
        if ($contact ne "") {
          $contact = "Contact: $contact";
        }
        if ($contact_email ne "") {
          $contact_email = qq!<br><a href="mailto:$contact_email">$contact_email</a>!;
        } 
        if ($web ne "") {
	  $show_url = $web;
	  $show_url =~ s%http://%%;
	  # crop web address on page to make sure thigns don't get
	  # too wide
	  if (length($show_url) > $url_crop) {
	    $show_url = substr($show_url, 0, $url_crop) . "...";
	  }
          $web = qq!<br><a href="$web">$show_url</a>!;
        }
        if ($transport ne "") {
          $transport = "Transport: $transport";
        }
      } else {
        # clean and line wrap all multi-line fields
        $summary = text_wrap($summary, "split");
        $contact = text_wrap($contact, "split");
        $transport = text_wrap($transport, "split");
        $rave = text_wrap($rave, "split");
      }
      
}

#######################################################################
#            &events_list   - Create a list of upcoming events        # 
#######################################################################

  # usage example: ?display=list&days=7 to get events for the next 7 days
  # [maffew]

  sub events_list
  {
    # buttons at the top
    print qq!
    <INPUT TYPE = "hidden" NAME = "day" VALUE = "$processed_data{'day'}">
    <INPUT TYPE = "hidden" NAME = "month" VALUE = "$processed_data{'month'}">
    <INPUT TYPE = "hidden" NAME = "year" VALUE = "$processed_data{'year'}">
    !;
    if ($button_images eq "yes") {
      print qq!
	<INPUT TYPE = "image" NAME = "addevent" ALT="add event"
	  src="../local/images/add-event.gif" $add_event_size border=0>
	<INPUT TYPE = "image" NAME = "editevent" ALT="edit event"
	  src="../local/images/edit-event.gif" $edit_event_size border=0>
	<INPUT TYPE = "image" NAME = "viewmonth" ALT="view month"
	  src="../local/images/view-month.gif" $view_month_size border=0>
      !;
    } else {
      print qq!
        <INPUT TYPE = "submit" NAME = "display" VALUE = "Add Event">
        <INPUT TYPE = "submit" NAME = "display" VALUE = "Edit Event">
        <INPUT TYPE = "submit" NAME = "display" VALUE = "View Month">
        </CENTER>
      !;
    }
    print "<p>\n";

    # Events to be extracted from the database that are relevant for
    # this month
    my (@events);
    my $event_index = 0;
    my $first_day;

    # Now we need to determine how many days to look ahead into the events 
    # file. The default will be set to 1, unless
    # the cgi was called with the added paramater ?days=somenumberofdays 
    # at the end of the URL.

    if ($_[0] ne "") {
     $days = $_[0];
    }
    elsif ($processed_data{'days'} ne "") {
     $days = "$processed_data{'days'}";
    }
    else {
     $days = 1;
    }

    $first_day = &jday(
      $processed_data{'month'},$processed_data{'day'},$processed_data{'year'});
    
    # Extract events from the events database.
    @events = &parse_database($first_day, $first_day + $days - 1);

    # loop through all the required events
    while ($event = @events[$event_index++]) {
      # chomp only eats trailing newline chars
      chomp $event;

      &massage_event($event, "html");

      if ($transport ne "" || $rave ne "") {
        # we need a zoom button
        $zoom_link = qq!
          <br><a href="?display=zoom&event=$database_id_number">
          The full rave...</a>
        !;
      } else {
        $zoom_link = "";
      }
      
      print qq!
        <table border=0 cellpadding=4 cellspacing=0 width=100%>
        <tr><td bgcolor="$color">
        <font face="$default_font">
        <b>$subject</b>
        </font>
        <tr><td bgcolor="$second_color">
        <font face="$default_font">
        $fulldate<br>
        $location<br>
        $contact
        $contact_email
        $web
        </font>
        <tr><td>
        <font face="$default_font">
        $summary
        $zoom_link
        </font>
        </table>
        <p>
      !;
    
    } # end while $event
    
    # say something if there weren't any events
    if (! @events) {
      $thismonth = &monthname($month);
      print qq!
        No events found. Maybe you know of one you can add?
      !;
    }

  }

#######################################################################
# &headlines - Create a list of events in simple format which can be  # 
# converted to lots of other useful scripts                           #
#######################################################################

  # usage example: ?display=headlines&days=1 to get events for the
  # next day
  sub headlines
  {
    # Events to be extracted from the database that are relevant for
    # this month
    my (@events);
    my $event_index = 0;
    my $first_day;

    # Now we need to determine how many days to look ahead into the events 
    # file. The default will be set to 1, unless
    # the cgi was called with the added paramater ?days=somenumberofdays 
    # at the end of the URL.

    if ($_[0] ne "") {
     $days = $_[0];
    }
    elsif ($processed_data{'days'} ne "") {
     $days = "$processed_data{'days'}";
    }
    else {
     $days = 1;
    }

    $first_day = &jday(
      $processed_data{'month'},$processed_data{'day'},$processed_data{'year'});
    
    # Extract events from the events database.
    @events = &parse_database($first_day, $first_day + $days - 1);

    $url_front = &MyBaseUrl;
    
    print "This is a simple database dump of the calendar events for the use\n";
    print "of scripts like wmheadlines.  Please limit the number of times\n";
    print "call this to once every half hour.";
    print "Records are delimited by %% on a line by itself.  Fields are\n";
    print "delimited by \\n.  The fields are:\n";
    print "  subject\n";
    print "  fulldate\n";
    print "  location\n";
    print "  contact\n";
    print "  contact_email\n";
    print "  web\n";
    print "  summary\n";
    print "  zoom_link\n";
    # loop through all the required events
    while ($event = @events[$event_index++]) {
      # chomp only eats trailing newline chars
      chomp $event;

      &massage_event($event, "text");

      if ($transport ne "" || $rave ne "") {
        # we need a zoom button
        $zoom_link = "$url_front?display=zoom&event=$database_id_number";
      } else {
        $zoom_link = "";
      }
      
      # strip newlines from multiline fields, as newline is the delimiter
      $contact =~ s/\n/ /g;
      $summary =~ s/\n/ /g;
      
      $event_text = "%%\n";
      $event_text .= "$subject\n";
      $event_text .= "$fulldate\n";
      $event_text .= "$location\n";
      $event_text .= "$contact\n";
      $event_text .= "$contact_email\n";
      $event_text .= "$web\n";
      $event_text .= "$summary\n";
      $event_text .= "$zoom_link\n";

      # although it's extremely unlikely any of the fields
      # will be just %%, I thought i'd play it safe
      $event_text =~ s/\n%%\n/\n%-%\n/g;

      print "$event_text";
    } # end while $event
  }



#######################################################################
# &mail_text - Create a list of events in text format which can then  #
# be emailed to interested people.  The idea is to call this from a   #
# periodic 'cron' job.                                                #
#######################################################################

  # usage example: ?display=mail_text&days=1 to get events for the
  # next day
  sub mail_text
  {
    # Events to be extracted from the database that are relevant for
    # this month
    my (@events);
    my $event_index = 0;
    my $first_day;

    # Now we need to determine how many days to look ahead into the events 
    # file. The default will be set to 1, unless
    # the cgi was called with the added paramater ?days=somenumberofdays 
    # at the end of the URL.

    if ($_[0] ne "") {
     $days = $_[0];
    }
    elsif ($processed_data{'days'} ne "") {
     $days = "$processed_data{'days'}";
    }
    else {
     $days = 1;
    }

    $first_day = &jday(
      $processed_data{'month'},$processed_data{'day'},$processed_data{'year'});
     
    # Extract events from the events database.
    @events = &parse_database($first_day, $first_day + $days - 1);

    if ($days > 1) {
      print "$mail_text_heading for the next $days days\n";
    } else
    {
      print "$mail_text_heading for today\n";
    }

    # print date: HH:MM Weekday Month YYYY
    printf("  created at: %0.2d:%0.2d %s %d %s %d\n", $today[2], $today[1],
      $day_names[$today[6]],$today[3],$month_names[$today[4]],$today[5] + 1900);

    print "\nIf you see [more...] then extra details are available at\n";
    print "$short_url\n";

    # loop through all the required events
    while ($event = @events[$event_index++]) {
      # chomp only eats trailing newline chars
      chomp $event;

      &massage_event($event, "text");
      
      $summary = "    $summary";
      $summary =~ s/\n/\n    /g;
      if ($rave ne "") { $summary .=  " [more...]" }
      $summary = text_wrap($summary, "indent");
      
      if ($transport ne "") { $location .=  " [more...]" }

      $contact = "[contact] $contact $contact_email $web";
      $contact = text_wrap($contact, "");

      $event_text = "\n---->> $subject <<----\n";
      $event_text .= "$fulldate\n\n$summary\n\n";
      $event_text .= "[where] $location\n";
      $event_text .= "$contact\n";

      # remove any remaining html
      $event_text =~ s/&amp;/&/g;
      $event_text =~ s/&quot;/"/g;
      $event_text =~ s/&lt;/</g;
      $event_text =~ s/&gt;/>/g;

      print $event_text;

    } # end while $event
  }


#######################################################################
#            event_zoom                                               #
#######################################################################

# zoom in to an event and show the full details 
# takes as input the event id
# outputs in $rave_page HTML description of the event with full details

sub event_zoom
{
  local ($event_id) = @_;

  &get_selected_event($event_id);

  # so this returned @selected_event already split

  &massage_event($selected_event, "html");
  
  $rave_page = qq!
    <table border=0 cellpadding=4 cellspacing=0 width=100%>
    <tr>
    <td bgcolor="$color" colspan="2">
    <font face="$default_font">
    <b>$subject</b>
    </font>
    <tr>
    <td bgcolor="$second_color" valign="top">
    <font face="$default_font">
    $fulldate<br>
    $contact
    $contact_email
    $web
    </font>
  
    <td bgcolor="$second_color" valign="top" width="40%">
    <font face="$default_font">
    $location<br>
    $transport
    </font>

    <tr><td  colspan="2">
    <font face="$default_font">
    $summary
    </font>
    </table>
    <blockquote>
    $rave
    </blockquote>
  !;
  
  return $rave_page;

}
 
#######################################################################
#            &front_page   - Create a list of upcoming events         # 
#######################################################################
 
   # usage example: ?display=front&days=7 for a front page including 
   # events for the next 7 days [maffew]
 
   sub front_page
   {
     # Print out feature event file defined in the setup
     if (open (FRONT_FILE, "$feature_file"))
     {
       while (<FRONT_FILE>)
       {
         print $_;
       }
     }

     print "<table border=1 cellpadding=10 cellspacing=0>\n";
     print "<tr><td valign=top width=50%>\n";
     print "<font face=\"$default_font\">\n";

     print "<img src=\"local/images/latest-news.gif\" alt=\"latest news\"
     $latest_news_size><p>";
     print "<a href=\"../news/publish.php3\"><img
     src=\"local/images/contribute-a-story.gif\" 
     alt=\"contribute a story\" border=0 $contribute_size></a><p>";

     if (open (FRONT_NEWS, "$front_news_file"))
     {
	 while (<FRONT_NEWS>) 
	 {
	     print $_;
	 }

     }
     else
     {
       print "Unable to find file $front_news_file";
     }

     # Print out the front page file defined in the setup
     if (open (FRONT_FILE, "$front_file"))
     {
       while (<FRONT_FILE>)
       {
         print $_;
       }
     }

     print "</font><td valign=top width=50%><font face=\"$default_font\">\n";
     print "<img
     src=\"local/images/events-this-week.gif\" alt=\"events this week\"
     $events_this_week_size><p>";

     &events_list($form_data{'days'});

     print "</font></table>\n";
     
   }

     
#######################################################################
#                      &yag   -   Year-at-a-Glance                    # 
#######################################################################
#
# MOD: CM
#
# Generate a table 12 cells, each contining a thumbnail calendar
# One for each month of the year
#
# Slow, but works
#
# Invoked with "calendar.cgi?yag=on" (actually, any non-blank string
# will work after the "yag", not just "on"

 sub yag
   {
     $cellrow = "0";
     $cellnum = "0";
     print qq!
     <CENTER><FONT SIZE = 6>Year at a Glance<BR>$processed_data{'year'}</FONT><BR>
     <HR><BR><BR>
     <TABLE BORDER=2 CELLPADDING=2 CELLSPACING=2><TR>!;
     while ($cellnum <= 11)
     {
       $cellnum++;
       $cellrow++;
       print "<TD VALIGN=\"TOP\">";
       &smcal($cellnum, 1997);
       print "</TD>";
       if ($cellrow eq "4")
        {
        print "</TR><TR>\n";
        $cellrow = "0";
        }

     }

     print "<TR></TABLE></CENTER>\n";

   }

#######################################################################
#                             Text Wrap                               #
#######################################################################

# cleans up text and wraps it for emailing
# when i say wrapping i mean line wrapping so long lines don't go 
# off the end of the screen

# $options can include the keywords 
# "indent" - maintains indent
# "split" - only splits over-long lines, doesn't wrap short lines, good
#             for keeping point lists in text

sub text_wrap
{
    local ($dirty_text, $options) = @_;

    #clean up whitespace
    $dirty_text =~ s/<[Bb][Rr]>/\n/g;
    $dirty_text =~ s/\t/        /g;
    if ($options =~ /indent/) {
      $dirty_text =~ s/(\S) +/$1 /g;
    } else {
      $dirty_text =~ s/ +/ /g;
      $dirty_text =~ s/\n /\n/g;
    }

    open(WRAP, ">/tmp/Tmp$$");
    print WRAP $dirty_text;
    close(WRAP);

    $fmt_options ="";
    if ($options =~ /split/) { $fmt_options .= "-s " }
    if ($options =~ /indent/) { $fmt_options .= "-c " }
    $dirty_text = `fmt $fmt_options -w 70 /tmp/Tmp$$`;

    # remove any remaining html
    $dirty_text =~ s/<.*?>//g;
    $dirty_text =~ s/&amp;/&/g;
    $dirty_text =~ s/&quot;/"/g;

    chomp $dirty_text;

    return $dirty_text; # well it's clean and wrapped now

}

######################################################################
#                              &header                               #
######################################################################
  sub header
    {
    local ($title) = @_;

    # read in the header files
    
    # first header goes before the heading text (useful for opening
    # format tags such as <h3>)
    if (open (HEADER_FILE, "$header_file1"))
    {
        while (<HEADER_FILE>)
        {
          $header1 .= "$_";
        }
    }

    # second header goes after the heading text (eg. </h3>)
    if (open (HEADER_FILE, "$header_file2"))
    {
        while (<HEADER_FILE>)
        {
          $header2 .= "$_";
        }
    }

    if ($title eq "")
      {
      $title = $title_default;
      }

    if ($title ne "") {
      $title_join = "- ";
    }

    if ($title_lower eq "yes") {
      $title = lc($title);
    }
        
    print qq!
    <HTML>
    <HEAD>
    <TITLE>$title_front $title_join $title</TITLE>
    </HEAD>
    $body_tag
    $header1
    $title
    $header2
    !;
    
    # only print form stuff if we aren't in auth mode
    if (! $auth_mode)
    {
#    <FORM METHOD = "get" ACTION = "http://hoohoo.ncsa.uiuc.edu/cgi-bin/test-env">
      print qq!
    <FORM METHOD = "post" ACTION = "$this_script_url">
    <INPUT TYPE = "hidden" NAME = "session_file"  VALUE =
    "$processed_data{'session_file'}">
    <INPUT TYPE = "hidden" NAME = "calendar" VALUE = "$form_data{'calendar'}">!;
    }
}

#######################################################################
# Print out the bottom of a html page #
#######################################################################
sub footer
{
  if (! $auth_mode)
    {
    print "</FORM>\n";
    }
  
  # Print out the footer file defined in the setup
  if (open (FOOTER_FILE, "$footer_file"))
  {
    while (<FOOTER_FILE>)
    {
      print $_;
    }
  }
  print "</BODY></HTML>\n";
}
