
############################################################
#                       AUTH-EXTRA-HTML.PL
#
# $Id: auth-extra-html.pl,v 1.3 1999/01/10 16:40:34 maffew Exp $
#
# This script was written by Selena Sol & Gunther Birznieks. 
# Date Created: 5-10-96
# Date Last Modified: 5-14-96
#
#   You may copy this under the terms of the GNU General Public
#   License or the Artistic License which is distributed with
#   copies of Perl v5.x for UNIX.
# 
# Selena Sol may be contacted at selena@eff.org
#
# Purpose: This script contains all the cosmetic HTML output
# routines related to the authentication routines.
#
# Main Procedures:
#   All the routines are ancillary to the auth-extra-lib.pl 
#   and auth-lib-fail.pl files.
#
# Special Notes: Nearly all the routines below accept
# some sort of parameter.  These parameters are only for
# printing out extra information.  They are not doing any
# significant processing.
#
# You will need to uncomment the sample header and footer
# functions below, if you have not defined them in your 
# calling script.
#
#
############################################################

######################################################################
#                              &header                               #
# Uncomment this function if you have not defined one in your calling
# script.
######################################################################
#   sub header
#     {
#     local ($title) = @_;
# 
#     if ($title eq "")
#       {
#       $title = "Calendar";
#       }
#       
#     print qq!
#     <HTML>
#     <HEAD>
#     <TITLE>$title</TITLE>
#     </HEAD>
#     <BODY BGCOLOR="#FFFFFF">
#     <h3>$title</h3>
#     !;
#     }


#######################################################################
# Print out the bottom of a html page #
# Uncomment this function if you have not defined one in your calling
# script.
#######################################################################
# sub footer
# {
#   print "</BODY></HTML>\n";
# }


############################################################
#
# subroutine: PrintLogonPage
#
#  This routine outputs the logon HTML page along with
#  a bad logon message if one exists.  Hidden form tags
#  are generated automatically if we are passing previous
#  form data from the main script.
#
############################################################

sub PrintLogonPage {
    local($bad_logon_message, $main_script, *in) = @_;
    local($form_tags);
    local($register_tag);
    local($search_tag);

    if (length($auth_logon_title) < 1) {
        $auth_logon_title = "Submit Logon";
    }

    if (length($auth_logon_header) < 1) {
        $auth_logon_header = "Enter Your Logon Information";
    }

    $register_tag = "";
    $search_tag = "";

    if ($auth_allow_register eq "on") {
	$register_tag = <<__END_OF_REG_TAG__;
<input type=submit name=auth_register_screen_op 
value="Start a new username"><p>
__END_OF_REG_TAG__
}

    if ($auth_allow_search eq "on") {

	$search_tag = <<__END_OF_SEARCH_TAG__;
<input type=submit name=auth_search_screen_op 
value="Search for an existing username"><p>
__END_OF_SEARCH_TAG__

    } 
   $form_tags = &PrintCurrentFormVars(*in);

    &header($auth_logon_title);

    print <<__END_OF_LOGON__;
<table border=0 cellpadding=15>
<tr><td valign="top">
<font face="$auth_font">
<H3>$auth_logon_header</h3>

You need to have a username and password to add events. This is so that you can
come back later and change or remove your events as you find out more
information. It also makes it easier to add new events because it saves you
re-typing your details each time.

<ul>

<li>If you already have a username, enter it and the password, then press the
<b>Login</b> button. 

<li>If you don't already have a username with us, it's easy to make
one, just press the <b>Start a new username</b> button and we'll make one
for you right now. 

<li>Or, if you have a username, but you've forgotten it, you can search for it
using your email address: to do this press the <b>Search for an existing
username</b> button. 

<li>You'll have to <a href="mailto:$auth_admin_email_address">email us</a> if
you've forgotten your password.

</ul>
</font>
<td valign="top">
<font face="$auth_font">
$bad_logon_message
<FORM METHOD=POST ACTION=$main_script>
$form_tags
Username<br>
<INPUT TYPE=TEXT NAME=auth_user_name>
<p>
Password<br>
<input type=password name=auth_password>
<p>
<input type=submit name=auth_logon_op 
value="Login"><p>
$register_tag
$search_tag
</font>
</table>
</form>
__END_OF_LOGON__

&footer;

} # End of PrintLogonPage

############################################################
#
# subroutine: PrintSearchPage
#
#  This routine outputs the Search HTML page if one exists.  
#  Hidden form tags are generated automatically if we are 
#  passing previous form data from the main script.
#
############################################################

sub PrintSearchPage {
local($main_script,*in) = @_;
    local($form_tags);
    $form_tags = &PrintCurrentFormVars(*in);
    &header("Username search");
    print <<__END_OF_SEARCH__;
<h3>Please type in your email address to search for a matching username</h3>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<TABLE>
<TR><TH>Email</TH>
<TD><INPUT TYPE=TEXT NAME=auth_email></td></tr>
</TABLE>
<p>
<input type=submit name=auth_search_op value="Search">
<input type=submit name=auth_logon_screen_op value="Return to Login Page">
<P>
</form>
__END_OF_SEARCH__
    &footer;
} # End of PrintSearchPage

############################################################
#
# subroutine: HTMLPrintSearchResults
#
#   This routine outputs the results of the search for 
#   usernames using an email address
#
############################################################

sub HTMLPrintSearchResults {
    local($main_script, $form_tags, $user_list) =
	@_;
  &header("Username search");
	print <<__END_SEARCHRESULTS__;
<H3>I found atleast one user with that email address</h3>
Username(s) found:
<strong>$user_list</strong>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<input type=submit name=auth_logon_screen_op
value="Return to Login Page">
<hr>
</form>
__END_SEARCHRESULTS__
  &footer;
} # End of HTMLPrintSearchResults


############################################################
#
# subroutine: HTMLPrintNoSearchResults
#
#   This routine prints the HTML related to not having
#   found any results from the search on email address.
#
############################################################

sub HTMLPrintNoSearchResults {
    local($main_script, $form_tags) = @_;
  &header("Username search");
	print <<__END_NOSEARCHRESULTS__;
<h3>Sorry, no users were found that matched your email address</h3>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<input type=submit name=auth_logon_screen_op
value="Return to Login Page">
<hr>
</form>
__END_NOSEARCHRESULTS__
  &footer;
} # End HTMLPrintNoSearchResults


############################################################
#
# subroutine: PrintRegisterPage
#
#  This routine outputs the Register HTML page.  Hidden form 
#  tags are generated automatically if we are passing previous
#  form data from the main script.
#
############################################################

sub PrintRegisterPage {
local($main_script,*in) = @_;
local($form_tags);
local($more_form_input,$password_input, $x);
    $form_tags = &PrintCurrentFormVars(*in);
local ($password_message);

#
# We also check for the extra fields and output HTML
# asking for input on the extra fields.
#
$more_form_input = "";
for ($x = 0; $x <= @auth_extra_fields - 1; $x++) {
    $more_form_input .= <<__END_OF_EXTRA_FIELDS__;
<TR><TH>$auth_extra_desc[$x]</TH>
<TD><INPUT TYPE=TEXT NAME=$auth_extra_fields[$x]></td></tr>
__END_OF_EXTRA_FIELDS__
}
$password_input = "";
if ($auth_generate_password ne "on") {
    $password_input = <<__END_OF_PASSWORD_FIELDS__;
<tr><th>Password</th>
<td><input type=password name=auth_password1></td></tr>
<tr><th>Password Again</th>
<td><input type=password name=auth_password2></td></tr>
__END_OF_PASSWORD_FIELDS__
} 
$password_message = "";
if ($auth_generate_password eq "on") {
$password_message = <<__PASSWORDMSG__;
Your password will be automatically generated and sent
to you via your E-Mail address.
__PASSWORDMSG__
} 

&header("Start a new username");
    print <<__END_OF_REGISTER__;
<H3>Please tell us a little about yourself</h3>

First you need to think of a username and a password. Please type your password
in twice, once in each box, as a confirmation of the spelling. We also need to
know your name and email address. 

<hr>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<TABLE>
<tr><th>Username</th>
<td><input type=Username name=auth_user_name></td></tr>
$password_input
$more_form_input
</TABLE>
<p>
<input type=submit name=auth_register_op value="Create This Username">
<input type=submit name=auth_logon_screen_op value="Return to Login Page">
<P>
$password_message
</form>
__END_OF_REGISTER__
&footer;
} # End of PrintRegisterPage

############################################################
#
# subroutine: HTMLPrintRegisterSuccess
#
#  This routine prints the HTML for a successful user
#  registration.
#
############################################################

sub HTMLPrintRegisterSuccess {
    local($main_script, $form_tags) = 
	@_;
    &header("New username created");
    print <<__END_OF_REGISTER_SUCCESS__;
<H3>Your new username is ready</h3>
<hr>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<BLOCKQUOTE>
    $auth_register_message
</Blockquote>
<input type=submit name=auth_logon_screen_op value="Return to Login Page")
</form>
__END_OF_REGISTER_SUCCESS__
    
    &footer;
    
} # End of RegisterSuccess


############################################################
#
# subroutine: HTMLPrintRegisterFoundDuplicate
#
#  This routine prints the HTML for a failed user
#  registration because of finding a duplicate username
#
############################################################


sub HTMLPrintRegisterFoundDuplicate {
    local($main_script, $form_tags) = 
	@_;
&header("New username - a small problem");
print <<__END_OF_REGISTER_DUPLICATE__;
<H3>I'm afraid your username has already been chosen by someone else</h3>
<hr>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<BLOCKQUOTE>
Please pick a different username. Press your <b>back</b> button to try again.
</Blockquote>
</form>
__END_OF_REGISTER_DUPLICATE__
&footer;
} # End of HTMLPrintRegisterFoundDuplicate

############################################################
#
# subroutine: HTMLPrintRegisterNoPasswordMatch
#
#  This routine prints the HTML for a failed user
#  registration because the two passwords did not match
#
############################################################

sub HTMLPrintRegisterNoPasswordMatch {
    local($main_script, $form_tags) = 
	@_;
    
    &header("New username - a small problem");
    print <<__END_OF_REGISTER_NOMATCH__;
<H3>Password mismatch</h3>
<hr>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<BLOCKQUOTE>

Sorry, the two passwords you typed in did not match. They need to be the same
so we're both sure how to spell it. Please press your <b>back</b> button to try
again.

</Blockquote>
</form>
__END_OF_REGISTER_NOMATCH__
    &footer;
} # End of HTMLPrintRegisterNoPasswordMatch

############################################################
#
# subroutine: HTMLPrintRegisterFoundDuplicate
#
#  This routine prints the HTML for a failed user
#  registration because of finding a missing value or
#  a value that has a PIPE in it.
#
############################################################

sub HTMLPrintRegisterNoValidValues {
    local ($main_script, $form_tags) =
	@_;
    &header("New username - a small problem");
    print <<__END_OF_REGISTER_NOVALUE__;
<H3>Need more info</h3>
<hr>
<FORM METHOD=POST ACTION=$main_script>
$form_tags
<BLOCKQUOTE>

Sorry, you need to put something in every box. Please press your <b>back</b>
button to try again.

</Blockquote>
</form>
__END_OF_REGISTER_NOVALUE__
    &footer; 
} # End of HTMLPrintRegisterNoValidValues

1;

