<?php

function truncate($string, $length = 80, $etc = '...',$break_words = false, $middle = false) {
if ($length == 0)
return '';

if (strlen($string) > $length) {
$length -= min($length, strlen($etc));

if (!$break_words && !$middle) {
$string = preg_replace('/\s+?(\S+)?$/', '', substr($string, 0, $length+1));
}

if(!$middle) {
return substr($string, 0, $length) . $etc;
} else {
return substr($string, 0, $length/2) . $etc . substr($string, -$length/2);
}
} else {
return $string;
}
}

function country() {

// recupero ip
if ($_SERVER) {
if ($_SERVER[HTTP_X_FORWARDED_FOR]) {
$realip = $_SERVER["HTTP_X_FORWARDED_FOR"];
} elseif ($_SERVER["HTTP_CLIENT_IP"]) {
$realip = $_SERVER["HTTP_CLIENT_IP"];
} else {
$realip = $_SERVER["REMOTE_ADDR"];
}
} else {
if (getenv('HTTP_X_FORWARDED_FOR')) {
$realip = getenv('HTTP_X_FORWARDED_FOR');
} elseif (getenv('HTTP_CLIENT_IP')) {
$realip = getenv('HTTP_CLIENT_IP');
} else {
$realip = getenv('REMOTE_ADDR');
}
}

// ahora el pais
/*requerimos la biblioteca o liberia */
require("geoip.inc.php");

/* apertura y lectura del archivo utilizando la constante GEOIP_STANDARD 
como forma de lectura que adquiere valor en geoip.inc */
$abir_bd = geoip_open("GeoIP.dat",GEOIP_STANDARD);

/* imprimimos el nick del pas */
$country = geoip_country_name_by_addr($abir_bd, $realip);

/* liberamos memoria cerrando el resorce devuelto por $abir_bd de la apertura*/
geoip_close($abir_bd);

switch ($country) {
case "Argentina":
$country = "MLA";
break;

case "Brazil":
$country = "MLB";
break;

case "Colombia":
$country = "MCO";
break;

case "Costa Rica":
$country = "MCR";
break;

case "Chile":
$country = "MLC";
break;

case "Ecuador":
$country = "MEC";
break;

case "Mexico":
$country = "MLM";
break;

case "Panama":
$country = "MPA";
break;

case "Peru":
$country = "MLP";
break;

case "Republica Dominicana":
$country = "MRD";
break;

case "Uruguay":
$country = "MLU";
break;

case "Venezuela":
$country = "MLV";
break;

default:
$country = "MLA";
}

return $country;
}

?>