<?php
/**
 *  Biblioteca de Funes bsicas  ---------------------------------------  //
 *  =============================
 *  arquivo: PhPage.lib.php
 *  verso: 1.0.1
 *  atualizado: 19/07/2005
 */
 

function create_file_of_method( $nObj )
{
  $nFile = _INC_  . $nObj . "_eventos.js.php";

  if( !file_exists( $nFile ) )
  {
    $_fp_ = @fopen( $nFile, 'wb');
    @fwrite($_fp_, '<script language="javascript">'             . NEWLINE );

    @fwrite($_fp_, '  var tags=document.getElementsByTagName("INPUT");'. NEWLINE );
    @fwrite($_fp_, '  for(var a=0;a<tags.length;a++)'. NEWLINE );
    @fwrite($_fp_, '  {'. NEWLINE );
    @fwrite($_fp_, '    i = tags[a].id.indexOf( "'.$nObj.'" );'. NEWLINE );
    @fwrite($_fp_, '    if( i != -1)'. NEWLINE );
    @fwrite($_fp_, '    {'. NEWLINE );
    @fwrite($_fp_, '      '.$nObj.'_ID = findDOM( tags[a].id, 0 );'                    . NEWLINE );
    @fwrite($_fp_, '      '.$nObj.'_ID.attachEvent( "onchange" , '.$nObj.'_onChange );'. NEWLINE );
    @fwrite($_fp_, '      '.$nObj.'_ID.attachEvent( "onfocus"  , '.$nObj.'_onFocus );' . NEWLINE );
    @fwrite($_fp_, '      '.$nObj.'_ID.attachEvent( "onblur"   , '.$nObj.'_onBlur );'  . NEWLINE );
    @fwrite($_fp_, '    }'. NEWLINE );
    @fwrite($_fp_, '  }'. NEWLINE );
    @fwrite($_fp_, '  '. NEWLINE );
    @fwrite($_fp_, '  function '.$nObj.'_onChange( evt )'. NEWLINE );
    @fwrite($_fp_, '  {'. NEWLINE );
    @fwrite($_fp_, '    '. NEWLINE );
    @fwrite($_fp_, '  }'. NEWLINE );
    @fwrite($_fp_, '  '. NEWLINE );
    @fwrite($_fp_, '  function '.$nObj.'_onFocus( evt )'. NEWLINE );
    @fwrite($_fp_, '  {'. NEWLINE );
    @fwrite($_fp_, '    '. NEWLINE );
    @fwrite($_fp_, '  }'. NEWLINE );
    @fwrite($_fp_, '  '. NEWLINE );
    @fwrite($_fp_, '  function '.$nObj.'_onBlur( evt )'. NEWLINE );
    @fwrite($_fp_, '  {'. NEWLINE );
    @fwrite($_fp_, '    '. NEWLINE );
    @fwrite($_fp_, '  }'. NEWLINE );
    @fwrite($_fp_, '  '. NEWLINE );
    @fwrite($_fp_, '  function '.$nObj.'_onLoad( evt )'. NEWLINE );
    @fwrite($_fp_, '  {'. NEWLINE );
    @fwrite($_fp_, '    '. NEWLINE );
    @fwrite($_fp_, '  }'. NEWLINE );
    @fwrite($_fp_, '  '. NEWLINE );


    @fwrite($_fp_, '</script>'                                  . NEWLINE );
    @fclose( $_fp_ );
  }// End
}// end

/**
 *
 */
function create_file_of_afterLoad( $nObj )
{
  $nFile = _INC_  . $nObj . "_afterLoad.js.php";

  if( !file_exists( $nFile ) )
  {
    $idx = substr( $nObj, 6 ) -1;
//echo"$idx";exit;
    $_fp_ = @fopen( $nFile, 'wb');
    @fwrite($_fp_, '<script language="javascript">'             . NEWLINE );
    @fwrite($_fp_, '  setDbNavigator_post( ' .$idx.', false );' . NEWLINE );
    @fwrite($_fp_, '  setDbNavigator_first( '.$idx.', false );' . NEWLINE );
    @fwrite($_fp_, '  setDbNavigator_prior( '.$idx.', false );' . NEWLINE );
    @fwrite($_fp_, '  '                                         . NEWLINE );
    @fwrite($_fp_, '  setDBgrid_linha_on( '.$idx.', 1 );'       . NEWLINE );
    @fwrite($_fp_, '  setDBgrid_readOnly( '.$idx.', true )'     . NEWLINE );
    @fwrite($_fp_, '</script>'                                  . NEWLINE );
    @fclose( $_fp_ );
  }// End
}// End


function create_file_of_evento( $nObj, $nEvento )
{
  if( !defined( '_INC_' ) )
  {
    define( '_INC_', INC );
  }
  $nFile = _INC_ . $nEvento . "_" . $nObj . ".js.php";
  if( !file_exists( $nFile ) )
  {
    switch( $nEvento )
    {
      case 'onOver':
        $linha = $nObj . "_mouseOver( objectID );";
        break;
      case 'onOut':
        $linha = $nObj . "_mouseOut( objectID );";
        break;

      case 'onUp':
        $linha = $nObj . "_mouseUp( objectID );";
        break;
      case 'onDown':
        $linha = $nObj . "_mouseDown( objectID );";
        break;

      case 'onDown':
        $linha = $nObj . "_ mouseMove( objectID );";
        break;

      case 'onDblClick':
        $linha = $nObj . "_mouseDblClick( objectID );";
        break;
      default:
        $linha = $nObj . "_mouseClick( objectID );";
        break;
    }// End
    $_fp_  = @fopen( $nFile, 'wb');
    @fwrite($_fp_, $linha );
    @fclose( $_fp_ );
  }// End
}// End


/**
 *  Funo: getPatch()
 *
 *  Descrio: Monta o caminho para a cpia local do Projeto
 *  retorna: string -
 */
  function getPatch()
  {
    $uri = $_SERVER["REQUEST_URI"];
    $len = strlen($uri) -1;
    while($uri[$len] != "/")
      $len --;

    return substr($uri, 0, $len + 1);
  }// End function getPatch()

/**
 *  Descrio: retorna o caminho para o root do PhPage Studio
 */
  function getRoot()
  {
    $uri = $_SERVER["REQUEST_URI"];
    $s = strpos( $uri, 'studio' );
    if( $s === false )
    {
      $s = strpos( $uri, 'Studio' );
    }
    return( substr($uri, 1, $s -1 ) );
  }// End function getPatch()

/**
 *  Funo execPage()
 *
 *  Descrio: Executa o cdigo da Page.
 *  Recebe: $nPage => nome da Page a ser Executada
 *  retorna:
 *
 *  Executa um Page
 */
  function execPage( $nPage )
  {
    global $projeto,
           $esquema,
           $componentes_no_Prj,
           $_desenv_,
           $_root_,
           $modo_RAD;

    /*  declara as variveis Globais  */
    foreach( $componentes_no_Prj as $ind_ => $val_)
    {
      global $$ind_;
    }// End foreach( $componentes_no_Prj as $ind_ => $val_)

    $_pathPage_ = $_SERVER['DOCUMENT_ROOT']  .
                  $_desenv_ . "core/" .
                  $nPage . '.main.php';

    include( $_pathPage_ );

  }// End function execPage( $nPage )


/**
 *  funo: getTemplates( $comp_no_Prj, $local )
 *
 *  Descrio: Retorna os nomes dos templates contidos no Objeto
 *
 *  $nPrj   => Nome do Projeto
 *  $local  => Nome do Objeto Container
 *
 *  retorna: array com o nome dos templates para o Objeto do tipo container
 */
  function getTemplates( $nPrj, $local )
  {
    $nFile = $nPrj . ".main.prj";

    if ( file_exists($nFile) )
    {
      $linhas = file($nFile);
    }else
    {
      $linhas = array();
    }// End

    $arrTemplate = array();
    foreach( $linhas as $i_ => $linha_ )
    {
      $linha_ = trim($linha_);

      if ( !empty( $linha_ ) )
      {
        $flag = true;
        $arrLinhas = explode( ";", trim($linha_) );
        array_pop($arrLinhas); // retira o NewLine da linha

        foreach( $arrLinhas as $ii_ => $linha )
        {
          $arr = explode( ":", $linha );
          
          if( $arr[3] == $local )
          {
            $arrTemplate[] = $arr[2];
          }//
        }//
      }//
    }//
    return( $arrTemplate );







    $arr = array();
    foreach($comp_no_Prj as $_ind_ => $_val_)
    {
      foreach($_val_ as $_n_ => $_l_)
      {
        if ($_l_['local'] == $local )
          $arr[] = $_l_['nome'];
      }
    }// End foreach($objetos_na_Page as $_ind_ => $_val_)
    return($arr);
  }// End function getTemplates( $comp_no_Prj, $local )

/**
 *  funo: getTemplates_old( $comp_no_Prj, $local )
 *
 *  Descrio: Retorna os nomes dos templates contidos no Objeto
 *
 *  $comp_no_Prj => array com os componentes incluidos no projeto
 *  $local       => Nome do Objeto Container
 *
 *  retorna: array com o nome dos templates para o Objeto do tipo container
 */
  function getTemplates_old( $comp_no_Prj, $local )
  {
    $arr = array();
    foreach($comp_no_Prj as $_ind_ => $_val_)
    {
      foreach($_val_ as $_n_ => $_l_)
      {
        if ($_l_['local'] == $local )
          $arr[] = $_l_['nome'];
      }
    }// End foreach($objetos_na_Page as $_ind_ => $_val_)
    return($arr);
  }// End function getTemplates( $comp_no_Prj, $local )


/**
 *  funo: getGlobal( $comp_no_Prj, $local )
 *
 *  Descrio:
 *
 *  Parametros:
 *  $comp_no_Prj => array com os componentes incluidos no projeto
 *  $local       => container dos objetos
 *
 *  retorna: array com o nome das variveis Globais
 */
  function getGlobal( $comp_no_Prj, $local )
  {
    $arr = array();
    foreach($comp_no_Prj as $_ind_ => $_val_)
    {
      foreach($_val_ as $_n_ => $_l_)
      {
        if ($_l_['local'] == $local )
          $arr[] = $_l_['nome'];
      }
    }// End foreach($objetos_na_Page as $_ind_ => $_val_)
    return($arr);
  }// End function getGlobal( $comp_no_Prj, $local )


  
/**
 *  funo getRegistro()
 *
 *  L o Arquivo de Projeto (.main.prj)
 *  para criar o arquivo de Configurao (.main.inc.php)
 *  ---------------------------------------------------------------------  //
 *
 *  $prj = nome do Projeto
 *  retorna: nome do arquivo gerado (.main.inc.php)
 */
  function getRegistro( $prj )
  {
    global $_rad_, $_desenv_;

    $nFile = $prj . ".main.prj";
    $nDest = $prj . ".main.inc.php";
    $texto = "";
    $nComp = "";
    $nObj  = "";
    $nl    = "\n";
    $array = array();
    
//return( $nDest );
    if ( file_exists( $nFile ) )
    {
      $linhas = file($nFile);
    }else
    {
      $linhas = array();
    }// End
      
    asort($linhas);
    reset($linhas);

    $texto = "<?php " . NEWLINE;
    $flag  = false;
    foreach( $linhas as $i_ => $linha_ )
    {
      $linha_ = trim($linha_);
      
      if ( !empty( $linha_ ) )
      {
        $flag = true;
        $arrLinhas = explode( ";", trim($linha_) );
        array_pop($arrLinhas);
      
        foreach( $arrLinhas as $ii_ => $linha )
        {
          $arr = explode( ":", $linha );
      
          if( $nComp != $arr[0] )
          {
            if ( $nObj != "" )
            {
              $texto .= "    )".$nl;
            }// End if ( $nObj == "" )
            if( $nComp != "" )
              $texto .= "  ); ".$nl;
        
            $nComp   = $arr[0];
            $nObj    = "";
            $array[] = $arr[0];
            $texto .= "  $".$arr[0]." = array( ".$nl;
          }// End if( $nComp != $arr[0] )

          if( $nObj != $arr[1] )
          {
            if ( $nObj != "" )
            {
              $texto .= "    ),".$nl;
            }// End if ( $nObj == "" )
            $nObj = $arr[1];
            $texto .= "    '" . $arr[1] . "' => array( " . $nl;
          }// End if( $nObj != $arr[1] )
      
          $texto .= "      'nome'      => '" . $arr[2]       . "'," . $nl;
          $texto .= "      'local'     => '" . $arr[3]       . "'," . $nl;
          $texto .= "      'container' => '" . $arr[4]       . "'," . $nl;
          $texto .= "      'visual'    => '" . trim($arr[5]) . "' " . $nl;

        }// End foreach()
      }// End if()
    }//End foreach( $linhas as $i_ => $linha )

    $l = count( $array );
    $x = 0;

    if ( $flag )
    {
      $texto .= "    )" . $nl;
      $texto .= "  );"  . $nl;
    }
    $texto .= "  "    . $nl;
    $texto .= "  \$componentes_no_Prj = array( " . $nl; 
     
    foreach($array as $ii_ => $cpo )
    {
      $x ++;
      $sp = ( $x < $l ) ? "," : "";
      $texto .= "    '".$cpo."' => $".$cpo . $sp . $nl; 
    }// End foreach($array as $ii_ => $cpo )

    $texto .= "  ); " . $nl;
    $texto .= "  "    . $nl;
    $texto .= "?> "   . $nl;  
    
    $fp = @fopen( $nDest, 'wb' );
    fwrite( $fp, $texto );
    fclose( $fp );

    return( $prj . ".main.inc.php" );
  }// End function getRegistro( $prj ) 
  
  
/**
 *  getPaletas()
 *
 *  retorna: array com as Paletas disponveis
 */  
  function getPaletas()
  { 
    $nDir      = "core/paletas/";
    $arrPaleta = array();
    
    if ( file_exists($nDir) && is_dir($nDir) )
    {
      if ($handle = opendir($nDir)) 
      {
        while (false !== ($file = readdir($handle))) 
        {
          if ( is_dir($nDir.$file) )
          {
            if ($file != "." && 
                $file != ".." &&
                $file != "bkp"
                ) 
            {
              $arrPaleta[] =  "$file";
            }
          }  
        }
        closedir($handle);
      }
    }// End if ( file_exists($nDir) && is_dir($nDir) )
    return( $arrPaleta  );
  }// End function getPaletas()
  
/**
 *  getObjetos()
 *
 *  $nPaleta = nome da Paleta
 *  retorna: array com os Componentes da Paletas
 */  
  function getObjetos( $nPaleta )
  { 
    $nDir   = "core/paletas/" . $nPaleta;
    $arrObj = array();
    
    if ( file_exists($nDir) )
    {
      if ($handle = opendir($nDir)) 
      {
        while (false !== ($file = readdir($handle))) 
        {
            if ($file != "." && 
                $file != ".." &&
                $file != "bkp"
                ) 
            {
              $ix = strpos( $file, ".");
              $arrObj[] =  substr($file,0, $ix);
            }
        }
        closedir($handle);
      }
    }// End if ( file_exists($nDir) && is_dir($nDir) )
    return( array_unique($arrObj)  );
  }// End function getObjetos()
  


  /**
   *  getFile()
   *
   *  pega os nome dos Arquivos no diretorio especificado
   *
   *  $nDir = nome do Diretorio
   *  $pre  = prefixo do nome dos arquivos
   *  retorna: Array associativo com os nomes dos Arquivos
   */
  function getFile( $nDir, $pre = "" )
  { 
    $arrFile = array();
    if ( file_exists($nDir) && is_dir($nDir) )
    {
      if ($handle = opendir($nDir)) 
      {
        while (false !== ($file = readdir($handle))) 
        {
          if ( !is_dir($nDir.$file) )
          {
            if ($pre == "" )
            {
              $arrFile[] =  "$file";
            }else
            {
              $l = strlen( $pre );
              if( $pre == substr( $file, 0, $l ) &&
                  !strpos( $file, "RAD" )
                )
                $arrFile[] =  "$file";
            }// End if ($pre == "" )
          }// End if ( !is_dir($nDir.$file) )
        }// End while (false !== ($file = readdir($handle)))
        closedir($handle);
      }// End if ($handle = opendir($nDir))
    }// End if ( file_exists($nDir) && is_dir($nDir) )
    return( $arrFile  );
  }// End function getFile( $nDir, $sufixo = "" ) 



  /**
   *  getDir()
   *
   *  pega os nome dos Diretorios
   *
   *  $nDir = nome do Diretorio base
   *  retorna: Array associativo com os nomes dos Diretorios
   */
  function getDir( $nDir )
  {
    $arrFile = array();
    if ( file_exists($nDir) && is_dir($nDir) )
    {
      if ($handle = opendir($nDir))
      {
        while (false !== ($file = readdir($handle)))
        {
          if ( is_dir($nDir . $file) &&
               $file != '.' && $file != '..'
             )
          {
            $arrFile[] =  "$file";
          }
        }
        closedir($handle);
      }// End if()
    }// End if ( file_exists($nDir) && is_dir($nDir) )
    return( $arrFile  );
  }// End function getFile( $nDir, $sufixo = "" )


/**
 *  writeTO()
 *
 *  escreve uma String no dispositivo indicado
 *
 *  $texto = String a ser escrita
 *  retorna: boolean
 */
function writeTO( $texto_, $alvo_ = "HTML" )
{
  if ( $alvo_ == "HTML")
  {
    echo( $texto_ . NEWLINE );
  }else
  {
//echo('dest: '.$alvo_."\n");
//echo('text: '.$texto_."\n");exit;
    fwrite( $alvo_, $texto_ . NEWLINE );
  }// End if ( $alvo_ == "HTML")
  return( true );
}// End function writeTO()





/**
 * writeINIfile()
 *
 *  Escreve no arquivo .ini
 *
 *  $filename = nome do arquivo a ser Escrito
 *  $array1 = Array com os Itens para ser escritos
 *  $commentchar = Caracter utilizado como marcador de Comentrio
 *  $commenttext = Comentrio a ser escrito
 *  retorna: boolean
 */
function writeINIfile($filename, $array1, $commentchar, $commenttext)
{
  $handle = @fopen($filename, 'wb');
  
  if ( $commenttext != '' )
  {
    $comtext = $commentchar.
    str_replace($commentchar, "\r\n".$commentchar,
      str_replace("\r", $commentchar,
        str_replace("\n", $commentchar,
          str_replace("\n\r", $commentchar,
            str_replace("\r\n", $commentchar, $commenttext)
          )
        )
      )
    );
    if ( substr($comtext, -1, 1) == $commentchar &&
         substr($comtext, -1, 1) != $commentchar)
    {
     $comtext = substr( $comtext, 0, -1 );
    }
    @fwrite ( $handle, $comtext."\r\n" );
  }// End if()
  
  foreach ($array1 as $sections => $items)
  {
    //Write the section
    if (isset($section))
    {
      @fwrite ($handle, "\r\n");
    }// End if()
    
    //$section = ucfirst(preg_replace('/[\0-\37]|[\177-\377]/', "-", $sections));
    $section = ucfirst(preg_replace('/[\0-\37]|\177/', "-", $sections));
    @fwrite ( $handle, "[".$section."]\r\n" );

    foreach ($items as $keys => $values)
    {
      //Write the key/value pairs
      //$key = ucfirst(preg_replace('/[\0-\37]|=|[\177-\377]/', "-", $keys));
      //$key = ucfirst(preg_replace('/[\0-\37]|=|\177/', "-", $keys));
      $key = preg_replace('/[\0-\37]|=|\177/', "-", $keys);

      if ( substr($key, 0, 1) == $commentchar)
      {
        $key = '-'.substr($key, 1);
      }
      //$value = ucfirst(addcslashes($values,''));
      $value = addcslashes($values,'');
      //@fwrite( $handle, '    ' . $key . ' = "' . $value . "\"\r\n" );
      @fwrite( $handle, '    ' . $key . ' = ' . $value . "\r\n" );

    }//End foreach()
  }// End foreach()
  
  fclose($handle);
  return(true);
}

/**
 * readINIfile()
 *
 *  Le o arquivo .ini para um array associativo
 *
 *  $filename = nome do arquivo a ser Lido
 *  $commentchar = Caracter utilizado como marcador de Comentrio
 *  retorna: Array contendo os Itens do arquivo
 */
function readINIfile( $filename, $commentchar = ";" )
{
  $array1 = array();
  $array2 = array();
  if( file_exists( $filename ) )
  {
    $array1  = @file( $filename );
    $section = '';
    foreach ( $array1 as $filedata )
    {
     $dataline  = trim($filedata);
     $firstchar = substr($dataline, 0, 1);
     if ( $firstchar != $commentchar && $dataline != '' )
     {
       //It's an entry (not a comment and not a blank line)
       if ($firstchar == '[' && substr($dataline, -1, 1) == ']')
       {
         //It's a section
         //$section = substr( $dataline, 1, -1 );
         $section = strtolower( substr( $dataline, 1, -1 ) );
         //$section = ucfirst( $section );
       }else
       {
         //It's a key...
         $delimiter = strpos($dataline, '=');
         

         if ($delimiter > 0)
         {
           //...with a value
           //$key   = strtolower( trim( substr($dataline, 0, $delimiter) ) );
           $key   = trim( substr($dataline, 0, $delimiter) );

           $value = trim( substr( $dataline, $delimiter + 1) );

           if ( substr($value, 1, 1) == '"' &&
                substr($value, -1, 1) == '"')
           {
             $value = substr($value, 1, -1);
           }
           $array2[$section][$key] = stripcslashes($value);
         }else
         {
           //...without a value
           //$array2[$section][strtolower(trim($dataline))] = '';
           $array2[$section][ trim($dataline) ] = '';
         }
       }
     }else
     {
       //It's a comment or blank line.  Ignore.
     }
    }
  }
  return( $array2 );
}

function getPrimaryKeyOf($table)
{
  $keys = Array();

  $query = sprintf("SHOW KEYS FROM `%s`", $table);
  $result = mysql_query($query) or die(mysql_error());

  while ($row = mysql_fetch_assoc($result))
  {
    if ( $row['Key_name'] == 'PRIMARY' )
    $keys[$row['Seq_in_index'] - 1] = $row['Column_name'];
  }// End while

  return $keys;
}// end function

/**
 *  getTableInformationOf()
 *  retorna um array associativo com os dados da Tabela fornecida
 *
 *  array
 *  (
 *    [auto] => nome da coluna auto_incremento
 *    [primary] => array
 *    (
 *       [0] => nome da(s) coluna(s) da chave primaria
 *    )
 *    [fields] => array
 *    (
 *      [0] => array
 *      (
 *        [Field]   => nome do campo
 *        [Type]    => tipo do campo
 *        [Null]    => yes ou no para NOT NULL
 *        [Key]     => nome da chave
 *        [Default] => valor padro
 *        [Extra]   => valor extra
 *      )
 *    )
 *  )
 */
function getTableInformationOf( $table )
{
  $information = array(
    "auto" => "",
    "primary" => array(),
    "fields" => array()
  );

  $information['primary'] = getPrimaryKeyOf($table);
  $result = mysql_query("DESC `$table`");
  while ( $field = mysql_fetch_assoc($result) )
  {
    $information['fields'][] = $field;
    if ( $field['Extra'] == "auto_increment" )
      $information['auto'] = $field['Field'];
  }

  return $information;
}// End function

function getNameLib( $nLib )
{
  switch( $nLib )
  {
    case 'dbedit':
      $ret = "dbEdit";
      break;
    case 'dbnavigator':
      $ret = "dbNavigator";
      break;
    case 'dbgrid':
      $ret = "dbGrid";
      break;
    default:
      $ret = $nLib;
  }// End
  return( $ret );
}// End function getNameLib( nLib )




/**
 *  retorna um array com a lista dos arquivos do Framework
 */
function getNameFile_framework()
{
  $arrFile = array();
  $arr_core = array(
    'rpcServer.dataAccess.php',
    'rpcServer.Studio.php'
    );

  $arr_include = array(
    'EventoGlobal.js',
    'EventoMouse.js',
    'EventoTeclado.js'
    );
  $arr_lib_JS = array(
    'control.js',
    'dataAccess.js',
    'findDOM.js',
    'jsrsClient.js',
    'jsrsCore.js',
    'wddx.js',
    'wddxDes.js'
    );
  $arr_lib_PHP = array(
    'JsrsServer.class.php',
    'PhPage.lib.php',
    'Studio.lib.php'
    );




  $arrSub = array(
      'FireFox',
      'MSIE',
      'NetScape',
      'Opera'
      );

  $arrDir = array(
    'core'    => false,
    'include' => true,
    'lib_JS'  => true,
    'lib_PHP' => false,
    );

  $idx = 0;
  foreach( $arrDir as $dir => $subDir )
  {
    $tmp = "arr_" . $dir;
    $arr = $$tmp;
    if( $subDir )
    {
      foreach( $arrSub as $sub )
      {
        foreach( $arr as $file )
        {
          //echo(  '<b>' . $dir . '/' . $sub . '/</b>' . $file . "<br>" );
          $arrFile[] = $dir . '/' . $sub . '/' . $file;
        }// End foreach( $arr as $file )
        //echo('<br>');
      }// End foreach( $arrSub as $sub )
    }else
    {
      foreach( $arr as $file )
      {
        //echo(  '<b>' . $dir . '/</b>' . $file . "<br>" );
        $arrFile[] = $dir . '/' . $file;
      }// End foreach( $arr as $file )
      //echo('<br>');
    }// End if( $subDir )

  }// End foreach( $arrDir as $dir => $subDir )
  return $arrFile;
}// End function getNameFile_framework()


?>

