<?php
include("../config.php");

function convdate($timestamp)
{
	$day = substr($timestamp, 6, 2);
	$month = substr($timestamp, 4, 2);
	$year = substr($timestamp, 0, 4);
	return $day . "/" . $month . "/" . $year;
}

$timer['start'] = microtime();

function parsetohtml($data) {
	//Replace [url="link"]text[/url] tags with <a href ones... (This regular expression is based on one found in the phpfreaks forums
	$data = preg_replace('/\[url=http:\/\/([^<]*)\]([^<]*)\[\/url\]/',"<a href=\"http://\$1\">$2</a>",$data);
	
	//Replace [img] tags with <img ones... (BIGA wrote the regular expression for this...)
	$data = preg_replace("/\[(IMG|img)\](.*?)\[\/(IMG|img)\]/","<img src=\"$2\" alt=\"User Posted Image\"</img>",$data);
	
	//Replace [b] tags with <b> ones... (BIGA wrote the regular expression for this...)
	$data = preg_replace("/\[(B|b)\](.*?)\[\/(B|b)\]/","<b>$2</b>",$data);
	
	return $data;
} //End Function Parse

function parsetobbc($data) {
	//Replace [url] tags with <a href ones...
	$data = str_replace("<a href=\"", "[url=", $data);
	$data = str_replace("\">", "]", $data);
	$data = str_replace("</a>", "[/url]", $data);
		
	//Replace [img] tags with <img ones...
	$data = str_replace("<img src=\"", "[img]", $data);
	$data = str_replace("\" alt=\"geoBlog: User Posted Image\">", "[/img]", $data);
	
	//Replace [b] tags with <b> ones...
	$data = str_replace("<b>", "[b]", $data);
	$data = str_replace("</b>", "[/b]", $data);
	
	return $data;
} //End Function Parse
?>