<?php
require('./admin/config.inc.php');
require('./include/constants.inc.php');
require('./include/db_mysql.inc.php');
require('./include/functions.inc.php');

// ############################ local functions
function page_header() {
echo <<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html dir="ltr">
<head>
	<title>Minhas Fotos : Instalao</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<style type="text/css" media="all">@import "./templates/Silver/style.css";</style>
	<style type="text/css" media="all">
	</style>
</head>
<body>
<h1><b>Script de instalao do MF no seu site.</b></h1>

EOF;
}
function page_footer() {

echo <<<EOF
<p class="copyright">MF&copy; by PN3.NET</p>
</body>
</html>
EOF;
	exit;
}
function dodb_queries() {
	global $DB_site,$sql,$explain,$onvservers;
	while (list($key,$val)=each($sql))
	{
		if(!empty($explain[$key]))
		{
			echo "<p class='messagebox'>$explain[$key]</p>\n";
		}
		echo "<!-- ".htmlspecialchars($val)." -->\n\n";
		flush();
		if ($onvservers==1 && substr($val, 0, 5)=="ALTER")
		{
			$DB_site->reporterror=0;
		}
		$DB_site->query($val);
		if ($onvservers==1 && substr($val, 0, 5)=="ALTER")
		{
			$DB_site->connect();
			$DB_site->reporterror=1;
		}
	}
	unset($query);
	unset($explain);
}
function gotonext($extra='') {
	global $step,$thisscript;
	
	$nextstep = $step+1;
	echo "<p class='smallbox'><a href='$thisscript?step=$nextstep'><b>Clique aqui para continuar ==&gt;&gt;</b></a> $extra</p>";
}

function stripslashesarray(&$arr) {
	while (list($key,$val) = each($arr))
	{
		if ((strtoupper($key)!=$key || "".intval($key)=="$key") && $key!="argc" && $key!="argv")
		{
			if(is_string($val))
			{
				$arr[$key] = stripslashes($val);
			}
			if(is_array($val))
			{
				$arr[$key] = stripslashesarray($val);
			}
		}
	}
	return $arr;
}

// ################################## local settings
error_reporting(E_ERROR | E_WARNING | E_PARSE);
set_magic_quotes_runtime(0);
$thisscript = 'install.php';

if (get_magic_quotes_gpc() and is_array($GLOBALS))
{
	$GLOBALS = stripslashesarray($GLOBALS);
}
if(!empty($HTTP_GET_VARS)) {
	while(list($xxxname, $value) = each($HTTP_GET_VARS)) {
		$$xxxname = $value;
    }
}
if(!empty($HTTP_POST_VARS)){
	while(list($xxxname, $value) = each($HTTP_POST_VARS)) {
		$$xxxname = $value;
	}
}

// ################################## local pages
if($action=='uninstall')
{
	$sql = "DROP TABLE ".DBTBL_CATS." ";
	$sql = "DROP TABLE ".DBTBL_COMMENTS." ";
	$sql = "DROP TABLE ".DBTBL_CONFIG." ";
	$sql = "DROP TABLE ".DBTBL_PHOTOS." ";
	dodb_queries();
	page_header();
	echo '<p class="messagebox">Desinstalao completa do programa. Todos os arquivos do Banco de dados foram removidos</p>';
	page_footer();
	
}

if(empty($step))
{
	page_header();
	echo '<p class="messagebox">Prximo passo: verificar conexo com o banco de dados MySQL utilizando as configuraes que voc editou no arquivo config.inc.php </p>';
	gotonext();
	page_footer();
}
if ($step == 1)
{
	$DB_site=new DB_Sql;
	$DB_site->server = $hostname;
	$DB_site->user = $dbuser;
	$DB_site->password = $dbpass;
	$DB_site->database = $dbname;
	$DB_site->reporterror=0;
	$DB_site->connect();
	$errno = $DB_site->errno;
	$dbpass='';
	$DB_site->password='';
	page_header();
	if ($DB_site->link_id != 0)
	{
		if ($errno != 0)
		{
			if ($errno =='1049')
			{
				echo '<p class="messagebox">Voc especificou um banco de dados inexistente. Tentando criar um agora...</p>';
				$DB_site->query(" CREATE DATABASE $dbname ");
				echo '<p class="messagebox">Tentando conectar-se ao banco de dados novamente...</p>';
				$DB_site->select_db($dbname);
				$errno=$DB_site->geterrno();
				if ($errno==0)
				{
					echo '<p class="messagebox">Conexo realizada com sucesso!</p>';
					gotonext();
				}else{
					echo '<p class="messagebox">Conexo no realizada! Verifique se o banco de dados esta configurado corretamente e tente novamente.</p>';
				}
			}else{
				echo '<p class="messagebox">Conexo no realizada: Um erro inesperado ocorreu.</p>';
				echo '<p class="messagebox">Erro nmero: '.$DB_site->errno.'</p>';
				echo '<p class="messagebox">Descrio do erro: '.$DB_site->errdesc.'</p>';
				echo '<p class="messagebox">Por favor tenha certeza que o seu banco de dados est corretamente configurado e tente novamente.</p>';
				exit;
			}
		}else{
			echo '<p class="messagebox">Conexo realizado com sucesso! O banco de dados especificado existe.</p>';
			gotonext();
		}
	}else{
		echo '<p class="messagebox">Houve falha na conexo pois voc no tem acesso ao servidor de banco de dados. Verifique novamente os dados que vc utilizou no arquivo config.inc.php e tente novamente. Caso persista o erro ento contate a sua provedora de hospedagem para pedir maiores esclarecimentos sobre como acessar o servidor de banco de dados MySQL.</p>';
	}
	page_footer();
}

if($step > 2)
{
	$DB_site=new DB_Sql;
	$DB_site->server=$hostname;
	$DB_site->user=$dbuser;
	$DB_site->password=$dbpass;
	$DB_site->database=$dbname;
	$DB_site->connect();
	$dbpass='';
	$DB_site->password='';
	$onvservers = 1;
}

if($step==2)
{
	page_header();
	echo '<p class="messagebox">Prximo passo: Popular o banco de dados com a estrutura das tabelas do necessrias ao programa.</p>';
	gotonext();
	page_footer();
}

if($step==3)
{

// ############################
$sql[] = "CREATE TABLE ".DBTBL_CATS." (
  cat_id int(11) unsigned NOT NULL auto_increment,
  cat_parent int(11) NOT NULL default '0',
  cat_name varchar(100) NOT NULL default '',
  cat_desc tinytext NOT NULL,
  cat_order smallint(6) NOT NULL default '0',
  cat_nphoto tinyint(4) unsigned NOT NULL default '0',
  cat_commdate int(10) NOT NULL default '0',
  cat_date int(10) NOT NULL default '0',
  UNIQUE KEY cat_id (cat_id)
)";
$explain[] = 'Criando tabela das categorias';

$sql[] = "CREATE TABLE ".DBTBL_CONFIG." (
  conf_id int(10) unsigned NOT NULL auto_increment,
  conf_varname varchar(20) NOT NULL default '',
  conf_value tinytext NOT NULL,
  conf_order tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (conf_id),
  UNIQUE KEY conf_varname (conf_varname)
)";
$explain[] = 'Criando tabela de configuraes';
$sql[] = "CREATE TABLE ".DBTBL_COMMENTS." (
  msg_id int(11) unsigned NOT NULL auto_increment,
  photo_id int(11) NOT NULL default '0',
  msg_text tinytext NOT NULL,
  msg_name varchar(50) NOT NULL default '',
  msg_ip varchar(15) NOT NULL default '',
  msg_date int(10) NOT NULL default '0',
  UNIQUE KEY msg_id (msg_id),
  KEY photo_id (photo_id)
)
";
$explain[] = 'Criando tabela das comentrios';
$sql[] = "
CREATE TABLE ".DBTBL_PHOTOS." (
  photo_id int(11) unsigned NOT NULL auto_increment,
  cat_id int(11) NOT NULL default '0',
  photo_title varchar(50) NOT NULL default '',
  photo_desc mediumtext NOT NULL,
  photo_file varchar(100) NOT NULL default '',
  photo_thm varchar(100) NOT NULL default '',
  photo_size int(10) unsigned NOT NULL default '0',
  photo_date datetime NOT NULL default '0000-00-00 00:00:00',
  photo_ncomm int(10) unsigned NOT NULL default '0',
  photo_lastcomm int(10) NOT NULL default '0',
  photo_votes int(11) NOT NULL default '0',
  photo_nvotes int(11) NOT NULL default '0',
  photo_rate tinyint(5) NOT NULL default '0',
  photo_hits smallint(6) NOT NULL default '0',
  UNIQUE KEY photo_id (photo_id)
)
";
$explain[] = 'Criando tabela das fotos';
page_header();
dodb_queries();
gotonext();
page_footer();
}

if ($step == 4)
{
	if (!defined('VC_IS_WINDOWS'))
	{
		if (defined('PHP_OS') && eregi('win', PHP_OS))
		{
			define('SLASH_SIGN', '\\');
		}else{
			define('SLASH_SIGN', '/');
		}
	}
	page_header();
	$thisscript = 'install.php';
	$old_step = $step -1;
	$base_url = str_replace("install.php?step=$old_step",'',getenv('HTTP_REFERER'));
	$base_path = str_replace(SLASH_SIGN.'install.php','',getenv('PATH_TRANSLATED')).SLASH_SIGN;
	$base_url = empty($base_url)? 'http://'.getenv('SERVER_NAME') . str_replace('install.php','',getenv('SCRIPT_NAME')) : $base_url ;
	?>
<div class="form">

<form action="install.php" method="post">
<h5>Nome do site:<br /><input type="text" name="site_name" size="50" maxlength="60" value="Nome do Site" /></h5>
<h5>URL at site:<br /><input type="text" name="site_url" size="50" maxlength="60" value="<?php echo $base_url; ?>" /></h5>
<h5>Caminho (path*) at o diretrio do site:<br /><input type="text" name="site_dir" size="50" maxlength="60" value="<?php echo $base_path; ?>" /></h5>
<h5>URL at o diretrio das fotos:<br /><input type="text" name="img_url" size="50" maxlength="60" value="<?php echo $base_url.'images/'; ?>" /></h5>
<h5>Caminho (path*) at o diretrio das fotos:<br /><input type="text" name="img_dir" size="50" maxlength="60" value="<?php echo $base_path.'images'.SLASH_SIGN; ?>" /></h5>
<h5><input type="submit" value="Continue" /></li>
<input type="hidden" name="step" value="<?php echo $step+1; ?>" />
</form>
<blockquote>
<b>*</b> PATH:<br />
Se refere ao caminho completo at o diretrio em questo.<br />
Dependendo do sistema operacional onde voc est hospedado o caminho  diferente tem um jeito diferente de escrever.<br />
<b>Windows</b><br />
vai ser algo do tipo: C:/inetpub/www/jose/MinhasFotos/diretorio
<br />
<b>Unix</b>
vai ser algo do tipo: /home/jose/public_html/MinhasFotos/diretorio
<br />
<br />
Em ambos os sistemas operacionais  prefervel que utilize / ao invs de \
<br />
<br />
Informe-se com a sua provedora de espao ou um amigo experiente para descobrir essa informao, caso voc no tenha a menor idia do que fazer.
</blockquote>

</div>
<?php
page_footer();
}

if($step==5)
{
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (1, 'site_name', '".addslashes($site_name)."', 1) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (2, 'site_url', '".addslashes($site_url)."', 2) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (3, 'site_dir', '".addslashes($site_dir)."', 3) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (4, 'img_url', '".addslashes($img_url)."', 4) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (5, 'img_dir', '".addslashes($img_dir)."', 5) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (6, 'lang', 'portuguese-br', 6) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (7, 'timezone', '-3', 7) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (8, 'datetime_format', 'd/m/Y H:i', 8) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (9, 'date_format', 'd/m/Y', 9) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (10, 'skin', 'Silver', 10) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (11, 'img_per_page', '9', 11) ";
	$sql[] = "INSERT INTO ".DBTBL_CONFIG." VALUES (12, 'img_cols_per_page', '3', 12) ";
page_header();
dodb_queries();
echo '<p class="messagebox">Configuraes bsicas armazenadas no banco de dados </p>';
gotonext();
page_footer();
}

if($step==6)
{
	page_header();
	echo '<h3>Instalao completada com sucesso!</h3>';
	echo '<p class="messagebox">Visite o <a href="./admin/"><b>painel de controle</b></a> e divirta-se.</p>';
	page_footer();
}
?>