<?php
define('VALIDATION_INC', TRUE);
/*********************************************************************************************************** 
*   Author : Nick Geller
*   Description : user data type validation
*   Date : August 18, 2001 | version 1.3 revised
*
*   Fixes:
*      1.1)email functionality added thanks to Henry.W
*      1.2)also the alpha function has been modified to accept spaces
*      1.3)global classArgArray now flushes previous data thanks to Vitaly.F
*
*   This class expects 2 variables
*      1. user defined data
*      2. configuration string
*   returns false if the field passes all the validation test, passed in the configuration string
*
*   *NOTE* this class returns false if passed field validates against the requered test
*   This was done to avoid the if(! syntax for usage
*
*   expected format of the configuration string:
*   "ls||INT||gt||INT||eq||INT||match||STRING||has||CHAR||not||STRING||alpha||numeric||email"
*   any one of these or all are expected in the configuration string, but must follow the format!!!
*
*   CLASS ABBRIVIATIONS :
*
*   ls = cant be less than this number, requires a number
*   gt = cant be greater than this number, requires a number
*   eq = string size has to be equal to this number
*   match = string must match this string
*   has = string must contain this character
*   not = string can not match this string
*   alpha = all characters in a string must be alphabetical
*   numeric = all characters must be numneric
*   email = validates string to be of similar nature as an email address
*
**********************************************************************************************************/ 
class validation 
{ 

	var $config_string;                       /* validation definition string */ 
	var $field;                               /* user defined data type */ 
	var $classArgArray;                       /* actions for the validation */ 
	var $error;                               /* errors retured by the validate_field function */ 

	function validate($configStr, $passedField) { 
	
		$this->classArgArray = array(); 
		$this->error = false; 
		$this->config_string = trim($configStr); 
		$this->field = trim($passedField);
		$this->buildProperties();
		$this->validate_field();
		return $this->error; 
	} 
	
	function buildProperties() 
	{ 
		$argumentsArray = explode('||', $this->config_string);
		for($i=0; $i< sizeOf($argumentsArray); $i++)
		{
			if($argumentsArray[$i] == 'ls' || $argumentsArray[$i] == 'gt' || $argumentsArray[$i] == 'eq')
			{
				if(eregi("^[0-9]+$", $argumentsArray[$i+1]))
				{
					$this->classArgArray[] = $argumentsArray[$i];
					$this->classArgArray[] = $argumentsArray[$i+1];
				}
			}else if($argumentsArray[$i] == 'match' || $argumentsArray[$i] == 'has' || $argumentsArray[$i] == 'not'){ 
				if(isset($argumentsArray[$i+1]) && !$argumentsArray[$i+1] =='') 
				{
					if($argumentsArray[$i+1] != 'ls' || $argumentsArray[$i+1] != 'gt' 
						|| $argumentsArray[$i+1] != 'eq' || $argumentsArray[$i+1] != 'match'  
						|| $argumentsArray[$i+1] != 'has' || $argumentsArray[$i+1] != 'alpha'  
						|| $argumentsArray[$i+1] != 'numeric' || $argumentsArray[$i+1] != 'not' 
						|| $argumentsArray[$i+1] != 'email')
					{
						$this->classArgArray[] = $argumentsArray[$i];
						$this->classArgArray[] = $argumentsArray[$i+1];
					}
				}
			}else if ($argumentsArray[$i] == 'numeric' || $argumentsArray[$i] == 'alpha' || $argumentsArray[$i] == 'email'){
				$this->classArgArray[] = $argumentsArray[$i]; 
			}
		}
	}
	
	function validate_field() 
	{ 
		$field_string_size = strlen($this->field); /* field string size */ 
		for($j = 0; $j < sizeOf($this->classArgArray); $j++) 
		{ 
			switch($this->classArgArray[$j]) 
			{
				case 'ls': 
					/* field is less than minimum required lenth */ 
					if($field_string_size < $this->classArgArray[$j+1]) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'gt':
					/* field is greater than maximum allowed lenth */ 
					if($field_string_size > $this->classArgArray[$j+1]) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'eq': 
					/* field is does not equal to required lenth */ 
					if($field_string_size != $this->classArgArray[$j+1]) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'match': 
					/* field does not match a required value */ 
					if($this->field != $this->classArgArray[$j+1]) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'alpha': 
					/* only alphabetical characters are required for this field */ 
					if(!eregi("^[a-zA-Z\ ]+$",  $this->field)) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'numeric': 
					/* only numeric characters are required for this field*/ 
					if(!eregi("^[0-9]+$",  $this->field)) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'has': 
					/* field does not contain a required character */ 
					if(!strstr($this->field, $this->classArgArray[$j+1])) 
					{ 
					   $this->error = true; 
					} 
					break; 
				case 'not': 
					/* fields value is not acceptable */ 
					if(!$this->field == $this->classArgArray[$j+1]) 
					{ 
					   $this->error = true; 
					} 
					break; 
		        case 'email': 
					/* fields value is not acceptable */ 
					if(!preg_match("/^\s*[^@ \r\n\t\#\$\%\;]+@[^@ \r\n\t\#\$\%\;]+\.\w{2,4}\s*$/", $this->field)) 
					{ 
			        	$this->error = true; 
					} 
					break; 
			} 
		} 
	} 
} 
?>