<?php
define('FUNCTIONS_INC', TRUE);
/* ******************* Array Manipulation ******************** */
function view_array($array) {

	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($array as $key1 => $elem1)
	{
		echo '<tr>';
		echo '<td>'.$key1.'&nbsp;</td>';
		if(is_array($elem1)){
			ext_array($elem1);
		}else{
			echo '<td>'.htmlspecialchars($elem1).'&nbsp;</td>';
		}
		echo '</tr>';
	}
	echo '</table>';
}
function ext_array($array)
{
	echo '<td>';
	echo '<table cellpadding="0" cellspacing="0" border="1">';
	foreach ($array as $key => $elem)
	{
		echo '<tr>';
        echo '<td>'.$key.'&nbsp;</td>';
        if (is_array($elem))
		{
			ext_array($elem);
		}else{
			echo '<td>'.htmlspecialchars($elem).'&nbsp;</td>';
		}
		echo '</tr>';
	}
    echo '</table>';
    echo '</td>';
}
/* ******** Categories Array ********* */
function recount_nphoto_cat()
{
	global $DB_site;
	
	$sql = "SELECT * FROM ".DBTBL_CATS." ";
	$data_arr = $DB_site->query($sql);
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$sql = "SELECT count(photo_id) AS count FROM ".DBTBL_PHOTOS." WHERE cat_id='".$row['cat_id']."' ";
		$counter = $DB_site->query_first($sql);
		$sql = "UPDATE ".DBTBL_CATS." SET cat_nphoto='". $counter['count'] . "' WHERE cat_id='".$row['cat_id']."' ";
		$DB_site->query($sql);
	}
	$DB_site->free_result($data_arr);
}


/* ******************* String Manipulation ******************** */
function append_sid($url, $non_html_amp = false) {
	global $MYSID;
	if ( !empty($MYSID) && !eregi('sid=', $url) )
	{
		$url .= ( ( strpos($url, '?') != false ) ?  ( ( $non_html_amp ) ? '&' : '&amp;' ) : '?' ) . $MYSID;
	}
	return($url);
}
/* ******************* File & Dir Manipulation ******************* */
function get_file_extension($uri_file) {

	$uri_file = strtolower($uri_file);
	$ext = split("[/\\.]", $uri_file);
	$n = count($ext)-1;
	return $ext[$n];
}
function get_file_name($uri_file,$only=false) {
	$arr = split("[/\\]",$uri_file);
	$n = count($arr)-1;
	$file_name = $arr[$n];
	if($only)
	{
		$arra = explode('.',$file_name);
		$n = count($arra)-1;
		return str_replace('.'.$arra[$n],'',$file_name);
	}else{
		return $file_name;
	}
}
function get_curr_dir($uri_file) {
	$arr = split("[/\\]",$uri_file);
	$n = count($arr)-1;
	return str_replace($arr[$n],'',$uri_file);
}

/* ******************* Cookies ******************** */
function my_setcookie($name,$value="",$permanent=1) {
	$cookiepath = '/';
	$cookiedomain = '';
	$SERVER_PORT = '';
	$expire = ($permanent)? time() + 60*60*24*365 : 0;
	if ($SERVER_PORT == '443')
	{
		$secure = 1; // we're using SSL
	}else{
		$secure = 0;
	}
	if ($cookiedomain)
	{
    	setcookie($name, $value, $expire, $cookiepath, $cookiedomain, $secure);
	}else{
		setcookie($name, $value, $expire, $cookiepath, '', $secure);
	}
}

/* ******************* String Parse ******************** */
function parse_smile($string) {
	global $cfg;
	
	$dir_smiles = $cfg['site_url'].'templates/'.$cfg['skin'].'/images/smilies';
	$smiles = array(
	':/' => "<img src='$dir_smiles/slant.gif' border='0' alt='' />",
	':|' => "<img src='$dir_smiles/straight.gif' border='0' alt='' />",
	':D' => "<img src='$dir_smiles/grin.gif' border='0' alt='' />",
	':)' => "<img src='$dir_smiles/smile.gif' border='0' alt='' />",
	':(' => "<img src='$dir_smiles/sad.gif' border='0' alt='' />",
	':P' => "<img src='$dir_smiles/tong.gif' border='0' alt='' />",
	'8)' => "<img src='$dir_smiles/cool.gif' border='0' alt='' />",
	'8P' => "<img src='$dir_smiles/cooltong.gif' border='0' alt='' />",
	'8O' => "<img src='$dir_smiles/coolmouth.gif' border='0' alt='' />",
	'8(' => "<img src='$dir_smiles/coolsad.gif' border='0' alt='' />",
	'%)' => "<img src='$dir_smiles/dazed.gif' border='0' alt='' />",
	'%O' => "<img src='$dir_smiles/dazedmouth.gif' border='0' alt='' />",
	'%(' => "<img src='$dir_smiles/dazedsad.gif' border='0' alt='' />",
	'%P' => "<img src='$dir_smiles/dazedtong.gif' border='0' alt='' />",
	':O' => "<img src='$dir_smiles/mouth.gif' border='0' alt='' />",
	';)' => "<img src='$dir_smiles/wink.gif' border='0' alt='' />",
	';O' => "<img src='$dir_smiles/winkmouth.gif' border='0' alt='' />",
	';(' => "<img src='$dir_smiles/winksad.gif' border='0' alt='' />",
	';P' => "<img src='$dir_smiles/winktong.gif' border='0' alt='' />"
	);
	foreach ($smiles as $smile => $image)
	{
		$string = str_replace($smile, $image, $string);
	}
	return $string;
}

/* ******************* Page Messages ******************** */
function message_die($msg_case,$msg_text) {
	global $TPL_site,$msg,$cfg,$MYFORMSID;
	$page_title = $msg['page_error'];
	if(!defined('HEADER_INC'))
	{
		if(defined('IN_ADMIN'))
		{
			include($cfg['root_path'].'admin/'.FILE_ADM_HEADER);
		}else{
			include($cfg['root_path'].'include/'.FILE_USR_HEADER);
		}
	}
	$TPL_site->set_filenames(array(
				'message_body' => 'message_body.html'
				));
	switch($msg_case)
	{
		case GENERAL_MESSAGE:
			$msg_title = $msg['error_information'];
			break;
		case CRITICAL_MESSAGE:
			$msg_title = $msg['error_critical_information'];
			break;
		case GENERAL_ERROR:
			$msg_text = empty($msg_text)? $msg['error_an_error_occured'] : $msg_text;
			$msg_title = $msg['error_general_error'];
			break;
		case CRITICAL_ERROR:
			$msg_text = empty($msg_text)? $msg['error_a_critical_error'] : $msg_text;
			$msg_title = '<b>' . $msg['error_critical_error'] . '</b>';
			break;
	}
	$TPL_site->assign_vars(array(
			'MSG_TITLE' => $msg_title,
			'MSG_TEXT' => $msg_text,
			'HTML_HIDDEN_FIELDS' => $MYFORMSID
			));
	$TPL_site->pparse('message_body');
	if(!defined('FOOTER_INC'))
	{
		if(defined('IN_ADMIN'))
		{
			include($cfg['root_path'].'admin/'.FILE_ADM_FOOTER);
		}else{
			include($cfg['root_path'].'include/'.FILE_USR_FOOTER);
		}
	}
	exit;
}
function message_confirm($msg_case,$value) {
	global $TPL_site,$msg,$cfg,$MYFORMSID;
	if(!defined('HEADER_INC'))
	{
		if(defined('IN_ADMIN'))
		{
			include($cfg['root_path'].'admin/'.FILE_ADM_HEADER);
		}else{
			include($cfg['root_path'].'include/'.FILE_USR_HEADER);
		}
	}
	$TPL_site->set_filenames(array(
				'message_body' => 'admin/message_confirm.html'
				));
	$msg_title = $msg['a_confirm_operation_title'];
	switch($msg_case)
	{
		case ACTION_ADD:
			$msg_text = $msg['error_information'];
			$action = 'add2';
			break;
		case ACTION_EDIT:
			$msg_text = $msg['error_critical_information'];
			$action = 'edit2';
			break;
		case ACTION_DELETE:
			$msg_text = $msg['a_confirm_operation_delete'];
			$action = 'delete2';
			break;
	}
	$_html_hidden_fields = $MYFORMSID.'<input type="hidden" name="action" value="'.$action.'" />';
	reset($value);
	while(list($k, $v) = each($value))
	{
		$_html_hidden_fields .= '<input type="hidden" name="'.$k.'" value="'.$v.'" />';
	}
	
	$TPL_site->assign_vars(array(
			'FORM_HIDDEN_FIELDS' => $_html_hidden_fields,
			'FORM_ACTION' => CURR_MF_FILE,
			'L_SUBMIT' => $msg['a_confirm_operation_imsure'],
			'L_RESET' => $msg['a_confirm_operation_no'],
			'MSG_TITLE' => $msg_title,
			'MSG_TEXT'=> $msg_text,
			));
	$TPL_site->pparse('message_body');
	if(defined('IN_ADMIN'))
	{
		include($cfg['root_path'].'admin/'.FILE_ADM_FOOTER);
	}else{
		include($cfg['root_path'].'include/'.FILE_USR_FOOTER);
	}
	exit;
}
function redirect_die($url){
	global $msg;
	
	if(defined('HEADER_INC'))
	{
		echo '<script type="text/javascript">window.location="'.$url.'";</script>';
		echo '<p><a href="'.$url.'">'.$msg['continue'].'</a></p>';
	}else{
		@header("Location: $url");
	}
	exit;
}

/* ************ cat manipulation *************** */
function make_cat_tree(){
	global $DB_site;
	
	$sql = "SELECT * FROM ".DBTBL_CATS." ORDER BY cat_order ASC ";
	$data_arr = $DB_site->query($sql);
	while($row=$DB_site->fetch_array($data_arr))
	{
		$arr[] = array(
			'cat_id' => $row['cat_id'],
			'cat_parent' => $row['cat_parent'],
			'cat_name' => stripslashes($row['cat_name']),
			'cat_desc' => stripslashes($row['cat_desc']),
			'cat_order' => $row['cat_order'],
			'cat_nphoto' => $row['cat_nphoto'],
			'cat_commdate' => $row['cat_commdate'],
			'cat_date' => $row['cat_date']
		);
	}
	$DB_site->free_result($data_arr);
	return $arr;
}
function get_cat_rows($cat_id=0,$insubcat=false) {
	global $TPL_site,$cfg;
	global $mfc_current_set,$cat_tree_arr,$cat_level;
	
	$cat_level++;
	//echo $level.'<br>';
	if($level>2){
		return true;
	}
	$_block = ($insubcat)? 'cat_row.subcat_row': 'cat_row';
	$space = ($insubcat)? str_repeat('&nbsp; ',$cat_level*3) : '';
	$k = sizeof($cat_tree_arr);
	for ($i=0; $i<$k; $i++)
	{
		if($cat_tree_arr[$i]['cat_parent']==$cat_id)
		{
			$new_icon = ($cat_tree_arr[$i]['cat_commdate'] > $mfc_current_set)? '<img src="templates/'.$cfg['skin'].'/images/icon_newcom.gif" alt="" />' : '';
			$TPL_site->assign_block_vars($_block,array(
					'U_CAT' => append_sid(FILE_USR_BROWSE.'?cid='.$cat_tree_arr[$i]['cat_id'].''),
					'CAT_NAME' => stripslashes($cat_tree_arr[$i]['cat_name']),
					'CAT_DATE' => timestamp_to_human($cat_tree_arr[$i]['cat_date']),
					'CAT_NUM_PHOTO' => $cat_tree_arr[$i]['cat_nphoto'],
					'CAT_DEEP_LEVEL_BLANK_SPACE' => $space,
					'NEW_COMMENTS_ICON' => $new_icon
			));
			get_cat_rows($cat_tree_arr[$i]['cat_id'],1);
		}
	}
	$cat_level--;
	return true;
}

function make_form_select_cat($name='cat_id',$cat_id=0){
	global $cat_tree_arr,$msg;

	$_html = '<select name="'.$name.'">';
	$selected = ($cat_id==0)? 'selected':'';
	$_html .= '<option value="0" '.$selected.'>'.$msg['a_none'].'</option>';
	$k = sizeof($cat_tree_arr);
	for ($i=0; $i<$k; $i++)
	{
		$_html .= '<option value="'.$cat_tree_arr[$i]['cat_id'].'" ';
		if($cat_tree_arr[$i]['cat_id']==$cat_id)
		{
			$_html .= 'selected';
		}
		$_html .='>'.$cat_tree_arr[$i]['cat_name'].'</option>'."\n";
	}
	$_html .='</select>';
	return $_html;
}

function make_nav_link($cat_id){
	global $cat_tree_arr;
	
	$k = sizeof($cat_tree_arr);
	for ($i=0; $i<$k; $i++)
	{
		if($cat_tree_arr[$i]['cat_id']==$cat_id)
		{
			$_html = '/<a href="browse.php?cid='.$cat_tree_arr[$i]['cat_id'].'">'.$cat_tree_arr[$i]['cat_name'].'</a>' . $_html;
			if($cat_tree_arr[$i]['cat_parent'] != '0')
			{
				$_html = make_nav_link($cat_tree_arr[$i]['cat_parent']) . $_html;
			}
		}
	}
	return $_html;
}
/* ******************* File Manipulation ******************** */
function my_filesize($file) {
	global $cfg;
	if(!is_file($cfg['img_dir'].$file))
	{
		return false;
	}
	$kb = 1024;         // Kilobyte
	$mb = 1024 * $kb;   // Megabyte
	$gb = 1024 * $mb;   // Gigabyte
	$tb = 1024 * $gb;   // Terabyte
	$size = filesize($file);
	if($size < $kb)
	{
    	return $size." B";
	}elseif($size < $mb){
		return round($size/$kb,2)." KB";
	}else if($size < $gb){
		return round($size/$mb,2)." MB";
	}else if($size < $tb){
		return round($size/$gb,2)." GB";
	}else{
		return round($size/$tb,2)." TB";
	}
}

function my_int_filesize($file) {
	global $cfg;
	if(!is_file($cfg['img_dir'].$file))
	{
		return false;
	}else{
		$kb = 1024;         // Kilobyte
		$mb = 1024 * $kb;   // Megabyte
		$size = filesize($cfg['img_dir'].$file);
		if($size < $kb)
		{
			return $size;
		}elseif($size < $mb){
			return round($size/$kb,0);
		}
	
	}
}
/* ******************* Image Manipulation ******************** */
function make_thumb_image($file,$pre='thm_') {
	global $cfg;
	$thm_format = 'jpg';
	$thm_filename = $pre.get_file_name($file,1).'.'.$thm_format;
	$ext = get_file_extension($file);
	$ori = $cfg['img_dir'].$file;
	$dest = $cfg['img_dir'].get_curr_dir($file).$thm_filename;
	$width = ($cfg['thm_width']==0 || empty($cfg['thm_width']))? 100 : $cfg['thm_width'];
	
	if ($ext == 'jpg' || $ext == 'jpeg'){
		$im = imagecreatefromjpeg($ori);
	}elseif($ext == 'png'){
		$im = imagecreatefrompng($ori);
	}elseif($ext == 'gif'){
		return false;
	}
	$w = imagesx($im);
	$h = imagesy($im);
	if ($w > $h)
	{
		$nw = $width;
		$nh = ($h * $width)/$w;
	}else{
		$nh = $width;
		$nw = ($w * $width)/$h;
	}
	if(function_exists('imagecopyresampled'))
	{
		if(function_exists('imageCreateTrueColor'))
		{
			$ni = imageCreateTrueColor($nw,$nh);
		}else{
			$ni	= imagecreate($nw,$nh);
		}
		if(!@imagecopyresampled($ni,$im,0,0,0,0,$nw,$nh,$w,$h))
		{
			imagecopyresized($ni,$im,0,0,0,0,$nw,$nh,$w,$h);
		}
	}else{
		$ni	= imagecreate($nw,$nh);
		imagecopyresized($ni,$im,0,0,0,0,$nw,$nh,$w,$h);
	}
	if($thm_format=='jpg'){
		imagejpeg($ni,$dest,60);
	}elseif($thm_format=='png'){
		imagepng($ni,$dest);
	}
	return get_curr_dir($file).$thmfilename;
}

function update_photo_date($file,$photo_id,$old_date) {
	global $cfg,$DB_site;
	
	if(function_exists('exif_read_data'))
	{
		$exif = exif_read_data($cfg['img_dir'].$file,'IFD0');
		if($exif!=false)
		{
			$exif = exif_read_data($cfg['img_dir'].$file,0,true);
			$props = array('DateTimeOriginal','Make','Model','Flash','FocalLength','ExposureTime','ApertureFNumber','ExposureBiasValue','WhiteBalance','MeteringMode','ExposureMode','Focus Distance');
			foreach($exif as $key=>$section)
			{
				foreach($section as $name=>$val)
				{
					if(in_array($name,$props))
					{
						//echo "$name: $val<br />\n";
						if($name=='DateTimeOriginal')
						{
							$exif_datetime = $val;
							break;
						}
					}
		    	}
			}
			if(!empty($exif_datetime)) // && $photo_info['photo_date'])
			{
				$photo_date = $exif_datetime;
			}
		}else{
			$photo_date = timestamp_to_mysql_datetime($old_date);
		}
		$sql = "UPDATE ".DBTBL_PHOTOS." SET photo_date='$photo_date' WHERE photo_id='".$photo_id."' ";
		$DB_site->query($sql);
	}
}
function get_photo_date($file){
	global $cfg;
	
	
	if(function_exists('exif_read_data'))
	{
		$exif = exif_read_data($cfg['img_dir'].$file,'IFD0');
		if($exif!=false)
		{
			$exif = exif_read_data($cfg['img_dir'].$file,0,true);
			$props = array('DateTimeOriginal','Make','Model','Flash','FocalLength','ExposureTime','ApertureFNumber','ExposureBiasValue','WhiteBalance','MeteringMode','ExposureMode','Focus Distance');
			foreach($exif as $key=>$section)
			{
				foreach($section as $name=>$val)
				{
					if(in_array($name,$props))
					{
						//echo "$name: $val<br />\n";
						if($name=='DateTimeOriginal')
						{
							$exif_datetime = $val;
							break;
						}
					}
		    	}
			}
			if(!empty($exif_datetime)) // && $photo_info['photo_date'])
			{
				return $exif_datetime;
			}
		}else{
			return timestamp_to_mysql_datetime(time(),$cfg['timezone']);
		}
	}else{
		return false;
	}
}

function update_photo_hits($photo_id='') {
	global $cfg,$DB_site;
	if($photo_id!=''){
		$sql = "UPDATE ".DBTBL_PHOTOS." SET photo_hits=photo_hits+1 WHERE photo_id='".addslashes($photo_id)."' ";
		$DB_site->query($sql);
		return true;
	}
}
function update_photo_rate($photo_id,$user_rating) {
	global $cfg,$DB_site;
	$sql = "SELECT * FROM ".DBTBL_PHOTOS." WHERE photo_id='".addslashes($photo_id)."' ";
	$rate_info =  $DB_site->query_first($sql);
	$photo_nvotes = $rate_info['photo_nvotes'] + 1; // Num_Votes
	$photo_votes = $rate_info['photo_votes'] + $user_rating;
	$photo_rate = round(( $photo_votes/$photo_nvotes ),2);
	$sql = "UPDATE ".DBTBL_PHOTOS." SET photo_nvotes='$photo_nvotes',photo_votes='$photo_votes',photo_rate='$photo_rate' WHERE photo_id='".addslashes($photo_id)."' ";
	$DB_site->query($sql);
	return $photo_rate;
}
function get_rating_stars($val=0) {
	global $cfg;
	
	$h = '';
	$stars = split("[/\\.]", $value);
	$starsf = $stars[0];
	for ($i=1; $i<=$val; $i++)
	{
		$h .= '<img src="templates/'.$cfg['skin'].'/images/star.gif" alt="" />';
		
	}
	if(!empty($stars[1]))
	{
			$h .= '<img src="templates/'.$cfg['skin'].'/images/starh.gif" alt="" />';
	}
	return $h;
}

?>