<%@ Page Language="C#" runat="Server" %>
<!-- #INCLUDE file="inc/inc.aspx" -->
<html>
<head>
  <title>Register new member</title>
  <meta http-equiv="Content-Type" content="text/html; charset=<%=contenttype_charset%>">
  <meta http-equiv="Content-Language" content="<%=contentlanguage%>">
  <style type="text/css">
<%=af.defaultcss%>
  </style>
</head>

<body>
<%
using(SqlConnection Connection = new SqlConnection(cs()))
{
  Connection.Open();

  Response.Cache.SetExpires(DateTime.Now);

  string name, pass, mail, page, info;

  if(Request.Form["name"] == null ||
     Request.Form["pass"] == null ||
     Request.Form["mail"] == null ||
     Request.Form["page"] == null ||
     Request.Form["info"] == null) { af.Error("Invalid request.", Response); goto errexit; }

  name = af.Substr(Request.Form["name"], 50);
  pass = af.Substr(Request.Form["pass"], 50);
  mail = af.Substr(Request.Form["mail"], 50);
  page = af.Substr(Request.Form["page"], 250);
  info = af.Substr(Request.Form["info"], 7500);

  name = Regex.Replace(name, "^\\s+|\\s+$", "");
  pass = Regex.Replace(pass, "^\\s+|\\s+$", "");
  mail = Regex.Replace(mail, "^\\s+|\\s+$", "");
  page = Regex.Replace(page, "^\\s+|\\s+$", "");
  page = af.URL_Encode(page);

  if(name.Length==0 || pass.Length==0 || mail.Length==0) { af.Error("Required field missed.", Response); goto errexit; }

  name = Regex.Replace(name, "\\s\\s+", " ");

  if(Regex.Match(pass, "\\W").Success) { af.Error("Password field contains invalid symbol (A-z,0-9 accepted).", Response); goto errexit; }
  if(!af.validateEmail(mail)) { af.Error("Invalid e-mail.", Response); goto errexit; }

  object idobj = (new SqlCommand("SELECT ID FROM _MEMBERS WHERE UPPER(NAME)='" + af.SQL_Encode(name.ToUpper()) + "'", Connection)).ExecuteScalar();
  if(idobj!=null) { af.Error("Please, try another name.", Response); goto errexit; }

  StringBuilder sbcom = new StringBuilder();
  sbcom.Append("INSERT INTO _MEMBERS (NAME, PASSWORD, EMAIL, PAGE, INFO, RATING, CONTRA, VOTEDPRO, VOTEDCONTRA, STATUS, UNTOUCHABLE, POSTED, DATEREGISTERED, FROMBOARD, INVALID) VALUES (");
  sbcom.Append("'");
  sbcom.Append(af.SQL_Encode(name));
  sbcom.Append("', '");
  sbcom.Append(af.SQL_Encode(pass));
  sbcom.Append("', '");
  sbcom.Append(af.SQL_Encode(mail));
  sbcom.Append("', '");
  sbcom.Append(af.SQL_Encode(page));
  sbcom.Append("', '");
  sbcom.Append(af.SQL_Encode(info));
  sbcom.Append("', 0, 0, 0, 0, 1, 0, 0, GETDATE(), ");
  sbcom.Append("1");
  sbcom.Append(", 0)\r\n");

  (new SqlCommand(sbcom.ToString(), Connection)).ExecuteNonQuery();

  Response.Write("<b>New user registered successfully</b><br><br>Name: ");
  Response.Write(af.HTML_Encode(name, false, false));
  Response.Write("<br>Password: ");
  Response.Write(pass);
  Response.Write("<br>\r\n");

errexit:

  Connection.Close();
}
%>
</body>
</html>