#!/usr/bin/php -q
<?php
/*
$Date: 2002/05/17 22:12:03 $
$Revision: 1.3 $

Use this file if you want to use an alias to pipe
the mail straight to the script.

*/

require_once('includes.php');

// read config file
$c = new config_reader('config.conf');
$c = $c->load();

$output = $c['output'];

set_time_limit($c['time_limit']);

//--------------------------------------------------
//-- INITIALISE THE MIME PARSE CLASS
//--------------------------------------------------
$mime = new mime_email();

//--------------------------------------------------
//-- INITIALISE THE SMS CLASS
//--------------------------------------------------
$sms = new sms_web_sender($c['sms_debug']);

// Add additional accounts if required
if (isset($c['sms_login'])) {
	if (is_string($c['sms_login'])) {
		$c['sms_login'] = (array)$c['sms_login'];
	}
	if (is_array($c['sms_login']) && (count($c['sms_login']) > 0)) {
		for ($x = 0; $x < count($c['sms_login']); $x++) {
			$tmp = explode(',', $c['sms_login'][$x]);
			$sms->add_site(array('user'=>trim($tmp[0]), 'pass'=>trim($tmp[1]), 'class'=>trim($tmp[2]), 'weight'=>(int)trim($tmp[3])));
		}
	}
}

if (count($sms->sites) > 1) {
	$sms->shuffle_logins();
}

$fp = fopen('php://stdin','r');
$email_msg = array();
$cur_size = 0;

while(!feof($fp)) {
	$data = trim(fgets($fp,4096));
	$cur_size += strlen($data);
	if ($cur_size > $c['msg_bytes']) {
		break;
	}
	$email_msg[] = $data;
}
fclose($fp);

	
// feed to mime class
$mime->set_emaildata($email_msg);
$mime->go_decode();

// grab email body
if (empty($mime->emailtextplain)) {
	$sms_body = 'MSG BODY NOT PLAIN TEXT';
} else {
	$sms_body = $mime->emailtextplain;
}

// cut and trim body
$sms_body = substr(trim($sms_body), 0, 160); 

// tries to match a phone number in the subject line
if ($c['allow_forwarded_sms'] && preg_match('/^(\+[0-9]+) ([0-9]+)/', $mime->subject, $matches)) {
	$sms_success = $sms->send_sms(array('ccode'=>$matches[1], 'num'=>$matches[2], 'msg'=>$sms_body));
	unset($matches);

	if ($sms_success) {
		$output("Message Sent\n");
	} else {
		$output("Message NOT Sent\n");
	}

} elseif (!empty($c['mobile_number'])) {
	// check To: header
	if (isset($c['filter_to'])) {
		if (is_string($c['filter_to'])) {
			$c['filter_to'] = (array)$c['filter_to'];
		}
		if (is_array($c['filter_to']) && count($c['filter_to']) > 0) {
			$blocked = true;
			foreach ($c['filter_to'] as $filter) {
				if (stristr($mime->to, $filter) !== false) {
					$blocked = false;
					break;
				}
			}
		}
	}

	if (isset($blocked) && $blocked === true) {
		$output("Message filtered out\n");
		unset($blocked);
	} else {
		$new_sms_body = $c['message_format'];
		$new_sms_body = parse_message_format('subject', $mime->subject, $new_sms_body);
		$new_sms_body = parse_message_format('from', $mime->from, $new_sms_body);
		$new_sms_body = parse_message_format('body', $sms_body, $new_sms_body);
		$sms_success = $sms->send_sms(array('num'=>$c['mobile_number'], 'ccode'=>$c['mobile_ccode'], 'msg'=>$new_sms_body));
		
		if ($sms_success) {
			$output("Message Sent\n");
		} else {
			$output("Message NOT Sent\n");
		}
	}
} else {
	$output("{$mime->subject} didn't match\n");
}

?>