<?
/********************************************************************************/
/* EasyBookMarker: Advanced Bookmarks Management System                         */
/* ====================================================                         */
/*                                                                              */
/* Copyright (c) 2003 by Angel Stoitsov and Mario Stoitsov                      */
/*    http://mario.alinea.bg                                                    */
/*                                                                              */
/* This file is part of EasyBookMarker.                                         */
/* EasyBookMarker is free software; you can redistribute it and/or modify       */
/*    it under the terms of the GNU General Public License as published by      */
/*    the Free Software Foundation; either version 2 of the License, or         */
/*    (at your option) any later version.                                       */
/* EasyBookMarker is distributed in the hope that it will be useful,            */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/*    GNU General Public License for more details.                              */
/* You should have received a copy of the GNU General Public License            */
/*    along with EasyBookMarker; if not, write to the Free Software             */
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/********************************************************************************/
$Title="EasyBookMarker";
include "header.php";
If (!isset($M)) $M="main";
//////////////////
If ($M=="main") { ?>
<table border=0 cellspacing=1 cellpadding=3 bgcolor=<? echo $table_main_color; ?> width=100% class=back>
  <tr><td class=black align=center>EasyBookMarker Description</td></tr>
  <tr><td class=gray colspan=2>Motivation</td></tr>
  <tr><td  valign=top>
   <P>Initially I have had a lot of WEB bookmarks in many different browsers
   and computers. Traveling abroad I had to carry with me many files containing
   these bookmarks in order to use them. Every new visit was adding a new file and
   soon I realized I need an online bookmarker system in order to collect and
   access all bookmarks I need. Then I have looked around the net for available bookmark
   management tools. I found however that some of them are nice but quite "heavy"
   or complicated while the simpler were not promising enough. Finally I decided
   to write an application by myself and this is the present
   <STRONG>EasyBookMarker</STRONG> management tool.
  </td></tr>
  <tr><td class=gray colspan=2>What is EasyBookMarker ?</td></tr>
  <tr><td  valign=top>
     <p><b>EasyBookMarker</b> is a program that allows you to store
    and display your bookmarks in different categories and subcategories.
    It is usefull also for lists of things grouped by categories as CDs, songs
    or games.  It stores the information with usability in mind, keeping
    often-used bookmarks at your fingertips. It sorts and displays your most
    recently used bookmarks in order to make sure that the most often-used bookmarks
    are always at your fingertips while the other bookmarks stay out of your way.
    Using <b>EasyBookMarker</b> your bookmarks will be available to you no
    matter where you go. If you have WEB connection, you have your bookmarks
    and you can always add to them new bookmarks or you can  edit,
    move or delete the existing bookmarks remoutly. </p>
  </td></tr>
  <tr><td class=gray colspan=2>What you can do with EasyBookMarker ?</td></tr>
  <tr><td  valign=top>
    <p><b>EasyBookMarker</b> is a higly customizable full featured bookmark
    management tool written in PHP. It has an easy to use administration
    interface and stores all bookmark entries in a MySQL database.
    With <b>EasyBookMarker</b> yuo can do the following:</p>
      <ul>
       <li >Add unlimited number of different bookmark categories and subcategories</li>
       <li >Add bookmarks to existing subcategories</li>
       <li >Edit all existing categories, subcategories or bookmarks </li>
       <li >Move a bookmark form one category.subcategory to another</li>
       <li >Delete a bookmark or a category (or subcategory) if it is empty</li>
       <li >Create, edit or delete users who has permition to manage the <b>EasyBookMarker</b></li>
       <li >Search <b>EasyBookMarker</b> for bookmarks containig a given string</li>
       <li >QuickMark allowing users to add a paricular web site of interest to <b>EasyBookMarker</b> automatically </li>
       <li >A pop-up list with recently used bookmarks. The last used bookmark becomes first in the pop-up list</li>
      </ul>
    <p>Particular care has been taken to provide with <b>EasyBookMarker</b> a very friendly and professional user
    interface. Included are tree themes that can by changed. Additionally, you can change
    the colors of each of them. If you want even greater control, you can edit the source code itself and
    change the overall look, or make the program do something entirely different.</p>
  </td></tr></table><br><br>
<? }

//////////////////////////////////////////////////////////////////////
If ($M=="main" || $M=="action") { ?>
<table border=0 cellspacing=1 cellpadding=3 bgcolor=<? echo $table_main_color; ?> width=100% class=back>
  <tr><td class=black colspan=2 align=center>Easy BookMarker in Action</td></tr>
  <tr><td class=gray><b>EasyBookMarker</b> Demo</td><td class=gray><b>EasyBookMarker</b> Working Examples</td></tr>
  <tr><td  valign=top>
     <p>This demo allows you to log in, change things around and play with <b>EasyBookMarker</b>.
     The username us <b>user</b> and the password is <b>pass</b>. Enjoy !</p>
     <ul type=disc>
      <li ><a href="http://mario.stoitsov.com/EasyBookMarker">http://mario.stoitsov.com/EasyBookMarker</a></li>
     </ul>
  </td>
  <td  valign=top>
     <p>This is a site using <b>EasyBookMarker</b>. Figure out how it is implemented.<br> <br> <br></p>
     <ul type=disc>
     <li ><a href="http://mario.stoitsov.com/bookmarker">http://mario.stoitsov.com/bookmarker</a></li>
     </ul>
  </td>
  </tr></table><br><br>
<? }

//////////////////////////////////////////////////////////////////////
If ($M=="main" || $M=="downloads") { ?>
<table border=0 cellspacing=1 cellpadding=3 bgcolor=<? echo $table_main_color; ?> width=100% class=back>
    <tr><td class=black colspan=3 align=center>Downloads</td></tr>
    <tr><td class=gray width=20%>Requirements</td><td class=gray width=50%>Downloads</td><td class=gray width=30%>Install</td></tr>
    <td  valign=top>
     <p><b>EasyBookMarker</b> can be used on servers supporting</p>
      <ul>
       <li ><a href="http://www.apache.org/" target=\"_new\">Apache</a> </li>
       <li ><a href="http://www.php.net/" target=\"_new\">PHP</a> </li>
       <li ><a href="http://www.mysql.com/" target=\"_new\">MySQL</a> </li>
      </ul>
   </td>
   <td  valign=top>
      <p>Donload the recent version of <strong>EasyBookMarker</strong> here</p>
      <ul type=disc>
       <li >Version 1.0 -
       <a href="http://mario.stoitsov.com/bookmarker/download/EasyBookMarker.zip">EasyBookMarker.zip</a>
       </li>
      </ul>
   </td>
   <td  valign=top>
     <p>After the download you should follow the instructions in the install.txt file.</p>
   </td>
   </tr></table><br><br>
<? }

//////////////////////////////////////////////////////////////////////
If ($M=="main" || $M=="install") { ?>
<table border=0 cellspacing=1 cellpadding=3 bgcolor=<? echo $table_main_color; ?> width=100% class=back>
  <tr><td class=black align=center>EasyBookMarker Installation Instructions</td></tr>
  <tr><td class=gray colspan=2>In order to install <strong>EasyBookMarker</strong> follow the instructions from the install.txt file </td></tr>
  <tr><td  valign=top>
      <p>Do the following:</p>
      <ul type=disc>
       <li ><strong>Unzip the file EasyBookMarker.zip in some temporary directory.</strong>
           <br>This will create a subdirectory 'EasyBookMarker' with all files and images required.
           <br><font color=red>Do not change the name of this subdirectory</font>.
       </li>
       <li ><strong>Copy the entire subdirectory 'EasyBookMarker' under the root directory on your server.</strong>
         <br>Make sure your web server has the rights to create a file in your 'EasyBookMarker'
         subdirectory.
       </li>
       <li ><strong>Open EasyBookMarker/index.php in your browser.</strong>
         <br>EasyBookMarker  has an auto-installer feature that makes the initial setup simple. It will prompt you for values it needs
         to perform the installation.  Click on setup and it will create the database for you and populate it.
          It will create also a file config.php which will block the installer when you start EasyBookMarker next time again.
       </li>
       <li ><strong> You are done.</strong>
         <br> Point the browser to http:\\your_domain.com\EasyBookMarker\index.php
         <br><br><font color=red><strong>Enjoy your EasyBookMarker</strong></font>.
       </li>
      </ul>
       <p>To customize your web browser with a "QuickMark" to add new bookmarks, click and drag the link "QuickMark"
        to your browser tool bar.  To add links to EasyBookMarker, you can click on the
        "QuickMark" link, which will take your current location and allow you to add a bookmark.
       </p>
  </td></tr></table><br><br>
<? }
//////////////////////////////////////////////////////////////////////
If ($M=="main" || $M=="EasyBookMarker") { ?>
<table border=0 cellspacing=1 cellpadding=3 bgcolor=<? echo $table_main_color; ?> width=100% class=back>
  <tr><td class=black align=center>Other BookMarker Programs</td></tr>
  <tr><td class=gray colspan=2>Other Bookmark Tools &amp; Sites</td></tr><tr>
  <td  valign=top>
   <P>If you are interested in other web based bookmark management sites
      you can check the links:
          <A href="http://www.baboo.com/">Baboo</A>,
          <A href="http://www.clickmarks.com/">Clickmarks</A>,
          <A href="http://www.itlist.com/">itList</A>,
          <A href="http://www.murl.com/">My URLs</A>,
          <A href="http://www.oneview.com/">Oneview</A>,
          <A href="http://freshmeat.net/projects/apb/">Active PHP Bookmarks</A>,
          <A href="http://freshmeat.net/projects/bookmark4u/">Bookmark4U</A>,
          <A href="http://freshmeat.net/projects/b./">b.</A>,
          <A href="http://freshmeat.net/projects/olbookmarks/">ol'bookmarks manager</A>,
          <A href="http://freshmeat.net/projects/phpbookmarks/">PHP Bookmarks</A>,
          <A href="http://freshmeat.net/projects/bookmarker/">bookmarker</A>,
          <A href="http://freshmeat.net/projects/linkbase/">LinkBase</A>.
    </p>
    <P>Summary for such sites one can find at:</p>
      <ul type=disc>
       <li><A href="http://www.webwizards.net/useful/wbbm.htm">http://www.webwizards.net/useful/wbbm.htm</A></li>
       <li><a href="http://lbstone.com/apb/stats/">http://lbstone.com/apb/stats/</a></li>
      </ul>
    <P>If you are interested in tools converting your browser's
            bookmarks into web page(s) take a look at
            <A href="http://multiagent.com/bk2site.html">bk2site</A>,
            <A href="http://www.moodfarm.demon.co.uk/download/index.html">favtohtml</A>,
            <A href="http://www.halcyon.com/mango/FavToHtml">FavToHtml</A>,
            <A href="http://www.senga.org/products.html">Catalog</A>.
        </P>
  </td></tr></table><br><br>
<? }
//////////////////////////////////////////////////////////////////////
If ($M=="main" || $M=="donations") { ?>
<table border=0 cellspacing=1 cellpadding=3 bgcolor=<? echo $table_main_color; ?> width=100% class=back>
  <tr><td class=black align=center>Donations</td></tr>
  <tr><td class=gray colspan=2>Make Donations for developing EasyBookMarker using the following links:</td></tr><tr>
  <td  valign=top>
   <P>
    <!-- Begin PayPal Logo -->
    <table border="0" cellpadding="5" cellspacing="0" align="center">
    <tr><td align="center">
    <a href="https://www.paypal.com/affil/pal=mario%40stoitsov.com" target="_blank">
    <img src="site_images/paypal/logo3.gif" border="0" alt="Pay me securely with your Visa, MasterCard, Discover, or American Express card through PayPal!"></a>
    </td><td>
    <table border=0 cellpadding=0 cellspacing=0>
    <tr><td>
    <a href="https://www.paypal.com/affil/pal=mario%40stoitsov.com" target="_blank">
    <img src="site_images/paypal/icon_visa.gif" border="0" alt="Visa">
    <img src="site_images/paypal/icon_mastercard.gif" border="0" alt="MasterCard" hspace=2>
    <img src="site_images/paypal/icon_discover.gif" border="0" alt="Discover">
    <img src="site_images/paypal/icon_amex.gif" border="0" alt="American Express" hspace=2></a>
    </td></tr></table></td></tr></table>
    <!-- End PayPal Logo -->
    </p>
  </td></tr></table><br><br>
<? }
//////////////////
include "footer.php";
?>
