#********************************************************************************/
#* EasyBookMarker: Advanced Bookmarks Management System                         */
#* ====================================================                         */
#*                                                                              */
#* Copyright (c) 2003 by Angel Stoitsov and Mario Stoitsov                      */
#*    http://mario.alinea.bg                                                    */
#*                                                                              */
#* This file is part of EasyBookMarker.                                         */
#* EasyBookMarker is free software; you can redistribute it and/or modify       */
#*    it under the terms of the GNU General Public License as published by      */
#*    the Free Software Foundation; either version 2 of the License, or         */
#*    (at your option) any later version.                                       */
#* EasyBookMarker is distributed in the hope that it will be useful,            */
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of            */
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
#*    GNU General Public License for more details.                              */
#* You should have received a copy of the GNU General Public License            */
#*    along with EasyBookMarker; if not, write to the Free Software             */
#*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/********************************************************************************/
# Database : `EastBookMarker`
# --------------------------------------------------------
#
# Table structure for table `bookmark_category`
DROP TABLE IF EXISTS `bookmark_category`;
CREATE TABLE `bookmark_category` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) TYPE=MyISAM;
# Dumping data for table `bookmark_category`
INSERT INTO `bookmark_category` (`id`, `name`) VALUES (2,'Webdesign'),
(1,'Physics'),
(3,'Journals');
# --------------------------------------------------------
#
# Table structure for table `bookmark_main`
DROP TABLE IF EXISTS `bookmark_main`;
CREATE TABLE `bookmark_main` (
  `id` int(11) NOT NULL auto_increment,
  `url` varchar(255) NOT NULL default ,
  `name` varchar(255) NOT NULL default ,
  `ldesc` varchar(255) NOT NULL default ,
  `subcategory_id` int(11) NOT NULL default 0,
  `added` date NOT NULL default 0000-00-00,
  `updated` varchar(20) NOT NULL default 0000-00-00,
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) TYPE=MyISAM;
# Dumping data for table `bookmark_main`
INSERT INTO `bookmark_main` (`id`, `url`, `name`, `ldesc`, `subcategory_id`, `added`, `updated`) VALUES (1,http://www.winedt.com/,WinEdt,WinEdt,1,2000-10-21,2002-08-29 16:47:46),
(2,http://www.hotscripts.com/,HotScripts.com,HotScripts.com,2,2000-10-21,2002-09-02 14:02:51),
(3,http://axiom.iop.org/,Axiom: Welcome e-prints in Physics,Axiom: Welcome,3,2000-10-21,2002-08-29 17:05:55),
(4,http://int.phys.washington.edu/seminars_all.html,INT Seminars,INT Seminars,24,2000-10-21,2002-08-29 16:47:52),
(5,http://prc.aps.org/,Physical Review C Home,Physical Review C Home,22,2000-11-03,2002-12-25 16:29:11),
(6,http://prl.aps.org/,Physical Review Letters online,Physical Review Letters online,22,2000-11-03,0000-00-00),
(7,http://int.phys.washington.edu/,Institute for Nuclear Theory, Seattle,Institute for Nuclear Theory, Seattle,24,2000-10-23,2002-08-29 16:51:59),
(8,http://www.php-resource.de/indexphp.php3?cat=PHP&catTyp=Calendar,The PHP- and MCSE-Resource,The PHP- and MCSE-Resource, PHP3, PHP4, ASP, Perl, Tutorials, Scripts, freeware, MCSE, MCP, MCSD, Braindumps,2,2000-10-23,0000-00-00),
(9,http://php.resourceindex.com/Complete_Scripts/,The PHP Complete Scripts,The PHP Resource Index: Complete Scripts,2,2000-10-24,0000-00-00),
(10,http://www.panic.unc.edu/,PANIC computational system at Chapel Hill,PANIC computational system at Chapel Hill, UNC,24,2000-10-25,0000-00-00),
(11,http://www.nameit.net/,Domain Registration - NameIT Corporation,Domain Registration - NameIT Corporation,2,2000-10-31,0000-00-00);
# --------------------------------------------------------
#
# Table structure for table `bookmark_subcategory`
DROP TABLE IF EXISTS `bookmark_subcategory`;
CREATE TABLE `bookmark_subcategory` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `category_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) TYPE=MyISAM;
# Dumping data for table `bookmark_subcategory`
INSERT INTO `bookmark_subcategory` (`id`, `name`, `category_id`) VALUES (22,'general',3),
(24,'general',1),
(2,'tools',2),
(1,'software',2),
(3,'e-preprints',1),
(40,'general','');
# --------------------------------------------------------
#
# Table structure for table `bookmark_users`
DROP TABLE IF EXISTS `bookmark_users`;
CREATE TABLE `bookmark_users` (
  `ID` tinyint(4) NOT NULL auto_increment,
  `username` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`ID`),
  KEY `ID` (`ID`)
) TYPE=MyISAM;
# Dumping data for table `bookmark_users`
INSERT INTO `bookmark_users` (`ID`, `username`, `password`) VALUES (1,'admin','pass');
