<HTML>
<?php 

/*
**
** AdBanner (C) www.AllGigs.co.uk
**
** This source code provides a rolling "Banner Advert" display.  
** The images used and when they are used is configurable (within the ./Ads/ads/csv file) - as is 
** the "rollover" time for each image and the URL to link to
**
** IF YOU USE THIS CODE, PLEASE EITHER:
** - Leave the second line of ./Ads/ads.csv intact (the AllGigs advert)
** OR
** - Add a link on your website to http://www.AllGigs.co.uk 
**
*/

// Global
$allArgs = array();

// Function definitions

// Gives today's date with no time
function todaysDate()
{
	list($dd,$mm,$yyyy) = split("-",date("d-m-Y",time()));
	return mktime(0, 0, 0, $mm, $dd, $yyyy);
}

function getArgValue($argName,$defaultValue="")
{
	global $allArgs;
	$retVal = null;
	$argName = strtoupper($argName);
	if (array_key_exists($argName,$allArgs))
	{
		$retVal = $allArgs[$argName];
	}
	return ($retVal == null) ? $defaultValue : $retVal;
} 

function parseArgs($script)
{
	$url=parse_url($script);
	if ($url)
	{
		$queryArgs = $url[query];	// Get query portion of URL
		if ($queryArgs)
		{
			$arg = split("&",$queryArgs);
			foreach($arg as $argValue)
			{
				$argDetails = split("=",$argValue);
				if ($argDetails)
				{
					storeArgValue($argDetails[0],$argDetails[1]);
				} 
			}
		}
	}
}

function storeArgValue($argName,$argValue)
{
	global $allArgs;
	$allArgs[strtoupper($argName)] = $argValue;
} 

if (isset($REQUEST_URI))
	parseArgs($REQUEST_URI);
else
	parseArgs(""); //dummy
?>
<HEAD>
	<title>AllGigs.co.uk - All Gigs in the England, Ireland, Scotland and Wales</title>
	<SCRIPT LANGUAGE="JavaScript">
	// Setup
	var curAd = 0;
	var ads = new Array();
	var delays = new Array();
	var links = new Array();
	var external = new Array();
	function displayAd()
	{
		if (ads.length)
		{	
			document.all.ad.src = "./Ads/"+ads[curAd];
			document.all.adLink.href=links[curAd];
			if (external[curAd])
			{
				document.all.adLink.target="_blank";
			}
			else
			{
				// It's one of our own!
				document.all.adLink.target="MAINTEXT";
			}
			if (ads.length > 1)
				// Skip refresh if we only have 1 ad!
				setTimeout("displayAd()",delays[curAd]*1000);
			// Move on
			curAd = (++curAd) % ads.length;
		}
		else
		{	
			// No ads for this month
			document.all.ad.src="./Ads/AllGigsAdHere.gif";
			document.all.adLink.href="./Services.html";
		}
	}
	</SCRIPT>
</HEAD>
<BODY bgcolor=#B040F0 topmargin=2 leftmargin=0>
<DIV align=center>
<A id=adLink href="#">
<IMG id=ad border=0 src="#">
</A>

<SCRIPT LANGUAGE="JavaScript">
// Setup
var i = 0;

// PHP generated JavaScript array:
<?php
$fd = fopen ("./Ads/ads.csv", "r");
if ($fd)
{
	$today = todaysDate();
	$line = null;
	$interval = getArgValue("interval",0);	// Used for test purposes
	while (!feof ($fd)) 
	{
		if (!$line)
		{
			// Skip header
			$line = fgets($fd, 4096);
		}
		else
		{
			$line = fgets($fd, 4096);
			if (strlen($line) > 10)
			{
				list($startDate,$durationMonths,$adDurationSecs,$pipeSeparatedImages,$URL) = split (",", $line, 5);
				list($dd,$mm,$yyyy)= split ("\/", $startDate, 3); 
				$startDateTime = mktime(0, 0, 0, $mm, $dd, $yyyy);
				$endDateTime = mktime(0, 0, 0, $mm + $durationMonths, $dd, $yyyy);
				if ($durationMonths < 0 || ($durationMonths > 0 && ($startDateTime <= $today ) && ($today <= $endDateTime)))
				{
					// We've got a contender
					$image = split("\|",$pipeSeparatedImages);
					foreach($image as $anImage)
					{
						if (strtolower(substr($URL,0,7))=="http://")
						{
							echo "external[i]=true;\n";
						}
						echo "ads[i] = \"$anImage\";\n";
						echo "links[i] = \"".rtrim($URL)."\";\n";
						echo "delays[i++] = ".($interval > 0 ? $interval : $adDurationSecs).";\n";
					}
				}
			}
		}
	}
	fclose($fd);
}
?>
displayAd();
</SCRIPT>
</DIV>
</BODY>
</HTML>