<?php

/* Banner Simple, Version 1.0
 * by Dan Kaplan <dan@abledesign.com>
 * Last Modified: January 10, 2003
 * --------------------------------------------------------------------
 *
 * USE THIS LIBRARY AT YOUR OWN RISK; no warranties are expressed or
 * implied. You may modify the file however you see fit, so long as
 * you retain this header information and any credits to other sources
 * throughout the file.  If you make any modifications or improvements,
 * please send them via email to Dan Kaplan <dan@abledesign.com>.
 * --------------------------------------------------------------------
*/

$base_dir = '/path/to/www/';
$img_url = 'http://www.mysite.com/images/ads';

// add any banner sizes (width x height) that you will use:
// IAB Standards & Guidelines:  http://www.iab.net/standards/adunits.asp
$banner_sizes = array ("468x60", "100x60", "100x38", "300x250", "250x250", "240x400", "336x280", "180x150", "468x60", "234x60", "88x31", "120x90", "120x60", "120x240", "125x125", "160x600", "120x600");

$srand_called = FALSE;
$last_file = '';
$array = '';

function get_banner($size='') {
	global $base_dir, $img_url, $banner_sizes, $srand_called, $last_file, $array;

	if (empty($size) || !in_array($size, $banner_sizes)) {
		$size = "468x60";
	}

	$size_split = explode("x", $size);
	$width = $size_split[0];
	$height = $size_split[1];

	if (empty($last_file) || ($size != $last_file) || !is_array($array)) {
		// if calling muliple banners on one page, no need to read in the same file repeatedly.  so,
		// if the last banner file read in is the next one called, pull the $array array from memory.
		
		$file = $base_dir."/mybanner_".$size.".txt";
		if (!file_exists($file)) {
			// could not load the banner file, so create a default blank image and exit
			$banner = "<img src=\"\" width=\"$width\" height=\"$height\" border=\"0\" alt=\"broken image\">";
			return $banner;
		}
		$array = file($file);	// read $file into an array
		$last_file = $size;		// save the last read-in file into memory
	}
	
	if (!$srand_called) {
		// slightly less random without this; srand() should only be called once for multiple banners
		mt_srand ((double) microtime() * 1000000);
		$srand_called = TRUE;
	}

	$rand = mt_rand(1, count($array)-1);	// start at 1 to ignore comment line
	$line = chop($array[$rand]);

	# URL | target="_blank" (1/0) | off-site image (1/0) | image | Alt text
	$banner_split = explode("|", $line);
	$URL = $banner_split[0];
	$blank = $banner_split[1];
	$off_site = $banner_split[2];
	$image = $banner_split[3];
	$alt = $banner_split[4];

	if ($blank == 1) {
		$target = "target=\"_blank\"";
	} else {
		$target = "";
	}

	if ($off_site == 1) {
		$image = $image;
	} else {
		$image = "$img_url/$image";
	}

	$banner = "<a href=\"$URL\" $target><img src=\"$image\" width=\"$width\" height=\"$height\" border=\"0\" alt=\"$alt\"></a>";
	return $banner;
}

?>