/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.ServletErrorHandling;
import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.Forum;
import com.ondelette.servlet.webforum.ForumFactory;
import com.ondelette.servlet.webforum.ForumLocaleFactory;
import com.ondelette.servlet.webforum.HTMLUtil;
import com.ondelette.servlet.webforum.ParameterNames;
import com.ondelette.servlet.webforum.ServletUtil;
import com.ondelette.servlet.webforum.User;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class WebForumServlet
extends HttpServlet
implements ParameterNames,
AutorizationConstants {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String s;
            if (request.getParameter("_RESET_") != null) {
                this.destroy();
            }
            if ((s = request.getParameter("_FORUMFILE_")) == null) {
                ServletErrorHandling.printErrorMessage(request, response, null);
                return;
            }
            Forum forum = ForumFactory.getForum(new File(s));
            User user = ServletUtil.getUser(request, response, forum);
            s = request.getParameter("_SUBSCRIBEUSER_");
            if (s != null) {
                String password2;
                if (request.getParameter("_NEWUSERNAME_") == null || request.getParameter("_NEWUSERPASSWORD_") == null || request.getParameter("_NEWUSERPASSWORD2_") == null) {
                    response.sendRedirect(forum.mWelcomeURL);
                    return;
                }
                String name = HTMLUtil.makeStringHTMLSafe(request.getParameter("_NEWUSERNAME_").trim());
                if (name.length() == 0) {
                    response.sendRedirect(forum.mWelcomeURL);
                    return;
                }
                if (forum.mUserList.isInList(name)) {
                    response.setContentType("text/html");
                    PrintWriter out = response.getWriter();
                    forum.showWarningNameInUse(name, out);
                    out.flush();
                    return;
                }
                String password1 = request.getParameter("_NEWUSERPASSWORD_").trim();
                if (!password1.equals(password2 = request.getParameter("_NEWUSERPASSWORD2_").trim())) {
                    response.setContentType("text/html");
                    PrintWriter out = response.getWriter();
                    forum.showWarningPasswordsDontMatch(name, out);
                    out.flush();
                    return;
                }
                String email = request.getParameter("_NEWUSEREMAIL_");
                if (email != null) {
                    email = email.trim();
                }
                int level = 2;
                user = new User(name, password1, email, level);
                HttpSession session = request.getSession(true);
                session.putValue("USERID", (Object)user);
                forum.mUserList.add(user);
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            if (forum.mAuthorizationLevel > 0) {
                if (user == null) {
                    forum.showWarningAutorizationRequired(out);
                    out.flush();
                    return;
                }
                if (user.getAutorizationLevel() < forum.mAuthorizationLevel) {
                    forum.showWarningAutorizationRequired(out);
                    out.flush();
                    return;
                }
            }
            if ((s = request.getParameter("_DELETEMESSAGE_")) != null && user != null && user.getAutorizationLevel() >= 64) {
                int messagenumber = Integer.parseInt(s);
                forum.askForConfirmationOnDeletingMessage(messagenumber, out, user, request.getServletPath());
                out.flush();
                return;
            }
            s = request.getParameter("_CONFIRMEDDELETEMESSAGE_");
            if (s != null && user != null && user.getAutorizationLevel() >= 64) {
                int messagenumber = Integer.parseInt(s);
                forum.deleteMessage(messagenumber, out, user, request.getServletPath());
                out.flush();
                return;
            }
            s = request.getParameter("_DELETEUSER_");
            if (s != null) {
                if (user.getAutorizationLevel() >= 128) {
                    User currentuser = forum.mUserList.getUser(s);
                    if (currentuser != null && currentuser.getAutorizationLevel() == 256) {
                        forum.showWarningCannotChangeAdmin(out);
                        out.flush();
                        return;
                    }
                    forum.mUserList.remove(s);
                    forum.displayUserList(out, request.getServletPath());
                    out.flush();
                    return;
                }
                forum.showWarningAutorizationRequired(out);
                out.flush();
                return;
            }
            if (request.getParameter("_DISPLAYUSERLIST_") != null) {
                if (user.getAutorizationLevel() >= 128) {
                    forum.displayUserList(out, request.getServletPath());
                    out.flush();
                    return;
                }
                forum.showWarningAutorizationRequired(out);
                out.flush();
                return;
            }
            s = request.getParameter("_DISPLAYUSER_");
            if (s != null) {
                if (user.getAutorizationLevel() >= 128) {
                    forum.displayUser(s, out, request.getServletPath());
                    out.flush();
                    return;
                }
                forum.showWarningAutorizationRequired(out);
                out.flush();
                return;
            }
            if (request.getParameter("_ADDUSER_") != null || request.getParameter("_CHANGEUSER_") != null) {
                if (user.getAutorizationLevel() >= 128) {
                    int level;
                    if (request.getParameter("_NEWUSERNAME_") == null || request.getParameter("_NEWUSERPASSWORD_") == null) {
                        forum.displayUserList(out, request.getServletPath());
                        out.flush();
                        return;
                    }
                    String name = HTMLUtil.makeStringHTMLSafe(request.getParameter("_NEWUSERNAME_").trim());
                    if (name.length() == 0) {
                        forum.displayUserList(out, request.getServletPath());
                        out.flush();
                        return;
                    }
                    User currentuser = forum.mUserList.getUser(name);
                    if (currentuser != null && currentuser.getAutorizationLevel() == 256) {
                        forum.showWarningCannotChangeAdmin(out);
                        out.flush();
                        return;
                    }
                    String password = request.getParameter("_NEWUSERPASSWORD_").trim();
                    String email = request.getParameter("_NEWUSEREMAIL_");
                    if (email != null) {
                        email = email.trim();
                    }
                    if ((level = Integer.parseInt(request.getParameter("_NEWUSERLEVEL_").trim())) >= 256) {
                        level = 128;
                    }
                    User u = new User(name, password, email, level);
                    forum.mUserList.add(u);
                    String oldname = request.getParameter("_OLDUSERNAME_");
                    if (oldname != null && !oldname.equals(name)) {
                        forum.mUserList.remove(oldname);
                    }
                    forum.displayUserList(out, request.getServletPath());
                    out.flush();
                    return;
                }
                forum.showWarningAutorizationRequired(out);
                out.flush();
                return;
            }
            if (request.getParameter("SubmitMessage") != null) {
                ServletUtil.processNewMessage(request, forum, out, user);
                out.flush();
                return;
            }
            s = request.getParameter("_SHOW_");
            if (s != null) {
                int k = Integer.parseInt(s);
                forum.showMessage(k, out, user, request.getServletPath());
                out.flush();
                return;
            }
            s = request.getParameter("_PAGE_");
            if (s != null) {
                int k = Integer.parseInt(s);
                forum.getPage(k, out, user, request.getServletPath());
                out.flush();
                return;
            }
            s = request.getParameter("_LASTMESSAGES_");
            if (s != null) {
                int k = Integer.parseInt(s);
                forum.getLastMessages(k, out, user, request.getServletPath());
                out.flush();
                return;
            }
            forum.getPage(0, out, user, request.getServletPath());
            out.flush();
            return;
        }
        catch (Exception ioe) {
            ServletErrorHandling.printErrorMessage(request, response, ioe);
            return;
        }
    }

    public void destroy() {
        ForumLocaleFactory.destroy();
        ForumFactory.destroy();
    }
}

