/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.HTMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class User
implements AutorizationConstants,
Serializable {
    private int mAutorizationLevel = -99;
    private String mLogin = null;
    private String mPassword = null;
    private String mEmail = null;

    public User(String login, String password, String email, int level) {
        this.mAutorizationLevel = level;
        if (login != null) {
            this.mLogin = HTMLUtil.makeStringHTMLSafe(login.trim());
        }
        if (password != null) {
            this.mPassword = HTMLUtil.makeStringHTMLSafe(password.trim());
        }
        if (email != null) {
            this.mEmail = HTMLUtil.makeStringHTMLSafe(email.trim());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof User) {
            User u = (User)o;
            return this.areEquals(u.mEmail, this.mEmail) && this.areEquals(u.mLogin, this.mLogin) && this.areEquals(u.mPassword, this.mPassword) && u.mAutorizationLevel == this.mAutorizationLevel;
        }
        return false;
    }

    private boolean areEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public void setLogin(String login) {
        if (login != null) {
            this.mLogin = HTMLUtil.makeStringHTMLSafe(login.trim());
        }
    }

    public void setEmail(String email) {
        if (email != null) {
            this.mEmail = HTMLUtil.makeStringHTMLSafe(email.trim());
        }
    }

    private User() {
    }

    public String getLogin() {
        return this.mLogin;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public int getAutorizationLevel() {
        return this.mAutorizationLevel;
    }

    protected String getPassword() {
        return this.mPassword;
    }

    public boolean checkPassword(String password) {
        if (this.mPassword == null) {
            return true;
        }
        if (password == null && this.mPassword.length() == 0) {
            return true;
        }
        if (this.mPassword.equals(password)) {
            return true;
        }
        return this.mPassword.equals(password.trim());
    }

    public static User read(InputStream in) throws IOException {
        while (in.available() > 0) {
            String buf = HTMLUtil.readString(in);
            if (!buf.equals("USER")) continue;
            User user = null;
            user = User.parseUser(in);
            return user;
        }
        return null;
    }

    public void write(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        writer.print("<USER>");
        if (this.mLogin != null) {
            writer.print("<LOGIN>");
            writer.print(this.mLogin);
            writer.print("</LOGIN>");
        }
        if (this.mPassword != null) {
            writer.print("<PASSWORD>");
            writer.print(this.mPassword);
            writer.print("</PASSWORD>");
        }
        if (this.mEmail != null) {
            writer.print("<EMAIL>");
            writer.print(this.mEmail);
            writer.print("</EMAIL>");
        }
        writer.print("<LEVEL>");
        writer.print(Integer.toString(this.mAutorizationLevel));
        writer.print("</LEVEL>");
        writer.print("</USER>");
        writer.flush();
    }

    private static User parseUser(InputStream in) throws IOException {
        User user;
        block4: {
            String header;
            user = new User();
            while (in.available() > 0 && !(header = HTMLUtil.readString(in)).equals("/USER")) {
                if (header.equals("LOGIN")) {
                    user.mLogin = HTMLUtil.readString(in).trim();
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("PASSWORD")) {
                    user.mPassword = HTMLUtil.readString(in).trim();
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("EMAIL")) {
                    user.mEmail = HTMLUtil.readString(in).trim();
                    HTMLUtil.readString(in);
                    continue;
                }
                if (!header.equals("LEVEL")) continue;
                user.mAutorizationLevel = Integer.parseInt(HTMLUtil.readString(in).trim());
                HTMLUtil.readString(in);
            }
            if (user.mPassword != null && user.mLogin != null && user.mAutorizationLevel != -99) break block4;
            user = null;
        }
        return user;
    }
}

