/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.laf.PropertiesMetalTheme;
import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.GenericServletInterface;
import com.ondelette.servlet.webforum.Message;
import com.ondelette.servlet.webforum.MessageReference;
import com.ondelette.servlet.webforum.ParameterNames;
import com.ondelette.servlet.webforum.SwingForumApplet;
import com.ondelette.servlet.webforum.User;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ObjectView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class SwingForumApplet
extends JApplet
implements ParameterNames {
    private MessageDisplay mMessageDisplay;
    private ForumBrowser mForumBrowser;
    private String mCopyrightString = "(c) 2000 Daniel Lemire (http://www.ondelette.com/)";
    private JLabel mStatus;
    private Hashtable mMessageHolderTable = new Hashtable();
    private MessageHolder mMessageHolder;
    private String mServletURLString;
    private String mForumFileString;
    private URL mForumURL = null;
    protected AppletLocale mAppletLocale = new AppletLocale(this, "/appletlocale.properties");
    private int mImageIndex = 0;

    public void init() {
        Point middle = new Point(this.getLocation().x + this.getWidth() / 2, this.getLocation().y + this.getHeight() / 2);
        LoadingMessageWindow lm = new LoadingMessageWindow(this, this.mAppletLocale.getLoadingText(), middle);
        this.setupGUI();
        this.wireEvents();
        lm.dispose();
    }

    public static void main(String[] arg) {
    }

    public void start() {
        this.mServletURLString = this.getParameter("ServletURL");
        this.mForumFileString = this.getParameter("ForumFile");
        try {
            this.mForumURL = new URL(this.mServletURLString);
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        this.mStatus.setText(this.mAppletLocale.getLoadingText());
        this.mMessageHolder = this.getMessageHolder();
        this.mMessageHolder.getTree(0);
    }

    public void gotTree(TreeModel tree) {
        this.mForumBrowser.setTreeModel(tree);
        this.mStatus.setText(this.mCopyrightString);
        this.mForumBrowser.setEnabled(true);
    }

    public void selected(MessageReference mr, Message m) {
        this.mImageIndex = 0;
        this.mMessageDisplay.setMessage(mr, m);
        this.mMessageDisplay.setEnabled(true);
    }

    public void stop() {
        this.mMessageHolder.stop();
    }

    public void destroy() {
        this.mMessageHolder.destroy();
    }

    public void postForm(MessageReference mr) {
        new PostForm(mr, this);
    }

    public void showPage(URL url) {
        if (url == null) {
            return;
        }
        System.out.println("should show ".concat(String.valueOf(String.valueOf(url.toString()))));
        this.getAppletContext().showDocument(url, "_new");
    }

    public void showImage(URL url) {
        if (url == null) {
            return;
        }
        ++this.mImageIndex;
        this.mImageIndex %= 10;
        System.out.println("should show image ".concat(String.valueOf(String.valueOf(url.toString()))));
        this.getAppletContext().showDocument(url, "_image".concat(String.valueOf(String.valueOf(this.mImageIndex))));
    }

    public MessageHolder getMessageHolder() {
        MessageHolder mh = (MessageHolder)this.mMessageHolderTable.get(this.mForumURL);
        if (mh == null) {
            mh = new MessageHolder(this.mForumURL, this.mForumFileString, this, this.mAppletLocale);
            this.mMessageHolderTable.put(this.mForumURL, mh);
        }
        return mh;
    }

    private void loadTheme(String themefile) {
        PropertiesMetalTheme myTheme = null;
        URL url = this.getClass().getResource(themefile);
        if (url != null) {
            try {
                InputStream is = url.openStream();
                try {
                    myTheme = new PropertiesMetalTheme(is);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                if (myTheme != null) {
                    MetalLookAndFeel.setCurrentTheme(myTheme);
                }
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception ex) {
                System.out.println("Failed loading Metal");
                System.out.println(ex);
            }
        }
    }

    public void gotValidUser(User u) {
        this.mMessageHolder.setUser(u);
    }

    public void setEnabled(boolean b) {
        this.mMessageDisplay.setEnabled(b);
        this.mForumBrowser.setEnabled(b);
    }

    private void setupGUI() {
        this.mStatus = new JLabel(this.mCopyrightString);
        this.mStatus.setBorder(new BevelBorder(0));
        this.mMessageDisplay = new MessageDisplay(this, new MessageReference(-1), new Message("", "", "", ""));
        this.mMessageDisplay.setEnabled(false);
        this.mForumBrowser = new ForumBrowser(this);
        this.mForumBrowser.setEnabled(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(0));
        panel.setLayout(new GridLayout(0, 2, 4, 4));
        panel.add(this.mForumBrowser);
        panel.add(this.mMessageDisplay);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.mStatus, "South");
        this.mMessageDisplay.setDoubleBuffered(false);
        this.mForumBrowser.setDoubleBuffered(false);
        this.mStatus.setDoubleBuffered(false);
    }

    private void wireEvents() {
    }

    final class AppletLocale {
        private Locale mCurrentLocale = new Locale("en", "US", "");
        private DateFormat mDateFormat = DateFormat.getDateTimeInstance(3, 3, this.mCurrentLocale);

        private AppletLocale(SwingForumApplet this$0, String ConfigurationFile) {
        }

        public DateFormat getDateFormat() {
            return this.mDateFormat;
        }

        public String getImageText() {
            return "image";
        }

        public String getPostButtonText() {
            return "post";
        }

        public String getCancelButtonText() {
            return "cancel";
        }

        public String getAuthorText() {
            return "author";
        }

        public String getAuthorEmailText() {
            return "email";
        }

        public String getURLText() {
            return "URL";
        }

        public String getURLTitleText() {
            return "URL title";
        }

        public String getSubjectText() {
            return "subject";
        }

        public String getOKButtonText() {
            return "Ok";
        }

        public String getMessageText() {
            return "Message";
        }

        public String getPostANewMessageText() {
            return "Post a new message";
        }

        public String getPostANewReplyText() {
            return "Post a new reply";
        }

        public String getExpandText() {
            return "Expand";
        }

        public String getLoadingText() {
            return "Loading... please wait...";
        }
    }

    class NoImageHTMLEditorKit
    extends HTMLEditorKit {
        public ViewFactory getViewFactory() {
            return new NoImageHTMLFactory();
        }
    }

    public class NoImageHTMLFactory
    implements ViewFactory {
        private HTMLEditorKit.HTMLFactory mHtmlfact = new HTMLEditorKit.HTMLFactory();

        public View create(Element elem) {
            HTML.Tag kind;
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag && (kind = (HTML.Tag)o) == HTML.Tag.IMG) {
                URL url = this.getSourceURL(elem);
                if (url != null) {
                    SwingForumApplet.this.showImage(url);
                }
                return new ObjectView(elem);
            }
            return this.mHtmlfact.create(elem);
        }

        private URL getSourceURL(Element elem) {
            String src = (String)elem.getAttributes().getAttribute(HTML.Attribute.SRC);
            if (src == null) {
                return null;
            }
            URL reference = ((HTMLDocument)elem.getDocument()).getBase();
            try {
                URL u;
                URL uRL = u = new URL(reference, src);
                return uRL;
            }
            catch (MalformedURLException e) {
                URL uRL = null;
                return uRL;
            }
        }
    }

    final class MessageExplorer
    implements TreeExpansionListener {
        private DefaultTreeModel mTreeModel;

        public MessageExplorer(SwingForumApplet this$0, DefaultTreeModel tm) {
            this.mTreeModel = tm;
        }

        public void treeCollapsed(TreeExpansionEvent e) {
        }

        public void treeExpanded(TreeExpansionEvent e) {
            PageNode pn;
            Object o = e.getPath().getLastPathComponent();
            if (o instanceof PageNode && !(pn = (PageNode)o).isExplored()) {
                pn.explore();
                this.mTreeModel.nodeStructureChanged(pn);
            }
        }
    }

    final class PageNode
    extends DefaultMutableTreeNode {
        private int mPageNumber;
        private MessageHolder mMessageHolder;
        private boolean mIsExplored;

        public PageNode(SwingForumApplet this$0, int PageNumber, int[] Headers, MessageHolder mh) {
            this.mMessageHolder = mh;
            this.mPageNumber = PageNumber;
            this.setUserObject(Headers);
        }

        public boolean isLeaf() {
            int[] array = (int[])this.getUserObject();
            if (array == null) {
                return true;
            }
            return array.length == 0;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public String toString() {
            return "page";
        }

        public boolean isExplored() {
            return this.mIsExplored;
        }

        public void explore() {
            int[] array = (int[])this.getUserObject();
            if (array == null) {
                return;
            }
            for (int k = 0; k < array.length; ++k) {
                MessageNode mn = this.mMessageHolder.getMessageNode(new MessageReference(array[k]));
                if (mn == null) continue;
                this.add(mn);
            }
            this.mIsExplored = true;
        }
    }

    final class MessageNode
    extends DefaultMutableTreeNode {
        private MessageHolder mMessageHolder;
        private MessageReference mMessageReference;
        private boolean mHasBeenRead = false;

        public MessageNode(SwingForumApplet this$0, MessageReference mr, Message m, MessageHolder mh) {
            this.mMessageHolder = mh;
            this.mMessageReference = mr;
            this.setUserObject(m);
            this.explore();
        }

        public MessageReference getMessageReference() {
            return this.mMessageReference;
        }

        public boolean isLeaf() {
            Message m = (Message)this.getUserObject();
            return !m.getReplies().hasMoreElements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public String toString() {
            return this.getUserObject().toString();
        }

        public void setHasBeenRead(boolean b) {
            this.mHasBeenRead = b;
        }

        public boolean hasBeenRead() {
            return this.mHasBeenRead;
        }

        public void explore() {
            Message m = (Message)this.getUserObject();
            Enumeration enumeration = m.getReplies();
            while (enumeration.hasMoreElements()) {
                MessageReference mr = (MessageReference)enumeration.nextElement();
                MessageNode mn = this.mMessageHolder.getMessageNode(mr);
                if (mn == null) continue;
                this.add(mn);
            }
        }
    }

    class MessageFormattingRenderer
    extends DefaultTreeCellRenderer
    implements AutorizationConstants {
        private Font mUnreadFont = new Font("Serif", 0, 12);
        private Font mReadFont = new Font("Serif", 2, 12);
        private DateFormat mDateFormat;
        private Color mTextColor;
        private Color mSelectedTextColor;
        private Color mBrightTextColor;
        private Color mBrightSelectedTextColor;

        public MessageFormattingRenderer(SwingForumApplet this$0, DateFormat df) {
            this.mDateFormat = df;
            this.mTextColor = this.getTextNonSelectionColor();
            this.mSelectedTextColor = this.getTextSelectionColor();
            this.mBrightTextColor = this.mTextColor.brighter();
            this.mBrightSelectedTextColor = this.mSelectedTextColor.brighter();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)value;
            Object userObject = n.getUserObject();
            if (userObject instanceof Message) {
                Message m = (Message)userObject;
                this.setText(m.toString());
                if (n instanceof MessageNode) {
                    MessageNode mn = (MessageNode)n;
                    if (mn.hasBeenRead()) {
                        this.setFont(this.mReadFont);
                    } else {
                        this.setFont(this.mUnreadFont);
                    }
                    if (m.getAutorizationLevel() > 32) {
                        this.setForeground(Color.red);
                    } else if (m.getAutorizationLevel() > 0) {
                        this.setForeground(Color.blue);
                    }
                }
            }
            return this;
        }
    }

    final class MessageHolder
    implements Runnable,
    GenericServletInterface {
        private Hashtable mMessageTable = new Hashtable();
        private Hashtable mMessageNodeTable = new Hashtable();
        private URL mForumURL;
        private String mForumFileString;
        private JTree mTree;
        private Thread mLoadTreeThread = null;
        private SwingForumApplet mTreeListener;
        private int mCurrentPage = -1;
        private int mCurrentMaxIndex = -1;
        private AppletLocale mAppletLocale;
        private User mUser;
        private DefaultTreeModel mTreeModel;

        public MessageHolder(URL forumurl, String forumfile, SwingForumApplet treelistener, AppletLocale al) {
            this.mAppletLocale = al;
            this.mForumURL = forumurl;
            this.mForumFileString = forumfile;
            this.mTreeListener = treelistener;
        }

        public void setUser(User u) {
            this.mUser = u;
        }

        public User getUser() {
            return this.mUser;
        }

        public boolean sendMessage(Message m) {
            if (this.mUser == null) {
                System.err.println("No user defined. Command ignored.");
                return false;
            }
            m.setAutorizationLevel(this.mUser.getAutorizationLevel());
            m.setAuthor(this.mUser.getLogin());
            m.setAuthorEmail(this.mUser.getEmail());
            try {
                int newmesssageid;
                URLConnection con = this.connect();
                DataOutputStream dos = new DataOutputStream(con.getOutputStream());
                try {
                    this.sendStandardHeader(dos);
                    dos.writeChar(112);
                    dos.writeChar(77);
                    dos.writeInt(m.getInReplyTo());
                    dos.flush();
                    ObjectOutputStream oos = new ObjectOutputStream(dos);
                    oos.writeObject(m);
                    oos.flush();
                }
                catch (IOException ioe) {
                    dos.close();
                    ioe.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                dos.flush();
                dos.close();
                dos = null;
                InputStream is = con.getInputStream();
                DataInputStream dis = new DataInputStream(is);
                try {
                    try {
                        this.readStandardHeader(dis);
                        char tc = dis.readChar();
                        if (tc != 'g') {
                            throw new IOException("No GET found where expected! Instead I found : ".concat(String.valueOf(String.valueOf(tc))));
                        }
                        tc = dis.readChar();
                        if (tc != 'M') {
                            throw new IOException("No MESSAGE found where expected! Instead I found :  ".concat(String.valueOf(String.valueOf(tc))));
                        }
                        int readparentmr = dis.readInt();
                        if (readparentmr != m.getInReplyTo()) {
                            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Bad parent message id ").append(readparentmr).append(" != ").append(m.getInReplyTo()))));
                        }
                        newmesssageid = dis.readInt();
                        if (newmesssageid < 0) {
                            throw new IOException("Negative message id ".concat(String.valueOf(String.valueOf(newmesssageid))));
                        }
                        Object var10_15 = null;
                    }
                    catch (IOException ioe) {
                        dis.close();
                        ioe.printStackTrace();
                        boolean bl = false;
                        Object var10_16 = null;
                        dis.close();
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    dis.close();
                    throw throwable;
                }
                dis.close();
                this.addNewMessage(new MessageReference(newmesssageid), m);
                boolean bl = true;
                return bl;
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
                boolean bl = false;
                return bl;
            }
        }

        private void addNewMessage(MessageReference mr, Message m) {
            this.mMessageTable.put(mr, m);
            if (m.getInReplyTo() < 0) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
                root.insert(this.getMessageNode(mr), 0);
                this.mTreeModel.nodeStructureChanged(root);
                return;
            }
            MessageReference parentmr = new MessageReference(m.getInReplyTo());
            MessageNode parentmn = this.getMessageNode(parentmr);
            Message parentmessage = (Message)parentmn.getUserObject();
            if (!parentmessage.contains(mr)) {
                parentmessage.addReply(mr);
                this.mMessageTable.put(parentmn, parentmessage);
            }
            parentmn.insert(this.getMessageNode(mr), 0);
            this.mTreeModel.nodeStructureChanged(parentmn);
        }

        public void getTree(int pagenumber) {
            if (this.mLoadTreeThread != null) {
                try {
                    this.mLoadTreeThread.join();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                this.mLoadTreeThread = null;
            }
            this.mCurrentPage = pagenumber;
            this.mLoadTreeThread = new Thread(this);
            this.mLoadTreeThread.start();
        }

        private URLConnection connect() throws IOException {
            URLConnection con = this.mForumURL.openConnection();
            con.setUseCaches(false);
            con.setRequestProperty("CONTENT_TYPE", "application/octet-stream");
            con.setDoInput(true);
            con.setDoOutput(true);
            return con;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                try {
                    URLConnection con = this.connect();
                    DataOutputStream dos = new DataOutputStream(con.getOutputStream());
                    try {
                        this.sendStandardHeader(dos);
                        dos.writeChar(103);
                        dos.writeChar(80);
                        dos.writeInt(this.mCurrentPage);
                        dos.flush();
                    }
                    catch (IOException ioe) {
                        dos.close();
                        ioe.printStackTrace();
                        return;
                    }
                    dos.flush();
                    dos.close();
                    dos = null;
                    InputStream is = con.getInputStream();
                    DataInputStream dis = new DataInputStream(is);
                    try {
                        try {
                            this.readStandardHeader(dis);
                            char tc = dis.readChar();
                            if (tc != 'p') {
                                throw new IOException("No PUT found where expected! Instead I found : ".concat(String.valueOf(String.valueOf(tc))));
                            }
                            tc = dis.readChar();
                            if (tc != 'P') {
                                throw new IOException("No PAGE found where expected! Instead I found :  ".concat(String.valueOf(String.valueOf(tc))));
                            }
                            this.mCurrentPage = dis.readInt();
                            try {
                                ObjectInputStream ois = new ObjectInputStream(is);
                                int[] pageheader = (int[])ois.readObject();
                                this.receiveMessages(is);
                                this.mTreeListener.gotTree(this.buildTree(this.mCurrentPage, pageheader));
                            }
                            catch (ClassNotFoundException cnfe) {
                                cnfe.printStackTrace();
                            }
                            Object var9_12 = null;
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            Object var9_13 = null;
                            dis.close();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        dis.close();
                        throw throwable;
                    }
                    dis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this.mCurrentPage = -1;
        }

        private void sendStandardHeader(DataOutputStream dos) throws IOException {
            dos.writeInt(this.mCurrentMaxIndex);
            dos.writeInt(this.mForumFileString.length());
            for (int k = 0; k < this.mForumFileString.length(); ++k) {
                dos.writeChar(this.mForumFileString.charAt(k));
            }
        }

        private void readStandardHeader(DataInputStream dis) throws IOException {
            int CurrentMaxIndex = dis.readInt();
            if (CurrentMaxIndex < 0) {
                throw new IOException("No such forum!");
            }
            if (CurrentMaxIndex < this.mCurrentMaxIndex) {
                this.launchUpdate();
            }
            int length = dis.readInt();
            StringBuffer sb = new StringBuffer();
            for (int k = 0; k < length; ++k) {
                sb.append(dis.readChar());
            }
            String s = sb.toString();
            if (!s.equals(this.mForumFileString)) {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Bad forum file : ").append(s).append(" != ").append(this.mForumFileString))));
            }
        }

        private void launchUpdate() {
            System.out.println("Normally, this should launch an update request in a new thread");
        }

        /*
         * Exception decompiling
         */
        private void receiveMessages(InputStream is) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private TreeModel buildTree(int pagenumber, int[] pageheader) {
            SwingForumApplet swingForumApplet = SwingForumApplet.this;
            swingForumApplet.getClass();
            PageNode pn = new PageNode(swingForumApplet, pagenumber, pageheader, this);
            pn.explore();
            this.mTreeModel = new DefaultTreeModel(pn);
            return this.mTreeModel;
        }

        public Message getMessage(MessageReference mr) {
            return (Message)this.mMessageTable.get(mr);
        }

        public MessageNode getMessageNode(MessageReference mr) {
            Message m;
            MessageNode mn = (MessageNode)this.mMessageNodeTable.get(mr);
            if (mn == null && (m = this.getMessage(mr)) != null) {
                SwingForumApplet swingForumApplet = SwingForumApplet.this;
                swingForumApplet.getClass();
                mn = new MessageNode(swingForumApplet, mr, m, this);
                this.mMessageNodeTable.put(mr, mn);
            }
            return mn;
        }

        public void stop() {
            if (this.mLoadTreeThread != null) {
                try {
                    this.mLoadTreeThread.join();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                this.mLoadTreeThread = null;
            }
        }

        public void destroy() {
            this.stop();
        }
    }

    final class ForumBrowser
    extends JComponent {
        private JButton mPostButton;
        private JButton mExpandButton;
        private JTree mTree;
        private SwingForumApplet mOwner;

        public void setEnabled(boolean b) {
            this.mPostButton.setEnabled(b);
        }

        public boolean isEnabled() {
            return this.mPostButton.isEnabled();
        }

        public ForumBrowser(SwingForumApplet msl) {
            this.mOwner = msl;
            this.setupTree();
            this.setupGUI();
            this.wireEvents();
        }

        private void setupGUI() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.mTree), "Center");
            JPanel buttonpanel = new JPanel();
            buttonpanel.setDoubleBuffered(false);
            this.mPostButton = new JButton(this.mOwner.mAppletLocale.getPostANewMessageText());
            buttonpanel.add(this.mPostButton);
            this.mExpandButton = new JButton(this.mOwner.mAppletLocale.getExpandText());
            buttonpanel.add(this.mExpandButton);
            this.add((Component)buttonpanel, "South");
            this.setDoubleBuffered(false);
            this.mTree.setDoubleBuffered(false);
            this.mPostButton.setDoubleBuffered(false);
            this.mExpandButton.setDoubleBuffered(false);
        }

        private void wireEvents() {
            this.mPostButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ForumBrowser this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ForumBrowser.access$5(this.this$1).postForm(new MessageReference(-1));
                }
            });
            this.mExpandButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ForumBrowser this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (ForumBrowser.access$6(this.this$1) == null) {
                        return;
                    }
                    7 var2_2 = this;
                    synchronized (var2_2) {
                        for (int k = 0; k < ForumBrowser.access$6(this.this$1).getRowCount(); ++k) {
                            ForumBrowser.access$6(this.this$1).expandRow(k);
                        }
                    }
                }
            });
        }

        private void setupTree() {
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode("messages");
            parent.add(new DefaultMutableTreeNode(this.mOwner.mAppletLocale.getLoadingText()));
            this.mTree = new JTree(parent);
            this.mTree.getSelectionModel().setSelectionMode(1);
            SwingForumApplet swingForumApplet = SwingForumApplet.this;
            swingForumApplet.getClass();
            this.mTree.setCellRenderer(new MessageFormattingRenderer(swingForumApplet, SwingForumApplet.this.mAppletLocale.getDateFormat()));
            this.mTree.putClientProperty("JTree.lineStyle", "Angled");
            this.mTree.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ ForumBrowser this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getNewLeadSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (node instanceof MessageNode) {
                        Message m = (Message)node.getUserObject();
                        MessageNode mn = (MessageNode)node;
                        ForumBrowser.access$5(this.this$1).selected(mn.getMessageReference(), m);
                        mn.setHasBeenRead(true);
                    }
                }
            });
            SwingForumApplet swingForumApplet2 = SwingForumApplet.this;
            swingForumApplet2.getClass();
            this.mTree.addTreeExpansionListener(new MessageExplorer(swingForumApplet2, (DefaultTreeModel)this.mTree.getModel()));
        }

        public Dimension getMinimumSize() {
            return this.getLayout().minimumLayoutSize(this);
        }

        public Dimension getPreferredSize() {
            return this.getLayout().preferredLayoutSize(this);
        }

        public void setTreeModel(TreeModel tree) {
            this.mTree.setModel(tree);
            this.repaint();
        }

        static /* synthetic */ SwingForumApplet access$5(ForumBrowser x$0) {
            return x$0.mOwner;
        }

        static /* synthetic */ JTree access$6(ForumBrowser x$0) {
            return x$0.mTree;
        }
    }

    final class PostForm
    extends JFrame {
        private MessageReference mMessageReference;
        private Message mParentMessage = null;
        private SwingForumApplet mOwner;
        private JTextField mSubjectTextField;
        private JTextField mURLTextField;
        private JTextField mURLTitleTextField;
        private JTextField mImageTextField;
        private JTextArea mTextArea = new JTextArea(10, 40);
        private AppletLocale mAppletLocale;
        private JButton mPostButton;
        private JButton mCancelButton;
        private final String HTTPSTRING = "http://";
        private boolean mCancel = false;

        public PostForm(MessageReference mr, SwingForumApplet owner) {
            this.mOwner = owner;
            this.mMessageReference = mr;
            this.mAppletLocale = owner.mAppletLocale;
            this.setupGUI();
            if (mr.getID() > 0) {
                this.mParentMessage = SwingForumApplet.this.mMessageHolder.getMessage(mr);
            }
            if (this.mParentMessage != null) {
                this.setTitle(this.mParentMessage.toString());
            }
            this.pack();
            Point middle = new Point(this.mOwner.getX() + this.mOwner.getWidth() / 2, this.mOwner.getY() + this.mOwner.getHeight() / 2);
            ((Component)this).setLocation(middle);
            this.setDefaultCloseOperation(2);
            this.wireEvents();
            if (this.mOwner.mMessageHolder.getUser() == null) {
                SwingForumApplet swingForumApplet = SwingForumApplet.this;
                swingForumApplet.getClass();
                swingForumApplet.new UserIdentificationForm(this);
                if (this.mCancel) {
                    this.dispose();
                } else {
                    this.show();
                }
            } else {
                this.show();
            }
        }

        public void cancel() {
            this.mCancel = true;
        }

        private void setupGUI() {
            this.getContentPane().setLayout(new BorderLayout());
            JPanel centerpanel = new JPanel();
            centerpanel.setLayout(new BorderLayout());
            JPanel variousfieldspanel = new JPanel();
            variousfieldspanel.setLayout(new GridLayout(0, 1, 2, 2));
            this.mURLTextField = new JTextField("http://");
            variousfieldspanel.add(this.mURLTextField);
            this.mURLTextField.setBorder(new TitledBorder(this.mAppletLocale.getURLText()));
            this.mURLTitleTextField = new JTextField();
            variousfieldspanel.add(this.mURLTitleTextField);
            this.mURLTitleTextField.setBorder(new TitledBorder(this.mAppletLocale.getURLTitleText()));
            this.mImageTextField = new JTextField("http://");
            variousfieldspanel.add(this.mImageTextField);
            this.mImageTextField.setBorder(new TitledBorder(this.mAppletLocale.getImageText()));
            centerpanel.add((Component)variousfieldspanel, "South");
            centerpanel.add(new JScrollPane(this.mTextArea));
            this.mTextArea.setBorder(new TitledBorder(this.mAppletLocale.getMessageText()));
            this.mSubjectTextField = new JTextField();
            centerpanel.add((Component)this.mSubjectTextField, "North");
            this.mSubjectTextField.setBorder(new TitledBorder(this.mAppletLocale.getSubjectText()));
            this.getContentPane().add((Component)centerpanel, "Center");
            JPanel buttonpanel = new JPanel();
            buttonpanel.setLayout(new GridLayout(1, 0, 5, 5));
            this.mPostButton = new JButton(this.mAppletLocale.getPostButtonText());
            buttonpanel.add(this.mPostButton);
            this.mCancelButton = new JButton(this.mAppletLocale.getCancelButtonText());
            buttonpanel.add(this.mCancelButton);
            this.getContentPane().add((Component)buttonpanel, "South");
            this.mTextArea.setDoubleBuffered(false);
            this.mSubjectTextField.setDoubleBuffered(false);
            this.mURLTextField.setDoubleBuffered(false);
            this.mURLTitleTextField.setDoubleBuffered(false);
            this.mImageTextField.setDoubleBuffered(false);
            this.mPostButton.setDoubleBuffered(false);
            this.mCancelButton.setDoubleBuffered(false);
        }

        private void wireEvents() {
            this.mCancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PostForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PostForm.access$1(this.this$1).setEnabled(true);
                    this.this$1.dispose();
                }
            });
            this.mPostButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PostForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.post();
                }
            });
        }

        public Message getMessage() {
            StringBuffer content = new StringBuffer(this.mTextArea.getText());
            if (this.mImageTextField.getText() != null && !this.mImageTextField.getText().equals("http://") && this.mImageTextField.getText().length() > 0) {
                content.append("<IMG SRC=\"");
                content.append(this.mImageTextField.getText());
                content.append("\" align=center>");
            }
            if (this.mURLTextField.getText() != null && !this.mURLTextField.getText().equals("http://") && this.mURLTextField.getText().length() > 0) {
                content.append("<DIV align=center><A HREF=\"");
                content.append(this.mURLTextField.getText());
                content.append("\">");
                if (this.mURLTitleTextField.getText() != null) {
                    if (this.mURLTitleTextField.getText().length() > 0) {
                        content.append(this.mURLTitleTextField.getText());
                    } else {
                        content.append(this.mURLTextField.getText());
                    }
                } else {
                    content.append(this.mURLTextField.getText());
                }
                content.append("</A></DIV>\n");
            }
            Message newmessage = new Message(null, null, this.mSubjectTextField.getText(), content.toString());
            newmessage.setInReplyTo(this.mMessageReference.getID());
            return newmessage;
        }

        public void post() {
            SwingForumApplet.this.mMessageHolder.sendMessage(this.getMessage());
            this.dispose();
        }
    }

    final class UserIdentificationForm
    extends JDialog
    implements AutorizationConstants {
        private JTextField mAuthorTextField;
        private JTextField mAuthorEmailTextField;
        private JButton mOKButton;
        private JButton mCancelButton;
        private PostForm mPostForm;
        private SwingForumApplet mOwner;

        public UserIdentificationForm(PostForm sfa) {
            super((Frame)sfa, true);
            this.mPostForm = sfa;
            this.mOwner = sfa.mOwner;
            this.mOwner.setEnabled(false);
            this.setupGUI();
            this.pack();
            Point middle = new Point(sfa.getX() + sfa.getWidth() / 2, sfa.getY() + sfa.getHeight() / 2);
            ((Component)this).setLocation(middle);
            this.setDefaultCloseOperation(0);
            this.wireEvents();
            this.show();
        }

        private void setupGUI() {
            JPanel fieldpanel = new JPanel();
            fieldpanel.setLayout(new GridLayout(0, 1, 2, 2));
            this.mAuthorTextField = new JTextField();
            fieldpanel.add(this.mAuthorTextField);
            this.mAuthorTextField.setBorder(new TitledBorder(SwingForumApplet.this.mAppletLocale.getAuthorText()));
            this.mAuthorEmailTextField = new JTextField();
            fieldpanel.add(this.mAuthorEmailTextField);
            this.mAuthorEmailTextField.setBorder(new TitledBorder(SwingForumApplet.this.mAppletLocale.getAuthorEmailText()));
            JPanel buttonpanel = new JPanel();
            buttonpanel.setLayout(new GridLayout(1, 0, 2, 2));
            this.mOKButton = new JButton(SwingForumApplet.this.mAppletLocale.getOKButtonText());
            buttonpanel.add(this.mOKButton);
            this.mCancelButton = new JButton(SwingForumApplet.this.mAppletLocale.getCancelButtonText());
            buttonpanel.add(this.mCancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)buttonpanel, "South");
            this.getContentPane().add((Component)fieldpanel, "Center");
            this.mAuthorTextField.setDoubleBuffered(false);
            this.mAuthorEmailTextField.setDoubleBuffered(false);
        }

        private void wireEvents() {
            this.mOKButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ UserIdentificationForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.registrer()) {
                        UserIdentificationForm.access$2(this.this$1).setEnabled(true);
                        this.this$1.dispose();
                    }
                }
            });
            this.mCancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ UserIdentificationForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    UserIdentificationForm.access$2(this.this$1).setEnabled(true);
                    this.this$1.dispose();
                    UserIdentificationForm.access$3(this.this$1).cancel();
                }
            });
        }

        public boolean registrer() {
            String author = this.mAuthorTextField.getText();
            if (author == null) {
                return false;
            }
            if ((author = author.trim()).length() == 0) {
                return false;
            }
            String email = this.mAuthorEmailTextField.getText();
            if (email != null) {
                email = email.trim();
            }
            User u = new User(author, null, email, 0);
            this.mOwner.gotValidUser(u);
            this.mOwner.setEnabled(true);
            return true;
        }

        static /* synthetic */ SwingForumApplet access$2(UserIdentificationForm x$0) {
            return x$0.mOwner;
        }

        static /* synthetic */ PostForm access$3(UserIdentificationForm x$0) {
            return x$0.mPostForm;
        }
    }

    final class MessageDisplay
    extends JComponent
    implements ActionListener {
        private Message mMessage;
        private MessageReference mMessageReference;
        private MessageHeader mHeader;
        private JEditorPane mPane;
        private SwingForumApplet mOwner;
        private JButton mReplyButton;

        public MessageDisplay(SwingForumApplet owner, MessageReference mr, Message m) {
            this.mMessage = m;
            this.mMessageReference = mr;
            this.mOwner = owner;
            this.setupGUI();
        }

        public void setEnabled(boolean b) {
            this.mReplyButton.setEnabled(b);
        }

        public boolean isEnabled() {
            return this.mReplyButton.isEnabled();
        }

        public void setMessage(MessageReference mr, Message m) {
            this.mMessage = m;
            this.mMessageReference = mr;
            this.updateGUI();
            this.mHeader.setMessage(m);
            this.repaint();
        }

        private void updateGUI() {
            if (this.mMessage.getMessage() != null) {
                this.mPane.setText(String.valueOf(String.valueOf(new StringBuffer("<HTML><BODY>").append(this.mMessage.getFormattedMessage().trim()).append("</BODY></HTML>"))));
            } else {
                this.mPane.setText("");
            }
        }

        private void setupGUI() {
            this.mHeader = new MessageHeader(this, this.mMessage, SwingForumApplet.this.mAppletLocale);
            this.mPane = new JEditorPane();
            this.mPane.setContentType("text/html");
            this.mPane.setEditorKit(new NoImageHTMLEditorKit());
            this.mPane.setEditable(false);
            if (this.mMessage.getMessage() != null) {
                this.mPane.setText(String.valueOf(String.valueOf(new StringBuffer("<HTML><BODY>").append(this.mMessage.getFormattedMessage().trim()).append("</BODY></HTML>"))));
            } else {
                this.mPane.setText("");
            }
            BorderLayout lm = new BorderLayout();
            this.setLayout(lm);
            this.add((Component)this.mHeader, "North");
            this.add((Component)new JScrollPane(this.mPane), "Center");
            this.mReplyButton = new JButton(SwingForumApplet.this.mAppletLocale.getPostANewReplyText());
            this.add((Component)this.mReplyButton, "South");
            this.mReplyButton.addActionListener(this);
            this.mPane.addHyperlinkListener(new HyperlinkListener(this){
                private final /* synthetic */ MessageDisplay this$1;
                {
                    this.this$1 = this$1;
                }

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        MessageDisplay.access$0(this.this$1).showPage(e.getURL());
                    }
                }
            });
            this.mPane.setDoubleBuffered(false);
            this.mReplyButton.setDoubleBuffered(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.mOwner.postForm(this.mMessageReference);
        }

        static /* synthetic */ SwingForumApplet access$0(MessageDisplay x$0) {
            return x$0.mOwner;
        }

        final class MessageHeader
        extends JComponent
        implements AutorizationConstants {
            private Message mMessage;
            private JLabel mAuthorLabel;
            private JLabel mSubjectLabel;
            private AppletLocale mAppletLocale;

            public MessageHeader(MessageDisplay this$1, Message m, AppletLocale al) {
                this.mAppletLocale = al;
                this.mMessage = m;
                this.setupGUI();
            }

            public void setMessage(Message m) {
                this.mMessage = m;
                this.updateGUI();
            }

            private void updateGUI() {
                if (this.mMessage.getSubject() != null) {
                    this.mSubjectLabel.setText(this.mMessage.getSubject().trim());
                    this.mSubjectLabel.setToolTipText(this.mMessage.getSubject().trim());
                } else {
                    this.mSubjectLabel.setText("");
                    this.mSubjectLabel.setToolTipText("");
                }
                this.mSubjectLabel.setBorder(new TitledBorder(this.mAppletLocale.getDateFormat().format(this.mMessage.getDate())));
                if (this.mMessage.getAuthor() != null) {
                    this.mAuthorLabel.setText(this.mMessage.getAuthor().trim());
                } else {
                    this.mAuthorLabel.setText("");
                }
                if (this.mMessage.getAuthorEmail() != null) {
                    this.mAuthorLabel.setBorder(new TitledBorder(this.mMessage.getAuthorEmail().trim()));
                    this.mAuthorLabel.setToolTipText(this.mMessage.getAuthorEmail());
                } else {
                    this.mAuthorLabel.setBorder(new TitledBorder(""));
                    this.mAuthorLabel.setToolTipText("");
                }
            }

            private void setupGUI() {
                GridLayout lm = new GridLayout(0, 1, 5, 5);
                this.setLayout(lm);
                this.mSubjectLabel = new JLabel();
                this.add(this.mSubjectLabel);
                this.mAuthorLabel = new JLabel();
                this.add(this.mAuthorLabel);
                this.updateGUI();
                this.setDoubleBuffered(false);
                this.mAuthorLabel.setDoubleBuffered(false);
                this.mSubjectLabel.setDoubleBuffered(false);
            }

            public Dimension getMinimumSize() {
                return this.getLayout().minimumLayoutSize(this);
            }

            public Dimension getPreferredSize() {
                return this.getLayout().preferredLayoutSize(this);
            }

            public Dimension getMaximumSize() {
                return this.getLayout().preferredLayoutSize(this);
            }
        }
    }

    final class LoadingMessageWindow
    extends JWindow {
        public LoadingMessageWindow(SwingForumApplet this$0, String message, Point p) {
            ((Component)this).setBackground(Color.white);
            this.getContentPane().setLayout(new BorderLayout());
            URL logourl = this.getClass().getResource("/logo_blanc_moyen.gif");
            JLabel mainlabel = null;
            mainlabel = logourl != null ? new JLabel(message, new ImageIcon(logourl), 0) : new JLabel(message, 0);
            mainlabel.setVerticalTextPosition(3);
            mainlabel.setHorizontalTextPosition(0);
            mainlabel.setBorder(new BevelBorder(2));
            mainlabel.setBackground(Color.white);
            this.getContentPane().add((Component)mainlabel, "Center");
            this.pack();
            ((Component)this).setLocation(p);
            mainlabel.setDoubleBuffered(false);
            this.show();
        }
    }
}

