/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.Forum;
import com.ondelette.servlet.webforum.HTMLUtil;
import com.ondelette.servlet.webforum.ParameterNames;
import com.ondelette.servlet.webforum.User;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class ServletUtil
implements ParameterNames,
AutorizationConstants {
    public static void processNewMessage(HttpServletRequest request, Forum forum, PrintWriter out, User user) throws IOException {
        String EmailString;
        String AuthorString;
        String MessageString;
        String SubjectString = request.getParameter("Subject");
        if (SubjectString != null) {
            SubjectString = SubjectString.trim();
        }
        if ((MessageString = request.getParameter("Message")) != null) {
            MessageString = MessageString.trim();
        }
        if ((AuthorString = request.getParameter("Author")) != null) {
            AuthorString = HTMLUtil.makeStringHTMLSafe(AuthorString.trim());
        }
        if ((EmailString = request.getParameter("Email")) != null) {
            EmailString = EmailString.trim();
        }
        if ((user = ServletUtil.updateUserStatus(forum, request, AuthorString, EmailString, user)) != null) {
            AuthorString = user.getLogin();
        }
        if (request.getParameter("_MESSAGEID_") != null) {
            int MessageNumber = Integer.parseInt(request.getParameter("_MESSAGEID_"));
            forum.addReply(MessageNumber, SubjectString, MessageString, AuthorString, EmailString, user);
            forum.showMessage(MessageNumber, out, user, request.getServletPath());
            out.flush();
            return;
        }
        forum.addMessage(SubjectString, MessageString, AuthorString, EmailString, user);
        forum.getPage(0, out, user, request.getServletPath());
        out.flush();
    }

    private static User updateUserStatus(Forum forum, HttpServletRequest request, String AuthorString, String EmailString, User user) {
        HttpSession session = request.getSession(true);
        if (user == null) {
            user = new User(AuthorString, null, EmailString, 0);
        } else if (forum.mUserList.isInList(AuthorString)) {
            user.setEmail(EmailString);
            forum.mUserList.save();
        } else {
            user.setEmail(EmailString);
            user.setLogin(AuthorString);
        }
        session.putValue("USERID", (Object)user);
        return user;
    }

    public static User processLoggingIn(HttpServletRequest request, Forum forum) {
        User user;
        String password;
        String login = request.getParameter("_LOGIN_");
        if (login != null) {
            login = login.trim();
        }
        if ((password = request.getParameter("_PASSWORD_")) != null) {
            password = password.trim();
        }
        if ((user = forum.mUserList.getUser(login, password)) != null) {
            HttpSession session = request.getSession(true);
            session.putValue("USERID", (Object)user);
        }
        return user;
    }

    public static User getUser(HttpServletRequest request, HttpServletResponse response, Forum forum) throws IOException, ServletException {
        User user = null;
        HttpSession session = request.getSession(true);
        if (session.getValue("USERID") != null) {
            try {
                user = (User)session.getValue("USERID");
                if (user == null) {
                    session.removeValue("USERID");
                }
                if (user.getAutorizationLevel() > 0 && !forum.mUserList.isInList(user)) {
                    session.removeValue("USERID");
                    user = null;
                }
            }
            catch (ClassCastException cce) {
                session.removeValue("USERID");
            }
        }
        if (request.getParameter("_LOGIN_") != null && ((user = ServletUtil.processLoggingIn(request, forum)) == null || user.getAutorizationLevel() < 0)) {
            response.sendRedirect(forum.mWelcomeURL);
            return null;
        }
        return user;
    }
}

