/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.webforum.Forum;
import com.ondelette.servlet.webforum.Message;
import com.ondelette.servlet.webforum.MessageArchiveBuffer;
import com.ondelette.servlet.webforum.MessageReference;
import java.io.IOException;
import java.io.PrintWriter;

public final class MessageFolder {
    protected Forum mForum;
    protected MessageArchiveBuffer mMAB;

    public MessageFolder(Forum forum) throws IOException {
        this.mForum = forum;
        this.mMAB = new MessageArchiveBuffer(this.mForum.mMessageArchiveDirectory, this.mForum.mSaveDelay);
    }

    public Message getMessage(int ID) throws IOException {
        return this.mMAB.getMessage(new MessageReference(ID));
    }

    public int getNumberOfPages() {
        int number = (int)Math.ceil((double)this.mMAB.mHeaders.size() / (double)this.mForum.mForumLocale.mSizeOfForumFolders);
        return number;
    }

    public void deleteMessage(MessageReference mr) throws IOException {
        this.mMAB.deleteMessage(mr);
    }

    public void deleteMessage(int mr) throws IOException {
        this.mMAB.deleteMessage(new MessageReference(mr));
    }

    private synchronized void deleteLastPage() {
        int begin;
        int pagenumber = this.getNumberOfPages() - 1;
        int max = this.mMAB.mHeaders.size();
        for (int messagepointer = begin = this.mForum.mForumLocale.mSizeOfForumFolders * pagenumber; messagepointer < max; ++messagepointer) {
            MessageReference mr = (MessageReference)this.mMAB.mHeaders.elementAt(begin);
            try {
                this.mMAB.deleteMessage(mr);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public int[] getPage(int pagenumber) {
        if (this.mForum.mForumLocale.mSizeOfForumFolders * pagenumber > this.mMAB.mHeaders.size() - 1) {
            return null;
        }
        int min = this.mForum.mForumLocale.mSizeOfForumFolders * (pagenumber + 1);
        min = min > this.mMAB.mHeaders.size() ? this.mMAB.mHeaders.size() : min;
        int begin = this.mForum.mForumLocale.mSizeOfForumFolders * pagenumber;
        int[] ans = new int[min - begin];
        for (int messagepointer = begin; messagepointer < min; ++messagepointer) {
            MessageReference mr = (MessageReference)this.mMAB.mHeaders.elementAt(messagepointer);
            ans[messagepointer - begin] = mr.getID();
        }
        return ans;
    }

    public void writePageSummaryHTML(int pagenumber, PrintWriter out, String ServletPath) throws IOException {
        if (this.mForum.mForumLocale.mSizeOfForumFolders * pagenumber > this.mMAB.mHeaders.size() - 1) {
            return;
        }
        int min = this.mForum.mForumLocale.mSizeOfForumFolders * (pagenumber + 1);
        min = min > this.mMAB.mHeaders.size() ? this.mMAB.mHeaders.size() : min;
        out.print("<UL CLASS=\"POSTS\">");
        for (int messagepointer = this.mForum.mForumLocale.mSizeOfForumFolders * pagenumber; messagepointer < min; ++messagepointer) {
            out.print("<LI CLASS=\"POSTS\">");
            MessageReference mr = (MessageReference)this.mMAB.mHeaders.elementAt(messagepointer);
            this.mForum.mForumLocale.printSummary(mr.getID(), this.mForum, out, ServletPath);
            out.print("</LI>");
        }
        out.print("</UL>");
    }

    public void writeLastMessagesSummaryHTML(int NumberOfMessages, PrintWriter out, String ServletPath) throws IOException {
        int[] LastMessages = this.mMAB.lastMessages(NumberOfMessages);
        out.print("<UL CLASS=\"POSTS\">");
        for (int messagepointer = 0; messagepointer < LastMessages.length; ++messagepointer) {
            out.print("<LI CLASS=\"POSTS\">");
            this.mForum.mForumLocale.printSummaryWithoutReplies(LastMessages[messagepointer], this.mForum, out, ServletPath);
            out.print("</LI>");
        }
        out.print("</UL>");
    }

    public MessageReference addMessage(Message message) throws IOException {
        if (message.getInReplyTo() < 0) {
            if (this.mMAB.mHeaders.size() / this.mForum.mForumLocale.mSizeOfForumFolders >= this.mForum.mForumLocale.mNumberOfFolders + 1) {
                this.deleteLastPage();
            }
            return this.mMAB.addMessage(message, true);
        }
        MessageReference parentmr = new MessageReference(message.getInReplyTo());
        Message parentmessage = parentmr.getMessage(this);
        MessageReference newmr = this.mMAB.addMessage(message, false);
        parentmessage.addReply(newmr);
        this.mMAB.replaceMessage(parentmr, parentmessage);
        return newmr;
    }

    public void destroy() {
        this.mMAB.destroy();
    }

    public int getCurrentMaxIndex() {
        return this.mMAB.mCurrentMaxIndex;
    }
}

