/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.ServletCopyright;
import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.FixedNumericalConstants;
import com.ondelette.servlet.webforum.Forum;
import com.ondelette.servlet.webforum.Message;
import com.ondelette.servlet.webforum.ParameterNames;
import com.ondelette.servlet.webforum.User;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public final class ForumLocale
implements ParameterNames,
AutorizationConstants,
FixedNumericalConstants {
    int mSizeOfForumFolders = 20;
    int mNumberOfFolders = 20;
    String mResetString = "Relancer la servlet";
    String mDeleteButtonString = "Effacer ce message";
    String mConfirmDeleteButtonString = "Oui, je veux effacer ce message!";
    String mCancelDeleteButtonString = "Non, je ne veux pas efface ce message!";
    String mInReplyTo = "En r\u00e9ponse \u00e0";
    String mSansTitreString = "Sans titre";
    String mAnonymousString = "Anonyme";
    String mByteString = " octet";
    String mBytesString = " octets";
    String mNewMessageString = "Soumettre un nouveau message";
    String mNewReplyString = "R\u00e9pondre \u00e0 ce message";
    String mMainString = "Retour au forum";
    String mReplyHeaderString = "En r\u00e9ponse \u00e0: ";
    String mFromString = "De";
    String mShortFromString = "par";
    String mSubmitString = "Soumettre mon message";
    String mReplyButtonString = "Soumettre ma r\u00e9ponse";
    String mSubjectString = "Sujet";
    String mMessageString = "Message";
    String mAuthorString = "Nom";
    String mEmailString = "Courriel";
    String mPasswordString = "Mot de passe";
    String mLinesString = "lignes";
    String mLineString = "ligne";
    String mMustEnterNameString = "Vous devez saisir votre nom.";
    String mMustEnterSubjectString = "Vous devez saisir un titre.";
    String mDisplayUserListString = "Liste des usagers";
    String mWelcomePageString = "Page d'accueil du forum (inscription)";
    String mWarningNameInUseString = "Ce nom est d\u00e9j\u00e0 utilis\u00e9.";
    String mWarningPasswordsDontMatchString = "Vous devez entrer deux fois le m\u00eame mot de passe.";
    String mWarningAutorizationRequiredString = "Vous n'avez pas l'autorisation n\u00e9cessaire.";
    String mWarningCannotChangeAdminString = "Vous ne pouvez pas modifier, cr\u00e9er ou effacer un administrateur.";
    String mDeleteUserString = "Effacer cet utilisateur (irr\u00e9versible).";
    String mAddUserString = "Ajouter cet utilisateur.";
    String mChangeUserString = "Modifier cet utilisateur.";
    String mLastTenString = "Dix messages les plus r\u00e9cents";
    String mOptionalLinkURLString = "Lien URL (optionnel)";
    String mLinkTitleString = "Titre de l'URL";
    String mImageURLString = "URL d'une image (optionnel)";
    String mLocaleLanguage = "fr";
    String mLocaleCountry = "CA";
    String mLocaleVariant = "";
    int mNumberOfRowsForTextArea = 10;
    int mNumberOfColsForTextArea = 37;
    int mNumberOfColsForTextFields = 40;
    Locale mCurrentLocale;
    DateFormat mDateFormat;
    static final String mOptionalLinkURLPARAM = "OptionalLinkURL";
    static final String mLinkTitlePARAM = "LinkTitle";
    static final String mImageURLPARAM = "ImageURL";
    static final String mSubjectJavaScriptValue = "document.SUBMITFORM.Subject.value";
    static final String mAuthorJavaScriptValue = "document.SUBMITFORM.Author.value";
    static final String mMessageJavaScriptValue = "document.SUBMITFORM.Message.value";
    static final String mOptionalLinkURLJavaScriptValue = "document.SUBMITFORM.OptionalLinkURL.value";
    static final String mLinkTitleJavaScriptValue = "document.SUBMITFORM.LinkTitle.value";
    static final String mImageURLJavaScriptValue = "document.SUBMITFORM.ImageURL.value";

    private void readConfig(File LocaleFile) throws IOException {
        Properties p = new Properties();
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(LocaleFile));
        p.load(fis);
        fis.close();
        String s = (String)((Hashtable)p).get("SizeOfForumFolders");
        if (s != null) {
            this.mSizeOfForumFolders = Integer.parseInt(s);
        }
        if ((s = (String)((Hashtable)p).get("NumberOfFolders")) != null) {
            this.mNumberOfFolders = Integer.parseInt(s);
        }
        if ((s = (String)((Hashtable)p).get("ResetString")) != null) {
            this.mResetString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("DeleteButton")) != null) {
            this.mDeleteButtonString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("ConfirmDeleteButton")) != null) {
            this.mConfirmDeleteButtonString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("CancelDeleteButton")) != null) {
            this.mCancelDeleteButtonString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("InReplyTo")) != null) {
            this.mInReplyTo = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("SansTitre")) != null) {
            this.mSansTitreString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Anonymous")) != null) {
            this.mAnonymousString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Byte")) != null) {
            this.mByteString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Bytes")) != null) {
            this.mBytesString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("NewMessage")) != null) {
            this.mNewMessageString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("NewReply")) != null) {
            this.mNewReplyString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Main")) != null) {
            this.mMainString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("ReplyHeader")) != null) {
            this.mReplyHeaderString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("From")) != null) {
            this.mFromString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("ShortFrom")) != null) {
            this.mShortFromString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Submit")) != null) {
            this.mSubmitString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("ReplyButton")) != null) {
            this.mReplyButtonString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Subject")) != null) {
            this.mSubjectString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Message")) != null) {
            this.mMessageString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Author")) != null) {
            this.mAuthorString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Email")) != null) {
            this.mEmailString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Password")) != null) {
            this.mPasswordString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Lines")) != null) {
            this.mLinesString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("Line")) != null) {
            this.mLineString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("MustEnterName")) != null) {
            this.mMustEnterNameString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("MustEnterSubject")) != null) {
            this.mMustEnterSubjectString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("DisplayUserList")) != null) {
            this.mDisplayUserListString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("WelcomePage")) != null) {
            this.mWelcomePageString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("WarningNameInUse")) != null) {
            this.mWarningNameInUseString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("WarningPasswordsDontMatch")) != null) {
            this.mWarningPasswordsDontMatchString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("WarningAutorizationRequired")) != null) {
            this.mWarningAutorizationRequiredString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("WarningCannotChangeAdmin")) != null) {
            this.mWarningCannotChangeAdminString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("DeleteUser")) != null) {
            this.mDeleteUserString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("AddUser")) != null) {
            this.mAddUserString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("ChangeUser")) != null) {
            this.mChangeUserString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("LastTen")) != null) {
            this.mLastTenString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get(mOptionalLinkURLPARAM)) != null) {
            this.mOptionalLinkURLString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get(mLinkTitlePARAM)) != null) {
            this.mLinkTitleString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get(mImageURLPARAM)) != null) {
            this.mImageURLString = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("LocaleLanguage")) != null) {
            this.mLocaleLanguage = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("LocaleCountry")) != null) {
            this.mLocaleCountry = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("LocaleVariant")) != null) {
            this.mLocaleVariant = new String(s);
        }
        if ((s = (String)((Hashtable)p).get("NumberOfRowsForTextArea")) != null) {
            this.mNumberOfRowsForTextArea = Integer.parseInt(s);
        }
        if ((s = (String)((Hashtable)p).get("NumberOfColsForTextArea")) != null) {
            this.mNumberOfColsForTextArea = Integer.parseInt(s);
        }
        if ((s = (String)((Hashtable)p).get("NumberOfColsForTextFields")) != null) {
            this.mNumberOfColsForTextFields = Integer.parseInt(s);
        }
    }

    public ForumLocale(File LocaleFile) {
        try {
            this.readConfig(LocaleFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mCurrentLocale = new Locale(this.mLocaleLanguage, this.mLocaleCountry, this.mLocaleVariant);
        this.mDateFormat = DateFormat.getDateTimeInstance(3, 3, this.mCurrentLocale);
    }

    public void printDeleteConfirmation(int mr, Forum forum, PrintWriter out, User user, String ServletPath) throws IOException {
        Message message = forum.mMessageFolder.getMessage(mr);
        this.confirmDeleteForm(out, forum, mr, user, ServletPath);
        this.printMessageTable(message, forum, out, ServletPath);
        message.writeRepliesSummaryHTML(this, forum, out, mr, ServletPath);
    }

    public void printInFull(int mr, Forum forum, PrintWriter out, User user, String ServletPath) throws IOException {
        this.printBackToForum(out, forum, ServletPath);
        Message message = forum.mMessageFolder.getMessage(mr);
        if (user != null && user.getAutorizationLevel() >= 64) {
            this.deleteForm(out, forum, mr, user, ServletPath);
        }
        this.printMessageTable(message, forum, out, ServletPath);
        message.writeRepliesSummaryHTML(this, forum, out, mr, ServletPath);
    }

    private void printMessageTable(Message message, Forum forum, PrintWriter out, String ServletPath) throws IOException {
        out.print("<DIV  CLASS=\"FULLMESSAGE\">");
        out.print("<TABLE CLASS=\"FULLMESSAGE\" BORDER=0>");
        out.println();
        if (message.getInReplyTo() >= 0) {
            out.print("<TR><TD CLASS=\"INREPLYTOID\">");
            out.print(this.mInReplyTo);
            out.print("&nbsp;: ");
            int parentmr = message.getInReplyTo();
            this.printSummaryWithoutReplies(parentmr, forum, out, ServletPath);
            out.println("</TD></TR>");
        }
        out.print("<TR><TD CLASS=\"DISPLAYSUBJECT\">");
        out.print(this.mSubjectString);
        out.print("&nbsp;: ");
        if (message.getSubject() != null) {
            out.print(message.getSubject().toString());
        } else {
            out.print(this.mSansTitreString);
        }
        out.print("<BR>");
        this.putStamp(message, out);
        out.print("</TD></TR>");
        out.println();
        String AuthorClass = this.getAuthorClass(message.getAutorizationLevel());
        out.print("<TR><TD CLASS=\"");
        out.print(AuthorClass);
        out.print("\">");
        out.print(this.mFromString);
        out.print("&nbsp;: ");
        if (message.getAuthor() != null) {
            if (message.getAuthorEmail() != null) {
                out.print("<A HREF=\"mailto:");
                out.print(message.getAuthorEmail());
                out.print("\" CLASS=\"");
                out.print(AuthorClass);
                out.print("\">");
                out.print(message.getAuthor().toString());
                out.print("</A>");
            } else {
                out.print(message.getAuthor().toString());
            }
        } else {
            out.print(this.mAnonymousString);
        }
        out.print("</TD></TR>");
        out.println("</TABLE>");
        out.println("</DIV>");
        if (message.getMessage() != null) {
            out.println("<DIV CLASS=\"DISPLAYMESSAGE\">");
            out.print(this.mMessageString);
            out.println("&nbsp;: <BR>");
            out.print(message.getFormattedMessage());
            out.println("</DIV>");
        }
    }

    private String getAuthorClass(int AutorizationLevel) {
        String AuthorClass = "AUTHORNAME";
        if (AutorizationLevel >= 256) {
            AuthorClass = "ADMINAUTHOR";
        } else if (AutorizationLevel >= 128) {
            AuthorClass = "VIPMEMBER";
        } else if (AutorizationLevel >= 64) {
            AuthorClass = "EXECUTIVEMEMBERAUTHOR";
        } else if (AutorizationLevel >= 32) {
            AuthorClass = "MEMBERAUTHOR";
        } else if (AutorizationLevel >= 2) {
            AuthorClass = "GUESTAUTHOR";
        }
        return AuthorClass;
    }

    public void printSummary(int mr, Forum forum, PrintWriter out, String ServletPath) throws IOException {
        Message message = this.printSummaryWithoutReplies(mr, forum, out, ServletPath);
        out.println();
        message.writeRepliesSummaryHTML(this, forum, out, mr, ServletPath);
    }

    public Message printSummaryWithoutReplies(int mr, Forum forum, PrintWriter out, String ServletPath) throws IOException {
        Message message = forum.mMessageFolder.getMessage(mr);
        out.println();
        out.print("<A HREF=\"");
        out.print(ServletPath);
        out.print("?");
        out.print("_FORUMFILE_");
        out.print("=");
        out.print(forum.mConfigFile.getPath());
        out.print("&");
        out.print("_SHOW_");
        out.print("=");
        out.print(Integer.toString(mr));
        out.print("\" CLASS=\"SHOWLINK\">");
        if (message.getSubject() != null) {
            if (message.getSubject().length() > 0) {
                out.print(message.getSubject());
            } else {
                out.print(this.mSansTitreString);
            }
        } else {
            out.print(this.mSansTitreString);
        }
        out.print("</A>");
        out.print(" ");
        out.print(this.mShortFromString);
        out.print(" ");
        String AuthorClass = this.getAuthorClass(message.getAutorizationLevel());
        if (message.getAuthor() != null) {
            if (message.getAuthorEmail() != null) {
                if (message.getAuthorEmail().length() > 0) {
                    out.print("<A HREF=\"mailto:");
                    out.print(message.getAuthorEmail());
                    out.print("\" CLASS=\"");
                    out.print(AuthorClass);
                    out.print("\">");
                    out.print(message.getAuthor());
                    out.print("</A>");
                } else {
                    out.print("<B CLASS=\"");
                    out.print(AuthorClass);
                    out.print("\">");
                    out.print(message.getAuthor());
                    out.print("</B>");
                }
            } else {
                out.print("<B CLASS=\"");
                out.print(AuthorClass);
                out.print("\">");
                out.print(message.getAuthor());
                out.print("</B>");
            }
        } else {
            out.print("<B CLASS=\"");
            out.print(AuthorClass);
            out.print("\">");
            out.print(this.mAnonymousString);
            out.print("</B>");
        }
        this.putStamp(message, out);
        return message;
    }

    private void putStamp(Message message, PrintWriter out) throws IOException {
        out.print(" <SMALL CLASS=\"STAMP\"><I>");
        out.print(this.mDateFormat.format(message.getDate()));
        out.print("</I>");
        out.print("</SMALL>");
    }

    public void printButtons(Forum forum, PrintWriter out, User user, String ServletPath) throws IOException {
        if (user != null && user.getAutorizationLevel() >= 128) {
            this.printResetForm(out, forum, ServletPath);
            this.printUserListForm(out, forum, ServletPath);
        }
        this.printBackToWelcomeURL(out, forum);
    }

    public void printMenu(Forum forum, PrintWriter out, int currentpage, User user, String ServletPath) throws IOException {
        int pages = forum.mMessageFolder.getNumberOfPages() > this.mNumberOfFolders ? this.mNumberOfFolders : forum.mMessageFolder.getNumberOfPages();
        out.print("<P CLASS=\"MENU\">[ ");
        out.println();
        if (currentpage == 0) {
            out.print("<B>1</B>");
        } else {
            out.print("<A HREF=\"");
            out.print(ServletPath);
            out.print("?");
            out.print("_FORUMFILE_");
            out.print("=");
            out.print(forum.mConfigFile.getPath());
            out.print("&");
            out.print("_PAGE_");
            out.print("=0\">1</A>");
        }
        for (int k = 1; k < pages; ++k) {
            out.println();
            out.print(" | ");
            String stringk = Integer.toString(k + 1);
            String stringkMinus = Integer.toString(k);
            if (k == currentpage) {
                out.print(String.valueOf(String.valueOf(new StringBuffer("<B>").append(stringk).append("</B>"))));
                continue;
            }
            out.print("<A HREF=\"");
            out.print(ServletPath);
            out.print("?");
            out.print("_FORUMFILE_");
            out.print("=");
            out.print(forum.mConfigFile.getPath());
            out.print("&");
            out.print("_PAGE_");
            out.print("=");
            out.print(stringkMinus);
            out.print("\">");
            out.print(stringk);
            out.print("</A>");
        }
        out.println(" ] ");
        out.println("</P>");
        out.println("<P CLASS=\"MENU\">");
        out.print("<A HREF=\"");
        out.print(ServletPath);
        out.print("?");
        out.print("_FORUMFILE_");
        out.print("=");
        out.print(forum.mConfigFile.getPath());
        out.print("&");
        out.print("_LASTMESSAGES_");
        out.print("=");
        out.print(10);
        out.print("\">");
        out.print(this.mLastTenString);
        out.print("</A>");
        out.println("</P>");
    }

    public void printForumTitle(Forum forum, PrintWriter out) throws IOException {
        if (forum.mForumTitle != null) {
            out.print("<H1 CLASS=\"TITLE\">");
            out.print(forum.mForumTitle);
            out.println("</H1>");
        }
        if (forum.mForumSubTitle != null) {
            out.print("<H2 CLASS=\"TITLE\">");
            out.print(forum.mForumSubTitle);
            out.println("</H1>");
        }
    }

    private void printJavaScriptHeader(Forum forum, PrintWriter out) throws IOException {
        out.println("<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">");
        out.println("<script type=\"text/javascript\">");
        out.println("<!--");
        out.println("function checkMessage(ext) {");
        out.print("if ((");
        out.print(mAuthorJavaScriptValue);
        out.print(" == null) || (");
        out.print(mAuthorJavaScriptValue);
        out.println(" == ''))");
        out.print("alert('");
        out.print(this.mMustEnterNameString);
        out.println("');");
        out.print("else if ((");
        out.print(mSubjectJavaScriptValue);
        out.print(" == null) || (");
        out.print(mSubjectJavaScriptValue);
        out.println(" == ''))");
        out.print("alert('");
        out.print(this.mMustEnterSubjectString);
        out.println("');");
        out.println("else {");
        out.print("if ((");
        out.print(mImageURLJavaScriptValue);
        out.print(" != null) && (");
        out.print(mImageURLJavaScriptValue);
        out.print(" != 'HTTP://') && (");
        out.print(mImageURLJavaScriptValue);
        out.println(" != '')) { ");
        out.println("document.SUBMITFORM.Message.value = document.SUBMITFORM.Message.value + '<DIV ALIGN=CENTER><IMG SRC=\"' + document.SUBMITFORM.ImageURL.value + '\" ALIGN=CENTER></DIV>';");
        out.println("}");
        out.print("if ((");
        out.print(mOptionalLinkURLJavaScriptValue);
        out.print(" != 'HTTP://') && (");
        out.print(mOptionalLinkURLJavaScriptValue);
        out.print(" != '') && (");
        out.print(mOptionalLinkURLJavaScriptValue);
        out.print(" != null)) {");
        out.print(" if ((");
        out.print(mLinkTitleJavaScriptValue);
        out.print(" != null) && (");
        out.print(mLinkTitleJavaScriptValue);
        out.println(" != '')) { ");
        out.println(" document.SUBMITFORM.Message.value = document.SUBMITFORM.Message.value + '<DIV ALIGN=CENTER><A HREF=\"' + document.SUBMITFORM.OptionalLinkURL.value+ '\">' + document.SUBMITFORM.LinkTitle.value + '</A></DIV>';");
        out.println(" } else {");
        out.println(" document.SUBMITFORM.Message.value = document.SUBMITFORM.Message.value + '<DIV ALIGN=CENTER><A HREF=\"' + document.SUBMITFORM.OptionalLinkURL.value+ '\">' + document.SUBMITFORM.OptionalLinkURL.value + '</A></DIV>';");
        out.println("}");
        out.println("}");
        out.print("document.");
        out.print("SUBMITFORM");
        out.println(".submit();}");
        out.println("}");
        out.println("// fin du script -->");
        out.println("</SCRIPT>");
    }

    public void printForumHeader(Forum forum, PrintWriter out) throws IOException {
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"");
        out.println("\"http://www.w3.org/TR/REC-html40/loose.dtd\">");
        out.println("<HTML>");
        out.println("<HEAD>");
        out.print("<TITLE>");
        out.print(forum.mForumTitle);
        out.println("</TITLE>");
        out.print("<link rel=stylesheet type=\"text/css\" href=\"");
        out.print(forum.mCSSURL);
        out.println("\">");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        out.println("<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">");
        out.print("<META HTTP-EQUIV=\"Content-Language\" CONTENT=\"");
        out.print(this.mLocaleLanguage);
        out.println("\">");
        out.print("<META NAME=\"Copyright\" CONTENT=\"");
        out.print(ServletCopyright.getCopyright());
        out.println("\">");
        this.printJavaScriptHeader(forum, out);
        out.print("</HEAD>");
        out.println();
        out.print("<BODY>");
        out.println();
    }

    public void printReplyForm(int mr, Forum forum, PrintWriter out, User user, String ServletPath) throws IOException {
        out.print("<P CLASS=\"REPLY\">");
        out.print(this.mNewReplyString);
        out.println("&nbsp;:</P>");
        this.printForm(out, forum, Integer.toString(mr), user, ServletPath);
    }

    public void printPostForm(Forum forum, PrintWriter out, User user, String ServletPath) throws IOException {
        out.print("<P CLASS=\"REPLY\">");
        out.print(this.mNewMessageString);
        out.println("&nbsp;:</P>");
        this.printForm(out, forum, null, user, ServletPath);
    }

    private void printForm(PrintWriter out, Forum forum, String MessageID, User user, String ServletPath) throws IOException {
        out.print("<form action=\"");
        out.print(ServletPath);
        out.print("\" method=\"post\" NAME=\"");
        out.print("SUBMITFORM");
        out.println("\">");
        if (MessageID != null) {
            out.print("<input type=\"hidden\" name=\"");
            out.print("_MESSAGEID_");
            out.print("\" value=\"");
            out.print(MessageID);
            out.println("\">");
        }
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.println("\">");
        out.println("<DIV CLASS=\"POSTMESSAGEFORM\">");
        out.println("<TABLE CLASS=\"POSTMESSAGEFORM\">");
        out.println("<TR><TD CLASS=\"SUBJECT\">");
        out.print(this.mSubjectString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"SUBJECTFIELD\">");
        out.print("<input type=\"TEXT\" value=\"");
        out.print("\" name=\"");
        out.print("Subject");
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD CLASS=\"MESSAGE\">");
        out.print(this.mMessageString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"FIELD\">");
        out.print("<textarea rows=\"");
        out.print(Integer.toString(this.mNumberOfRowsForTextArea));
        out.print("\" name=\"");
        out.print("Message");
        out.print("\" cols=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextArea));
        out.println("\" wrap=\"soft\"></textarea>");
        out.println("</TD></TR>");
        out.println("<TR><TD CLASS=\"AUTHOR\">");
        out.print(this.mAuthorString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"AUTHORFIELD\">");
        if (user == null) {
            out.print("<input type=\"TEXT\" value=\"\" name=\"");
            out.print("Author");
            out.print("\" size=\"");
            out.print(Integer.toString(this.mNumberOfColsForTextFields));
            out.print("\" maxlength=\"");
            out.print(128);
            out.println("\">");
        } else if (user.getAutorizationLevel() > 0) {
            if (user.getLogin() != null) {
                out.println(user.getLogin());
            }
            out.print("<input type=\"hidden\" value=\"");
            if (user.getLogin() != null) {
                out.print(user.getLogin());
            }
            out.print("\" name=\"");
            out.print("Author");
            out.print("\" size=\"");
            out.print(Integer.toString(this.mNumberOfColsForTextFields));
            out.print("\" maxlength=\"");
            out.print(128);
            out.println("\">");
        } else {
            out.print("<input type=\"TEXT\" value=\"");
            if (user.getLogin() != null) {
                out.print(user.getLogin());
            }
            out.print("\" name=\"");
            out.print("Author");
            out.print("\" size=\"");
            out.print(Integer.toString(this.mNumberOfColsForTextFields));
            out.print("\" maxlength=\"");
            out.print(128);
            out.println("\">");
        }
        out.println("</TD></TR>");
        out.println("<TR><TD CLASS=\"EMAIL\">");
        out.print(this.mEmailString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"EMAILFIELD\">");
        out.print("<input type=\"TEXT\" value=\"");
        if (user != null && user.getEmail() != null) {
            out.print(user.getEmail());
        }
        out.print("\" name=\"");
        out.print("Email");
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD CLASS=\"OPTLINK\">");
        out.print(this.mOptionalLinkURLString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"OPTLINKFIELD\">");
        out.print("<input type=\"TEXT\" value=\"HTTP://\" name=\"");
        out.print(mOptionalLinkURLPARAM);
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD CLASS=\"LT\">");
        out.print(this.mLinkTitleString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"LTFIELD\">");
        out.print("<input type=\"TEXT\" value=\"\" name=\"");
        out.print(mLinkTitlePARAM);
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD CLASS=\"IMAGEURL\">");
        out.print(this.mImageURLString);
        out.println("&nbsp;:");
        out.println("</TD><TD CLASS=\"IMAGEURLFIELD\">");
        out.print("<input type=\"TEXT\" value=\"HTTP://\" name=\"");
        out.print(mImageURLPARAM);
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("</TABLE>");
        out.println("</DIV>");
        out.println("<DIV CLASS=\"SUBMITBUTTONS\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("SubmitMessage");
        out.println("\" value=\"NADA\">");
        out.print("<input type=\"button\" value=\"");
        if (MessageID == null) {
            out.print(this.mSubmitString);
            out.print("\" name=\"");
            out.print("toto");
        } else {
            out.print(this.mReplyButtonString);
            out.print("\" name=\"");
            out.print("toto");
        }
        out.println("\" onClick=\"checkMessage('')\">");
        out.println("</P>");
        out.print("</form>");
        out.println();
    }

    private void deleteForm(PrintWriter out, Forum forum, int mr, User user, String ServletPath) throws IOException {
        out.print("<DIV CLASS=\"DELETEMESSAGE\">");
        out.print("<form action=\"");
        out.print(ServletPath);
        out.println("\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_DELETEMESSAGE_");
        out.print("\" value=\"");
        out.print(Integer.toString(mr));
        out.print("\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.print("\">");
        out.print("<input type=\"SUBMIT\" value=\"");
        out.print(this.mDeleteButtonString);
        out.print("\" name=\"");
        out.print("SUBMIT");
        out.print("\">");
        out.println();
        out.print("</P>");
        out.println();
        out.print("</form>");
        out.println();
    }

    private void confirmDeleteForm(PrintWriter out, Forum forum, int mr, User user, String ServletPath) throws IOException {
        out.print("<DIV CLASS=\"CONFIRMDELETEMESSAGE\">");
        out.print("<form action=\"");
        out.print(ServletPath);
        out.println("\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_CONFIRMEDDELETEMESSAGE_");
        out.print("\" value=\"");
        out.print(Integer.toString(mr));
        out.print("\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.print("\">");
        out.print("<input type=\"SUBMIT\" value=\"");
        out.print(this.mConfirmDeleteButtonString);
        out.print("\" name=\"");
        out.print("SUBMIT");
        out.println("\">");
        out.println("</form>");
        out.print("<form action=\"");
        out.print(ServletPath);
        out.println("\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_SHOW_");
        out.print("\" value=\"");
        out.print(Integer.toString(mr));
        out.print("\">");
        out.println();
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.print("\">");
        out.print("<input type=\"SUBMIT\" value=\"");
        out.print(this.mCancelDeleteButtonString);
        out.print("\" name=\"");
        out.print("SUBMIT");
        out.println("\">");
        out.println("</form>");
        out.print("</P>");
    }

    public void printResetForm(PrintWriter out, Forum forum, String ServletPath) throws IOException {
        out.print("<DIV CLASS=\"RESET\">");
        out.print("<form action=\"");
        out.print(ServletPath);
        out.println("\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.print("\">");
        out.print("<input type=\"SUBMIT\" value=\"");
        out.print(this.mResetString);
        out.print("\" name=\"");
        out.print("_RESET_");
        out.print("\">");
        out.println();
        out.print("</P>");
        out.println();
        out.println("</form>");
    }

    public void printUserListForm(PrintWriter out, Forum forum, String ServletPath) throws IOException {
        out.print("<DIV CLASS=\"USERLIST\">");
        out.print("<form action=\"");
        out.print(ServletPath);
        out.println("\" method=\"post\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.print("\">");
        out.print("<input type=\"SUBMIT\" value=\"");
        out.print(this.mDisplayUserListString);
        out.print("\" name=\"");
        out.print("_DISPLAYUSERLIST_");
        out.println("\">");
        out.println("</form>");
        out.println("</DIV>");
    }

    public void printBackToWelcomeURL(PrintWriter out, Forum forum) {
        out.print("<P CLASS=\"BACKTOFORUM\">");
        out.print("<A HREF=\"");
        out.print(forum.mWelcomeURL);
        out.print("\"  CLASS=\"BACKTOFORUM\">");
        out.print(this.mWelcomePageString);
        out.print("</A>");
        out.println("</P>");
    }

    public void printBackToForum(PrintWriter out, Forum forum, String ServletPath) {
        out.print("<P CLASS=\"BACKTOFORUM\">");
        out.print("<A HREF=\"");
        out.print(ServletPath);
        out.print("?");
        out.print("_FORUMFILE_");
        out.print("=");
        out.print(forum.mConfigFile.getPath());
        out.print("\"  CLASS=\"BACKTOFORUM\">");
        out.print(this.mMainString);
        out.print("</A>");
        out.println("</P>");
    }

    public void showWarningNameInUse(String name, PrintWriter out, Forum forum) {
        this.printBackToWelcomeURL(out, forum);
        out.println("<P CLASS=\"WARNING\">");
        out.println(this.mWarningNameInUseString);
        out.println("</P>");
    }

    public void showWarningPasswordsDontMatch(String name, PrintWriter out, Forum forum) {
        this.printBackToWelcomeURL(out, forum);
        out.println("<P CLASS=\"WARNING\">");
        out.println(this.mWarningPasswordsDontMatchString);
        out.println("</P>");
    }

    public void showWarningAutorizationRequired(PrintWriter out, Forum forum) {
        this.printBackToWelcomeURL(out, forum);
        out.println("<P CLASS=\"WARNING\">");
        out.println(this.mWarningAutorizationRequiredString);
        out.println("</P>");
    }

    public void showWarningCannotChangeAdmin(PrintWriter out, Forum forum) {
        this.printBackToWelcomeURL(out, forum);
        out.println("<P CLASS=\"WARNING\">");
        out.println(this.mWarningCannotChangeAdminString);
        out.println("</P>");
    }

    public void printUserList(Forum forum, PrintWriter out, String ServletPath) {
        this.printBackToForum(out, forum, ServletPath);
        Enumeration enumeration = forum.mUserList.getUsers();
        out.println("<TABLE BORDER=5>");
        while (enumeration.hasMoreElements()) {
            User u = (User)enumeration.nextElement();
            out.println("<TR><TD>");
            if (u.getAutorizationLevel() < 256) {
                out.print("<form action=\"");
                out.print(ServletPath);
                out.println("\" method=\"post\">");
                out.print("<input type=\"hidden\" name=\"");
                out.print("_FORUMFILE_");
                out.print("\" value=\"");
                out.print(forum.mConfigFile.getPath());
                out.println("\">");
                out.print("<input type=\"hidden\" name=\"");
                out.print("_DISPLAYUSER_");
                out.print("\" value=\"");
            }
            if (u.getLogin() != null) {
                out.print(u.getLogin());
            }
            if (u.getAutorizationLevel() < 256) {
                out.print("\">");
                out.print("<input type=\"SUBMIT\" value=\"");
                if (u.getLogin() != null) {
                    out.println(u.getLogin());
                }
                out.print("\">");
                out.println("</form>");
            }
            out.println("</TD><TD>");
            out.println("<A HREF=\"mailto:");
            if (u.getEmail() != null) {
                out.println(u.getEmail());
            }
            out.println("\">");
            if (u.getEmail() != null) {
                out.println(u.getEmail());
            }
            out.println("</A>");
            out.println("</TD><TD>");
            out.println(u.getAutorizationLevel());
            out.println("</TD><TD>");
            if (u.getAutorizationLevel() < 256) {
                out.print("<form action=\"");
                out.print(ServletPath);
                out.println("\" method=\"post\">");
                out.print("<input type=\"hidden\" name=\"");
                out.print("_FORUMFILE_");
                out.print("\" value=\"");
                out.print(forum.mConfigFile.getPath());
                out.print("\">");
                out.print("<input type=\"hidden\" name=\"");
                out.print("_DELETEUSER_");
                out.print("\" value=\"");
                if (u.getLogin() != null) {
                    out.print(u.getLogin());
                }
                out.print("\">");
                out.print("<input type=\"SUBMIT\" value=\"");
                out.print(this.mDeleteUserString);
                out.print("\" onClick=\"return confirm('");
                out.print(this.mDeleteUserString);
                out.print("')\">");
                out.println("</form>");
            }
            out.println("</TD></TR>");
        }
        out.println("</TABLE>");
        this.printUserForm(forum, null, out, ServletPath);
    }

    public void printUser(Forum forum, String name, PrintWriter out, String ServletPath) {
        this.printBackToForum(out, forum, ServletPath);
        this.printUserForm(forum, forum.mUserList.getUser(name), out, ServletPath);
    }

    public void printUserForm(Forum forum, User u, PrintWriter out, String ServletPath) {
        out.print("<form action=\"");
        out.print(ServletPath);
        out.print("\" method=\"post\">");
        out.println("<TABLE>");
        out.print("<input type=\"hidden\" name=\"");
        out.print("_FORUMFILE_");
        out.print("\" value=\"");
        out.print(forum.mConfigFile.getPath());
        out.println("\">");
        if (u != null) {
            out.print("<input type=\"hidden\" name=\"");
            out.print("_OLDUSERNAME_");
            out.print("\" value=\"");
            if (u.getLogin() != null) {
                out.print(u.getLogin());
            }
            out.println("\">");
        }
        out.println("<TR><TD>");
        out.println(this.mAuthorString);
        out.println("</TD><TD>");
        out.print("<input type=\"text\" name=\"");
        out.print("_NEWUSERNAME_");
        out.print("\" value=\"");
        if (u != null && u.getLogin() != null) {
            out.print(u.getLogin());
        }
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD>");
        out.println(this.mPasswordString);
        out.println("</TD><TD>");
        out.print("<input type=\"text\" name=\"");
        out.print("_NEWUSERPASSWORD_");
        out.print("\" value=\"");
        if (u != null && u.getPassword() != null && u.getAutorizationLevel() < 256) {
            out.print(u.getPassword());
        }
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD>");
        out.println(this.mEmailString);
        out.println("</TD><TD>");
        out.print("<input type=\"text\" name=\"");
        out.print("_NEWUSEREMAIL_");
        out.print("\" value=\"");
        if (u != null && u.getEmail() != null) {
            out.print(u.getEmail());
        }
        out.print("\" size=\"");
        out.print(Integer.toString(this.mNumberOfColsForTextFields));
        out.print("\" maxlength=\"");
        out.print(128);
        out.println("\">");
        out.println("</TD></TR>");
        out.println("<TR><TD>");
        out.println("</TD><TD>");
        out.print("<SELECT NAME=\"");
        out.print("_NEWUSERLEVEL_");
        out.println("\">");
        if (u != null) {
            out.print("  <OPTION VALUE=\"");
            out.print(u.getAutorizationLevel());
            out.println("\"> ".concat(String.valueOf(String.valueOf(u.getAutorizationLevel()))));
        }
        out.print("  <OPTION VALUE=\"");
        out.print(2);
        out.println("\"> IDENTIFIEDGUEST (2)");
        out.print("  <OPTION VALUE=\"");
        out.print(32);
        out.println("\"> MEMBER (32)");
        out.print("  <OPTION VALUE=\"");
        out.print(64);
        out.println("\"> EXECUTIVEMEMBER (64)");
        out.print("  <OPTION VALUE=\"");
        out.print(128);
        out.println("\"> VIPMEMBER");
        out.print("  <OPTION VALUE=\"");
        out.print(-1);
        out.println("\"> ACCOUNTINACTIVE (-1)");
        out.println("</SELECT>");
        out.println("</TD></TR>");
        out.println("</TABLE>");
        out.print("<input type=\"SUBMIT\" value=\"");
        if (u == null) {
            out.print(this.mAddUserString);
        } else {
            out.print(this.mChangeUserString);
        }
        out.print("\" name=\"");
        if (u == null) {
            out.print("_ADDUSER_");
        } else {
            out.print("_CHANGEUSER_");
        }
        out.println("\">");
        out.println("</form>");
    }

    static {
        mOptionalLinkURLPARAM = mOptionalLinkURLPARAM;
        mLinkTitlePARAM = mLinkTitlePARAM;
        mImageURLPARAM = mImageURLPARAM;
        mSubjectJavaScriptValue = mSubjectJavaScriptValue;
        mAuthorJavaScriptValue = mAuthorJavaScriptValue;
        mMessageJavaScriptValue = mMessageJavaScriptValue;
        mOptionalLinkURLJavaScriptValue = mOptionalLinkURLJavaScriptValue;
        mLinkTitleJavaScriptValue = mLinkTitleJavaScriptValue;
        mImageURLJavaScriptValue = mImageURLJavaScriptValue;
    }
}

