/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.webforum.HTMLUtil;
import com.ondelette.servlet.webforum.User;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class UserList
implements Runnable {
    private Hashtable mLoginTable = new Hashtable();
    private boolean mHasChanged = false;
    private File mUserListFile;
    private Thread mSaveThread;
    private long mDelay;

    public UserList(File file, long delay) {
        try {
            UserList userList = this;
            synchronized (userList) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                while (bis.available() > 0) {
                    User user = User.read(bis);
                    if (user == null) continue;
                    this.mLoginTable.put(user.getLogin(), user);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.mUserListFile = file;
        this.mSaveThread = new Thread(this);
        this.mSaveThread.setPriority(1);
        this.mSaveThread.start();
    }

    public Enumeration getUsers() {
        return this.mLoginTable.elements();
    }

    public User getUser(String login, String password) {
        if (login == null) {
            return null;
        }
        Object o = this.mLoginTable.get(login);
        if (o == null && (o = this.mLoginTable.get(HTMLUtil.makeStringHTMLSafe(login))) == null) {
            return null;
        }
        User user = (User)o;
        if (user.checkPassword(password)) {
            return user;
        }
        return null;
    }

    public User getUser(String login) {
        if (login == null) {
            return null;
        }
        Object o = this.mLoginTable.get(login);
        if (o == null && (o = this.mLoginTable.get(HTMLUtil.makeStringHTMLSafe(login))) == null) {
            return null;
        }
        return (User)o;
    }

    public void add(User user) {
        if (user == null) {
            return;
        }
        this.mLoginTable.put(user.getLogin(), user);
        this.mHasChanged = true;
    }

    public boolean isInList(User user) {
        if (user == null) {
            return false;
        }
        return this.mLoginTable.contains(user);
    }

    public void remove(String login) {
        if (login == null) {
            return;
        }
        if (this.mLoginTable.remove(login) == null) {
            this.mLoginTable.remove(HTMLUtil.makeStringHTMLSafe(login));
        }
        this.mHasChanged = true;
    }

    public boolean isInList(String login) {
        if (login == null) {
            return false;
        }
        if (this.mLoginTable.containsKey(login)) {
            return true;
        }
        return this.mLoginTable.containsKey(HTMLUtil.makeStringHTMLSafe(login));
    }

    public void save() {
        this.mHasChanged = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write() throws IOException {
        if (this.mHasChanged) {
            UserList userList = this;
            synchronized (userList) {
                block10: {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.mUserListFile));
                    try {
                        try {
                            Enumeration enumeration = this.mLoginTable.elements();
                            while (enumeration.hasMoreElements()) {
                                User u = (User)enumeration.nextElement();
                                u.write(bos);
                                bos.write(13);
                                bos.write(10);
                            }
                            Object var6_6 = null;
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            Object var6_7 = null;
                            bos.close();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        bos.close();
                        throw throwable;
                    }
                    bos.close();
                }
            }
        }
        this.mHasChanged = false;
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (me == this.mSaveThread) {
            try {
                Thread.sleep(this.mDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.write();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void destroy() {
        this.mSaveThread.interrupt();
        this.mSaveThread = null;
        try {
            this.write();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

