/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.FixedNumericalConstants;
import com.ondelette.servlet.webforum.Message;
import com.ondelette.servlet.webforum.MessageReference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class MessageArchiveBuffer
implements Runnable,
AutorizationConstants,
FixedNumericalConstants {
    private File mDirectory;
    protected int mCurrentMaxIndex;
    protected Vector mHeaders = new Vector();
    private Hashtable mBuffer = new Hashtable();
    private Hashtable mOldBuffer = new Hashtable();
    private Vector mDeleted = new Vector();
    private Vector mModified = new Vector();
    private Thread mMaintenanceThread;
    private long mDelay;
    private boolean mHeaderHasBeenChanged = false;

    public int[] lastMessages(int NumberOfMessages) {
        int[] messages = new int[NumberOfMessages];
        int allocated = 0;
        for (int index = this.mCurrentMaxIndex - 1; allocated < messages.length && index >= 0; --index) {
            Message m = this.getMessage(new MessageReference(index));
            if (m == null || m.getAutorizationLevel() < 0) continue;
            messages[allocated++] = index;
        }
        if (allocated < messages.length) {
            int[] messages2 = new int[allocated];
            System.arraycopy(messages, 0, messages2, 0, allocated);
            messages = messages2;
        }
        return messages;
    }

    public MessageArchiveBuffer(File dir, long delay) {
        this.mDirectory = dir;
        this.mDelay = delay;
        try {
            this.readHeaders();
        }
        catch (IOException ioe) {
            this.mCurrentMaxIndex = 0;
            this.mHeaderHasBeenChanged = true;
            try {
                this.doMaintenance();
            }
            catch (IOException ioe2) {
                ioe.printStackTrace();
            }
        }
        this.mMaintenanceThread = new Thread(this);
        this.mMaintenanceThread.setPriority(1);
        this.mMaintenanceThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readHeaders() throws IOException {
        String line;
        this.mDirectory.mkdirs();
        File indexfile = new File(this.mDirectory, "index.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(indexfile)));
        try {
            try {
                try {
                    this.mCurrentMaxIndex = Integer.parseInt(br.readLine());
                }
                catch (NumberFormatException nfe) {
                    this.mCurrentMaxIndex = 0;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Object var6_9 = null;
                br.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            br.close();
            throw throwable;
        }
        while ((line = br.readLine()) != null) {
            try {
                this.mHeaders.addElement(new MessageReference(Integer.parseInt(line)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Object var6_8 = null;
        br.close();
    }

    public Enumeration getHeaders() {
        return this.mHeaders.elements();
    }

    public Message getMessage(MessageReference mr) {
        if (mr.getID() < 0 || mr.getID() > this.mCurrentMaxIndex) {
            return null;
        }
        Message message = (Message)this.mBuffer.get(mr);
        if (message == null) {
            message = (Message)this.mOldBuffer.get(mr);
            if (message == null) {
                try {
                    File messagefile = new File(this.mDirectory, mr.toString());
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(messagefile));
                    message = Message.read(is);
                    is.close();
                }
                catch (IOException ioe) {
                    Message message2 = null;
                    return message2;
                }
                this.mBuffer.put(mr, message);
                return message;
            }
            this.mOldBuffer.remove(mr);
            this.mBuffer.put(mr, message);
        }
        return message;
    }

    public synchronized MessageReference addMessage(Message message, boolean newHeader) {
        MessageReference mr = new MessageReference(this.mCurrentMaxIndex);
        while (this.getMessage(mr) != null) {
            mr = new MessageReference(this.mCurrentMaxIndex++);
        }
        this.mBuffer.put(mr, message);
        if (newHeader) {
            this.mHeaders.insertElementAt(mr, 0);
        }
        ++this.mCurrentMaxIndex;
        if (this.mCurrentMaxIndex > 65000) {
            this.mCurrentMaxIndex = 0;
        }
        this.mModified.addElement(mr);
        this.mHeaderHasBeenChanged = true;
        return mr;
    }

    public void replaceMessage(MessageReference mr, Message message) {
        this.mBuffer.put(mr, message);
        this.mModified.addElement(mr);
    }

    public void deleteMessage(MessageReference mr) throws IOException {
        Message message = this.getMessage(mr);
        Enumeration enumeration = message.getReplies();
        while (enumeration.hasMoreElements()) {
            MessageReference repliesmr = (MessageReference)enumeration.nextElement();
            this.deleteMessage(repliesmr);
        }
        message.setAutorizationLevel(-2);
        if (this.mHeaders.removeElement(mr)) {
            this.mHeaderHasBeenChanged = true;
        } else if (message.getInReplyTo() != -1) {
            MessageReference parentmr = new MessageReference(message.getInReplyTo());
            Message parentmessage = this.getMessage(parentmr);
            parentmessage.removeReply(mr);
            this.replaceMessage(parentmr, parentmessage);
        }
        this.mDeleted.addElement(mr);
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (me == this.mMaintenanceThread) {
            try {
                Thread.sleep(this.mDelay * (long)1000 * (long)60);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.doMaintenance();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void destroy() {
        this.mMaintenanceThread.interrupt();
        this.mMaintenanceThread = null;
        try {
            this.doMaintenance();
        }
        catch (IOException ioe) {
            System.err.println("Could do not do maintenance in MessageArchiveBuffer ".concat(String.valueOf(String.valueOf(ioe.toString()))));
        }
    }

    private void doMaintenance() throws IOException {
        if (this.mHeaderHasBeenChanged) {
            this.saveHeaders();
        }
        this.saveModifiedMessages();
        this.deleteDeletedMessages();
        MessageArchiveBuffer messageArchiveBuffer = this;
        synchronized (messageArchiveBuffer) {
            this.mOldBuffer = this.mBuffer;
            this.mBuffer = new Hashtable();
        }
    }

    private synchronized void saveHeaders() throws IOException {
        File indexfile = new File(this.mDirectory, "index.txt");
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(indexfile)));
        try {
            pw.println(this.mCurrentMaxIndex);
            Enumeration enumeration = this.getHeaders();
            while (enumeration.hasMoreElements()) {
                MessageReference mr = (MessageReference)enumeration.nextElement();
                pw.println(mr.toString());
            }
            Object var6_5 = null;
            pw.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            pw.close();
            throw throwable;
        }
        this.mHeaderHasBeenChanged = false;
    }

    private void saveModifiedMessages() throws IOException {
        Vector OldModified;
        MessageArchiveBuffer messageArchiveBuffer = this;
        synchronized (messageArchiveBuffer) {
            OldModified = (Vector)this.mModified.clone();
            this.mModified = new Vector();
        }
        Enumeration enumeration = OldModified.elements();
        while (enumeration.hasMoreElements()) {
            Object var8_7;
            MessageReference mr = (MessageReference)enumeration.nextElement();
            Message message = this.getMessage(mr);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(this.mDirectory, mr.toString())));
            try {
                message.write(bos);
                bos.flush();
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                bos.close();
                throw throwable;
            }
            bos.close();
            {
            }
        }
    }

    private void deleteDeletedMessages() throws IOException {
        Vector OldDeleted;
        MessageArchiveBuffer messageArchiveBuffer = this;
        synchronized (messageArchiveBuffer) {
            OldDeleted = (Vector)this.mDeleted.clone();
            this.mDeleted = new Vector();
        }
        Enumeration enumeration = OldDeleted.elements();
        while (enumeration.hasMoreElements()) {
            MessageReference mr = (MessageReference)enumeration.nextElement();
            File file = new File(this.mDirectory, mr.toString());
            if (file.delete()) continue;
            System.out.println("could not delete file ".concat(String.valueOf(String.valueOf(file.getCanonicalPath()))));
        }
    }
}

