/*
 * Decompiled with CFR 0.152.
 */
package com.ondelette.servlet.webforum;

import com.ondelette.servlet.webforum.AutorizationConstants;
import com.ondelette.servlet.webforum.Forum;
import com.ondelette.servlet.webforum.ForumLocale;
import com.ondelette.servlet.webforum.HTMLUtil;
import com.ondelette.servlet.webforum.MessageReference;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public final class Message
implements AutorizationConstants,
Serializable {
    private Date mPostedDate;
    private String mSubjectString;
    private String mMessageString;
    private String mAuthorString;
    private String mAuthorEmailString;
    private int mInReplyToID = -1;
    private int mAutorizationLevel = 0;
    private Vector mReplies = new Vector();
    private int mNumberOfLines = 0;
    private int mNumberOfBytes = 0;
    private static DateFormat mDateFormat = DateFormat.getDateTimeInstance(0, 0, new Locale("en", "us"));
    private static DateFormat mDateFormatSecondary = DateFormat.getDateInstance(0, new Locale("en", "us"));

    private Message() {
    }

    public Enumeration getReplies() {
        return this.mReplies.elements();
    }

    public boolean contains(MessageReference mr) {
        return this.mReplies.contains(mr);
    }

    public Message(String AuthorString, String AuthorEmail, String SubjectString, String MessageString) {
        if (AuthorString != null) {
            this.mAuthorString = HTMLUtil.makeStringHTMLSafe(AuthorString.trim());
            if (this.mAuthorString.length() == 0) {
                this.mAuthorString = null;
            }
        }
        if (SubjectString != null) {
            this.mSubjectString = HTMLUtil.makeStringHTMLSafe(SubjectString.trim());
            if (this.mSubjectString.length() == 0) {
                this.mSubjectString = null;
            }
        }
        if (AuthorEmail != null) {
            this.mAuthorEmailString = HTMLUtil.makeStringHTMLSafe(AuthorEmail.trim());
            if (this.mAuthorEmailString.length() == 0) {
                this.mAuthorEmailString = null;
            }
        }
        if (MessageString != null) {
            this.mMessageString = MessageString.trim();
            if (this.mMessageString.length() == 0) {
                this.mMessageString = null;
            }
        }
        long time = System.currentTimeMillis();
        this.mPostedDate = new Date(time);
        this.mAutorizationLevel = 0;
        this.mNumberOfLines = HTMLUtil.getNumberOfLines(this.mMessageString);
        this.mNumberOfBytes = this.mMessageString != null ? this.mMessageString.length() : 0;
    }

    public void setInReplyTo(int ID) {
        this.mInReplyToID = ID;
    }

    public int getInReplyTo() {
        return this.mInReplyToID;
    }

    public Date getDate() {
        return this.mPostedDate;
    }

    public void setDate(Date date) {
        this.mPostedDate = date;
    }

    public void setAutorizationLevel(int level) {
        this.mAutorizationLevel = level;
    }

    public boolean hasBeenDeleted() {
        return this.mAutorizationLevel == -2;
    }

    public int getAutorizationLevel() {
        return this.mAutorizationLevel;
    }

    public void addReply(MessageReference mr) {
        this.mReplies.insertElementAt(mr, 0);
    }

    public boolean removeReply(MessageReference mr) {
        return this.mReplies.removeElement(mr);
    }

    public void setSubject(String Subject) {
        this.mSubjectString = HTMLUtil.makeStringHTMLSafe(Subject.trim());
        if (this.mSubjectString.length() == 0) {
            this.mSubjectString = null;
        }
    }

    public void setMessage(String message) {
        this.mMessageString = message.trim();
        if (this.mMessageString.length() == 0) {
            this.mMessageString = null;
        }
        this.mNumberOfLines = HTMLUtil.getNumberOfLines(message);
        this.mNumberOfBytes = this.mMessageString != null ? message.length() : 0;
    }

    public void setAuthor(String Author) {
        this.mAuthorString = HTMLUtil.makeStringHTMLSafe(Author.trim());
        if (this.mAuthorString.length() == 0) {
            this.mAuthorString = null;
        }
    }

    public void setAuthorEmail(String AuthorEmail) {
        this.mAuthorEmailString = HTMLUtil.makeStringHTMLSafe(AuthorEmail.trim());
        if (this.mAuthorEmailString.length() == 0) {
            this.mAuthorEmailString = null;
        }
    }

    public int getNumberOfLines() {
        return this.mNumberOfLines;
    }

    public int getNumberOfBytes() {
        return this.mNumberOfBytes;
    }

    public String getSubject() {
        return this.mSubjectString;
    }

    public String getMessage() {
        return this.mMessageString;
    }

    public String getFormattedMessage() {
        return HTMLUtil.replaceLinesWithParagraphs(this.mMessageString);
    }

    public String getAuthor() {
        return this.mAuthorString;
    }

    public String getAuthorEmail() {
        return this.mAuthorEmailString;
    }

    public void writeRepliesSummaryHTML(ForumLocale locale, Forum forum, PrintWriter out, int selfmr, String ServletPath) throws IOException {
        Enumeration enumeration = this.mReplies.elements();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        out.print("<UL CLASS=\"REPLIES\">");
        while (enumeration.hasMoreElements()) {
            MessageReference mr = (MessageReference)enumeration.nextElement();
            if (mr.getID() == selfmr) continue;
            out.print("<LI CLASS=\"REPLIES\">");
            locale.printSummary(mr.getID(), forum, out, ServletPath);
            out.print("</LI>");
        }
        out.print("</UL>");
    }

    public void write(OutputStream out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        writer.println("<MESSAGE>");
        if (this.mAutorizationLevel != 0) {
            writer.println("<AUTHORIZATION>");
            writer.println(Integer.toString(this.mAutorizationLevel));
            writer.println("</AUTHORIZATION>");
        }
        writer.println("<POSTED>");
        writer.println(mDateFormat.format(this.mPostedDate).toString());
        writer.println("</POSTED>");
        if (this.mSubjectString != null) {
            writer.println("<SUBJECT>");
            writer.println(this.mSubjectString);
            writer.println("</SUBJECT>");
        }
        if (this.mMessageString != null) {
            writer.println("<CONTENT>");
            writer.println(HTMLUtil.makeStringHTMLSafe(this.mMessageString));
            writer.println("</CONTENT>");
        }
        if (this.mInReplyToID >= 0) {
            writer.println("<REPLYTOID>");
            writer.println(this.mInReplyToID);
            writer.println("</REPLYTOID>");
        }
        if (this.mAuthorString != null) {
            writer.println("<AUTHOR>");
            writer.println(this.mAuthorString);
            writer.println("</AUTHOR>");
        }
        if (this.mAuthorEmailString != null) {
            writer.println("<EMAIL>");
            writer.println(this.mAuthorEmailString);
            writer.println("</EMAIL>");
        }
        writer.flush();
        if (this.mReplies.size() > 0) {
            writer.flush();
            Enumeration enumeration = this.mReplies.elements();
            while (enumeration.hasMoreElements()) {
                MessageReference mr = (MessageReference)enumeration.nextElement();
                mr.write(out);
            }
        }
        writer.println("</MESSAGE>");
        writer.flush();
    }

    private static Message parseMessage(InputStream in) throws IOException {
        Message message;
        block12: {
            String header;
            message = new Message();
            while (in.available() > 0 && !(header = HTMLUtil.readString(in)).equals("/MESSAGE")) {
                if (header.equals("POSTED")) {
                    String DateString = HTMLUtil.readString(in).trim();
                    try {
                        message.mPostedDate = mDateFormat.parse(DateString);
                    }
                    catch (ParseException pe) {
                        try {
                            message.mPostedDate = mDateFormatSecondary.parse(DateString);
                        }
                        catch (ParseException pe2) {
                            message.mPostedDate = new Date();
                        }
                    }
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("REPLYTOID")) {
                    message.mInReplyToID = Integer.parseInt(HTMLUtil.readString(in).trim());
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("SUBJECT")) {
                    message.mSubjectString = HTMLUtil.readString(in);
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("CONTENT")) {
                    message.mMessageString = HTMLUtil.recoverHTML(HTMLUtil.readString(in).trim());
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("AUTHOR")) {
                    message.mAuthorString = HTMLUtil.readString(in).trim();
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("EMAIL")) {
                    message.mAuthorEmailString = HTMLUtil.readString(in).trim();
                    HTMLUtil.readString(in);
                    continue;
                }
                if (header.equals("MREF")) {
                    message.mReplies.addElement(new MessageReference(HTMLUtil.readString(in)));
                    HTMLUtil.readString(in);
                    continue;
                }
                if (!header.equals("AUTHORIZATION")) continue;
                message.mAutorizationLevel = Integer.parseInt(HTMLUtil.readString(in).trim());
                HTMLUtil.readString(in);
            }
            if (message.mPostedDate != null) break block12;
            message.mPostedDate = new Date();
        }
        return message;
    }

    public static Message read(InputStream in) throws IOException {
        while (in.available() > 0) {
            String buf = HTMLUtil.readString(in);
            if (!buf.equals("MESSAGE")) continue;
            Message message = null;
            message = Message.parseMessage(in);
            return message;
        }
        return null;
    }

    public static void main(String[] t) throws IOException {
        Message m = new Message("dan", "dan@t", "tata", "message");
        FileOutputStream fos = new FileOutputStream(t[0]);
        m.write(fos);
        fos.close();
        FileInputStream fis = new FileInputStream(t[0]);
        m = Message.parseMessage(fis);
        fis.close();
        System.out.println(m.getAuthor());
    }

    public String toString() {
        if (this.mSubjectString != null && this.mAuthorString != null) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mSubjectString.trim()))).append(" - ").append(this.mAuthorString)));
        }
        if (this.mSubjectString != null) {
            return this.mSubjectString.trim();
        }
        if (this.mAuthorString != null) {
            return String.valueOf(String.valueOf(new StringBuffer("(").append(this.mAuthorString).append(")")));
        }
        return "?";
    }
}

